/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.tx;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.lucene.engine.OLuceneIndexEngine;
import com.orientechnologies.lucene.exception.OLuceneIndexException;
import com.orientechnologies.lucene.tx.OLuceneTxChanges;
import java.io.IOException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;

public abstract class OLuceneTxChangesAbstract
implements OLuceneTxChanges {
    public static final String TMP = "_tmp_rid";
    protected final OLuceneIndexEngine engine;
    protected final IndexWriter writer;
    protected final IndexWriter deletedIdx;

    public OLuceneTxChangesAbstract(OLuceneIndexEngine engine, IndexWriter writer, IndexWriter deletedIdx) {
        this.engine = engine;
        this.writer = writer;
        this.deletedIdx = deletedIdx;
    }

    @Override
    public IndexSearcher searcher() {
        try {
            return new IndexSearcher((IndexReader)DirectoryReader.open((IndexWriter)this.writer, (boolean)true, (boolean)true));
        }
        catch (IOException e) {
            throw OException.wrapException((OException)new OLuceneIndexException("Error during searcher index instantiation on new documents"), (Throwable)e);
        }
    }

    @Override
    public long deletedDocs(Query query) {
        try {
            IndexSearcher indexSearcher = new IndexSearcher((IndexReader)DirectoryReader.open((IndexWriter)this.deletedIdx, (boolean)true, (boolean)true));
            TopDocs search = indexSearcher.search(query, Integer.MAX_VALUE);
            return search.totalHits;
        }
        catch (IOException e) {
            OLogManager.instance().error((Object)this, "Error during searcher index instantiation on deleted documents ", (Throwable)e, new Object[0]);
            return 0L;
        }
    }
}

