/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.index;

import com.orientechnologies.lucene.engine.OLuceneIndexEngine;
import com.orientechnologies.lucene.index.OLuceneIndexNotUnique;
import com.orientechnologies.orient.core.exception.OInvalidIndexEngineIdException;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperationsManager;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Query;

public class OLuceneFullTextIndex
extends OLuceneIndexNotUnique {
    public OLuceneFullTextIndex(String name, String typeId, String algorithm, int version, OAbstractPaginatedStorage storage, String valueContainerAlgorithm, ODocument metadata, int binaryFormatVersion, OAtomicOperationsManager atomicOperationsManager) {
        super(name, typeId, algorithm, version, storage, valueContainerAlgorithm, metadata, binaryFormatVersion, atomicOperationsManager);
    }

    public Document buildDocument(Object key) {
        while (true) {
            try {
                return (Document)this.storage.callIndexEngine(false, this.indexId, engine -> {
                    OLuceneIndexEngine indexEngine = (OLuceneIndexEngine)engine;
                    return indexEngine.buildDocument(key, null);
                });
            }
            catch (OInvalidIndexEngineIdException e) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
    }

    public Query buildQuery(Object query) {
        while (true) {
            try {
                return (Query)this.storage.callIndexEngine(false, this.indexId, engine -> {
                    OLuceneIndexEngine indexEngine = (OLuceneIndexEngine)engine;
                    return indexEngine.buildQuery(query);
                });
            }
            catch (OInvalidIndexEngineIdException e) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
    }

    public Analyzer queryAnalyzer() {
        while (true) {
            try {
                return (Analyzer)this.storage.callIndexEngine(false, this.indexId, engine -> {
                    OLuceneIndexEngine indexEngine = (OLuceneIndexEngine)engine;
                    return indexEngine.queryAnalyzer();
                });
            }
            catch (OInvalidIndexEngineIdException e) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
    }

    public boolean isCollectionIndex() {
        while (true) {
            try {
                return (Boolean)this.storage.callIndexEngine(false, this.indexId, engine -> {
                    OLuceneIndexEngine indexEngine = (OLuceneIndexEngine)engine;
                    return indexEngine.isCollectionIndex();
                });
            }
            catch (OInvalidIndexEngineIdException e) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
    }

    public Analyzer indexAnalyzer() {
        while (true) {
            try {
                return (Analyzer)this.storage.callIndexEngine(false, this.indexId, engine -> {
                    OLuceneIndexEngine indexEngine = (OLuceneIndexEngine)engine;
                    return indexEngine.indexAnalyzer();
                });
            }
            catch (OInvalidIndexEngineIdException e) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
    }
}

