/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.functions;

import com.orientechnologies.lucene.builder.OLuceneQueryBuilder;
import com.orientechnologies.lucene.collections.OLuceneCompositeKey;
import com.orientechnologies.lucene.functions.OLuceneFunctionsUtils;
import com.orientechnologies.lucene.functions.OLuceneSearchFunctionTemplate;
import com.orientechnologies.lucene.index.OLuceneFullTextIndex;
import com.orientechnologies.lucene.query.OLuceneKeyAndMetadata;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.metadata.OMetadata;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.parser.OBinaryCompareOperator;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OFromClause;
import com.orientechnologies.orient.core.sql.parser.OFromItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.memory.MemoryIndex;

public class OLuceneSearchOnFieldsFunction
extends OLuceneSearchFunctionTemplate {
    public static final String NAME = "search_fields";

    public OLuceneSearchOnFieldsFunction() {
        super(NAME, 2, 3);
    }

    public String getName() {
        return NAME;
    }

    public Object execute(Object iThis, OIdentifiable iCurrentRecord, Object iCurrentResult, Object[] params, OCommandContext ctx) {
        List fieldNames;
        OResult result;
        OElement element;
        String className;
        OLuceneFullTextIndex index;
        if (iThis instanceof ORID) {
            iThis = ((ORID)iThis).getRecord();
        }
        if (iThis instanceof OIdentifiable) {
            iThis = new OResultInternal((OIdentifiable)iThis);
        }
        if ((index = this.searchForIndex(className = ((OClass)(element = (result = (OResult)iThis).toElement()).getSchemaType().get()).getName(), ctx, fieldNames = (List)params[0])) == null) {
            return false;
        }
        String query = (String)params[1];
        MemoryIndex memoryIndex = OLuceneFunctionsUtils.getOrCreateMemoryIndex(ctx);
        List key = index.getDefinition().getFields().stream().map(s -> element.getProperty(s)).collect(Collectors.toList());
        for (IndexableField field : index.buildDocument(key).getFields()) {
            memoryIndex.addField(field, index.indexAnalyzer());
        }
        ODocument metadata = this.getMetadata(params);
        OLuceneKeyAndMetadata keyAndMetadata = new OLuceneKeyAndMetadata(new OLuceneCompositeKey(Arrays.asList(query)).setContext(ctx), metadata);
        return memoryIndex.search(index.buildQuery(keyAndMetadata)) > 0.0f;
    }

    private ODocument getMetadata(Object[] params) {
        if (params.length == 3) {
            return new ODocument().fromMap((Map)params[2]);
        }
        return OLuceneQueryBuilder.EMPTY_METADATA;
    }

    public String getSyntax() {
        return "SEARCH_INDEX( indexName, [ metdatada {} ] )";
    }

    public Iterable<OIdentifiable> searchFromTarget(OFromClause target, OBinaryCompareOperator operator, Object rightValue, OCommandContext ctx, OExpression ... args) {
        OLuceneFullTextIndex index = this.searchForIndex(target, ctx, args);
        OExpression expression = args[1];
        String query = (String)expression.execute((OIdentifiable)null, ctx);
        if (index != null) {
            Set<OIdentifiable> luceneResultSet;
            ODocument meta = this.getMetadata(args);
            try (Stream rids = index.getInternal().getRids((Object)new OLuceneKeyAndMetadata(new OLuceneCompositeKey(Arrays.asList(query)).setContext(ctx), meta));){
                luceneResultSet = rids.collect(Collectors.toSet());
            }
            return luceneResultSet;
        }
        throw new RuntimeException();
    }

    private ODocument getMetadata(OExpression[] args) {
        if (args.length == 3) {
            return new ODocument().fromJSON(args[2].toString());
        }
        return new ODocument();
    }

    @Override
    protected OLuceneFullTextIndex searchForIndex(OFromClause target, OCommandContext ctx, OExpression ... args) {
        List fieldNames = (List)args[0].execute((OIdentifiable)null, ctx);
        OFromItem item = target.getItem();
        String className = item.getIdentifier().getStringValue();
        return this.searchForIndex(className, ctx, fieldNames);
    }

    private OLuceneFullTextIndex searchForIndex(String className, OCommandContext ctx, List<String> fieldNames) {
        OMetadata dbMetadata = ctx.getDatabase().activateOnCurrentThread().getMetadata();
        List indices = dbMetadata.getSchema().getClass(className).getIndexes().stream().filter(idx -> idx instanceof OLuceneFullTextIndex).map(idx -> (OLuceneFullTextIndex)idx).filter(idx -> this.intersect(idx.getDefinition().getFields(), fieldNames)).collect(Collectors.toList());
        if (indices.size() > 1) {
            throw new IllegalArgumentException("too many indices matching given field name: " + String.join((CharSequence)",", fieldNames));
        }
        return indices.size() == 0 ? null : (OLuceneFullTextIndex)indices.get(0);
    }

    public <T> List<T> intersection(List<T> list1, List<T> list2) {
        ArrayList<T> list = new ArrayList<T>();
        for (T t : list1) {
            if (!list2.contains(t)) continue;
            list.add(t);
        }
        return list;
    }

    public <T> boolean intersect(List<T> list1, List<T> list2) {
        for (T t : list1) {
            if (!list2.contains(t)) continue;
            return true;
        }
        return false;
    }
}

