/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.engine;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.lucene.engine.OLuceneIndexEngineAbstract;
import com.orientechnologies.lucene.exception.OLuceneIndexException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;

public class OLuceneIndexEngineUtils {
    public static void sendTotalHits(String indexName, OCommandContext context, long totalHits) {
        if (context != null) {
            if (context.getVariable("totalHits") == null) {
                context.setVariable("totalHits", (Object)totalHits);
            } else {
                context.setVariable("totalHits", null);
            }
            context.setVariable((indexName + ".totalHits").replace(".", "_"), (Object)totalHits);
        }
    }

    public static void sendLookupTime(String indexName, OCommandContext context, final TopDocs docs, final Integer limit, long startFetching) {
        if (context != null) {
            final long finalTime = System.currentTimeMillis() - startFetching;
            context.setVariable((indexName + ".lookupTime").replace(".", "_"), (Object)new HashMap<String, Object>(){
                {
                    this.put("limit", limit);
                    this.put("totalTime", finalTime);
                    this.put("totalHits", docs.totalHits);
                    this.put("returnedHits", docs.scoreDocs.length);
                    if (!Float.isNaN(docs.getMaxScore())) {
                        this.put("maxScore", Float.valueOf(docs.getMaxScore()));
                    }
                }
            });
        }
    }

    public static Document retrieveIndexMetadata(IndexWriter writer) {
        DirectoryReader reader = null;
        IndexSearcher searcher = null;
        try {
            Document metaDoc;
            reader = DirectoryReader.open((IndexWriter)writer);
            searcher = new IndexSearcher((IndexReader)reader);
            TopDocs topDocs = searcher.search((Query)new TermQuery(new Term("_CLASS", "JSON_METADATA")), 1);
            Document document = metaDoc = searcher.doc(topDocs.scoreDocs[0].doc);
            return document;
        }
        catch (IOException e) {
            throw OException.wrapException((OException)new OLuceneIndexException("unable to retrieve metadata document from index"), (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    OLogManager.instance().error(OLuceneIndexEngineAbstract.class, "Error while retrieving index metadata", (Throwable)e, new Object[0]);
                }
            }
        }
    }

    public static List<SortField> buildSortFields(ODocument metadata) {
        List sortConf = Optional.ofNullable(metadata.getProperty("sort")).orElse(Collections.emptyList());
        List<SortField> fields = sortConf.stream().map(d -> OLuceneIndexEngineUtils.buildSortField(d)).collect(Collectors.toList());
        return fields;
    }

    public static SortField buildSortField(ODocument conf) {
        return OLuceneIndexEngineUtils.buildSortField(conf.toMap());
    }

    public static SortField buildSortField(Map<String, Object> conf) {
        String field = Optional.ofNullable((String)conf.get("field")).orElse(null);
        String type = Optional.ofNullable(((String)conf.get("type")).toUpperCase()).orElse(SortField.Type.STRING.name());
        Boolean reverse = Optional.ofNullable((Boolean)conf.get("reverse")).orElse(false);
        SortField sortField = new SortField(field, SortField.Type.valueOf((String)type), reverse.booleanValue());
        return sortField;
    }

    public static ODocument getMetadataFromIndex(IndexWriter writer) {
        Document metaDoc = OLuceneIndexEngineUtils.retrieveIndexMetadata(writer);
        return new ODocument().fromJSON(metaDoc.get("_META_JSON"));
    }

    public static OIndexDefinition getIndexDefinitionFromIndex(IndexWriter writer) {
        Document metaDoc = OLuceneIndexEngineUtils.retrieveIndexMetadata(writer);
        ODocument defAsJson = new ODocument().fromJSON(metaDoc.get("_DEF_JSON"));
        String defClassName = metaDoc.get("_DEF_CLASS_NAME");
        try {
            Class<?> indexDefClass = Class.forName(defClassName);
            OIndexDefinition indexDefinition = (OIndexDefinition)indexDefClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            indexDefinition.fromStream(defAsJson);
            return indexDefinition;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw OException.wrapException((OException)new OLuceneIndexException("Error during deserialization of index definition"), (Throwable)e);
        }
    }
}

