/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.engine;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.lucene.engine.OLuceneDirectory;
import com.orientechnologies.orient.core.db.ODatabaseType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.OStorage;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.store.RAMDirectory;

public class OLuceneDirectoryFactory {
    public static final String OLUCENE_BASE_DIR = "luceneIndexes";
    public static final String DIRECTORY_TYPE = "directory_type";
    public static final String DIRECTORY_NIO = "nio";
    public static final String DIRECTORY_MMAP = "mmap";
    public static final String DIRECTORY_RAM = "ram";
    public static final String DIRECTORY_PATH = "directory_path";

    public OLuceneDirectory createDirectory(OStorage storage, String indexName, ODocument metadata) {
        String luceneType;
        String string = luceneType = metadata.containsField(DIRECTORY_TYPE) ? (String)metadata.field(DIRECTORY_TYPE) : DIRECTORY_MMAP;
        if (storage.getType().equals(ODatabaseType.MEMORY.name().toLowerCase()) || DIRECTORY_RAM.equals(luceneType)) {
            RAMDirectory dir = new RAMDirectory();
            return new OLuceneDirectory((Directory)dir, null);
        }
        return this.createDirectory(storage, indexName, metadata, luceneType);
    }

    private OLuceneDirectory createDirectory(OStorage storage, String indexName, ODocument metadata, String luceneType) {
        String luceneBasePath = metadata.containsField(DIRECTORY_PATH) ? (String)metadata.field(DIRECTORY_PATH) : OLUCENE_BASE_DIR;
        Path luceneIndexPath = Paths.get(storage.getConfiguration().getDirectory(), luceneBasePath, indexName);
        try {
            NIOFSDirectory dir = null;
            if (DIRECTORY_NIO.equals(luceneType)) {
                dir = new NIOFSDirectory(luceneIndexPath);
            } else if (DIRECTORY_MMAP.equals(luceneType)) {
                dir = new MMapDirectory(luceneIndexPath);
            }
            return new OLuceneDirectory((Directory)dir, luceneIndexPath.toString());
        }
        catch (IOException e) {
            OLogManager.instance().error((Object)this, "unable to create Lucene Directory with type " + luceneType, (Throwable)e, new Object[0]);
            OLogManager.instance().warn((Object)this, "unable to create Lucene Directory, FALL BACK to ramDir", new Object[0]);
            return new OLuceneDirectory((Directory)new RAMDirectory(), null);
        }
    }
}

