/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.builder;

import com.orientechnologies.lucene.builder.OLuceneIndexType;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexableField;

public class OLuceneDocumentBuilder {
    public Document newBuild(OIndexDefinition indexDefinition, Object key, OIdentifiable oid) {
        if (oid != null) {
            ORecord record = oid.getRecord();
            OElement oElement = (OElement)record.load();
        }
        return null;
    }

    public Document build(OIndexDefinition definition, Object key, OIdentifiable value, Map<String, Boolean> fieldsToStore, ODocument metadata) {
        Document doc = new Document();
        this.addDefaultFieldsToDocument(definition, value, doc);
        List<Object> formattedKey = this.formatKeys(definition, key);
        int counter = 0;
        for (String field : definition.getFields()) {
            Object val = formattedKey.get(counter);
            ++counter;
            if (val == null) continue;
            Boolean sorted = this.isSorted(field, metadata);
            OLuceneIndexType.createFields(field, val, Field.Store.YES, sorted).forEach(f -> doc.add((IndexableField)f));
            OLuceneIndexType.createFields(definition.getClassName() + "." + field, val, Field.Store.YES, sorted).forEach(f -> doc.add((IndexableField)f));
        }
        return doc;
    }

    private void addDefaultFieldsToDocument(OIndexDefinition definition, OIdentifiable value, Document doc) {
        if (value != null) {
            doc.add((IndexableField)OLuceneIndexType.createField("RID", value.getIdentity().toString(), Field.Store.YES));
            doc.add((IndexableField)OLuceneIndexType.createField("_CLUSTER", "" + value.getIdentity().getClusterId(), Field.Store.YES));
            doc.add((IndexableField)OLuceneIndexType.createField("_CLASS", definition.getClassName(), Field.Store.YES));
        }
    }

    private List<Object> formatKeys(OIndexDefinition definition, Object key) {
        ArrayList<Object> keys;
        if (key instanceof OCompositeKey) {
            keys = ((OCompositeKey)key).getKeys();
        } else if (key instanceof List) {
            keys = (List)key;
        } else {
            keys = new ArrayList<Object>();
            keys.add(key);
        }
        for (int i = keys.size(); i < definition.getFields().size(); ++i) {
            keys.add("");
        }
        return keys;
    }

    protected Field.Store isToStore(String f, Map<String, Boolean> collectionFields) {
        return collectionFields.get(f) != false ? Field.Store.YES : Field.Store.NO;
    }

    protected Boolean isSorted(String field, ODocument metadata) {
        if (metadata == null) {
            return true;
        }
        Boolean sorted = true;
        try {
            Boolean localSorted = (Boolean)metadata.field("*_index_sorted");
            if (localSorted == null) {
                localSorted = (Boolean)metadata.field(field + "_index_sorted");
            }
            if (localSorted != null) {
                sorted = localSorted;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sorted;
    }
}

