/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.spatial.shape;

import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.spatial.shape.OComplexShapeBuilder;
import com.orientechnologies.spatial.shape.OGeometryCollectionShapeBuilder;
import com.orientechnologies.spatial.shape.OLineStringShapeBuilder;
import com.orientechnologies.spatial.shape.OMultiLineStringShapeBuilder;
import com.orientechnologies.spatial.shape.OMultiPointShapeBuilder;
import com.orientechnologies.spatial.shape.OMultiPolygonShapeBuilder;
import com.orientechnologies.spatial.shape.OPointShapeBuilder;
import com.orientechnologies.spatial.shape.OPolygonShapeBuilder;
import com.orientechnologies.spatial.shape.ORectangleShapeBuilder;
import com.orientechnologies.spatial.shape.OShapeBuilder;
import com.orientechnologies.spatial.shape.OShapeOperation;
import com.orientechnologies.spatial.shape.OShapeOperationImpl;
import com.orientechnologies.spatial.shape.OShapeType;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.Point;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.shape.Rectangle;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.ShapeCollection;
import org.locationtech.spatial4j.shape.jts.JtsGeometry;
import org.locationtech.spatial4j.shape.jts.JtsPoint;

public class OShapeFactory
extends OComplexShapeBuilder {
    public static final OShapeFactory INSTANCE = new OShapeFactory();
    protected OShapeOperation operation;
    private Map<String, OShapeBuilder> factories = new HashMap<String, OShapeBuilder>();

    protected OShapeFactory() {
        this.operation = new OShapeOperationImpl(this);
        this.registerFactory(new OLineStringShapeBuilder());
        this.registerFactory(new OMultiLineStringShapeBuilder());
        this.registerFactory(new OPointShapeBuilder());
        this.registerFactory(new OMultiPointShapeBuilder());
        this.registerFactory(new ORectangleShapeBuilder());
        this.registerFactory(new OPolygonShapeBuilder());
        this.registerFactory(new OMultiPolygonShapeBuilder());
        this.registerFactory(new OGeometryCollectionShapeBuilder(this));
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public OShapeType getType() {
        return null;
    }

    @Override
    public void initClazz(ODatabaseInternal db) {
        for (OShapeBuilder f : this.factories.values()) {
            f.initClazz(db);
        }
    }

    @Override
    public Shape fromDoc(ODocument document) {
        OShapeBuilder oShapeBuilder = this.factories.get(document.getClassName());
        if (oShapeBuilder != null) {
            return oShapeBuilder.fromDoc(document);
        }
        return null;
    }

    @Override
    public Shape fromObject(Object obj) {
        if (obj instanceof String) {
            try {
                return this.fromText((String)obj);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if (obj instanceof ODocument) {
            return this.fromDoc((ODocument)obj);
        }
        if (obj instanceof Map) {
            Map map = (Map)((Map)obj).get("shape");
            if (map == null) {
                map = (Map)obj;
            }
            return this.fromMapGeoJson(map);
        }
        return null;
    }

    @Override
    public String asText(ODocument document) {
        OShapeBuilder oShapeBuilder = this.factories.get(document.getClassName());
        if (oShapeBuilder != null) {
            return oShapeBuilder.asText(document);
        }
        return null;
    }

    @Override
    public String asText(Object obj) {
        if (obj instanceof ODocument) {
            return this.asText((ODocument)obj);
        }
        if (obj instanceof Map) {
            Map map = (Map)((Map)obj).get("shape");
            if (map == null) {
                map = (Map)obj;
            }
            return this.asText(map);
        }
        return null;
    }

    @Override
    public byte[] asBinary(Object obj) {
        if (obj instanceof ODocument) {
            Shape shape = this.fromDoc((ODocument)obj);
            return ((OShapeBuilder)this).asBinary(shape);
        }
        if (obj instanceof Map) {
            Map map = (Map)((Map)obj).get("shape");
            if (map == null) {
                map = (Map)obj;
            }
            Shape shape = this.fromMapGeoJson(map);
            return ((OShapeBuilder)this).asBinary(shape);
        }
        throw new IllegalArgumentException("Error serializing to binary " + obj);
    }

    @Override
    public ODocument toDoc(Shape shape) {
        ODocument doc = null;
        if (org.locationtech.spatial4j.shape.Point.class.isAssignableFrom(shape.getClass())) {
            doc = this.factories.get(OPointShapeBuilder.NAME).toDoc(shape);
        } else if (Rectangle.class.isAssignableFrom(shape.getClass())) {
            doc = this.factories.get("ORectangle").toDoc(shape);
        } else if (JtsGeometry.class.isAssignableFrom(shape.getClass())) {
            JtsGeometry geometry = (JtsGeometry)shape;
            Geometry geom = geometry.getGeom();
            doc = this.factories.get("O" + geom.getClass().getSimpleName()).toDoc(shape);
        } else if (ShapeCollection.class.isAssignableFrom(shape.getClass())) {
            ShapeCollection collection = (ShapeCollection)shape;
            doc = this.isMultiPolygon((ShapeCollection<Shape>)collection) ? this.factories.get("OMultiPolygon").toDoc(this.createMultiPolygon((ShapeCollection<Shape>)collection)) : (this.isMultiPoint((ShapeCollection<Shape>)collection) ? this.factories.get("OMultiPoint").toDoc(this.createMultiPoint((ShapeCollection<JtsPoint>)collection)) : (this.isMultiLine((ShapeCollection<Shape>)collection) ? this.factories.get("OMultiLineString").toDoc(this.createMultiLine((ShapeCollection<JtsGeometry>)collection)) : this.factories.get("OGeometryCollection").toDoc(shape)));
        }
        return doc;
    }

    @Override
    public Shape fromMapGeoJson(Map geoJsonMap) {
        OShapeBuilder oShapeBuilder = this.factories.get(geoJsonMap.get("type"));
        if (oShapeBuilder == null) {
            oShapeBuilder = this.factories.get(geoJsonMap.get("@class"));
        }
        if (oShapeBuilder != null) {
            return oShapeBuilder.fromMapGeoJson(geoJsonMap);
        }
        throw new IllegalArgumentException("Invalid map");
    }

    @Override
    public Geometry toGeometry(Shape shape) {
        if (shape instanceof ShapeCollection) {
            ShapeCollection shapes = (ShapeCollection)shape;
            Geometry[] geometries = new Geometry[shapes.size()];
            int i = 0;
            for (Shape shapeItem : shapes) {
                geometries[i] = SPATIAL_CONTEXT.getGeometryFrom(shapeItem);
                ++i;
            }
            return GEOMETRY_FACTORY.createGeometryCollection(geometries);
        }
        return SPATIAL_CONTEXT.getGeometryFrom(shape);
    }

    @Override
    public ODocument toDoc(Geometry geometry) {
        if (geometry instanceof Point) {
            Point point = (Point)geometry;
            org.locationtech.spatial4j.shape.Point point1 = this.context().makePoint(point.getX(), point.getY());
            return this.toDoc((Shape)point1);
        }
        if (geometry instanceof GeometryCollection) {
            GeometryCollection gc = (GeometryCollection)geometry;
            ArrayList<JtsGeometry> shapes = new ArrayList<JtsGeometry>();
            for (int i = 0; i < gc.getNumGeometries(); ++i) {
                Geometry geo = gc.getGeometryN(i);
                JtsGeometry shape = null;
                if (geo instanceof Point) {
                    Point point = (Point)geo;
                    shape = this.context().makePoint(point.getX(), point.getY());
                } else {
                    shape = SPATIAL_CONTEXT.makeShape(geo);
                }
                shapes.add(shape);
            }
            return this.toDoc((Shape)new ShapeCollection(shapes, (SpatialContext)SPATIAL_CONTEXT));
        }
        return this.toDoc((Shape)SPATIAL_CONTEXT.makeShape(geometry));
    }

    public OShapeOperation operation() {
        return this.operation;
    }

    public void registerFactory(OShapeBuilder factory) {
        this.factories.put(factory.getName(), factory);
    }
}

