/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.spatial.shape;

import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.spatial.shape.OShapeBuilder;
import com.orientechnologies.spatial.shape.OShapeType;
import java.util.ArrayList;
import java.util.List;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Rectangle;

public class ORectangleShapeBuilder
extends OShapeBuilder<Rectangle> {
    public static final String NAME = "ORectangle";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public OShapeType getType() {
        return OShapeType.RECTANGLE;
    }

    @Override
    public void initClazz(ODatabaseInternal db) {
        OSchema schema = db.getMetadata().getSchema();
        OClass rectangle = schema.createAbstractClass(this.getName(), this.superClass(db));
        OProperty coordinates = rectangle.createProperty("coordinates", OType.EMBEDDEDLIST, OType.DOUBLE);
        coordinates.setMin("4");
        coordinates.setMin("4");
    }

    @Override
    public Rectangle fromDoc(ODocument document) {
        this.validate(document);
        List coordinates = (List)document.field("coordinates");
        Point topLeft = SPATIAL_CONTEXT.makePoint(((Number)coordinates.get(0)).doubleValue(), ((Number)coordinates.get(1)).doubleValue());
        Point bottomRight = SPATIAL_CONTEXT.makePoint(((Number)coordinates.get(2)).doubleValue(), ((Number)coordinates.get(3)).doubleValue());
        Rectangle rectangle = SPATIAL_CONTEXT.makeRectangle(topLeft, bottomRight);
        return rectangle;
    }

    @Override
    public ODocument toDoc(final Rectangle shape) {
        ODocument doc = new ODocument(this.getName());
        doc.field("coordinates", (Object)new ArrayList<Double>(){
            {
                this.add(shape.getMinX());
                this.add(shape.getMinY());
                this.add(shape.getMaxX());
                this.add(shape.getMaxY());
            }
        });
        return doc;
    }
}

