/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.spatial.shape;

import com.orientechnologies.spatial.shape.OShapeBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Rectangle;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.ShapeCollection;
import org.locationtech.spatial4j.shape.jts.JtsGeometry;
import org.locationtech.spatial4j.shape.jts.JtsPoint;

public abstract class OComplexShapeBuilder<T extends Shape>
extends OShapeBuilder<T> {
    protected List<List<Double>> coordinatesFromLineString(LineString ring) {
        Coordinate[] coordinates = ring.getCoordinates();
        ArrayList<List<Double>> numbers = new ArrayList<List<Double>>();
        for (Coordinate coordinate : coordinates) {
            numbers.add(Arrays.asList(coordinate.x, coordinate.y));
        }
        return numbers;
    }

    protected LineString createLineString(List<List<Number>> coordinates) {
        Coordinate[] coords = new Coordinate[coordinates.size()];
        int i = 0;
        for (List<Number> c : coordinates) {
            coords[i] = new Coordinate(c.get(0).doubleValue(), c.get(1).doubleValue());
            ++i;
        }
        return GEOMETRY_FACTORY.createLineString(coords);
    }

    protected JtsGeometry createMultiPoint(ShapeCollection<JtsPoint> geometries) {
        Coordinate[] points = new Coordinate[geometries.size()];
        int i = 0;
        for (JtsPoint geometry : geometries) {
            points[i] = new Coordinate(geometry.getX(), geometry.getY());
            ++i;
        }
        MultiPoint multiPoints = GEOMETRY_FACTORY.createMultiPoint(points);
        return SPATIAL_CONTEXT.makeShape((Geometry)multiPoints);
    }

    protected JtsGeometry createMultiLine(ShapeCollection<JtsGeometry> geometries) {
        LineString[] multiLineString = new LineString[geometries.size()];
        int i = 0;
        for (JtsGeometry geometry : geometries) {
            multiLineString[i] = (LineString)geometry.getGeom();
            ++i;
        }
        MultiLineString multiPoints = GEOMETRY_FACTORY.createMultiLineString(multiLineString);
        return SPATIAL_CONTEXT.makeShape((Geometry)multiPoints);
    }

    protected JtsGeometry createMultiPolygon(ShapeCollection<Shape> geometries) {
        Polygon[] polygons = new Polygon[geometries.size()];
        int i = 0;
        for (Shape geometry : geometries) {
            if (geometry instanceof JtsGeometry) {
                polygons[i] = (Polygon)((JtsGeometry)geometry).getGeom();
            } else {
                Rectangle rectangle = (Rectangle)geometry;
                Geometry geometryFrom = SPATIAL_CONTEXT.getGeometryFrom((Shape)rectangle);
                polygons[i] = (Polygon)geometryFrom;
            }
            ++i;
        }
        MultiPolygon multiPolygon = GEOMETRY_FACTORY.createMultiPolygon(polygons);
        return SPATIAL_CONTEXT.makeShape((Geometry)multiPolygon);
    }

    protected boolean isMultiPolygon(ShapeCollection<Shape> collection) {
        boolean isMultiPolygon = true;
        for (Shape shape : collection) {
            if (this.isPolygon(shape)) continue;
            isMultiPolygon = false;
            break;
        }
        return isMultiPolygon;
    }

    protected boolean isMultiPoint(ShapeCollection<Shape> collection) {
        boolean isMultipoint = true;
        for (Shape shape : collection) {
            if (this.isPoint(shape)) continue;
            isMultipoint = false;
            break;
        }
        return isMultipoint;
    }

    protected boolean isMultiLine(ShapeCollection<Shape> collection) {
        boolean isMultipoint = true;
        for (Shape shape : collection) {
            if (this.isLineString(shape)) continue;
            isMultipoint = false;
            break;
        }
        return isMultipoint;
    }

    private boolean isLineString(Shape shape) {
        if (shape instanceof JtsGeometry) {
            Geometry geom = ((JtsGeometry)shape).getGeom();
            return geom instanceof LineString;
        }
        return false;
    }

    protected boolean isPoint(Shape shape) {
        return shape instanceof Point;
    }

    protected boolean isPolygon(Shape shape) {
        if (shape instanceof JtsGeometry) {
            Geometry geom = ((JtsGeometry)shape).getGeom();
            return geom instanceof Polygon;
        }
        return shape instanceof Rectangle;
    }
}

