/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.spatial.index;

import com.orientechnologies.lucene.index.OLuceneIndexNotUnique;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OInvalidIndexEngineIdException;
import com.orientechnologies.orient.core.index.OIndexEngine;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.OIndexEngineCallback;
import com.orientechnologies.orient.core.tx.OTransactionIndexChanges;
import com.orientechnologies.orient.core.tx.OTransactionIndexChangesPerKey;
import com.orientechnologies.spatial.engine.OLuceneSpatialIndexContainer;
import com.orientechnologies.spatial.shape.OShapeFactory;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.spatial4j.shape.Shape;

public class OLuceneSpatialIndex
extends OLuceneIndexNotUnique {
    OShapeFactory shapeFactory = OShapeFactory.INSTANCE;

    public OLuceneSpatialIndex(String name, String typeId, String algorithm, int version, OAbstractPaginatedStorage storage, String valueContainerAlgorithm, ODocument metadata, int binaryFormatVersion) {
        super(name, typeId, algorithm, version, storage, valueContainerAlgorithm, metadata, binaryFormatVersion);
    }

    @Override
    public OLuceneIndexNotUnique put(Object key, OIdentifiable singleValue) {
        if (key == null) {
            return this;
        }
        return super.put(key, singleValue);
    }

    @Override
    protected Iterable<OTransactionIndexChangesPerKey.OTransactionIndexEntry> interpretTxKeyChanges(final OTransactionIndexChangesPerKey changes) {
        try {
            return (Iterable)this.storage.callIndexEngine(false, false, this.indexId, (OIndexEngineCallback)new OIndexEngineCallback<Iterable<OTransactionIndexChangesPerKey.OTransactionIndexEntry>>(){

                public Iterable<OTransactionIndexChangesPerKey.OTransactionIndexEntry> callEngine(OIndexEngine engine) {
                    if (((OLuceneSpatialIndexContainer)engine).isLegacy()) {
                        return OLuceneSpatialIndex.super.interpretTxKeyChanges(changes);
                    }
                    return OLuceneSpatialIndex.this.interpretAsSpatial(changes.entries);
                }
            });
        }
        catch (OInvalidIndexEngineIdException e) {
            e.printStackTrace();
            return super.interpretTxKeyChanges(changes);
        }
    }

    @Override
    protected Object encodeKey(Object key) {
        if (key instanceof ODocument) {
            Shape shape = this.shapeFactory.fromDoc((ODocument)key);
            return this.shapeFactory.toGeometry(shape);
        }
        return key;
    }

    @Override
    protected Object decodeKey(Object key) {
        if (key instanceof Geometry) {
            Geometry geom = (Geometry)key;
            return this.shapeFactory.toDoc(geom);
        }
        return key;
    }

    protected Iterable<OTransactionIndexChangesPerKey.OTransactionIndexEntry> interpretAsSpatial(List<OTransactionIndexChangesPerKey.OTransactionIndexEntry> entries) {
        ArrayList<OTransactionIndexChangesPerKey.OTransactionIndexEntry> newChanges = new ArrayList<OTransactionIndexChangesPerKey.OTransactionIndexEntry>();
        LinkedHashMap<OIdentifiable, Integer> counters = new LinkedHashMap<OIdentifiable, Integer>();
        for (OTransactionIndexChangesPerKey.OTransactionIndexEntry entry : entries) {
            Integer counter = (Integer)counters.get(entry.value);
            if (counter == null) {
                counter = 0;
            }
            switch (entry.operation) {
                case PUT: {
                    Integer n = counter;
                    Integer n2 = counter = Integer.valueOf(counter + 1);
                    break;
                }
                case REMOVE: {
                    Integer n = counter;
                    Integer n2 = counter = Integer.valueOf(counter - 1);
                    break;
                }
            }
            counters.put(entry.value, counter);
        }
        Set oIdentifiables = counters.keySet();
        for (OIdentifiable oIdentifiable : oIdentifiables) {
            switch ((Integer)counters.get(oIdentifiable)) {
                case 1: {
                    newChanges.add(new OTransactionIndexChangesPerKey.OTransactionIndexEntry(oIdentifiable, OTransactionIndexChanges.OPERATION.PUT));
                    break;
                }
                case -1: {
                    newChanges.add(new OTransactionIndexChangesPerKey.OTransactionIndexEntry(oIdentifiable, OTransactionIndexChanges.OPERATION.REMOVE));
                }
            }
        }
        return newChanges;
    }
}

