/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import com.orientechnologies.common.concur.resource.OCloseable;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.client.remote.OStorageRemote;
import com.orientechnologies.orient.core.OOrientShutdownListener;
import com.orientechnologies.orient.core.OOrientStartupListener;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import com.orientechnologies.orient.core.storage.index.sbtreebonsai.local.OSBTreeBonsai;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OBonsaiCollectionPointer;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OSBTreeCollectionManager;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class OSBTreeCollectionManagerRemote
implements OCloseable,
OSBTreeCollectionManager,
OOrientStartupListener,
OOrientShutdownListener {
    private static final ConcurrentLinkedHashMap<CacheKey, SBTreeBonsaiContainer> GLOBAL_TREE_CACHE = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(Long.MAX_VALUE).build();
    private static final int GLOBAL_EVICTION_THRESHOLD = OGlobalConfiguration.SBTREEBONSAI_LINKBAG_CACHE_EVICTION_SIZE.getValueAsInteger();
    private static final int GLOBAL_CACHE_MAX_SIZE = OGlobalConfiguration.SBTREEBONSAI_LINKBAG_CACHE_SIZE.getValueAsInteger();
    private static final Object[] GLOBAL_LOCKS;
    private static final int GLOBAL_SHIFT;
    private static final int GLOBAL_MASK;
    private final int evictionThreshold;
    private final int cacheMaxSize;
    private final int shift;
    private final int mask;
    private final Object[] locks;
    protected final ConcurrentLinkedHashMap<CacheKey, SBTreeBonsaiContainer> treeCache;
    private final OStorageRemote storage;
    private volatile ThreadLocal<Map<UUID, WeakReference<ORidBag>>> pendingCollections = new PendingCollectionsThreadLocal();

    public OSBTreeCollectionManagerRemote(OStorageRemote storage) {
        this(GLOBAL_TREE_CACHE, storage, GLOBAL_EVICTION_THRESHOLD, GLOBAL_CACHE_MAX_SIZE, GLOBAL_LOCKS);
    }

    OSBTreeCollectionManagerRemote(OStorageRemote storage, int evictionThreshold, int cacheMaxSize) {
        this((ConcurrentLinkedHashMap<CacheKey, SBTreeBonsaiContainer>)new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(Long.MAX_VALUE).build(), storage, evictionThreshold, cacheMaxSize, null);
    }

    private OSBTreeCollectionManagerRemote(ConcurrentLinkedHashMap<CacheKey, SBTreeBonsaiContainer> treeCache, OStorageRemote storage, int evictionThreshold, int cacheMaxSize, Object[] locks) {
        this.treeCache = treeCache;
        this.storage = storage;
        this.evictionThreshold = evictionThreshold;
        this.cacheMaxSize = cacheMaxSize;
        if (locks == null) {
            int concurrencyLevel = Runtime.getRuntime().availableProcessors() * 8;
            int size = 1;
            int shifted = 0;
            while (size < concurrencyLevel) {
                size <<= 1;
                ++shifted;
            }
            this.shift = 32 - shifted;
            this.mask = size - 1;
            locks = new Object[size];
            for (int i = 0; i < locks.length; ++i) {
                locks[i] = new Object();
            }
        } else {
            this.shift = GLOBAL_SHIFT;
            this.mask = GLOBAL_MASK;
        }
        this.locks = locks;
        Orient.instance().registerWeakOrientStartupListener((OOrientStartupListener)this);
        Orient.instance().registerWeakOrientShutdownListener((OOrientShutdownListener)this);
    }

    public void onShutdown() {
        this.pendingCollections = null;
        this.treeCache.clear();
    }

    public void onStartup() {
        if (this.pendingCollections == null) {
            this.pendingCollections = new PendingCollectionsThreadLocal();
        }
    }

    protected OSBTreeBonsai<OIdentifiable, Integer> createEdgeTree(OAtomicOperation atomicOperation, int clusterId) {
        throw new UnsupportedOperationException("Creation of SB-Tree from remote storage is not allowed");
    }

    protected OSBTreeBonsai<OIdentifiable, Integer> loadTree(OBonsaiCollectionPointer collectionPointer) {
        throw new UnsupportedOperationException();
    }

    public UUID listenForChanges(ORidBag collection) {
        UUID id = collection.getTemporaryId();
        if (id == null) {
            id = UUID.randomUUID();
        }
        this.pendingCollections.get().put(id, new WeakReference<ORidBag>(collection));
        return id;
    }

    public void updateCollectionPointer(UUID uuid, OBonsaiCollectionPointer pointer) {
        WeakReference<ORidBag> reference = this.pendingCollections.get().get(uuid);
        if (reference == null) {
            OLogManager.instance().warn((Object)this, "Update of collection pointer is received but collection is not registered", new Object[0]);
            return;
        }
        ORidBag collection = (ORidBag)reference.get();
        if (collection != null) {
            collection.notifySaved(pointer);
        }
    }

    public void clearPendingCollections() {
        this.pendingCollections.get().clear();
    }

    public Map<UUID, OBonsaiCollectionPointer> changedIds() {
        throw new UnsupportedOperationException();
    }

    public void clearChangedIds() {
        throw new UnsupportedOperationException();
    }

    public OSBTreeBonsai<OIdentifiable, Integer> createAndLoadTree(OAtomicOperation atomicOperation, int clusterId) throws IOException {
        return this.loadSBTree(this.createSBTree(clusterId, atomicOperation, null));
    }

    public OBonsaiCollectionPointer createSBTree(int clusterId, OAtomicOperation atomicOperation, UUID ownerUUID) throws IOException {
        OSBTreeBonsai<OIdentifiable, Integer> tree = this.createEdgeTree(atomicOperation, clusterId);
        return tree.getCollectionPointer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OSBTreeBonsai<OIdentifiable, Integer> loadSBTree(OBonsaiCollectionPointer collectionPointer) {
        OSBTreeBonsai tree;
        Object lock;
        CacheKey cacheKey = new CacheKey(this.storage, collectionPointer);
        Object object = lock = this.treesSubsetLock(cacheKey);
        synchronized (object) {
            SBTreeBonsaiContainer container = (SBTreeBonsaiContainer)this.treeCache.get((Object)cacheKey);
            if (container != null) {
                ++container.usagesCounter;
                container.lastAccessTime = System.currentTimeMillis();
                tree = container.tree;
            } else {
                tree = this.loadTree(collectionPointer);
                if (tree != null) {
                    assert (tree.getRootBucketPointer().equals((Object)collectionPointer.getRootPointer()));
                    container = new SBTreeBonsaiContainer(tree);
                    ++container.usagesCounter;
                    container.lastAccessTime = System.currentTimeMillis();
                    this.treeCache.put((Object)cacheKey, (Object)container);
                }
            }
        }
        this.evict();
        return tree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseSBTree(OBonsaiCollectionPointer collectionPointer) {
        Object lock;
        CacheKey cacheKey = new CacheKey(this.storage, collectionPointer);
        Object object = lock = this.treesSubsetLock(cacheKey);
        synchronized (object) {
            SBTreeBonsaiContainer container = (SBTreeBonsaiContainer)this.treeCache.getQuietly((Object)cacheKey);
            assert (container != null);
            --container.usagesCounter;
            assert (container.usagesCounter >= 0);
            container.lastAccessTime = System.currentTimeMillis();
        }
        this.evict();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(OBonsaiCollectionPointer collectionPointer) {
        Object lock;
        CacheKey cacheKey = new CacheKey(this.storage, collectionPointer);
        Object object = lock = this.treesSubsetLock(cacheKey);
        synchronized (object) {
            SBTreeBonsaiContainer container = (SBTreeBonsaiContainer)this.treeCache.getQuietly((Object)cacheKey);
            assert (container != null);
            if (container.usagesCounter != 0) {
                throw new IllegalStateException("Cannot delete SBTreeBonsai instance because it is used in other thread.");
            }
            this.treeCache.remove((Object)cacheKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evict() {
        if (this.treeCache.size() <= this.cacheMaxSize) {
            return;
        }
        for (CacheKey cacheKey : this.treeCache.ascendingKeySetWithLimit(this.evictionThreshold)) {
            Object treeLock;
            Object object = treeLock = this.treesSubsetLock(cacheKey);
            synchronized (object) {
                SBTreeBonsaiContainer container = (SBTreeBonsaiContainer)this.treeCache.getQuietly((Object)cacheKey);
                if (container != null && container.usagesCounter == 0) {
                    this.treeCache.remove((Object)cacheKey);
                }
            }
        }
    }

    public void close() {
        this.clear();
    }

    public void clear() {
        this.treeCache.keySet().removeIf(cacheKey -> ((CacheKey)cacheKey).storage == this.storage);
    }

    void clearClusterCache(long fileId, String fileName) {
        this.treeCache.entrySet().removeIf(entry -> {
            CacheKey key = (CacheKey)entry.getKey();
            if (key.storage == this.storage && key.pointer.getFileId() == fileId) {
                SBTreeBonsaiContainer container = (SBTreeBonsaiContainer)entry.getValue();
                if (container.usagesCounter > 0) {
                    throw new IllegalStateException("Ridbags of file " + fileName + " can not be cleared because some of them are in use");
                }
                return true;
            }
            return false;
        });
    }

    int size() {
        return this.treeCache.size();
    }

    protected Object treesSubsetLock(CacheKey cacheKey) {
        int hashCode = cacheKey.hashCode();
        int index = hashCode >>> this.shift & this.mask;
        return this.locks[index];
    }

    static {
        int concurrencyLevel = Runtime.getRuntime().availableProcessors() * 8;
        int size = 1;
        int shifted = 0;
        while (size < concurrencyLevel) {
            size <<= 1;
            ++shifted;
        }
        GLOBAL_SHIFT = 32 - shifted;
        GLOBAL_MASK = size - 1;
        Object[] locks = new Object[size];
        for (int i = 0; i < locks.length; ++i) {
            locks[i] = new Object();
        }
        GLOBAL_LOCKS = locks;
    }

    protected static final class CacheKey {
        private final OStorageRemote storage;
        private final OBonsaiCollectionPointer pointer;

        CacheKey(OStorageRemote storage, OBonsaiCollectionPointer pointer) {
            this.storage = storage;
            this.pointer = pointer;
        }

        public int hashCode() {
            return this.storage.hashCode() ^ this.pointer.hashCode();
        }

        public boolean equals(Object obj) {
            CacheKey other = (CacheKey)obj;
            return this.storage == other.storage && this.pointer.equals((Object)other.pointer);
        }
    }

    protected static final class SBTreeBonsaiContainer {
        private final OSBTreeBonsai<OIdentifiable, Integer> tree;
        protected volatile int usagesCounter = 0;
        protected volatile long lastAccessTime = 0L;

        private SBTreeBonsaiContainer(OSBTreeBonsai<OIdentifiable, Integer> tree) {
            this.tree = tree;
        }
    }

    private static class PendingCollectionsThreadLocal
    extends ThreadLocal<Map<UUID, WeakReference<ORidBag>>> {
        private PendingCollectionsThreadLocal() {
        }

        @Override
        protected Map<UUID, WeakReference<ORidBag>> initialValue() {
            return new HashMap<UUID, WeakReference<ORidBag>>();
        }
    }
}

