/*
 * Decompiled with CFR 0.152.
 */
package com.orhanobut.logger;

import android.text.TextUtils;
import android.util.Log;
import com.orhanobut.logger.LogLevel;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class Logger {
    private static final int CHUNK_SIZE = 4000;
    private static final int JSON_INDENT = 4;
    private static final Settings settings = new Settings();
    private static LogLevel logLevel = LogLevel.FULL;
    private static String TAG = "PRETTYLOGGER";

    private Logger() {
    }

    public static Settings init() {
        return settings;
    }

    public static Settings init(LogLevel logLevel) {
        return Logger.init(logLevel, TAG);
    }

    public static Settings init(String tag) {
        return Logger.init(LogLevel.FULL, tag);
    }

    public static Settings init(LogLevel logLevel, String tag) {
        if (tag == null) {
            throw new NullPointerException("tag may not be null");
        }
        if (tag.trim().length() == 0) {
            throw new IllegalStateException("tag may not be empty");
        }
        TAG = tag;
        Logger.logLevel = logLevel;
        return settings;
    }

    public static void d(String message) {
        Logger.d(message, Logger.settings.methodCount);
    }

    public static void d(String message, int methodCount) {
        Logger.validateMethodCount(methodCount);
        Logger.log(3, message, methodCount);
    }

    public static void e(String message) {
        Logger.e(message, null, Logger.settings.methodCount);
    }

    public static void e(Exception e) {
        Logger.e(null, e, Logger.settings.methodCount);
    }

    public static void e(String message, int methodCount) {
        Logger.validateMethodCount(methodCount);
        Logger.e(message, null, methodCount);
    }

    public static void e(String message, Exception e) {
        Logger.e(message, e, Logger.settings.methodCount);
    }

    public static void e(String message, Exception e, int methodCount) {
        Logger.validateMethodCount(methodCount);
        if (e != null && message != null) {
            message = message + " : " + e.toString();
        }
        if (e != null && message == null) {
            message = e.toString();
        }
        if (message == null) {
            message = "No message/exception is set";
        }
        Logger.log(6, message, methodCount);
    }

    public static void w(String message) {
        Logger.w(message, Logger.settings.methodCount);
    }

    public static void w(String message, int methodCount) {
        Logger.validateMethodCount(methodCount);
        Logger.log(5, message, methodCount);
    }

    public static void i(String message) {
        Logger.i(message, Logger.settings.methodCount);
    }

    public static void i(String message, int methodCount) {
        Logger.validateMethodCount(methodCount);
        Logger.log(4, message, methodCount);
    }

    public static void v(String message) {
        Logger.v(message, Logger.settings.methodCount);
    }

    public static void v(String message, int methodCount) {
        Logger.validateMethodCount(methodCount);
        Logger.log(2, message, methodCount);
    }

    public static void wtf(String message) {
        Logger.wtf(message, Logger.settings.methodCount);
    }

    public static void wtf(String message, int methodCount) {
        Logger.validateMethodCount(methodCount);
        Logger.log(7, message, methodCount);
    }

    public static void json(String json) {
        Logger.json(json, Logger.settings.methodCount);
    }

    public static void json(String json, int methodCount) {
        Logger.validateMethodCount(methodCount);
        if (TextUtils.isEmpty((CharSequence)json)) {
            Logger.d("Empty/Null json content", methodCount);
            return;
        }
        try {
            if (json.startsWith("{")) {
                JSONObject jsonObject = new JSONObject(json);
                String message = jsonObject.toString(4);
                Logger.d(message, methodCount);
                return;
            }
            if (json.startsWith("[")) {
                JSONArray jsonArray = new JSONArray(json);
                String message = jsonArray.toString(4);
                Logger.d(message, methodCount);
            }
        }
        catch (JSONException e) {
            Logger.d(e.getCause().getMessage() + "\n" + json, methodCount);
        }
    }

    private static void log(int logType, String message, int methodCount) {
        if (logLevel == LogLevel.NONE) {
            return;
        }
        Logger.logHeader(logType);
        Logger.logHeaderContent(logType, methodCount);
        byte[] bytes = message.getBytes();
        int length = bytes.length;
        if (length <= 4000) {
            if (methodCount > 0) {
                Logger.logDivider(logType);
            }
            Logger.logContent(logType, message);
            Logger.logFooter(logType);
            return;
        }
        if (methodCount > 0) {
            Logger.logDivider(logType);
        }
        for (int i = 0; i < length; i += 4000) {
            int count = Math.min(length - i, 4000);
            Logger.logContent(logType, new String(bytes, i, count));
        }
        Logger.logFooter(logType);
    }

    private static void logHeader(int logType) {
        Logger.logChunk(logType, "\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
    }

    private static void logHeaderContent(int logType, int methodCount) {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        if (Logger.settings.showThreadInfo) {
            Logger.logChunk(logType, "\u2551 Thread: " + Thread.currentThread().getName());
            Logger.logDivider(logType);
        }
        String level = "";
        for (int i = methodCount; i > 0; --i) {
            int stackIndex = i + 5;
            StringBuilder builder = new StringBuilder();
            builder.append("\u2551 ").append(level).append(Logger.getSimpleClassName(trace[stackIndex].getClassName())).append(".").append(trace[stackIndex].getMethodName()).append(" ").append(" (").append(trace[stackIndex].getFileName()).append(":").append(trace[stackIndex].getLineNumber()).append(")");
            level = level + "   ";
            Logger.logChunk(logType, builder.toString());
        }
    }

    private static void logFooter(int logType) {
        Logger.logChunk(logType, "\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
    }

    private static void logDivider(int logType) {
        Logger.logChunk(logType, "\u255f\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500");
    }

    private static void logContent(int logType, String chunk) {
        String[] lines;
        for (String line : lines = chunk.split(System.getProperty("line.separator"))) {
            Logger.logChunk(logType, "\u2551 " + line);
        }
    }

    private static void logChunk(int logType, String chunk) {
        switch (logType) {
            case 6: {
                Log.e((String)TAG, (String)chunk);
                break;
            }
            case 4: {
                Log.i((String)TAG, (String)chunk);
                break;
            }
            case 2: {
                Log.v((String)TAG, (String)chunk);
                break;
            }
            case 5: {
                Log.w((String)TAG, (String)chunk);
                break;
            }
            case 7: {
                Log.wtf((String)TAG, (String)chunk);
                break;
            }
            default: {
                Log.d((String)TAG, (String)chunk);
            }
        }
    }

    private static String getSimpleClassName(String name) {
        int lastIndex = name.lastIndexOf(".");
        return name.substring(lastIndex + 1);
    }

    private static void validateMethodCount(int methodCount) {
        if (methodCount < 0 || methodCount > 5) {
            throw new IllegalStateException("methodCount must be bigger than 0 and less than 5");
        }
    }

    public static class Settings {
        int methodCount = 2;
        boolean showThreadInfo = true;

        public Settings hideThreadInfo() {
            this.showThreadInfo = false;
            return this;
        }

        public Settings setMethodCount(int methodCount) {
            Logger.validateMethodCount(methodCount);
            this.methodCount = methodCount;
            return this;
        }
    }
}

