/*
 * Decompiled with CFR 0.152.
 */
package redis.util;

public class Encoding {
    public static final byte[] NEG_ONE;
    public static final byte[] NEG_ONE_WITH_CRLF;
    public static final char LF = '\n';
    public static final char CR = '\r';
    private static final int NUM_MAP_LENGTH = 256;
    private static byte[][] numMap;
    private static byte[][] numMapWithCRLF;

    public static byte[] numToBytes(long value) {
        return Encoding.numToBytes(value, false);
    }

    public static byte[] numToBytes(long value, boolean withCRLF) {
        if (value >= 0L && value < 256L) {
            int index = (int)value;
            return withCRLF ? numMapWithCRLF[index] : numMap[index];
        }
        if (value == -1L) {
            return withCRLF ? NEG_ONE_WITH_CRLF : NEG_ONE;
        }
        return Encoding.convert(value, withCRLF);
    }

    private static byte[] convert(long value, boolean withCRLF) {
        boolean negative = value < 0L;
        long abs = Math.abs(value);
        int index = (value == 0L ? 0 : (int)Math.log10(abs)) + (negative ? 2 : 1);
        byte[] bytes = new byte[withCRLF ? index + 2 : index];
        if (withCRLF) {
            bytes[index] = 13;
            bytes[index + 1] = 10;
        }
        if (negative) {
            bytes[0] = 45;
        }
        long next = abs;
        while ((next /= 10L) > 0L) {
            bytes[--index] = (byte)(48L + abs % 10L);
            abs = next;
        }
        bytes[--index] = (byte)(48L + abs);
        return bytes;
    }

    public static long bytesToNum(byte[] bytes) {
        int sign;
        byte read;
        int length = bytes.length;
        if (length == 0) {
            throw new IllegalArgumentException("value is not an integer or out of range");
        }
        int position = 0;
        if ((read = bytes[position++]) == 45) {
            read = bytes[position++];
            sign = -1;
        } else {
            sign = 1;
        }
        long number = 0L;
        while (true) {
            int value;
            if ((value = read - 48) >= 0 && value < 10) {
                number *= 10L;
                number += (long)value;
            } else {
                throw new IllegalArgumentException("value is not an integer or out of range");
            }
            if (position == length) {
                return number * (long)sign;
            }
            read = bytes[position++];
        }
    }

    static {
        int i;
        NEG_ONE = Encoding.convert(-1L, false);
        NEG_ONE_WITH_CRLF = Encoding.convert(-1L, true);
        numMap = new byte[256][];
        for (i = 0; i < 256; ++i) {
            Encoding.numMap[i] = Encoding.convert(i, false);
        }
        numMapWithCRLF = new byte[256][];
        for (i = 0; i < 256; ++i) {
            Encoding.numMapWithCRLF[i] = Encoding.convert(i, true);
        }
    }
}

