/*
 * Decompiled with CFR 0.152.
 */
package redis.netty4;

import io.netty.buffer.ByteBuf;
import io.netty.util.CharsetUtil;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.netty4.AbstractRedisDecoderState;
import redis.netty4.BulkReply;
import redis.netty4.ErrorReply;
import redis.netty4.InAMultiBulkDecoderState;
import redis.netty4.IntegerReply;
import redis.netty4.Reply;
import redis.netty4.StatusReply;

public class InitialRedisDecoderState
extends AbstractRedisDecoderState {
    private static final Logger LOG = LoggerFactory.getLogger(InitialRedisDecoderState.class);

    @Override
    public void decode(ByteBuf in) throws IOException {
        Reply res;
        int initialReaderIndex = in.readerIndex();
        this.setDecodedReply(null);
        this.setNextState(new InitialRedisDecoderState());
        if (in.readableBytes() < 1) {
            return;
        }
        byte code = in.readByte();
        int indexCrLf = InitialRedisDecoderState.findCrLf(in);
        if (indexCrLf < 0) {
            in.readerIndex(initialReaderIndex);
            return;
        }
        switch (code) {
            case 43: {
                String status = this.readString(in, indexCrLf);
                res = new StatusReply(status);
                break;
            }
            case 45: {
                String error = this.readString(in, indexCrLf);
                res = new ErrorReply(error);
                break;
            }
            case 58: {
                Long l = InitialRedisDecoderState.readLong(in, indexCrLf);
                if (l == null) {
                    in.readerIndex(initialReaderIndex);
                    return;
                }
                res = new IntegerReply(l);
                break;
            }
            case 36: {
                Integer size = this.readBulkReplySize(in, indexCrLf);
                if (size == null) {
                    in.readerIndex(initialReaderIndex);
                    return;
                }
                if (size == -1) {
                    res = BulkReply.NIL_REPLY;
                    break;
                }
                ByteBuf b = this.readBytes(in, indexCrLf, size);
                if (b == null) {
                    in.readerIndex(initialReaderIndex);
                    return;
                }
                res = new BulkReply(b);
                break;
            }
            case 42: {
                Long l = InitialRedisDecoderState.readLong(in, indexCrLf);
                if (l == null) {
                    in.readerIndex(initialReaderIndex);
                    return;
                }
                if (l > Integer.MAX_VALUE) {
                    in.readerIndex(initialReaderIndex);
                    throw new IllegalArgumentException("Java only supports arrays up to 2147483647 in size");
                }
                InAMultiBulkDecoderState ns = new InAMultiBulkDecoderState(l.intValue());
                ns.decode(in);
                res = ns.getDecodedReply();
                this.setNextState(ns.getNextState());
                break;
            }
            default: {
                throw new IOException("Unexpected character in stream: " + code);
            }
        }
        LOG.trace("decoded => {} ", (Object)res);
        this.setDecodedReply(res);
    }

    private String readString(ByteBuf is, int index) throws IOException {
        String res = is.readBytes(index - is.readerIndex()).toString(CharsetUtil.UTF_8);
        is.skipBytes(2);
        return res;
    }
}

