/*
 * Decompiled with CFR 0.152.
 */
package redis.netty4;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import redis.netty4.Command;
import redis.netty4.ErrorReply;
import redis.netty4.RedisException;
import redis.netty4.Reply;

public class CommandResp {
    private final Command command;
    private final Promise<Reply> replyPromise;
    private final Class<?> replyClass;
    private Reply replyForDebug = null;
    private long replyDate;
    private static final DateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");

    public CommandResp(Command command, Class<?> clazz, Promise<Reply> replyPromise) {
        this.command = command;
        this.replyPromise = replyPromise;
        this.replyClass = clazz;
    }

    public Command getCommand() {
        return this.command;
    }

    public <T> void map(final Promise<T> promise, final Class<T> clazz) {
        if (this.replyClass == null || !this.replyClass.equals(clazz)) {
            throw new RedisException("bad type : replyClass Name should be " + this.replyClass.getName() + " but is " + clazz.getName());
        }
        this.replyPromise.addListener(new GenericFutureListener<Future<Reply>>(){

            @Override
            public void operationComplete(Future<Reply> future) throws Exception {
                if (future.isSuccess()) {
                    Reply result = (Reply)future.get();
                    Object castedResult = null;
                    try {
                        castedResult = clazz.cast(result);
                        promise.setSuccess(castedResult);
                    }
                    catch (ClassCastException e) {
                        promise.setFailure(e);
                    }
                } else if (future.isCancelled()) {
                    promise.cancel(false);
                } else {
                    promise.setFailure(future.cause());
                }
            }
        });
    }

    public void setReply(Reply reply) {
        this.replyDate = System.currentTimeMillis();
        this.replyForDebug = reply;
        if (reply instanceof ErrorReply) {
            this.replyPromise.setFailure(new RedisException(reply.toString() + " Command was " + this.command));
        } else {
            if (this.replyClass == null || reply == null || reply.getClass() == null || !this.replyClass.isAssignableFrom(reply.getClass())) {
                throw new RedisException("bad type : replyClassName should be " + this.replyClass.getName() + " but is " + reply.getClass().getName() + " Command was " + this.command);
            }
            this.replyPromise.setSuccess(reply);
        }
    }

    public void setFailure(Throwable cause) {
        this.replyPromise.setFailure(cause);
    }

    public String toString() {
        return df.format(new Date(this.replyDate)) + " CommandResp [command=" + this.command + ", reply=" + this.replyForDebug + ", replyClassName=" + this.replyClass.getName() + "]";
    }
}

