/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.internal;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.circuitbreaker.CircuitBreakerConfiguration;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.InternalBuilderAccess;
import com.oracle.bmc.http.internal.BaseClient;
import com.oracle.bmc.http.internal.ClientCall;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.BmcResponse;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.CircuitBreakerUtils;
import java.util.function.Supplier;

public class BaseSyncClient
extends BaseClient {
    private final RetryConfiguration retryConfiguration;

    private static CircuitBreakerConfiguration circuitBreakerConfiguration(ClientBuilderBase<?, ?> builder, CircuitBreakerConfiguration defaultCircuitBreaker) {
        CircuitBreakerConfiguration circuitBreakerConfiguration = CircuitBreakerUtils.getUserDefinedCircuitBreakerConfiguration(InternalBuilderAccess.getConfiguration(builder));
        if (circuitBreakerConfiguration == null) {
            return defaultCircuitBreaker;
        }
        return circuitBreakerConfiguration;
    }

    protected BaseSyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, CircuitBreakerConfiguration defaultCircuitBreaker) {
        super(builder, authenticationDetailsProvider, BaseSyncClient.circuitBreakerConfiguration(builder, defaultCircuitBreaker));
        this.retryConfiguration = this.clientConfigurationToUse.getRetryConfiguration();
    }

    @Override
    protected <REQ extends BmcRequest<?>, RESP extends BmcResponse, RESP_BUILDER extends BmcResponse.Builder<RESP>> ClientCall<REQ, RESP, RESP_BUILDER> clientCall(REQ request, Supplier<RESP_BUILDER> responseBuilder) {
        return super.clientCall(request, responseBuilder).retryConfiguration(this.retryConfiguration);
    }
}

