/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http;

import com.google.common.base.Preconditions;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.DefaultConfigurator;
import com.oracle.bmc.http.internal.CrossTenancyRequestClientFilter;
import java.util.Arrays;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;

public class CrossTenancyRequestConfigurator
implements ClientConfigurator {
    private final ClientConfigurator baseConfigurator;
    private final String[] authorizedTenancyIds;

    public CrossTenancyRequestConfigurator(String[] authorizedTenancyIds) {
        this(authorizedTenancyIds, new DefaultConfigurator());
    }

    public CrossTenancyRequestConfigurator(String[] authorizedTenancyIds, ClientConfigurator baseConfigurator) {
        this.baseConfigurator = (ClientConfigurator)Preconditions.checkNotNull((Object)baseConfigurator);
        if (authorizedTenancyIds == null || authorizedTenancyIds.length == 0) {
            throw new IllegalArgumentException("Must provide at least one authorized tenancyId");
        }
        for (String authorizedTenancyId : authorizedTenancyIds) {
            if (authorizedTenancyId != null && !authorizedTenancyId.isEmpty()) continue;
            throw new IllegalArgumentException("Authorized tenancyId was not valid");
        }
        this.authorizedTenancyIds = Arrays.copyOf(authorizedTenancyIds, authorizedTenancyIds.length);
    }

    @Override
    public void customizeBuilder(ClientBuilder builder) {
        this.baseConfigurator.customizeBuilder(builder);
    }

    @Override
    public void customizeClient(Client client) {
        this.baseConfigurator.customizeClient(client);
        client.register((Object)new CrossTenancyRequestClientFilter(this.authorizedTenancyIds));
    }
}

