/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xslt;

import java.util.StringTokenizer;
import oracle.xml.xqxp.XQException;
import oracle.xml.xslt.WildCard;
import oracle.xml.xslt.XSLConstants;
import oracle.xml.xslt.XSLException;
import oracle.xml.xslt.XSLNode;
import oracle.xml.xslt.XSLStylesheet;

class XSLSpaceElem
extends XSLNode
implements XSLConstants {
    private boolean preserve;
    private WildCard[] wildCards;
    int importPrecedence;

    XSLSpaceElem(XSLStylesheet xSLStylesheet, String string) throws XSLException {
        super(xSLStylesheet);
        this.elementType = 3;
        this.localName = string;
        this.preserve = this.getLocalName() == "preserve-space";
    }

    @Override
    public void setAttribute(String string, String string2, String string3, String string4) throws XSLException, XQException {
        if (string == "" && string3 == "elements") {
            this.wildCards = this.getWildCards(string4);
        }
        super.setAttribute(string, string2, string3, string4);
    }

    private WildCard[] getWildCards(String string) throws XSLException {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = stringTokenizer.countTokens();
        WildCard[] wildCardArray = new WildCard[n];
        for (int i = 0; i < n; ++i) {
            wildCardArray[i] = new WildCard(stringTokenizer.nextToken(), this);
        }
        return wildCardArray;
    }

    int getImportPrecedence() {
        return this.importPrecedence;
    }

    boolean strip() {
        return !this.preserve;
    }

    int length() {
        return this.wildCards.length;
    }

    WildCard elementAt(int n) {
        if (n >= 0 && n < this.wildCards.length) {
            return this.wildCards[n];
        }
        return null;
    }
}

