/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xti;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.scalable.BinaryStream;
import oracle.xml.util.QxName;
import oracle.xml.xti.QNameKey;
import oracle.xml.xti.XTICompressor;
import oracle.xml.xti.XTIConstants;
import oracle.xml.xti.XTIContentManager;
import oracle.xml.xti.XTIDecoder;
import oracle.xml.xti.XTIDecompressor;
import oracle.xml.xti.XTIEncoder;
import oracle.xml.xti.XTIException;
import oracle.xml.xti.XTIUtil;

public class XTIStream
extends BinaryStream
implements XTIConstants {
    HashMap<QNameKey, byte[]> qnameHash = new HashMap(128);
    HashMap<Long, QxName> qnameCache = new HashMap(128);
    HashMap<Integer, byte[]> xtic = new HashMap();
    HashMap<Integer, byte[]> xtin = new HashMap();
    int[] xtinPages;
    int[] xticPages;
    int xtinPagesSize;
    int xticPagesSize;
    int maxPageId;
    boolean scratchMode;
    boolean twofilemode;
    static final int XTIN_STREAM = 0;
    static final int XTIC_STREAM = 1;
    XTIStream xtinstream;
    XTIStream xticstream;
    private int totalXTINPages = 0;
    private boolean isInterleaving = false;
    XTIEncoder encoder = null;
    XTIDecoder decoder = null;
    XTIContentManager xticm = null;
    XMLError err = new XMLError();
    private int xticmode = -1;
    private int zeroAvailByteStartPageNum = -1;
    private int zeroAvailByteEndPageNum = -1;
    int textsize = 0;
    private int freeBytesQname = 4091;
    private int freeBytesText = 4091;

    XTIStream() {
    }

    void initTwoFileMode4XTIN() {
        this.twofilemode = true;
        this.xtinPagesSize = 1024;
        this.xtinPages = new int[this.xtinPagesSize];
        this.resetBuffer();
        this.maxPageId = 0;
        this.readOnly = false;
    }

    void initTwoFileMode4XTIC() {
        this.twofilemode = true;
        this.xticPagesSize = 1024;
        this.xticPages = new int[this.xticPagesSize];
        this.resetBuffer();
        this.maxPageId = 0;
        this.readOnly = false;
    }

    void initScratchMode() {
        if (this.twofilemode) {
            this.err.error0(36003, 1);
            throw new XTIException(this.err.getMessage0(36003));
        }
        this.scratchMode = true;
        this.xtinPagesSize = 1024;
        this.xticPagesSize = 1024;
        this.xtinPages = new int[this.xtinPagesSize];
        this.xticPages = new int[this.xticPagesSize];
        this.resetBuffer();
        this.maxPageId = 0;
        this.readOnly = false;
    }

    @Override
    public void setFiles(File file, File file2) throws IOException {
        if (this.scratchMode && this.pagedio != null && this.pagedio instanceof BinaryStream.FilePagedIO || this.twofilemode && this.xtinstream != null && this.xticstream != null) {
            this.err.error0(36003, 1);
            throw new XTIException(this.err.getMessage0(36003));
        }
        this.scratchMode = false;
        this.twofilemode = true;
        this.setXTINFile(file);
        this.setXTICFile(file2);
    }

    private void setXTINFile(File file) throws IOException {
        this.xtinstream = new XTIStream();
        this.xtinstream.setFile(file);
        this.xtinstream.initTwoFileMode4XTIN();
    }

    private void setXTICFile(File file) throws IOException {
        this.xticstream = new XTIStream();
        this.xticstream.setFile(file);
        this.xticstream.initTwoFileMode4XTIC();
    }

    public XTIEncoder getEncoder() {
        if (this.encoder == null) {
            this.encoder = new XTIEncoder(this);
        }
        this.readOnly = false;
        return this.encoder;
    }

    public XTIDecoder getDecoder() {
        if (this.decoder == null) {
            this.decoder = new XTIDecoder(this);
        }
        this.readOnly = true;
        return this.decoder;
    }

    void setXMLError(XMLError xMLError) {
        this.err = xMLError;
    }

    @Override
    public XTIContentManager getContentManager() {
        if (this.xticm == null) {
            this.xticm = this.encoder != null ? this.encoder : new XTIContentManager(this);
        }
        return this.xticm;
    }

    void setZeroAvailByteStartPageNum(int n) {
        this.zeroAvailByteStartPageNum = n;
    }

    void setZeroAvailByteEndPageNum(int n) {
        this.zeroAvailByteEndPageNum = n;
    }

    void setFreeBytesQname(int n) {
        this.freeBytesQname = n;
    }

    void setFreeBytesText(int n) {
        this.freeBytesText = n;
    }

    private byte[] getXTINPageData(XTIStream xTIStream, int n, boolean bl) {
        if (n >= xTIStream.xtinPagesSize) {
            int[] nArray = xTIStream.xtinPages;
            xTIStream.xtinPages = new int[xTIStream.xtinPagesSize + 1024];
            System.arraycopy(nArray, 0, xTIStream.xtinPages, 0, xTIStream.xtinPagesSize);
            xTIStream.xtinPagesSize += 1024;
        }
        int n2 = xTIStream.xtinPages[n];
        if (n == 0) {
            if (xTIStream.maxPageId == 0) {
                xTIStream.maxPageId += 2;
            }
            return xTIStream.load(0, 8192, bl);
        }
        if (n2 == 0) {
            xTIStream.xtinPages[n] = n2 = xTIStream.maxPageId;
            xTIStream.maxPageId += 2;
        }
        return xTIStream.load(n2, 8192, bl);
    }

    byte[] getXTINPageNumber(int n, boolean bl) {
        if (this.scratchMode) {
            return this.getXTINPageData(this, n, bl);
        }
        if (this.twofilemode) {
            return this.getXTINPageData(this.xtinstream, n, bl);
        }
        byte[] byArray = this.xtin.get(n);
        if (byArray == null) {
            byArray = new byte[8192];
            this.xtin.put(n, byArray);
        }
        return byArray;
    }

    void setXTINPageNumber(int n, byte[] byArray) {
        if (this.twofilemode) {
            int n2 = this.xtinstream.xtinPages[n];
            this.xtinstream.unload(n2, true, byArray);
        }
    }

    void setXTICPageNumber(int n, byte[] byArray) {
        if (this.twofilemode) {
            int n2 = this.xticstream.xticPages[n];
            this.xticstream.unload(n2, true, byArray);
        }
    }

    private byte[] getXTICPageData(XTIStream xTIStream, int n, boolean bl) {
        int n2;
        if (n >= xTIStream.xticPagesSize) {
            int[] nArray = xTIStream.xticPages;
            xTIStream.xticPages = new int[xTIStream.xticPagesSize + 1024];
            System.arraycopy(nArray, 0, xTIStream.xticPages, 0, xTIStream.xticPagesSize);
            xTIStream.xticPagesSize += 1024;
        }
        if ((n2 = xTIStream.xticPages[n]) == 0) {
            xTIStream.xticPages[n] = n2 = xTIStream.maxPageId++;
        }
        return xTIStream.load(n2, 4096, bl);
    }

    byte[] getXTICPageNumber(int n, boolean bl) {
        if (this.scratchMode) {
            return this.getXTICPageData(this, n, bl);
        }
        if (this.twofilemode) {
            return this.getXTICPageData(this.xticstream, n, bl);
        }
        byte[] byArray = this.xtic.get(n);
        if (byArray == null) {
            byArray = new byte[4096];
            this.xtic.put(n, byArray);
        }
        return byArray;
    }

    void writeToXTINAddress(int n, byte[] byArray, boolean bl) {
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        n3 = 32 * n3;
        byte[] byArray2 = this.getXTINPageNumber(n2, true);
        System.arraycopy(byArray, 0, byArray2, n3, byArray.length);
        byte by = byArray2[n3];
        if (bl) {
            byArray2[n3] = by = (byte)(by | 0x10);
        }
        this.setXTINPageNumber(n2, byArray2);
    }

    void writePIToAddress(int[] nArray, String string, String string2) throws Exception {
        int n = 0;
        int n2 = 0;
        byte[] byArray = null;
        this.xticmode = 1;
        byte[] byArray2 = this.getUTF8Bytes(string);
        int n3 = byArray2.length;
        if (n3 <= XTIUtil.getXTICSizePerPage(this.xticmode)) {
            n = nArray[0] >> 12;
            n2 = nArray[0] & 0xFFF;
            byArray = this.getXTICPageNumber(n, true);
            if (n2 == 5) {
                this.writeFirst5Bytes4XTICPages(byArray, this.freeBytesQname, n, true);
            }
            System.arraycopy(byArray2, 0, byArray, n2, n3);
            byArray[n3 + n2] = 0;
            this.setXTICPageNumber(n, byArray);
        } else {
            this.writeMoreThanOnePage(nArray, byArray2, n3, n2, 0, 0);
        }
        byArray2 = this.getUTF8Bytes(string2);
        n3 = byArray2.length;
        if (n3 <= XTIUtil.getXTICSizePerPage(this.xticmode)) {
            n = nArray[1] >> 12;
            n2 = nArray[1] & 0xFFF;
            byArray = this.getXTICPageNumber(n, true);
            if (n2 == 5) {
                this.writeFirst5Bytes4XTICPages(byArray, this.freeBytesQname, n, true);
            }
            System.arraycopy(byArray2, 0, byArray, n2, n3);
            byArray[n3 + n2] = 0;
            this.setXTICPageNumber(n, byArray);
        } else {
            this.writeMoreThanOnePage(nArray, byArray2, n3, n2, 1, 0);
        }
    }

    private void writeMoreThanOnePage(int[] nArray, byte[] byArray, int n, int n2, int n3, int n4) throws XTIException {
        int n5 = XTIUtil.getXTICSizePerPage(this.xticmode);
        int n6 = 4096;
        switch (this.xticmode) {
            case 1: {
                n6 = this.freeBytesQname;
                break;
            }
            case 0: 
            case 2: {
                n6 = this.freeBytesText;
            }
        }
        int n7 = nArray[n3] >> 12;
        n2 = nArray[n3] & 0xFFF;
        int n8 = (int)Math.round((double)(n / n5) + 0.5);
        byte[] byArray2 = this.getXTICPageNumber(n7, true);
        if (n2 == 5) {
            this.writeFirst5Bytes4XTICPages(byArray2, 0, n7, true);
        }
        boolean bl = false;
        if (n4 > 0) {
            byArray2[n2] = (byte)n4;
            System.arraycopy(byArray, 0, byArray2, n2 + 1, n5 - 1);
            bl = true;
        } else {
            System.arraycopy(byArray, 0, byArray2, n2, n5);
        }
        this.setXTICPageNumber(n7, byArray2);
        for (int i = 1; i < n8; ++i) {
            byArray2 = this.getXTICPageNumber(++n7, true);
            if (i + 1 == n8) {
                int n9 = n - n5 * i;
                if (bl) {
                    System.arraycopy(byArray, n5 * i - 1, byArray2, n2, n9 + 1);
                    this.writeFirst5Bytes4XTICPages(byArray2, n9 + 1, n7, false);
                } else {
                    System.arraycopy(byArray, n5 * i, byArray2, n2, n9);
                    this.writeFirst5Bytes4XTICPages(byArray2, n9, n7, false);
                }
            } else {
                System.arraycopy(byArray, n5 * i, byArray2, n2, n5);
                this.writeFirst5Bytes4XTICPages(byArray2, 0, n7, true);
            }
            this.setXTICPageNumber(n7, byArray2);
        }
    }

    void writeTextToAddress(int[] nArray, String string) throws XTIException {
        int n = 0;
        int n2 = 0;
        byte[] byArray = null;
        this.xticmode = 2;
        byte[] byArray2 = this.getUTF8Bytes(string);
        int n3 = byArray2.length;
        if (n3 <= XTIUtil.getXTICSizePerPage(this.xticmode)) {
            n = nArray[0] >> 12;
            n2 = nArray[0] & 0xFFF;
            byArray = this.getXTICPageNumber(n, true);
            if (n2 == 5) {
                this.writeFirst5Bytes4XTICPages(byArray, this.freeBytesText, n, true);
            }
            System.arraycopy(byArray2, 0, byArray, n2, n3);
            byArray[n3 + n2] = 0;
            this.setXTICPageNumber(n, byArray);
        } else {
            this.writeMoreThanOnePage(nArray, byArray2, n3, n2, 0, 0);
        }
    }

    void writeQnameTOAddress(int[] nArray, String string, String string2, String string3) throws XTIException {
        byte[] byArray;
        int n;
        int n2 = 0;
        this.xticmode = 1;
        byte[] byArray2 = this.getUTF8Bytes(string);
        int n3 = byArray2.length;
        if (n3 <= XTIUtil.getXTICSizePerPage(this.xticmode)) {
            n = nArray[0] >> 12;
            byArray = this.getXTICPageNumber(n, true);
            n2 = nArray[0] & 0xFFF;
            System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
            if (n2 == 5) {
                this.writeFirst5Bytes4XTICPages(byArray, this.freeBytesQname, n, true);
            }
            byArray[n2 + byArray2.length] = 0;
            this.setXTICPageNumber(n, byArray);
        } else {
            this.writeMoreThanOnePage(nArray, byArray2, n3, n2, 0, 0);
        }
        int n4 = string2.length();
        if (n4 > 255) {
            String string4 = Integer.toString(n4);
            this.err.error1(36001, 1, string4);
            throw new XTIException(this.err.getMessage1(36001, string4));
        }
        String string5 = string2 + ":" + string3;
        byArray2 = this.getUTF8Bytes(string5);
        n3 = byArray2.length;
        if (n3 <= XTIUtil.getXTICSizePerPage(this.xticmode)) {
            n = nArray[1] >> 12;
            n2 = nArray[1] & 0xFFF;
            byArray = this.getXTICPageNumber(n, true);
            byArray[n2] = (byte)(n4 + 1);
            System.arraycopy(byArray2, 0, byArray, n2 + 1, byArray2.length);
            byArray[byArray2.length + 1 + n2] = 0;
            this.setXTICPageNumber(n, byArray);
        } else {
            this.writeMoreThanOnePage(nArray, byArray2, n3, n2, 1, n4 + 1);
        }
    }

    private byte[] writeFirst5Bytes4XTICPages(byte[] byArray, int n, int n2, boolean bl) {
        int n3 = 0;
        int n4 = 4091;
        switch (this.xticmode) {
            case 1: {
                n3 = 1;
                break;
            }
            case 2: {
                n3 = 2;
                break;
            }
            case 0: {
                n3 = 2;
                n4 = 4089;
            }
        }
        if (n2 >= this.zeroAvailByteStartPageNum && n2 <= this.zeroAvailByteEndPageNum) {
            n = 0;
            bl = true;
        }
        int n5 = bl ? n : n4 - n;
        byte[] byArray2 = XTIUtil.intToByteArray(n4 - n5);
        for (int i = 0; i < 4; ++i) {
            byArray[i] = byArray2[i];
        }
        byArray[4] = n3;
        return byArray;
    }

    private byte[] getUTF8Bytes(String string) {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = string.getBytes();
            this.xticmode = 0;
        }
        return byArray;
    }

    void flushInterleavingToStream() throws IOException {
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte[] byArray3 = new byte[BUFSIZE];
        int n = this.getMaxKey(0);
        int n2 = this.getMaxKey(1);
        int n3 = 0;
        do {
            byArray2 = (byArray2 = this.xtin.get(n3)) == null ? byArray3 : XTICompressor.compressXTINPage(byArray2, n3);
            this.flushBuffer(byArray2, BUFSIZE);
            byArray = this.xtic.get(n3);
            if (byArray == null) {
                byArray = byArray3;
            }
            this.flushBuffer(byArray, BUFSIZE);
        } while (++n3 <= n || n3 <= n2);
    }

    void flushToStream() throws IOException {
        if (this.isInterleaving) {
            this.flushInterleavingToStream();
            return;
        }
        if (this.twofilemode) {
            this.flushToStreamInTwoFileMode();
        } else {
            this.flushToStreamInOtherMode();
        }
    }

    private void flushToStreamInTwoFileMode() throws IOException {
        this.xtinstream.flushAllPagesInMemory();
        this.xticstream.flushAllPagesInMemory();
    }

    @Override
    public void close() {
        if (this.twofilemode) {
            if (this.xtinstream != null) {
                this.xtinstream.close();
            }
            if (this.xticstream != null) {
                this.xticstream.close();
            }
        }
        super.close();
    }

    private void flushToStreamInOtherMode() throws IOException {
        int n;
        byte[] byArray = new byte[BUFSIZE];
        byte[] byArray2 = null;
        byte[] byArray3 = new byte[8192];
        int n2 = this.getMaxKey(0);
        for (n = 0; n <= n2; ++n) {
            byArray2 = this.xtin.get(n);
            if (byArray2 == null) {
                byArray2 = byArray3;
            }
            this.flushBuffer(byArray2, BUFSIZE);
            System.arraycopy(byArray2, BUFSIZE, byArray, 0, BUFSIZE);
            this.flushBuffer(byArray, BUFSIZE);
        }
        n2 = this.getMaxKey(1);
        for (n = 0; n <= n2; ++n) {
            byArray2 = this.xtic.get(n);
            if (byArray2 == null) {
                byArray2 = byArray3;
            }
            this.flushBuffer(byArray2, BUFSIZE);
        }
    }

    private int getMaxKey(int n) {
        Set<Integer> set = null;
        set = n == 0 ? this.xtin.keySet() : this.xtic.keySet();
        ArrayList<Integer> arrayList = new ArrayList<Integer>(set);
        Collections.sort(arrayList);
        int n2 = arrayList.get(arrayList.size() - 1);
        return n2;
    }

    private byte[] readXTINPageData(XTIStream xTIStream, int n, boolean bl) {
        if (n >= xTIStream.xtinPagesSize) {
            int[] nArray = xTIStream.xtinPages;
            xTIStream.xtinPages = new int[xTIStream.xtinPagesSize + 1024];
            System.arraycopy(nArray, 0, xTIStream.xtinPages, 0, xTIStream.xtinPagesSize);
            xTIStream.xtinPagesSize += 1024;
        }
        int n2 = xTIStream.xtinPages[n];
        if (n == 0) {
            if (xTIStream.maxPageId == 0) {
                xTIStream.maxPageId += 2;
            }
            return xTIStream.load(0, 8192, bl);
        }
        if (n2 == 0) {
            xTIStream.xtinPages[n] = n2 = xTIStream.maxPageId;
            xTIStream.maxPageId += 2;
        }
        return xTIStream.load(n2, 8192, bl);
    }

    byte[] readXTINPage(int n, boolean bl) {
        if (this.scratchMode) {
            return this.readXTINPageData(this, n, bl);
        }
        if (this.twofilemode) {
            return this.readXTINPageData(this.xtinstream, n, bl);
        }
        if (!this.xtin.containsKey(n)) {
            this.loadXTINPage(n, true);
        }
        return this.xtin.get(n);
    }

    byte[] readXTICPage(int n, boolean bl) {
        byte[] byArray = this.getAllBytesFromStartPageNum(n, bl);
        return byArray;
    }

    private byte[] getAllBytesFromStartPageNum(int n, boolean bl) {
        boolean bl2 = false;
        byte[] byArray = this.getXTICBytes(n, bl);
        bl2 = this.needReadNextXTICPage(byArray, n);
        if (!bl2) {
            return byArray;
        }
        byte[][] byArray2 = this.addByteArray2Bytes(byArray, null);
        int n2 = 1;
        while (this.needReadNextXTICPage(byArray2[n2 - 1], n)) {
            byArray = this.getXTICBytes(++n, bl);
            byArray2 = this.addByteArray2Bytes(byArray, byArray2);
            ++n2;
        }
        int n3 = n2 * 4096;
        byte[] byArray3 = new byte[n3];
        for (int i = 0; i < n2; ++i) {
            if (i == 0) {
                System.arraycopy(byArray2[i], 0, byArray3, 0, 4096);
                continue;
            }
            System.arraycopy(byArray2[i], 5, byArray3, 4096 + (i - 1) * XTIUtil.getXTICSizePerPage(this.xticmode), XTIUtil.getXTICSizePerPage(this.xticmode));
        }
        return byArray3;
    }

    private byte[] getXTICBytes(int n, boolean bl) {
        byte[] byArray;
        if (this.scratchMode || this.twofilemode) {
            return this.getXTICPageNumber(n, bl);
        }
        if (!this.xtic.containsKey(n)) {
            byArray = this.loadXTICPage(n, bl);
        }
        byArray = this.xtic.get(n);
        return byArray;
    }

    private boolean needReadNextXTICPage(byte[] byArray, int n) {
        if (n >= this.zeroAvailByteStartPageNum && n <= this.zeroAvailByteEndPageNum) {
            return true;
        }
        int n2 = XTIUtil.byteArrayToInt(byArray, 0);
        int n3 = XTIUtil.getXTICSizePerPage(this.xticmode);
        int n4 = n3 - n2;
        return n4 == 0;
    }

    private byte[][] addByteArray2Bytes(byte[] byArray, byte[][] byArray2) {
        int n = 0;
        if (byArray2 == null) {
            byte[][] byArray3 = new byte[1][4096];
            System.arraycopy(byArray, 0, byArray3[0], 0, 4096);
            return byArray3;
        }
        n = byArray2.length;
        byte[][] byArray4 = new byte[++n][4096];
        for (int i = 0; i < n - 1; ++i) {
            System.arraycopy(byArray2[i], 0, byArray4[i], 0, 4096);
        }
        System.arraycopy(byArray, 0, byArray4[n - 1], 0, 4096);
        return byArray4;
    }

    private byte[] loadXTINPage(int n, boolean bl) {
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        if (this.isInterleaving) {
            byArray = this.load(n * 2, bl);
            byArray3 = XTIDecompressor.uncompressXTINPage(byArray, n);
        } else {
            byArray = this.load(n * 2, bl);
            byArray2 = this.load(n * 2 + 1, bl);
            byArray3 = new byte[8192];
            System.arraycopy(byArray, 0, byArray3, 0, BUFSIZE);
            System.arraycopy(byArray2, 0, byArray3, BUFSIZE, BUFSIZE);
        }
        this.xtin.put(n, byArray3);
        return byArray3;
    }

    void setTotalXTINPages(int n) {
        this.totalXTINPages = n;
    }

    boolean isInterleaving() {
        return this.isInterleaving;
    }

    void setInterleaving(boolean bl) {
        this.isInterleaving = bl;
    }

    private byte[] loadXTICPage(int n, boolean bl) {
        byte[] byArray = null;
        byArray = this.isInterleaving ? this.load(n * 2 + 1, bl) : this.load(this.totalXTINPages * 2 + n, bl);
        this.xtic.put(n, byArray);
        return byArray;
    }
}

