/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xqxp.functions.builtIns;

import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xqxp.functions.OXMLFunction;
import oracle.xml.xqxp.functions.OXMLFunctionContext;
import oracle.xml.xqxp.functions.builtIns.FNUtil;

class StringToCodepoints
extends OXMLFunction {
    StringToCodepoints() {
    }

    @Override
    public String getFunctionName() {
        return "string-to-codepoints";
    }

    @Override
    public int getNumberArgs() {
        return 1;
    }

    @Override
    public OXMLSequenceType getReturnType() {
        return OXMLSequenceType.getConstantType(4, 22);
    }

    @Override
    public OXMLSequenceType getArgType(int n) {
        if (n == 0) {
            return OXMLSequenceType.TSTRING_ZERO_OR_ONE;
        }
        return null;
    }

    @Override
    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence oXMLSequence) throws XQException {
        OXMLItem oXMLItem = FNUtil.getEmptyOrSingleItem(oXMLSequence);
        if (oXMLItem == null) {
            OXMLSequence oXMLSequence2 = oXMLFunctionContext.createSequence();
            return oXMLSequence2;
        }
        String string = oXMLItem.getString();
        OXMLSequence oXMLSequence3 = oXMLFunctionContext.createSequence();
        for (int i = 0; i < string.length(); ++i) {
            int n = string.charAt(i);
            if ((n & 0xFC00) == 55296 && i + 1 < string.length()) {
                char c = string.charAt(++i);
                n = ((n & 0x3FF) << 10 | c & 0x3FF) + 65536;
            }
            OXMLItem oXMLItem2 = oXMLFunctionContext.createItem();
            oXMLItem2.setInt(OXMLSequenceType.TINTEGER, n);
            oXMLSequence3.appendItem(oXMLItem2);
        }
        return oXMLSequence3;
    }

    @Override
    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence[] oXMLSequenceArray) throws XQException {
        if (oXMLSequenceArray.length != 1) {
            throw new XQException("FORT0001");
        }
        return this.invoke(oXMLFunctionContext, oXMLSequenceArray[0]);
    }
}

