/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xpath;

import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDNode;
import oracle.xml.parser.v2.TypedAttributes;
import oracle.xml.parser.v2.XMLAttr;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.xpath.XPathAxis;
import oracle.xml.xpath.XPathCompileEvents;
import oracle.xml.xpath.XPathException;
import oracle.xml.xpath.XPathPredicate;
import oracle.xml.xpath.XPathRuntimeContext;
import oracle.xml.xpath.XPathSequence;
import oracle.xml.xpath.XSLExpr;
import oracle.xml.xpath.XSLExprBase;
import oracle.xml.xpath.XSLParseString;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xslt.XSLException;
import oracle.xml.xslt.XSLStylesheet;
import oracle.xml.xslt.XSLTContext;

public class XPathStep
extends XSLExprBase {
    int nodeTestType;
    int nodeType;
    String name;
    String nameSpace;
    XSDNode schNode;
    XPathAxis axisClass = null;
    int prevSeparator;
    boolean anyNode = false;
    boolean isPattern;
    boolean lazyLoad;
    boolean firstNodeOnly;
    static final XPathStep DESC_SELF = new XPathStep();

    boolean isSame(XPathStep xPathStep) throws NullPointerException {
        if (!this.name.equals(xPathStep.name)) {
            return false;
        }
        if (!this.nameSpace.equals(xPathStep.nameSpace)) {
            return false;
        }
        if (this.prevSeparator != xPathStep.prevSeparator) {
            return false;
        }
        if (!this.axisClass.isSame(xPathStep.axisClass)) {
            return false;
        }
        if (this.nodeTestType != xPathStep.nodeTestType) {
            return false;
        }
        if (this.nodeType != xPathStep.nodeType) {
            return false;
        }
        if (this.isPattern != xPathStep.isPattern) {
            return false;
        }
        if (this.lazyLoad != xPathStep.lazyLoad) {
            return false;
        }
        if (this.firstNodeOnly != xPathStep.firstNodeOnly) {
            return false;
        }
        if (this.exprType != xPathStep.exprType) {
            return false;
        }
        if (this.operator != xPathStep.operator) {
            return false;
        }
        if (this.priority != xPathStep.priority) {
            return false;
        }
        if (this.version != xPathStep.version) {
            return false;
        }
        if (this.bkwdCompFlag != xPathStep.bkwdCompFlag) {
            return false;
        }
        return this.fwdCompFlag == xPathStep.fwdCompFlag;
    }

    XPathStep clone(boolean bl) {
        XPathStep xPathStep = new XPathStep();
        xPathStep.name = this.name;
        xPathStep.nameSpace = this.nameSpace;
        xPathStep.prevSeparator = this.prevSeparator;
        xPathStep.nodeTestType = this.nodeTestType;
        xPathStep.nodeType = this.nodeType;
        xPathStep.axisClass = this.axisClass;
        xPathStep.anyNode = this.anyNode;
        xPathStep.isPattern = this.isPattern;
        xPathStep.lazyLoad = this.lazyLoad;
        xPathStep.firstNodeOnly = this.firstNodeOnly;
        super.clone(xPathStep, bl);
        return xPathStep;
    }

    XPathStep() {
    }

    static XPathStep parseAxisStep(XSLParseString xSLParseString, int n) throws XSLException, XQException {
        XPathStep xPathStep = null;
        int n2 = xSLParseString.peekToken();
        switch (n2) {
            case 3: 
            case 4: {
                if (xSLParseString.isPattern()) {
                    return null;
                }
                xPathStep = new XPathStep(xSLParseString, n);
                break;
            }
            case 110: 
            case 111: {
                xPathStep = new XPathStep(xSLParseString, n);
                break;
            }
        }
        return xPathStep;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    XPathStep(XSLParseString xSLParseString, int n) throws XSLException, XQException {
        XPathCompileEvents xPathCompileEvents = xSLParseString.getXPathCompileEvents();
        this.setCompatibilityFlags(xSLParseString.getXSLTVersion(), xSLParseString.isBackwardCompatibilityMode(), xSLParseString.isForwardCompatibilityMode());
        this.isPattern = xSLParseString.isPattern();
        this.prevSeparator = n;
        super.setExprType(0x2200000);
        this.nodeType = 1;
        int n2 = xSLParseString.peekToken();
        if (!(this.isPattern || n2 != 3 && n2 != 4)) {
            xSLParseString.nextToken();
            this.nodeTestType = 403;
            this.anyNode = true;
            if (n2 == 3) {
                this.axisClass = XPathAxis.getInstance(11);
            } else {
                if (xPathCompileEvents != null) {
                    xPathCompileEvents.reportEventsNoParam(234, 2);
                }
                this.axisClass = XPathAxis.getInstance(8);
            }
            this.setNodeType();
            return;
        }
        if (n2 == 111 && xSLParseString.getAxisType() == 503) {
            xSLParseString.nextToken();
            if (xSLParseString.nextToken() != 110) {
                return;
            }
            this.axisClass = XPathAxis.getInstance(2);
            this.nodeType = 2;
            this.name = xSLParseString.getLocalName();
            this.nameSpace = xSLParseString.getNamespace();
            this.nodeTestType = xSLParseString.getNodeTest();
            this.priority = this.nodeTestType == 451 ? 0.0f : (this.nodeTestType == 450 ? -0.5f : -0.25f);
        } else if (n2 == 111 || n2 == 110) {
            Object object;
            int n3;
            xSLParseString.nextToken();
            if (this.tryAxis(xSLParseString.getAxisType(), xPathCompileEvents)) {
                n3 = this.axisClass.getAxisType();
                if (xPathCompileEvents != null) {
                    xPathCompileEvents.reportEventsWithIntParam(103, 0, n3, 0);
                }
                if ((n3 == 9 || n3 == 10) && (object = xSLParseString.getStylesheet()) != null) {
                    ((XSLStylesheet)object).setPrecedingAxis(true);
                }
                if (this.isPattern && this.axisClass.getAxisType() != 3) {
                    throw new XPathException(1013, new String(xSLParseString.getExprString()));
                }
                xSLParseString.nextToken();
            } else {
                this.axisClass = XPathAxis.getInstance(3);
                if (xPathCompileEvents != null) {
                    xPathCompileEvents.reportEventsWithIntParam(103, 0, this.axisClass.getAxisType(), 0);
                }
            }
            n3 = 0;
            this.nodeTestType = xSLParseString.getNodeTest();
            switch (this.nodeTestType) {
                case 404: {
                    if (!XSLExpr.isXPath20Compatible(xSLParseString)) {
                        throw new XPathException(1013, xSLParseString.getExprString());
                    }
                    if (xPathCompileEvents != null) {
                        xPathCompileEvents.reportEventsNoParam(204, 0);
                    }
                    this.nodeType = 9;
                    if (xSLParseString.peekToken(117)) {
                        int n4 = xSLParseString.getKindTest();
                        if (n4 == 405) {
                            n2 = xSLParseString.peekToken();
                            if (n2 == 120 || n2 == 119) {
                                xSLParseString.nextToken();
                                if (n2 == 120) {
                                    this.nameSpace = xSLParseString.getNamespace();
                                    this.name = xSLParseString.getLocalName();
                                }
                                if (xSLParseString.peekToken(1)) {
                                    if (xSLParseString.nextToken() != 120) throw new XPathException(1013, xSLParseString.getExprString());
                                    String string = xSLParseString.getNamespace();
                                    String string2 = xSLParseString.getLocalName();
                                    XMLSchema xMLSchema = xSLParseString.getXMLSchema();
                                    if (xMLSchema != null) {
                                        this.schNode = xMLSchema.getType(string, string2);
                                    }
                                    if (this.schNode == null) {
                                        throw new XPathException(23056, xSLParseString.getQName());
                                    }
                                }
                            }
                        } else {
                            if (n4 != 407) throw new XPathException(1013, xSLParseString.getExprString());
                            if (xSLParseString.nextToken() != 120) throw new XPathException(1013, xSLParseString.getExprString());
                            this.nameSpace = xSLParseString.getNamespace();
                            this.name = xSLParseString.getLocalName();
                            XMLSchema xMLSchema = xSLParseString.getXMLSchema();
                            if (xMLSchema != null) {
                                this.schNode = xMLSchema.getElement(this.nameSpace, this.name);
                            }
                            if (this.schNode == null) {
                                throw new XPathException(23056, xSLParseString.getQName());
                            }
                        }
                    }
                    if (xSLParseString.nextToken() != 26) {
                        throw new XPathException(1019, ")", xSLParseString.getCurrentToken());
                    }
                    if (xPathCompileEvents == null) break;
                    xPathCompileEvents.reportEventsNoParam(204, 1);
                    break;
                }
                case 405: {
                    if (xPathCompileEvents != null) {
                        xPathCompileEvents.reportEventsNoParam(208, 0);
                    }
                    this.nodeType = 1;
                    n2 = xSLParseString.peekToken();
                    if (n2 == 26) {
                        this.priority = -0.5f;
                    } else if (n2 == 120 || n2 == 119) {
                        xSLParseString.nextToken();
                        if (n2 == 120) {
                            this.nameSpace = xSLParseString.getNamespace();
                            this.name = xSLParseString.getLocalName();
                        }
                        if (xSLParseString.peekToken(1)) {
                            if (!XSLExpr.isXPath20Compatible(xSLParseString)) {
                                throw new XPathException(1013, xSLParseString.getExprString());
                            }
                            if (xSLParseString.nextToken() != 120) throw new XPathException(1013, xSLParseString.getExprString());
                            object = xSLParseString.getNamespace();
                            String string = xSLParseString.getLocalName();
                            XMLSchema xMLSchema = xSLParseString.getXMLSchema();
                            if (xMLSchema != null) {
                                this.schNode = xMLSchema.getType((String)object, string);
                            }
                            if (this.schNode == null) {
                                throw new XPathException(23056, xSLParseString.getQName());
                            }
                        }
                    }
                    if (xSLParseString.nextToken() != 26) {
                        throw new XPathException(1019, ")", xSLParseString.getCurrentToken());
                    }
                    if (xPathCompileEvents == null) break;
                    xPathCompileEvents.reportEventsNoParam(208, 1);
                    break;
                }
                case 406: {
                    if (xPathCompileEvents != null) {
                        xPathCompileEvents.reportEventsNoParam(206, 0);
                    }
                    this.axisClass = XPathAxis.getInstance(2);
                    this.nodeType = 2;
                    n2 = xSLParseString.peekToken();
                    if (n2 == 120 || n2 == 119) {
                        xSLParseString.nextToken();
                        if (n2 == 120) {
                            this.nameSpace = xSLParseString.getNamespace();
                            this.name = xSLParseString.getLocalName();
                        }
                        if (xSLParseString.peekToken(1)) {
                            if (!XSLExpr.isXPath20Compatible(xSLParseString)) {
                                throw new XPathException(1013, xSLParseString.getExprString());
                            }
                            if (xSLParseString.nextToken() != 120) throw new XPathException(1013, xSLParseString.getExprString());
                            object = xSLParseString.getNamespace();
                            String string = xSLParseString.getLocalName();
                            XMLSchema xMLSchema = xSLParseString.getXMLSchema();
                            if (xMLSchema != null) {
                                this.schNode = xMLSchema.getType((String)object, string, 2);
                            }
                            if (this.schNode == null) {
                                throw new XPathException(230563, xSLParseString.getQName());
                            }
                        }
                    }
                    if (xSLParseString.nextToken() != 26) {
                        throw new XPathException(1019, ")", xSLParseString.getCurrentToken());
                    }
                    if (xPathCompileEvents == null) break;
                    xPathCompileEvents.reportEventsNoParam(206, 1);
                    break;
                }
                case 407: {
                    if (!XSLExpr.isXPath20Compatible(xSLParseString)) {
                        throw new XPathException(1013, xSLParseString.getExprString());
                    }
                    if (xPathCompileEvents != null) {
                        xPathCompileEvents.reportEventsNoParam(211, 0);
                    }
                    if (xSLParseString.nextToken() != 120) throw new XPathException(1013, xSLParseString.getExprString());
                    this.nameSpace = xSLParseString.getNamespace();
                    this.name = xSLParseString.getLocalName();
                    object = xSLParseString.getXMLSchema();
                    if (object != null) {
                        this.schNode = ((XMLSchema)object).getElement(this.nameSpace, this.name);
                    }
                    if (this.schNode == null) {
                        throw new XPathException(23056, xSLParseString.getQName());
                    }
                    if (xSLParseString.nextToken() != 26) {
                        throw new XPathException(1019, ")", xSLParseString.getCurrentToken());
                    }
                    if (xPathCompileEvents == null) break;
                    xPathCompileEvents.reportEventsNoParam(211, 1);
                    break;
                }
                case 408: {
                    if (!XSLExpr.isXPath20Compatible(xSLParseString)) {
                        throw new XPathException(1013, xSLParseString.getExprString());
                    }
                    if (xPathCompileEvents != null) {
                        xPathCompileEvents.reportEventsNoParam(210, 0);
                    }
                    if (xSLParseString.nextToken() != 120) throw new XPathException(1013, xSLParseString.getExprString());
                    this.nameSpace = xSLParseString.getNamespace();
                    this.name = xSLParseString.getLocalName();
                    object = xSLParseString.getXMLSchema();
                    if (object != null) {
                        this.schNode = ((XMLSchema)object).getAttribute(this.nameSpace, this.name);
                    }
                    if (this.schNode == null) {
                        throw new XPathException(23056, xSLParseString.getQName());
                    }
                    if (xSLParseString.nextToken() != 26) {
                        throw new XPathException(1019, ")", xSLParseString.getCurrentToken());
                    }
                    if (xPathCompileEvents == null) break;
                    xPathCompileEvents.reportEventsNoParam(210, 1);
                    break;
                }
                case 400: {
                    if (xPathCompileEvents != null) {
                        xPathCompileEvents.reportEventsNoParam(209, 0);
                        xPathCompileEvents.reportEventsWithIntParam(115, 0, this.axisClass.getAxisType(), 0);
                        n3 = 115;
                    }
                    this.nodeType = 7;
                    n2 = xSLParseString.nextToken();
                    if (n2 == 109) {
                        this.name = xSLParseString.getLiteralValue();
                        this.priority = 0.0f;
                        n2 = xSLParseString.nextToken();
                    } else {
                        this.priority = -0.5f;
                        this.name = "*";
                    }
                    if (n2 != 26) {
                        throw new XPathException(1019, ")", xSLParseString.getCurrentToken());
                    }
                    if (xPathCompileEvents == null) break;
                    xPathCompileEvents.reportEventsNoParam(209, 1);
                    break;
                }
                case 402: {
                    if (xPathCompileEvents != null) {
                        xPathCompileEvents.reportEventsNoParam(212, 0);
                        xPathCompileEvents.reportEventsWithIntParam(119, 0, this.axisClass.getAxisType(), 0);
                        n3 = 119;
                    }
                    this.nodeType = 3;
                    this.priority = -0.5f;
                    if (xSLParseString.nextToken() != 26) {
                        throw new XPathException(1019, ")", xSLParseString.getCurrentToken());
                    }
                    if (xPathCompileEvents == null) break;
                    xPathCompileEvents.reportEventsNoParam(212, 1);
                    break;
                }
                case 401: {
                    if (xPathCompileEvents != null) {
                        xPathCompileEvents.reportEventsNoParam(207, 0);
                        xPathCompileEvents.reportEventsWithIntParam(105, 0, this.axisClass.getAxisType(), 0);
                        n3 = 105;
                    }
                    this.nodeType = 8;
                    this.priority = -0.5f;
                    if (xSLParseString.nextToken() != 26) {
                        throw new XPathException(1019, ")", xSLParseString.getCurrentToken());
                    }
                    if (xPathCompileEvents == null) break;
                    xPathCompileEvents.reportEventsNoParam(207, 1);
                    break;
                }
                case 403: {
                    if (xPathCompileEvents != null) {
                        xPathCompileEvents.reportEventsNoParam(205, 0);
                    }
                    this.priority = -0.5f;
                    if (xSLParseString.nextToken() != 26) {
                        throw new XPathException(1019, ")", xSLParseString.getCurrentToken());
                    }
                    this.anyNode = true;
                    if (xPathCompileEvents == null) break;
                    xPathCompileEvents.reportEventsNoParam(205, 1);
                    break;
                }
                case 451: {
                    this.name = xSLParseString.getLocalName();
                    this.nameSpace = xSLParseString.getNamespace();
                    this.priority = 0.0f;
                    if (xPathCompileEvents == null) break;
                    xPathCompileEvents.reportEventsWithStringParam(232, 2, this.nameSpace, this.name, null);
                    break;
                }
                case 450: {
                    this.name = xSLParseString.getLocalName();
                    this.nameSpace = xSLParseString.getNamespace();
                    this.priority = -0.5f;
                    if (xPathCompileEvents == null) break;
                    xPathCompileEvents.reportEventsWithIntStringParam(233, 2, this.nodeTestType, 0, this.nameSpace, this.name, null);
                    break;
                }
                case 453: {
                    this.name = xSLParseString.getLocalName();
                    this.nameSpace = xSLParseString.getNamespace();
                    this.priority = -0.25f;
                    if (xPathCompileEvents == null) break;
                    xPathCompileEvents.reportEventsWithIntStringParam(233, 2, this.nodeTestType, 0, this.nameSpace, this.name, null);
                    break;
                }
                case 452: {
                    this.name = xSLParseString.getLocalName();
                    this.nameSpace = xSLParseString.getNamespace();
                    this.priority = -0.25f;
                    if (xPathCompileEvents == null) break;
                    xPathCompileEvents.reportEventsWithIntStringParam(233, 2, this.nodeTestType, 0, this.nameSpace, this.name, null);
                }
            }
            if (xPathCompileEvents != null) {
                xPathCompileEvents.reportEventsNoParam(103, 1);
                switch (n3) {
                    case 105: {
                        xPathCompileEvents.reportEventsNoParam(n3, 1);
                        break;
                    }
                    case 115: {
                        xPathCompileEvents.reportEventsNoParam(n3, 1);
                        break;
                    }
                    case 119: {
                        xPathCompileEvents.reportEventsNoParam(n3, 1);
                    }
                }
            }
        } else {
            if (xPathCompileEvents == null) return;
            xPathCompileEvents.reportEventsNoParam(118, 1);
            xPathCompileEvents.reportEventsNoParam(109, 1);
            return;
        }
        if (this.name != null && this.name.equals("xmlns")) {
            this.nameSpace = "http://www.w3.org/2000/xmlns/";
        }
        if (xSLParseString.peekToken() == 27) {
            this.predicates = new XPathPredicate(xSLParseString);
            this.priority = 0.5f;
        }
        this.setNodeType();
        if (xPathCompileEvents == null) return;
        xPathCompileEvents.reportEventsNoParam(118, 1);
        xPathCompileEvents.reportEventsNoParam(109, 1);
    }

    int getPrevSeparator() {
        return this.prevSeparator;
    }

    void setPrevSeparator(int n) {
        this.prevSeparator = n;
    }

    String getLocalName() {
        return this.name;
    }

    void setLocalName(String string) {
        this.name = string;
    }

    String getNamespace() {
        return this.nameSpace;
    }

    void setNamespace(String string) {
        this.nameSpace = string;
    }

    int getNodeTestType() {
        return this.nodeTestType;
    }

    @Override
    public int getAnchorType() {
        if (!this.anyNode) {
            return this.nodeType;
        }
        return -1;
    }

    @Override
    public void getAnchorName(String[] stringArray) {
        if (this.nodeTestType == 451) {
            stringArray[0] = this.nameSpace.intern();
            stringArray[1] = this.name.intern();
        }
    }

    int getAxisType() {
        return this.axisClass.getAxisType();
    }

    private boolean tryAxis(int n, XPathCompileEvents xPathCompileEvents) throws XSLException {
        switch (n) {
            case 508: {
                this.axisClass = XPathAxis.getInstance(0);
                if (xPathCompileEvents == null) break;
                xPathCompileEvents.reportEventsWithIntParam(231, 2, n, 0);
                break;
            }
            case 513: {
                this.axisClass = XPathAxis.getInstance(1);
                if (xPathCompileEvents == null) break;
                xPathCompileEvents.reportEventsWithIntParam(231, 2, n, 0);
                break;
            }
            case 503: {
                this.axisClass = XPathAxis.getInstance(2);
                this.nodeType = 2;
                if (xPathCompileEvents == null) break;
                xPathCompileEvents.reportEventsWithIntParam(230, 2, n, 0);
                break;
            }
            case 501: {
                this.axisClass = XPathAxis.getInstance(3);
                if (xPathCompileEvents == null) break;
                xPathCompileEvents.reportEventsWithIntParam(230, 2, n, 0);
                break;
            }
            case 502: {
                this.axisClass = XPathAxis.getInstance(4);
                if (xPathCompileEvents == null) break;
                xPathCompileEvents.reportEventsWithIntParam(230, 2, n, 0);
                break;
            }
            case 510: {
                this.axisClass = XPathAxis.getInstance(5);
                if (xPathCompileEvents == null) break;
                xPathCompileEvents.reportEventsWithIntParam(230, 2, n, 0);
                break;
            }
            case 505: {
                this.axisClass = XPathAxis.getInstance(6);
                if (xPathCompileEvents == null) break;
                xPathCompileEvents.reportEventsWithIntParam(230, 2, n, 0);
                break;
            }
            case 511: {
                this.axisClass = XPathAxis.getInstance(7);
                if (xPathCompileEvents == null) break;
                xPathCompileEvents.reportEventsWithIntParam(230, 2, n, 0);
                break;
            }
            case 507: {
                this.axisClass = XPathAxis.getInstance(8);
                if (xPathCompileEvents == null) break;
                xPathCompileEvents.reportEventsWithIntParam(231, 2, n, 0);
                break;
            }
            case 509: {
                this.axisClass = XPathAxis.getInstance(9);
                if (xPathCompileEvents == null) break;
                xPathCompileEvents.reportEventsWithIntParam(231, 2, n, 0);
                break;
            }
            case 512: {
                this.axisClass = XPathAxis.getInstance(10);
                if (xPathCompileEvents == null) break;
                xPathCompileEvents.reportEventsWithIntParam(231, 2, n, 0);
                break;
            }
            case 504: {
                this.axisClass = XPathAxis.getInstance(11);
                if (xPathCompileEvents == null) break;
                xPathCompileEvents.reportEventsWithIntParam(230, 2, n, 0);
                break;
            }
            case 506: {
                this.axisClass = XPathAxis.getInstance(12);
                if (xPathCompileEvents == null) break;
                xPathCompileEvents.reportEventsWithIntParam(230, 2, n, 0);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void setNodeType() throws XSLException, XQException {
        if (this.axisClass == null) {
            return;
        }
        this.nameSpace = this.nameSpace == null || this.nameSpace.equals("*") ? null : this.nameSpace.intern();
        String string = this.name = this.name == null || this.name.equals("*") ? null : this.name.intern();
        if (this.predicates != null) {
            if (this.prevSeparator == 6 || this.isPattern) {
                this.predicates.isSimpleContext();
            }
            this.predicates.getPositionTest();
        }
    }

    @Override
    public void setEvaluationHints(String string, Object object) {
        if (this.predicates == null && Boolean.TRUE.equals(object)) {
            if ("value-of".equals(string)) {
                this.firstNodeOnly = true;
            } else if ("for-each".equals(string) && this.nodeTestType == 451) {
                this.lazyLoad = true;
            }
        }
    }

    @Override
    void cacheSubExpr() {
    }

    @Override
    boolean canCacheExpr() {
        return this.predicates == null || this.predicates.canCacheExpr();
    }

    @Override
    public String getNormalizedExpr() throws XQException {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.prevSeparator == 5) {
            stringBuffer.append("/");
        } else {
            stringBuffer.append("//");
        }
        if (this.nameSpace != null && this.nameSpace.length() > 0) {
            stringBuffer.append("{");
            stringBuffer.append(this.nameSpace);
            stringBuffer.append("}");
        }
        stringBuffer.append(this.name);
        if (this.predicates != null) {
            stringBuffer.append(this.predicates.getNormalizedExpr());
        }
        return stringBuffer.toString();
    }

    @Override
    public void evaluate(XPathRuntimeContext xPathRuntimeContext) throws XSLException, XQException {
        xPathRuntimeContext.setCompatibilityFlags(this.getXSLTVersion(), this.isBackwardCompatibilityMode(), this.isForwardCompatibilityMode());
        int n = this.axisClass.getAxisType();
        if (this.prevSeparator == 6) {
            if ((this.predicates == null || this.predicates.isSimpleContext()) && n == 3) {
                XPathAxis xPathAxis = XPathAxis.getInstance(4);
                xPathAxis.getNodeList(this, xPathRuntimeContext);
            } else if (n != 3) {
                XPathAxis xPathAxis = XPathAxis.getInstance(5);
                xPathAxis.getNodeList(null, xPathRuntimeContext);
                this.axisClass.getNodeList(this, xPathRuntimeContext);
            } else {
                XPathAxis.getDescNodeList(this, xPathRuntimeContext);
            }
        } else {
            this.axisClass.getNodeList(this, xPathRuntimeContext);
        }
    }

    public boolean isDescendantStep() {
        return this.prevSeparator == 6 && this.axisClass.getAxisType() == 3;
    }

    public boolean matchQName(String string, String string2) {
        return this.anyNode || (this.name == null || this.name.equals(string2)) && (this.nameSpace == null || this.nameSpace.equals(string));
    }

    public boolean filter(int n, TypedAttributes typedAttributes) {
        if (this.predicates == null) {
            return true;
        }
        return this.predicates.filter(n, typedAttributes);
    }

    XMLNode matchPattern(XSLTContext xSLTContext, OXMLSequence oXMLSequence, OXMLSequence oXMLSequence2) throws XSLException, XQException {
        OXMLSequence oXMLSequence3 = xSLTContext.pushExprValue();
        while (oXMLSequence.next()) {
            XMLNode xMLNode = XPathSequence.nextNode(oXMLSequence);
            if (!this.anyNode && !xMLNode.checkTypeNSName(this.nodeType, this.nameSpace, this.name)) continue;
            XPathSequence.addNode(oXMLSequence3, xMLNode);
        }
        if (this.predicates != null) {
            if (this.predicates.isSimpleContext()) {
                this.predicates.filter(oXMLSequence3, xSLTContext);
            } else {
                OXMLSequence oXMLSequence4 = xSLTContext.pushExprValue();
                XPathSequence.getParentList(oXMLSequence3, oXMLSequence4);
                this.axisClass.getNodeList(this, xSLTContext);
                XPathSequence.intersectSequence(oXMLSequence3, oXMLSequence4);
                xSLTContext.popExprValue();
            }
        }
        if (oXMLSequence3.getItemOccurrence() != 0) {
            if (this.prevSeparator == 5) {
                XPathSequence.getParentList(oXMLSequence3, oXMLSequence2);
            } else {
                XPathAxis.getAncestor(oXMLSequence3, oXMLSequence2, xSLTContext);
            }
        }
        xSLTContext.popExprValue();
        if (oXMLSequence2.getItemOccurrence() == 1) {
            oXMLSequence2.next();
            return XPathSequence.nextNode(oXMLSequence2);
        }
        return null;
    }

    XMLNode matchPattern(XSLTContext xSLTContext, XMLNode xMLNode, OXMLSequence oXMLSequence) throws XSLException, XQException {
        if (!this.anyNode && !xMLNode.checkTypeNSName(this.nodeType, this.nameSpace, this.name)) {
            return null;
        }
        int n = this.getAxisType();
        Object object = n == 2 ? (XMLNode)((Object)((XMLAttr)xMLNode).getOwnerElement()) : (n == 3 && xMLNode.getNodeType() == 16 ? null : (XMLNode)xMLNode.getParentNode());
        if (this.predicates != null) {
            if (!this.predicates.isSimpleContext()) {
                OXMLSequence oXMLSequence2 = xSLTContext.pushExprValue();
                XPathSequence.addNode(oXMLSequence2, (XMLNode)object);
                this.axisClass.getNodeList(this, xSLTContext);
                if (XPathSequence.contains(oXMLSequence2, xMLNode)) {
                    if (this.prevSeparator == 5) {
                        xSLTContext.popExprValue();
                        return object;
                    }
                    XPathAxis.getAncestor(xMLNode, oXMLSequence);
                }
                xSLTContext.popExprValue();
                return null;
            }
            if (!this.predicates.filterNode(xMLNode, xSLTContext)) {
                return null;
            }
        }
        if (this.prevSeparator == 5) {
            return object;
        }
        if (object != null) {
            XPathAxis.getAncestor(xMLNode, oXMLSequence);
        }
        return null;
    }

    int matchStep(XPathStep xPathStep) {
        int n = xPathStep.axisClass.getAxisType();
        if (this.axisClass == xPathStep.axisClass && this.predicates == null && (this.anyNode || this.name != null && this.name.equals(xPathStep.name) && this.nameSpace.equals(xPathStep.nameSpace))) {
            return 1;
        }
        if (n != 3 && n != 2 || this.predicates != null) {
            return 0;
        }
        return -1;
    }

    static {
        XPathStep.DESC_SELF.axisClass = XPathAxis.getInstance(5);
        XPathStep.DESC_SELF.anyNode = true;
        XPathStep.DESC_SELF.nodeTestType = 403;
        XPathStep.DESC_SELF.prevSeparator = 5;
        XPathStep.DESC_SELF.isPattern = false;
    }
}

