/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xpath;

import oracle.xml.parser.v2.XMLParser;
import oracle.xml.xpath.AdditiveExpr;
import oracle.xml.xpath.RangeExpr;
import oracle.xml.xpath.XPathCompileEvents;
import oracle.xml.xpath.XPathRuntimeContext;
import oracle.xml.xpath.XPathSequence;
import oracle.xml.xpath.XSLExpr;
import oracle.xml.xpath.XSLExprBase;
import oracle.xml.xpath.XSLParseString;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xslt.XSLException;

class ComparisonExpr
extends XSLExprBase {
    short compType;
    static short GENERALCOMP = 1;
    static short VALUECOMP = (short)2;
    static short NODECOMP = (short)3;
    static short ORDERCOMP = (short)4;

    ComparisonExpr() {
        super.setExprType(4);
    }

    static XSLExprBase parse(XSLParseString xSLParseString) throws XSLException, XQException {
        boolean bl = XSLExpr.isXPath20Compatible(xSLParseString);
        XSLExprBase xSLExprBase = bl ? RangeExpr.parse(xSLParseString) : AdditiveExpr.parse(xSLParseString);
        XPathCompileEvents xPathCompileEvents = xSLParseString.getXPathCompileEvents();
        int n = 0;
        int n2 = 0;
        if (xSLParseString.peekToken() == 105) {
            if (xPathCompileEvents != null) {
                n = 224;
                xPathCompileEvents.reportEventsNoParam(n, 0);
            }
            ComparisonExpr comparisonExpr = new ComparisonExpr();
            comparisonExpr.setCompatibilityFlags(xSLParseString.getXSLTVersion(), xSLParseString.isBackwardCompatibilityMode(), xSLParseString.isForwardCompatibilityMode());
            n2 = xSLParseString.getOperator();
            if (xPathCompileEvents != null) {
                if (ComparisonExpr.isEqualityOp(n2)) {
                    n = 106;
                    xPathCompileEvents.reportEventsNoParam(n, 0);
                } else if (ComparisonExpr.isRelationalOp(n2)) {
                    n = 116;
                    xPathCompileEvents.reportEventsNoParam(n, 0);
                }
                if (n != 0) {
                    xPathCompileEvents.reportEventsWithIntParam(n, 1, n2, 0);
                }
            }
            if (ComparisonExpr.isGeneralCompOp(n2)) {
                comparisonExpr.compType = GENERALCOMP;
                if (xPathCompileEvents != null) {
                    n = 227;
                    xPathCompileEvents.reportEventsWithIntParam(n, 2, n2, 0);
                }
            } else if (ComparisonExpr.isValueCompOp(n2)) {
                comparisonExpr.compType = VALUECOMP;
                if (xPathCompileEvents != null) {
                    n = 228;
                    xPathCompileEvents.reportEventsWithIntParam(n, 2, n2, 0);
                }
            } else if (ComparisonExpr.isNodeCompOp(n2)) {
                comparisonExpr.compType = NODECOMP;
                if (xPathCompileEvents != null) {
                    n = 229;
                    xPathCompileEvents.reportEventsWithIntParam(n, 2, n2, 0);
                }
            } else if (ComparisonExpr.isOrderCompOp(n2)) {
                comparisonExpr.compType = ORDERCOMP;
            } else {
                return xSLExprBase;
            }
            xSLParseString.nextToken();
            comparisonExpr.operator = n2;
            comparisonExpr.leftExpr = xSLExprBase;
            comparisonExpr.rightExpr = bl ? RangeExpr.parse(xSLParseString) : ComparisonExpr.parse(xSLParseString);
            XSLExprBase xSLExprBase2 = comparisonExpr.rightExpr;
            if (xSLExprBase2 instanceof ComparisonExpr) {
                xSLExprBase = xSLExprBase2;
                while (xSLExprBase2.leftExpr instanceof ComparisonExpr) {
                    xSLExprBase2 = xSLExprBase2.leftExpr;
                }
                comparisonExpr.rightExpr = xSLExprBase2.leftExpr;
                xSLExprBase2.leftExpr = comparisonExpr;
            } else {
                xSLExprBase = comparisonExpr;
            }
            if (xSLParseString.isCachingExpr() && !xSLExprBase.canCacheExpr()) {
                xSLExprBase.cacheSubExpr();
            }
        }
        if (xPathCompileEvents != null) {
            if (n != 0) {
                xPathCompileEvents.reportEventsWithIntParam(n, 1, n2, 0);
            }
            if (xSLExprBase instanceof ComparisonExpr && n2 != 0) {
                xPathCompileEvents.reportEventsWithIntParam(224, 1, n2, 0);
            }
        }
        return xSLExprBase;
    }

    static boolean isEqualityOp(int n) {
        return n == 216 || n == 217;
    }

    static boolean isRelationalOp(int n) {
        return n == 218 || n == 219 || n == 220 || n == 221;
    }

    static boolean isGeneralCompOp(int n) {
        return n == 216 || n == 217 || n == 218 || n == 219 || n == 220 || n == 221;
    }

    static boolean isValueCompOp(int n) {
        return n == 210 || n == 211 || n == 212 || n == 213 || n == 214 || n == 215;
    }

    static boolean isNodeCompOp(int n) {
        if (XMLParser.getIs1010Compatible()) {
            return n == 208 || n == 209;
        }
        return n == 208;
    }

    static boolean isOrderCompOp(int n) {
        return n == 222 || n == 223;
    }

    @Override
    void cacheSubExpr() throws XQException {
        if (this.leftExpr.canCacheExpr()) {
            this.leftExpr = this.leftExpr.createCachedExpr();
        }
        if (this.rightExpr.canCacheExpr()) {
            this.rightExpr = this.rightExpr.createCachedExpr();
        }
    }

    @Override
    boolean canCacheExpr() {
        return this.leftExpr.canCacheExpr() && this.rightExpr.canCacheExpr();
    }

    @Override
    public String getNormalizedExpr() throws XQException {
        StringBuffer stringBuffer = new StringBuffer(this.leftExpr.getNormalizedExpr());
        stringBuffer.append(this.operator);
        stringBuffer.append(this.rightExpr.getNormalizedExpr());
        return stringBuffer.toString();
    }

    @Override
    public void evaluate(XPathRuntimeContext xPathRuntimeContext) throws XSLException, XQException {
        xPathRuntimeContext.setCompatibilityFlags(this.getXSLTVersion(), this.isBackwardCompatibilityMode(), this.isForwardCompatibilityMode());
        this.leftExpr.evaluate(xPathRuntimeContext);
        OXMLSequence oXMLSequence = xPathRuntimeContext.peekExprValue();
        this.rightExpr.evaluate(xPathRuntimeContext);
        if (this.compType == GENERALCOMP) {
            boolean bl = this.getXSLTVersion() == 10 && !this.isForwardCompatibilityMode() || this.getXSLTVersion() == 20 && this.isBackwardCompatibilityMode();
            XPathSequence.compareGeneral(oXMLSequence, xPathRuntimeContext.popExprValue(), this.operator, bl);
        }
        if (this.compType == VALUECOMP) {
            XPathSequence.compareValue(oXMLSequence, xPathRuntimeContext.popExprValue(), this.operator);
        } else if (this.compType == NODECOMP || this.compType == ORDERCOMP) {
            XPathSequence.compareNodeAndOrder(oXMLSequence, xPathRuntimeContext.popExprValue(), this.operator);
        }
    }
}

