/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.jaxp;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TemplatesHandler;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPathFunctionResolver;
import oracle.xml.jaxp.JXEntityResolver;
import oracle.xml.jaxp.JXSAXData;
import oracle.xml.jaxp.JXTransformer;
import oracle.xml.jaxp.JXTransformerHandler;
import oracle.xml.jaxp.JXXMLFilter;
import oracle.xml.parser.v2.DOMLocator;
import oracle.xml.parser.v2.SAXParser;
import oracle.xml.parser.v2.XMLConstants;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLParser;
import oracle.xml.util.XMLUtil;
import oracle.xml.xslt.OutputURIResolver;
import oracle.xml.xslt.XSLBuilder;
import oracle.xml.xslt.XSLException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;

public class JXSAXTransformerFactory
extends SAXTransformerFactory
implements XMLConstants {
    URIResolver m_uriResolver;
    OutputURIResolver outputResolver;
    XPathFunctionResolver funcResolver;
    ErrorListener m_errorListener;
    XMLError m_err = new XMLError();
    Connection m_domConn;
    String m_domKind;
    String compVersion = null;
    Boolean secure;
    public static final String COMPATIBLE_VERSION = "oracle.xdkjava.transformer.compatible.jdkversion";

    @Override
    public TransformerHandler newTransformerHandler(Source source) throws TransformerConfigurationException {
        String string;
        Templates templates = this.newTemplates(source);
        TransformerHandler transformerHandler = this.newTransformerHandler(templates);
        if (this.secure != null) {
            ((JXTransformer)transformerHandler.getTransformer()).setSecure(this.secure);
        }
        if ((string = source.getSystemId()) != null) {
            transformerHandler.setSystemId(string);
        }
        return transformerHandler;
    }

    @Override
    public TransformerHandler newTransformerHandler(Templates templates) throws TransformerConfigurationException {
        Transformer transformer = templates.newTransformer();
        JXTransformerHandler jXTransformerHandler = new JXTransformerHandler(transformer);
        return jXTransformerHandler;
    }

    @Override
    public TransformerHandler newTransformerHandler() throws TransformerConfigurationException {
        JXTransformerHandler jXTransformerHandler = new JXTransformerHandler();
        if (this.compVersion != null) {
            jXTransformerHandler.compVersion = this.compVersion;
        }
        return jXTransformerHandler;
    }

    @Override
    public TemplatesHandler newTemplatesHandler() throws TransformerConfigurationException {
        XSLBuilder xSLBuilder = new XSLBuilder();
        if (this.secure != null) {
            xSLBuilder.setSecure(this.secure);
        }
        if (this.funcResolver != null) {
            xSLBuilder.setFunctionResolver(this.funcResolver);
        }
        return xSLBuilder;
    }

    @Override
    public XMLFilter newXMLFilter(Source source) throws TransformerConfigurationException {
        Templates templates = this.newTemplates(source);
        return this.newXMLFilter(templates);
    }

    @Override
    public XMLFilter newXMLFilter(Templates templates) throws TransformerConfigurationException {
        JXXMLFilter jXXMLFilter = new JXXMLFilter();
        if (this.secure != null) {
            jXXMLFilter.setSecureProcessing();
        }
        jXXMLFilter.setTemplates(templates);
        return jXXMLFilter;
    }

    @Override
    public Transformer newTransformer(Source source) throws TransformerConfigurationException {
        Templates templates = this.newTemplates(source);
        JXTransformer jXTransformer = (JXTransformer)templates.newTransformer();
        if (this.secure != null) {
            jXTransformer.setSecure(this.secure);
        }
        jXTransformer.setURIResolver(this.m_uriResolver);
        jXTransformer.setOutputURIResolver(this.outputResolver);
        return jXTransformer;
    }

    @Override
    public Transformer newTransformer() throws TransformerConfigurationException {
        JXTransformer jXTransformer = new JXTransformer();
        jXTransformer.setConnection(this.m_domConn);
        jXTransformer.setDOMKind(this.m_domKind);
        jXTransformer.setCompVersion(this.compVersion);
        if (this.secure != null) {
            jXTransformer.setSecure(this.secure);
        }
        jXTransformer.setURIResolver(this.m_uriResolver);
        jXTransformer.setOutputURIResolver(this.outputResolver);
        return jXTransformer;
    }

    @Override
    public Templates newTemplates(Source source) throws TransformerConfigurationException {
        Object object;
        XSLBuilder xSLBuilder = new XSLBuilder();
        if (this.secure != null) {
            xSLBuilder.setSecure(this.secure);
        }
        if (this.funcResolver != null) {
            xSLBuilder.setFunctionResolver(this.funcResolver);
        }
        if (this.m_uriResolver != null) {
            object = new JXEntityResolver(this.m_uriResolver, source);
            xSLBuilder.setEntityResolver((EntityResolver)object);
        }
        if ((object = source.getSystemId()) != null) {
            try {
                xSLBuilder.setBaseURL(new URL((String)object));
            }
            catch (MalformedURLException malformedURLException) {
                this.reportConfigException(malformedURLException, 1, 1108, null);
                throw new TransformerConfigurationException(malformedURLException);
            }
        }
        if (!(source instanceof DOMSource)) {
            XMLReader xMLReader = null;
            InputSource inputSource = SAXSource.sourceToInputSource(source);
            if (source instanceof SAXSource) {
                xMLReader = ((SAXSource)source).getXMLReader();
            }
            if (xMLReader == null || !(xMLReader instanceof SAXParser)) {
                xMLReader = new SAXParser();
            }
            try {
                if (this.secure != null && this.secure.booleanValue()) {
                    ((SAXParser)xMLReader).setSecureProcessing();
                }
                ((SAXParser)xMLReader).setPreserveWhitespace(true);
                xMLReader.setContentHandler(xSLBuilder);
                xMLReader.parse(inputSource);
            }
            catch (Exception exception) {
                Exception exception2;
                int n = 0;
                if (exception instanceof SAXException && (exception2 = ((SAXException)exception).getException()) instanceof XSLException) {
                    n = ((XSLException)exception2).getMessageType(0);
                }
                DOMLocator dOMLocator = new DOMLocator(xSLBuilder.getLocator());
                this.reportConfigException(exception2, n, 1000, dOMLocator);
                throw new TransformerConfigurationException(exception2);
            }
        }
        Node node = ((DOMSource)source).getNode();
        if (!(node instanceof XMLNode)) {
            node = XMLUtil.getXMLDocumentFromDoc(node);
        }
        XMLNode xMLNode = (XMLNode)node;
        try {
            if (!(xMLNode instanceof XMLDocument)) {
                xSLBuilder.startDocument();
            }
            xMLNode.reportSAXEvents(xSLBuilder);
            if (!(xMLNode instanceof XMLDocument)) {
                xSLBuilder.endDocument();
            }
        }
        catch (SAXException sAXException) {
            DOMLocator dOMLocator = (DOMLocator)xSLBuilder.getLocator();
            this.reportConfigException(sAXException, 0, 1900, dOMLocator);
            throw new TransformerConfigurationException(sAXException);
        }
        return xSLBuilder.getTemplates();
    }

    @Override
    public Source getAssociatedStylesheet(Source source, String string, String string2, String string3) throws TransformerConfigurationException {
        return this.getAssociatedStylesheet(source);
    }

    @Override
    public void setURIResolver(URIResolver uRIResolver) {
        this.m_uriResolver = uRIResolver;
    }

    public void setOutputURIResolver(OutputURIResolver outputURIResolver) {
        this.outputResolver = outputURIResolver;
    }

    @Override
    public URIResolver getURIResolver() {
        return this.m_uriResolver;
    }

    public OutputURIResolver getOutputURIResolver() {
        return this.outputResolver;
    }

    @Override
    public void setFeature(String string, boolean bl) throws TransformerConfigurationException {
        if (!string.equals("http://javax.xml.XMLConstants/feature/secure-processing")) {
            throw new TransformerConfigurationException();
        }
        this.secure = new Boolean(bl);
    }

    @Override
    public boolean getFeature(String string) {
        boolean bl = string.equals("http://javax.xml.transform.dom.DOMResult/feature") ? true : (string.equals("http://javax.xml.transform.dom.DOMSource/feature") ? true : (string.equals("http://javax.xml.transform.sax.SAXSource/feature") ? true : (string.equals("http://javax.xml.transform.sax.SAXResult/feature") ? true : (string.equals("http://javax.xml.transform.sax.SAXTransformerFactory/feature") ? true : (string.equals("http://javax.xml.transform.sax.SAXTransformerFactory/feature/xmlfilter") ? true : (string.equals("http://javax.xml.XMLConstants/feature/secure-processing") ? this.secure : false))))));
        return bl;
    }

    @Override
    public void setAttribute(String string, Object object) throws IllegalArgumentException {
        if ((string = string.intern()).equals("http://javax.xml.XMLConstants/feature/secure-processing") && object instanceof Boolean) {
            this.secure = (Boolean)object;
        } else if (string == "oracle.xml.parser.XMLDocument.Connection" && object instanceof Connection) {
            this.m_domConn = (Connection)object;
        } else if (string == "oracle.xml.parser.XMLDocument.Kind" && object instanceof String) {
            if (!object.equals("oracle.xml.parser.XMLDocument.THICK") || !object.equals("oracle.xml.parser.XMLDocument.THIN")) {
                throw new IllegalArgumentException();
            }
            this.m_domKind = (String)object;
        } else if (string == COMPATIBLE_VERSION && object instanceof String) {
            if (!object.equals("JDK_1.4") && !object.equals("JDK_1.5")) {
                throw new IllegalArgumentException();
            }
            this.compVersion = ((String)object).intern();
        } else if (string == "javax.xml.xpath.XPathFunctionResolver" && object instanceof XPathFunctionResolver) {
            this.funcResolver = (XPathFunctionResolver)object;
        } else {
            throw new IllegalArgumentException(string);
        }
    }

    @Override
    public Object getAttribute(String string) throws IllegalArgumentException {
        if ((string = string.intern()) == "oracle.xml.parser.XMLDocument.Connection") {
            return this.m_domConn;
        }
        if (string == "oracle.xml.parser.XMLDocument.Kind") {
            return this.m_domKind;
        }
        if (string == "http://javax.xml.XMLConstants/feature/secure-processing") {
            return this.secure;
        }
        throw new IllegalArgumentException(string);
    }

    @Override
    public void setErrorListener(ErrorListener errorListener) throws IllegalArgumentException {
        if (errorListener == null) {
            throw new IllegalArgumentException();
        }
        this.m_errorListener = errorListener;
    }

    @Override
    public ErrorListener getErrorListener() {
        if (this.m_errorListener == null) {
            return new ErrorListener(){

                @Override
                public void warning(TransformerException transformerException) {
                }

                @Override
                public void error(TransformerException transformerException) {
                }

                @Override
                public void fatalError(TransformerException transformerException) {
                }
            };
        }
        return this.m_errorListener;
    }

    private Source getAssociatedStylesheet(Source source) throws TransformerConfigurationException {
        String string = source.getSystemId();
        String string2 = null;
        if (source instanceof DOMSource) {
            Node node = ((DOMSource)source).getNode();
            string2 = this.getAssociatedStylesheet(node, string);
        } else if (source instanceof SAXSource) {
            InputSource inputSource = ((SAXSource)source).getInputSource();
            string2 = this.getAssociatedStylesheet(inputSource, string);
        } else if (source instanceof StreamSource) {
            string2 = this.getAssociatedStylesheet((StreamSource)source, string);
        }
        if (string2 == null) {
            this.reportConfigException(null, 0, 1121, null);
        }
        return new StreamSource(string2);
    }

    private String getAssociatedStylesheet(Node node, String string) throws TransformerConfigurationException {
        Node node2;
        if (!(node instanceof XMLDocument) && node instanceof Document) {
            node = XMLUtil.getXMLDocumentFromDoc(node);
        } else if (!(node instanceof XMLDocument)) {
            return null;
        }
        XMLDocument xMLDocument = (XMLDocument)node;
        NodeList nodeList = xMLDocument.getChildrenByTagName("xml-stylesheet");
        int n = nodeList.getLength();
        String string2 = null;
        if (n > 0 && (node2 = nodeList.item(0)).getNodeType() == 7) {
            String string3 = node2.getNodeValue();
            string2 = JXSAXData.searchLinkedXSL(string3);
            string2 = this.resolvedHref(string2, string);
        }
        return string2;
    }

    private String resolvedHref(String string, String string2) throws TransformerConfigurationException {
        String string3 = null;
        Source source = null;
        if (this.m_uriResolver != null) {
            try {
                source = this.m_uriResolver.resolve(string, string2);
                string3 = source.getSystemId();
            }
            catch (TransformerException transformerException) {
                throw new TransformerConfigurationException(transformerException);
            }
            return string3;
        }
        if (string2 == null) {
            return string;
        }
        return this.resolve(string, string2);
    }

    private String resolve(String string, String string2) throws TransformerConfigurationException {
        String string3 = null;
        try {
            URL uRL = new URL(string2);
            URL uRL2 = new URL(uRL, string);
            string3 = uRL2.toString();
        }
        catch (MalformedURLException malformedURLException) {
            this.reportConfigException(malformedURLException, 0, 1117, null);
        }
        return string3;
    }

    private InputSource streamSource2InputSource(StreamSource streamSource) throws TransformerConfigurationException {
        InputStream inputStream = streamSource.getInputStream();
        if (inputStream != null) {
            return new InputSource(inputStream);
        }
        Reader reader = streamSource.getReader();
        if (reader != null) {
            return new InputSource(reader);
        }
        String string = streamSource.getSystemId();
        if (string != null) {
            return new InputSource(string);
        }
        this.reportConfigException(null, 0, 1106, null);
        return null;
    }

    private String getAssociatedStylesheet(InputSource inputSource, String string) throws TransformerConfigurationException {
        if (inputSource == null) {
            return null;
        }
        JXSAXData jXSAXData = new JXSAXData();
        SAXParser sAXParser = new SAXParser();
        if (this.secure != null && this.secure.booleanValue()) {
            sAXParser.setSecureProcessing();
        }
        sAXParser.setDocumentHandler(jXSAXData);
        sAXParser.setEntityResolver(jXSAXData);
        sAXParser.setDTDHandler(jXSAXData);
        sAXParser.setErrorHandler(jXSAXData);
        try {
            sAXParser.parse(inputSource);
        }
        catch (Exception exception) {
            this.reportConfigException(exception, 1000, 0, null);
        }
        String string2 = jXSAXData.getXMLStylesheetHref();
        if (string2 == null || string2.trim().length() == 0) {
            this.reportConfigException(null, 0, 1121, null);
            return null;
        }
        string2 = this.resolvedHref(string2, string);
        return string2;
    }

    private String getAssociatedStylesheet(StreamSource streamSource, String string) throws TransformerConfigurationException {
        InputSource inputSource = this.streamSource2InputSource(streamSource);
        return this.getAssociatedStylesheet(inputSource, string);
    }

    private void reportConfigException(Exception exception, int n, int n2, SourceLocator sourceLocator) throws TransformerConfigurationException {
        this.m_err.reset();
        if (exception == null) {
            this.m_err.error0(n2, n);
        } else if (exception.getMessage() == null) {
            this.m_err.error1(n2, n, "null");
        } else {
            this.m_err.error1(n2, n, exception.getMessage());
        }
        String string = this.m_err.formatErrorMesg(0);
        TransformerConfigurationException transformerConfigurationException = sourceLocator != null ? (exception != null ? new TransformerConfigurationException(string, sourceLocator, exception) : new TransformerConfigurationException(string, sourceLocator)) : (exception != null ? new TransformerConfigurationException(string, exception) : new TransformerConfigurationException(string));
        if (this.m_errorListener == null) {
            try {
                if (!XMLParser.getNoShowForInvalidURLError()) {
                    this.m_err.setErrorStream(System.err);
                }
                this.m_err.printErrorListener();
                if (n == 0) {
                    throw transformerConfigurationException;
                }
            }
            catch (IOException iOException) {
                throw new TransformerConfigurationException(iOException);
            }
            return;
        }
        try {
            switch (n) {
                case 0: {
                    this.m_errorListener.fatalError(transformerConfigurationException);
                    throw transformerConfigurationException;
                }
                case 1: {
                    this.m_errorListener.error(transformerConfigurationException);
                    break;
                }
                case 2: {
                    this.m_errorListener.warning(transformerConfigurationException);
                }
            }
        }
        catch (TransformerException transformerException) {
            throw new TransformerConfigurationException(transformerException);
        }
    }
}

