/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.jdwp;

import java.util.Hashtable;
import oracle.xml.jdwp.XSLJDWPCommandSet;
import oracle.xml.jdwp.XSLJDWPConstants;
import oracle.xml.jdwp.XSLJDWPException;
import oracle.xml.jdwp.XSLJDWPObjectReference;
import oracle.xml.jdwp.XSLJDWPPacket;
import oracle.xml.jdwp.XSLJDWPPacketStream;
import oracle.xml.jdwp.XSLJDWPUtil;

class XSLJDWPStringReference
extends XSLJDWPCommandSet
implements XSLJDWPConstants {
    Hashtable ids2strings;

    XSLJDWPStringReference(XSLJDWPObjectReference xSLJDWPObjectReference) {
        this.ids2strings = xSLJDWPObjectReference.getIds2Objs();
    }

    @Override
    XSLJDWPPacket execute(XSLJDWPPacket xSLJDWPPacket) {
        this.cmd = xSLJDWPPacket;
        this.cmdStrm = new XSLJDWPPacketStream(this.cmd);
        XSLJDWPPacket xSLJDWPPacket2 = null;
        switch (this.getCommand()) {
            case 1: {
                xSLJDWPPacket2 = this.valueCmd();
                break;
            }
            default: {
                xSLJDWPPacket2 = this.cmd.createErrorReply((short)99);
            }
        }
        return xSLJDWPPacket2;
    }

    XSLJDWPPacket valueCmd() {
        int n = this.cmdStrm.readObjectID();
        XSLJDWPPacketStream xSLJDWPPacketStream = new XSLJDWPPacketStream(this.cmd.createReply());
        try {
            String string = this.getString(n);
            if (string != null) {
                xSLJDWPPacketStream.writeString(string);
            } else {
                xSLJDWPPacketStream.writeString("");
            }
        }
        catch (XSLJDWPException xSLJDWPException) {
            return this.cmd.createErrorReply(xSLJDWPException.errorCode());
        }
        xSLJDWPPacketStream.close();
        return xSLJDWPPacketStream.packet();
    }

    String getString(int n) {
        Object v = this.ids2strings.get(new Integer(n));
        return XSLJDWPUtil.toString(v);
    }
}

