/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.scalable;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Vector;
import oracle.xml.binxml.BinXMLException;
import oracle.xml.binxml.BinXMLProcessorFactory;
import oracle.xml.binxml.BinXMLProcessorImpl;
import oracle.xml.binxml.BinXMLStreamImpl;
import oracle.xml.comp.CXMLStream;
import oracle.xml.fisupport.FIStream;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.scalable.BinaryIndex;
import oracle.xml.scalable.ContentManager;
import oracle.xml.scalable.InfosetReader;
import oracle.xml.scalable.InfosetWriter;
import oracle.xml.scalable.PageManager;
import oracle.xml.xti.XTIProcessor;

public class BinaryStream {
    protected PagedIO pagedio;
    private byte[][] bufArray;
    private int[] bufCount;
    private boolean[] bufUpdated;
    private byte[] wriBuf;
    private int[][] reversePageIds;
    private int[] pageIds;
    private int pidSize = 128;
    private int[] pageTicks;
    private int pageTickCnt;
    private int pageOrderIdx;
    private DTD dtd;
    private String version;
    private String encoding;
    private String standalone;
    private String systemId;
    private Vector typelist;
    protected Vector readers;
    protected boolean writer;
    protected boolean updated;
    protected boolean readOnly = false;
    private boolean pgmSet;
    public static int NBUFFERS = 64;
    public static int BUFSIZE = 4096;
    public static final String BINARY_FORMAT = "oracle.xml.scalable.binary_format";
    public static final String XDK_CXML = "XDK_CXML_BINARY";
    public static final String XDB_BINXML = "XDB_BINXML_BINARY";
    public static final String SUN_FI = "SUN_FASTINFOSET_BINARY";
    public static final String XDK_XTI = "XDK_XTI_BINARY";
    XMLError err = new XMLError();

    public BinaryStream() {
        int n;
        this.wriBuf = new byte[BUFSIZE];
        this.bufArray = new byte[NBUFFERS][];
        this.bufCount = new int[NBUFFERS];
        this.bufUpdated = new boolean[NBUFFERS];
        this.pageIds = new int[NBUFFERS];
        this.reversePageIds = new int[this.pidSize][];
        this.reversePageIds[0] = new int[1024];
        for (n = 0; n < 1024; ++n) {
            this.reversePageIds[0][n] = -1;
        }
        this.pageTicks = new int[NBUFFERS];
        this.pageTickCnt = 0;
        this.pageOrderIdx = 0;
        for (n = 0; n < NBUFFERS; ++n) {
            this.pageIds[n] = -1;
            this.pageTicks[n] = -1;
        }
        this.pagedio = new MemoryPagedIO();
        this.typelist = new Vector();
        this.readers = new Vector();
        this.writer = false;
        this.pgmSet = false;
        this.dtd = new DTD();
    }

    public static BinaryStream newInstance(String string) {
        BinaryStream binaryStream = null;
        if (string.equals(XDK_CXML)) {
            binaryStream = new CXMLStream();
        } else if (string.equals(XDB_BINXML)) {
            try {
                BinXMLProcessorFactory binXMLProcessorFactory = new BinXMLProcessorFactory();
                BinXMLProcessorImpl binXMLProcessorImpl = (BinXMLProcessorImpl)binXMLProcessorFactory.createProcessor();
                binaryStream = (BinXMLStreamImpl)binXMLProcessorImpl.createBinXMLStream();
            }
            catch (BinXMLException binXMLException) {}
        } else if (string.equals(SUN_FI)) {
            binaryStream = new FIStream();
        } else if (string.equals(XDK_XTI)) {
            XTIProcessor xTIProcessor = new XTIProcessor();
            binaryStream = xTIProcessor.createXTIStream();
        } else {
            throw new IllegalArgumentException(string);
        }
        return binaryStream;
    }

    public InfosetReader getInfosetReader() {
        return null;
    }

    public InfosetWriter getInfosetWriter() {
        return null;
    }

    public boolean isIndexingSupported() {
        return false;
    }

    public BinaryIndex getBinaryIndex() {
        return null;
    }

    public ContentManager getContentManager() {
        return null;
    }

    public long getSize() {
        return this.pagedio.size() * BUFSIZE;
    }

    public int getBufferSize() {
        return BUFSIZE;
    }

    public void setDTD(DTD dTD) {
        this.dtd = dTD;
    }

    public DTD getDTD() {
        return this.dtd;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setStandalone(String string) {
        this.standalone = string;
    }

    public String getStandalone() {
        return this.standalone;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public Vector getTypeList() {
        return this.typelist;
    }

    public boolean isSeekSupported() {
        return this.pgmSet || !(this.pagedio instanceof StreamPagedIO) && !(this.pagedio instanceof ObjectPagedIO);
    }

    public boolean copyBytes(BinaryStream binaryStream) throws IOException {
        byte[] byArray = binaryStream.getByteArray();
        if (byArray == null) {
            return false;
        }
        OutputStream outputStream = this.pagedio.getOutputStream();
        if (outputStream == null) {
            return false;
        }
        outputStream.write(byArray);
        outputStream.flush();
        return true;
    }

    public void setObjectOutput(ObjectOutput objectOutput) {
        if (this.readers.size() > 0) {
            throw new RuntimeException();
        }
        if (!(this.pagedio instanceof ObjectPagedIO)) {
            this.pagedio = new ObjectPagedIO();
        }
        ((ObjectPagedIO)this.pagedio).setObjectOutput(objectOutput);
    }

    public void setObjectInput(ObjectInput objectInput) {
        if (this.readers.size() > 0) {
            throw new RuntimeException();
        }
        if (!(this.pagedio instanceof ObjectPagedIO)) {
            this.pagedio = new ObjectPagedIO();
        }
        ((ObjectPagedIO)this.pagedio).setObjectInput(objectInput);
    }

    public ObjectOutput getObjectOutput() {
        if (this.pagedio instanceof ObjectPagedIO) {
            return ((ObjectPagedIO)this.pagedio).getObjectOutput();
        }
        return null;
    }

    public ObjectInput getObjectInput() {
        if (this.pagedio instanceof ObjectPagedIO) {
            return ((ObjectPagedIO)this.pagedio).getObjectInput();
        }
        return null;
    }

    public String getVersion() {
        return this.version;
    }

    public void setOutputStream(OutputStream outputStream) {
        if (this.readers.size() > 0) {
            throw new RuntimeException();
        }
        if (!(this.pagedio instanceof StreamPagedIO)) {
            this.pagedio = new StreamPagedIO();
        }
        ((StreamPagedIO)this.pagedio).setOutputStream(outputStream);
    }

    public void setBlob(Blob blob) throws IOException {
        if (this.readers.size() > 0) {
            throw new RuntimeException();
        }
        this.pagedio = new BlobPagedIO(blob);
    }

    public void setFile(File file) throws IOException {
        if (this.readers.size() > 0) {
            throw new RuntimeException();
        }
        this.pagedio = new FilePagedIO(file);
    }

    public void setFiles(File file, File file2) throws IOException {
        this.err.error0(36002, 1);
        throw new RuntimeException(this.err.getMessage0(36002));
    }

    public void setInputStream(InputStream inputStream) {
        if (this.readers.size() > 0) {
            throw new RuntimeException();
        }
        if (!(this.pagedio instanceof StreamPagedIO)) {
            this.pagedio = new StreamPagedIO();
        }
        ((StreamPagedIO)this.pagedio).setInputStream(inputStream);
    }

    public void setByteArray(byte[] byArray) {
        this.pagedio = new ArrayPagedIO(byArray);
    }

    public byte[] getByteArray() {
        if (this.pagedio instanceof ArrayPagedIO) {
            return ((ArrayPagedIO)this.pagedio).data;
        }
        return null;
    }

    public void setPageManager(PageManager pageManager) {
        if (this.pagedio instanceof MemoryPagedIO) {
            this.pagedio = new StreamPagedIO();
        }
        if (!this.pgmSet && (this.pagedio instanceof StreamPagedIO || this.pagedio instanceof ObjectPagedIO)) {
            ((StreamPagedIO)this.pagedio).setPageManager(pageManager);
            this.pgmSet = true;
        }
    }

    public void resetBuffer() {
        for (int i = 0; i < NBUFFERS; ++i) {
            int n = this.pageIds[i];
            if (n < 0) continue;
            this.bufArray[i] = null;
            this.pageTicks[i] = -1;
            this.pageIds[i] = -1;
            this.reversePageIds[n >> 10][n & 0x3FF] = -1;
        }
    }

    int getReplacementBuf1() {
        int n = this.pageOrderIdx;
        do {
            int n2 = this.pageOrderIdx;
            this.pageOrderIdx = this.pageOrderIdx + 1 & NBUFFERS - 1;
            if (this.bufCount[n2] != 0) continue;
            return n2;
        } while (this.pageOrderIdx != n);
        return this.getReplacementBuf2();
    }

    int getReplacementBuf2() {
        int n = this.pageTickCnt;
        int n2 = -1;
        for (int i = 0; i < NBUFFERS; ++i) {
            if (this.pageTicks[i] >= n) continue;
            n2 = i;
            n = this.pageTicks[i];
        }
        return n2;
    }

    int getBufferId(int n) {
        int n2 = n / 1024;
        if (this.reversePageIds[n2] == null) {
            this.reversePageIds[n2] = new int[1024];
            for (int i = 0; i < 1024; ++i) {
                this.reversePageIds[n2][i] = -1;
            }
        }
        return this.reversePageIds[n2][n & 0x3FF];
    }

    void setBufferId(int n, int n2) {
        int n3 = n / 1024;
        if (this.reversePageIds[n3] == null) {
            this.reversePageIds[n3] = new int[1024];
            for (int i = 0; i < 1024; ++i) {
                this.reversePageIds[n3][i] = -1;
            }
        }
        this.reversePageIds[n3][n & 0x3FF] = n2;
    }

    public byte[] load(int n, boolean bl) {
        return this.load(n, BUFSIZE, bl);
    }

    public byte[] load(int n, int n2, boolean bl) {
        byte[][] byArray = this.bufArray;
        synchronized (this.bufArray) {
            int n3;
            if (n >= this.pidSize * 1024) {
                n3 = n / 1024;
                int n4 = this.pidSize;
                while (n3 >= this.pidSize) {
                    this.pidSize *= 2;
                }
                int[][] nArray = this.reversePageIds;
                this.reversePageIds = new int[this.pidSize][];
                System.arraycopy(nArray, 0, this.reversePageIds, 0, n4);
            }
            try {
                n3 = this.getBufferId(n);
                if (n3 != -1) {
                    this.pageTicks[n3] = ++this.pageTickCnt;
                    int n5 = n3;
                    this.bufCount[n5] = this.bufCount[n5] + 1;
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return this.bufArray[n3];
                }
                n3 = this.getReplacementBuf1();
                if (!this.readOnly && this.bufArray[n3] != null && this.bufUpdated[n3]) {
                    this.flushBuffer(this.bufArray[n3], this.pageIds[n3], this.bufArray[n3].length);
                }
                if (this.bufArray[n3] == null || this.bufCount[n3] > 0) {
                    this.bufArray[n3] = new byte[n2];
                }
                if (!bl && n >= this.pagedio.size()) {
                    throw new IllegalArgumentException("Invalid Page IO size!!!");
                }
                byte[] byArray2 = this.bufArray[n3];
                int n6 = this.pageIds[n3];
                if (n6 != -1) {
                    this.reversePageIds[n6 >> 10][n6 & 0x3FF] = -1;
                }
                this.reversePageIds[n >> 10][n & 0x3FF] = n3;
                this.pageIds[n3] = n;
                this.pageTicks[n3] = ++this.pageTickCnt;
                this.bufCount[n3] = 1;
                this.bufUpdated[n3] = bl;
                if (n < this.pagedio.size()) {
                    this.pagedio.seek(n);
                    this.pagedio.read(byArray2);
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return byArray2;
            }
            catch (IOException iOException) {
                RuntimeException runtimeException = new RuntimeException(iOException);
                throw runtimeException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unload(int n, boolean bl, byte[] byArray) {
        byte[][] byArray2 = this.bufArray;
        synchronized (this.bufArray) {
            int n2 = this.getBufferId(n);
            if (n2 >= 0 && this.bufArray[n2] != byArray) {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return;
            }
            if (n2 >= 0) {
                int n3 = n2;
                this.bufCount[n3] = this.bufCount[n3] - 1;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    public byte[] getWriteBuffer() {
        this.updated = true;
        return this.wriBuf;
    }

    public OutputStream getWriteStream() {
        this.updated = true;
        return new WriteStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushAllPagesInMemory() throws IOException {
        byte[][] byArray = this.bufArray;
        synchronized (this.bufArray) {
            for (int i = 0; i < NBUFFERS; ++i) {
                if (!this.bufUpdated[i]) continue;
                this.flushBuffer(this.bufArray[i], this.pageIds[i], this.bufArray[i].length);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void flushWriBuffer() throws IOException {
        this.wriBuf = this.pagedio.write(this.wriBuf);
    }

    public void flushWriBuffer(int n) throws IOException {
        this.pagedio.write(this.wriBuf, n);
        this.updated = false;
    }

    public void flushBuffer(byte[] byArray, int n) throws IOException {
        this.pagedio.write(byArray, n);
        this.updated = false;
    }

    public void flushBuffer(byte[] byArray, int n, int n2) throws IOException {
        this.pagedio.write(byArray, n, n2);
        this.updated = true;
    }

    public void flush() throws IOException {
        if (this.updated) {
            this.pagedio.write(this.wriBuf);
        }
        this.updated = false;
        this.pagedio.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        byte[][] byArray = this.bufArray;
        synchronized (this.bufArray) {
            this.pagedio.seek(0);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void setSystemId(String string) {
        this.systemId = string;
    }

    public String getSystemId() {
        return this.systemId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        byte[][] byArray = this.bufArray;
        synchronized (this.bufArray) {
            try {
                this.pagedio.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAll() throws IOException {
        byte[][] byArray = this.bufArray;
        synchronized (this.bufArray) {
            this.pagedio.closeAll();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static class StreamPagedIO
    implements PagedIO {
        OutputStream oos;
        InputStream ois;
        PageManager pageMgr;
        ArrayList pageIdList;
        int streamPos;
        int seekPos;

        public void setOutputStream(OutputStream outputStream) {
            this.oos = outputStream;
        }

        public void setInputStream(InputStream inputStream) {
            this.ois = inputStream;
        }

        public void setPageManager(PageManager pageManager) {
            this.pageMgr = pageManager;
            this.pageIdList = new ArrayList();
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            return this.oos;
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            while (this.seekPos >= this.streamPos && this.ois != null) {
                int n;
                int n2 = 0;
                for (int i = BUFSIZE; i != 0 && (n = this.ois.read(byArray, n2, i)) != -1; i -= n) {
                    n2 += n;
                }
                ++this.streamPos;
                if (this.pageMgr != null) {
                    PageManager.PageId pageId = this.pageMgr.writePage(byArray, 0, n2);
                    this.pageIdList.add(pageId);
                }
                if (this.seekPos != this.streamPos - 1) continue;
                ++this.seekPos;
                return n2;
            }
            PageManager.PageId pageId = (PageManager.PageId)this.pageIdList.get(this.seekPos);
            this.pageMgr.readPage(pageId, byArray, 0);
            ++this.seekPos;
            return BUFSIZE;
        }

        @Override
        public byte[] write(byte[] byArray) throws IOException {
            if (this.oos != null) {
                this.oos.write(byArray);
            }
            if (this.pageMgr != null) {
                PageManager.PageId pageId = this.pageMgr.writePage(byArray, 0, BUFSIZE);
                this.pageIdList.add(pageId);
            }
            return byArray;
        }

        @Override
        public void write(byte[] byArray, int n) throws IOException {
            if (this.oos != null) {
                this.oos.write(byArray, 0, n);
            }
            if (this.pageMgr != null) {
                PageManager.PageId pageId = this.pageMgr.writePage(byArray, 0, n);
                this.pageIdList.add(pageId);
            }
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
        }

        @Override
        public void seek(int n) {
            if (this.pageMgr == null && n < this.streamPos) {
                throw new RuntimeException("Seek not supported");
            }
            this.seekPos = n;
        }

        @Override
        public int size() {
            if (this.ois != null) {
                return Integer.MAX_VALUE;
            }
            if (this.pageMgr != null) {
                return this.pageIdList.size();
            }
            return 0;
        }

        @Override
        public void flush() {
            try {
                if (this.oos != null) {
                    this.oos.flush();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public void close() throws IOException {
            if (this.pageMgr != null) {
                int n = this.pageIdList.size();
                for (int i = n - 1; i >= 0; --i) {
                    this.pageMgr.deletePage((PageManager.PageId)this.pageIdList.remove(i));
                }
            }
        }

        @Override
        public void closeAll() throws IOException {
            this.close();
            if (this.ois != null) {
                this.ois.close();
            }
            if (this.oos != null) {
                this.oos.close();
            }
        }
    }

    static class ObjectPagedIO
    implements PagedIO {
        ObjectOutput oos;
        ObjectInput ois;
        PageManager pageMgr;
        ArrayList pageIdList;
        int streamPos;
        int seekPos;

        ObjectPagedIO() {
        }

        public void setObjectOutput(ObjectOutput objectOutput) {
            this.oos = objectOutput;
        }

        public void setObjectInput(ObjectInput objectInput) {
            this.ois = objectInput;
        }

        public ObjectOutput getObjectOutput() {
            return this.oos;
        }

        public ObjectInput getObjectInput() {
            return this.ois;
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            return null;
        }

        public void setPageManager(PageManager pageManager) {
            this.pageMgr = pageManager;
            this.pageIdList = new ArrayList();
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            while (this.seekPos >= this.streamPos && this.ois != null) {
                int n;
                int n2 = 0;
                for (int i = BUFSIZE; i != 0 && (n = this.ois.read(byArray, n2, i)) != -1; i -= n) {
                    n2 += n;
                }
                ++this.streamPos;
                if (this.pageMgr != null) {
                    PageManager.PageId pageId = this.pageMgr.writePage(byArray, 0, n2);
                    this.pageIdList.add(pageId);
                }
                if (this.seekPos != this.streamPos - 1) continue;
                ++this.seekPos;
                return n2;
            }
            PageManager.PageId pageId = (PageManager.PageId)this.pageIdList.get(this.seekPos);
            this.pageMgr.readPage(pageId, byArray, 0);
            ++this.seekPos;
            return BUFSIZE;
        }

        @Override
        public byte[] write(byte[] byArray) throws IOException {
            if (this.oos != null) {
                this.oos.write(byArray);
            }
            if (this.pageMgr != null) {
                PageManager.PageId pageId = this.pageMgr.writePage(byArray, 0, BUFSIZE);
                this.pageIdList.add(pageId);
            }
            return byArray;
        }

        @Override
        public void write(byte[] byArray, int n) throws IOException {
            if (this.oos != null) {
                this.oos.write(byArray, 0, n);
            }
            if (this.pageMgr != null) {
                PageManager.PageId pageId = this.pageMgr.writePage(byArray, 0, n);
                this.pageIdList.add(pageId);
            }
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
        }

        @Override
        public void seek(int n) {
            if (this.pageMgr == null && n < this.streamPos) {
                throw new RuntimeException("Seek not supported");
            }
            this.seekPos = n;
        }

        @Override
        public int size() {
            if (this.ois != null) {
                return Integer.MAX_VALUE;
            }
            if (this.pageMgr != null) {
                return this.pageIdList.size();
            }
            return 0;
        }

        @Override
        public void flush() {
            try {
                if (this.oos != null) {
                    this.oos.flush();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public void close() throws IOException {
            if (this.pageMgr != null) {
                int n = this.pageIdList.size();
                for (int i = n - 1; i >= 0; --i) {
                    this.pageMgr.deletePage((PageManager.PageId)this.pageIdList.remove(i));
                }
            }
        }

        @Override
        public void closeAll() throws IOException {
            this.close();
            if (this.ois != null) {
                this.ois.close();
            }
            if (this.oos != null) {
                this.oos.close();
            }
        }
    }

    static class ArrayPagedIO
    implements PagedIO {
        byte[] data;
        int readPos = 0;
        int wriPos = 0;
        int size;

        ArrayPagedIO(byte[] byArray) {
            this.data = byArray;
            this.size = this.data.length / BUFSIZE;
            if (this.data.length % BUFSIZE != 0) {
                ++this.size;
            }
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void closeAll() throws IOException {
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            return null;
        }

        @Override
        public void seek(int n) {
            this.readPos = n * BUFSIZE;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            if (this.data == null || this.readPos >= this.data.length) {
                return -1;
            }
            int n = BUFSIZE;
            if (this.readPos + BUFSIZE > this.data.length) {
                n = this.data.length - this.readPos;
            }
            System.arraycopy(this.data, this.readPos, byArray, 0, n);
            this.readPos += n;
            return n;
        }

        @Override
        public byte[] write(byte[] byArray) throws IOException {
            System.arraycopy(byArray, 0, this.data, this.wriPos, BUFSIZE);
            this.wriPos += BUFSIZE;
            return byArray;
        }

        @Override
        public void write(byte[] byArray, int n) throws IOException {
            System.arraycopy(byArray, 0, this.data, this.wriPos, n);
            this.wriPos += n;
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            System.arraycopy(byArray, n * BUFSIZE, this.data, this.wriPos, n2);
        }

        @Override
        public void flush() {
        }
    }

    static class MemoryPagedIO
    implements PagedIO {
        ArrayList buffers = new ArrayList();
        int seekBuf;

        MemoryPagedIO() {
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void closeAll() throws IOException {
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            return null;
        }

        @Override
        public void seek(int n) {
            this.seekBuf = n;
        }

        @Override
        public int size() {
            return this.buffers.size();
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            if (this.buffers == null) {
                return -1;
            }
            int n = byArray.length;
            int n2 = 0;
            while (n > 0) {
                byte[] byArray2 = (byte[])this.buffers.get(this.seekBuf);
                System.arraycopy(byArray2, 0, byArray, n2, BUFSIZE);
                ++this.seekBuf;
                n -= BUFSIZE;
                n2 += BUFSIZE;
            }
            return n2;
        }

        @Override
        public byte[] write(byte[] byArray) throws IOException {
            byte[] byArray2 = new byte[BUFSIZE];
            System.arraycopy(byArray, 0, byArray2, 0, BUFSIZE);
            this.buffers.add(byArray2);
            return byArray;
        }

        @Override
        public void write(byte[] byArray, int n) throws IOException {
            byte[] byArray2 = new byte[BUFSIZE];
            System.arraycopy(byArray, 0, byArray2, 0, n);
            this.buffers.add(byArray2);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            byte[] byArray2 = null;
            int n3 = 0;
            while (n2 > 0) {
                byArray2 = new byte[BUFSIZE];
                System.arraycopy(byArray, n3, byArray2, 0, BUFSIZE);
                n3 += BUFSIZE;
                n2 -= BUFSIZE;
                if (this.buffers.size() <= n) {
                    while (this.buffers.size() < n) {
                        this.buffers.add(null);
                    }
                    this.buffers.add(byArray2);
                } else {
                    this.buffers.set(n, byArray2);
                }
                ++n;
            }
        }

        @Override
        public void flush() {
        }
    }

    static class BlobPagedIO
    implements PagedIO {
        Blob blob;
        OutputStream os;
        int offset;
        int sz;

        BlobPagedIO(Blob blob) throws IOException {
            try {
                this.blob = blob;
                long l = blob.length();
                this.sz = (int)(l / (long)BUFSIZE);
                if (l % (long)BUFSIZE != 0L) {
                    ++this.sz;
                }
            }
            catch (SQLException sQLException) {
                IOException iOException = new IOException(sQLException.getMessage());
                iOException.initCause(sQLException);
                throw iOException;
            }
        }

        @Override
        public void close() throws IOException {
            if (this.os != null) {
                this.os.close();
            }
            this.os = null;
        }

        @Override
        public void closeAll() throws IOException {
            this.close();
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            if (this.os == null) {
                try {
                    this.os = this.blob.setBinaryStream(0L);
                }
                catch (SQLException sQLException) {
                    IOException iOException = new IOException(sQLException.getMessage());
                    iOException.initCause(sQLException);
                    throw iOException;
                }
            }
            return this.os;
        }

        @Override
        public void seek(int n) {
            this.offset = n;
        }

        @Override
        public int size() {
            return this.sz;
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            try {
                int n;
                int n2 = this.offset * BUFSIZE;
                int n3 = byArray.length;
                if (this.offset == this.sz - 1 && n2 + n3 > (n = (int)this.blob.length())) {
                    n3 = n - n2;
                }
                byte[] byArray2 = this.blob.getBytes(n2 + 1, n3);
                System.arraycopy(byArray2, 0, byArray, 0, n3);
                ++this.offset;
                return n3;
            }
            catch (SQLException sQLException) {
                IOException iOException = new IOException(sQLException.getMessage());
                iOException.initCause(sQLException);
                throw iOException;
            }
        }

        @Override
        public byte[] write(byte[] byArray) throws IOException {
            if (this.os == null) {
                try {
                    this.os = this.blob.setBinaryStream(0L);
                }
                catch (SQLException sQLException) {
                    IOException iOException = new IOException(sQLException.getMessage());
                    iOException.initCause(sQLException);
                    throw iOException;
                }
            }
            for (int i = 0; i < BUFSIZE; ++i) {
                this.os.write(byArray[i]);
            }
            ++this.sz;
            return byArray;
        }

        @Override
        public void write(byte[] byArray, int n) throws IOException {
            if (this.os == null) {
                try {
                    this.os = this.blob.setBinaryStream(0L);
                }
                catch (SQLException sQLException) {
                    IOException iOException = new IOException(sQLException.getMessage());
                    iOException.initCause(sQLException);
                    throw iOException;
                }
            }
            for (int i = 0; i < n; ++i) {
                this.os.write(byArray[i]);
            }
            ++this.sz;
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (this.os == null) {
                try {
                    this.os = this.blob.setBinaryStream(n * BUFSIZE);
                }
                catch (SQLException sQLException) {
                    IOException iOException = new IOException(sQLException.getMessage());
                    iOException.initCause(sQLException);
                    throw iOException;
                }
            }
            for (int i = 0; i < n2; ++i) {
                this.os.write(byArray[i]);
            }
        }

        @Override
        public void flush() {
            try {
                if (this.os != null) {
                    this.os.flush();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static class FilePagedIO
    implements PagedIO {
        RandomAccessFile file;
        int sz;
        int offset;

        public FilePagedIO(File file) throws IOException {
            this.file = new RandomAccessFile(file, "rw");
            long l = this.file.length();
            this.sz = (int)(l / (long)BUFSIZE);
            if ((l & (long)(BUFSIZE - 1)) != 0L) {
                ++this.sz;
            }
        }

        @Override
        public void close() throws IOException {
            this.file.close();
        }

        @Override
        public void closeAll() throws IOException {
            this.file.close();
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            return null;
        }

        @Override
        public void seek(int n) {
            try {
                this.offset = n;
                this.file.seek((long)n * (long)BUFSIZE);
            }
            catch (IOException iOException) {
                RuntimeException runtimeException = new RuntimeException(iOException);
                runtimeException.initCause(iOException);
                throw runtimeException;
            }
        }

        @Override
        public int size() {
            return this.sz;
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            int n;
            int n2 = 0;
            int n3 = byArray.length;
            while (n3 != 0 && (n = this.file.read(byArray, n2, n3)) != -1) {
                n3 -= n;
                n2 += n;
            }
            return n2;
        }

        @Override
        public byte[] write(byte[] byArray) throws IOException {
            this.file.write(byArray);
            if (this.offset == this.sz) {
                ++this.offset;
                ++this.sz;
            }
            return byArray;
        }

        @Override
        public void write(byte[] byArray, int n) throws IOException {
            this.file.write(byArray, 0, n);
            if (this.offset == this.sz) {
                ++this.offset;
                ++this.sz;
            }
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            long l = (long)n * (long)BUFSIZE;
            if (l >= this.file.length()) {
                this.file.setLength(l + 1L);
            }
            this.file.seek(l);
            this.file.write(byArray, 0, n2);
            long l2 = this.file.length();
            this.sz = (int)(l2 / (long)BUFSIZE);
            if ((l2 & (long)(BUFSIZE - 1)) != 0L) {
                ++this.sz;
            }
        }

        @Override
        public void flush() {
        }
    }

    static interface PagedIO {
        public int read(byte[] var1) throws IOException;

        public byte[] write(byte[] var1) throws IOException;

        public void write(byte[] var1, int var2) throws IOException;

        public void write(byte[] var1, int var2, int var3) throws IOException;

        public void seek(int var1);

        public OutputStream getOutputStream() throws IOException;

        public int size();

        public void flush();

        public void close() throws IOException;

        public void closeAll() throws IOException;
    }

    class WriteStream
    extends OutputStream {
        int index = 0;

        WriteStream() {
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            int n = byArray.length;
            int n2 = 0;
            while (n > 0) {
                int n3;
                if (this.index == BUFSIZE) {
                    BinaryStream.this.flushWriBuffer();
                    this.index = 0;
                }
                n3 = (n3 = BUFSIZE - this.index) > n ? n : n3;
                n -= n3;
                System.arraycopy(byArray, n2, BinaryStream.this.wriBuf, this.index, n3);
                this.index += n3;
                n2 += n3;
            }
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            int n3 = n;
            while (n2 > 0) {
                int n4;
                if (this.index == BUFSIZE) {
                    BinaryStream.this.flushWriBuffer();
                    this.index = 0;
                }
                n4 = (n4 = BUFSIZE - this.index) > n2 ? n2 : n4;
                n2 -= n4;
                System.arraycopy(byArray, n3, BinaryStream.this.wriBuf, this.index, n4);
                this.index += n4;
                n3 += n4;
            }
        }

        @Override
        public void write(int n) throws IOException {
            if (this.index == BUFSIZE) {
                BinaryStream.this.flushWriBuffer();
                this.index = 0;
            }
            ((BinaryStream)BinaryStream.this).wriBuf[this.index++] = (byte)n;
        }

        @Override
        public void flush() throws IOException {
            BinaryStream.this.flushWriBuffer(this.index);
        }
    }
}

