/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.jdwp;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.xml.jdwp.XSLJDWPCommandSet;
import oracle.xml.jdwp.XSLJDWPConstants;
import oracle.xml.jdwp.XSLJDWPException;
import oracle.xml.jdwp.XSLJDWPObjectReference;
import oracle.xml.jdwp.XSLJDWPPacket;
import oracle.xml.jdwp.XSLJDWPPacketStream;
import oracle.xml.jdwp.XSLJDWPUtil;
import oracle.xml.parser.v2.XMLParser;
import oracle.xml.xpath.XPathSequence;

public class XSLJDWPVirtualMachine
extends XSLJDWPCommandSet
implements XSLJDWPConstants {
    private Hashtable classes2IDs;
    private Hashtable ids2Classes;
    private Vector xmlclassids = new Vector(5);
    private XSLJDWPObjectReference or;

    public XSLJDWPVirtualMachine() {
        this.classes2IDs = new Hashtable(5, 0.2f);
        this.ids2Classes = new Hashtable(5, 0.2f);
        Integer n = new Integer(1);
        this.classes2IDs.put("XMLNode", n);
        this.ids2Classes.put(n, "XMLNode");
        n = new Integer(2);
        this.classes2IDs.put("XMLNode[]", n);
        this.ids2Classes.put(n, "XMLNode[]");
        n = new Integer(3);
        this.classes2IDs.put("XMLString", n);
        this.ids2Classes.put(n, "XMLString");
        n = new Integer(4);
        this.classes2IDs.put("char[]", n);
        this.ids2Classes.put(n, "char[]");
    }

    public void setJDWPObjectReference(XSLJDWPObjectReference xSLJDWPObjectReference) {
        this.or = xSLJDWPObjectReference;
    }

    public Vector getXMLSourceClassIDs() {
        return this.xmlclassids;
    }

    public Hashtable getClasses2IDs() {
        return this.classes2IDs;
    }

    public Hashtable getIDs2Classes() {
        return this.ids2Classes;
    }

    public int getClassID(String string) {
        if (string == null || string.length() == 0) {
            return 1;
        }
        Integer n = (Integer)this.classes2IDs.get(string);
        if (n == null) {
            int n2 = this.classes2IDs.size() + 1;
            n = new Integer(n2);
            this.classes2IDs.put(string, n);
            this.ids2Classes.put(n, string);
            return n2;
        }
        return n;
    }

    public Hashtable getAllClassesByID() {
        return this.ids2Classes;
    }

    public int getRefType(String string) {
        Enumeration enumeration = this.ids2Classes.keys();
        while (enumeration.hasMoreElements()) {
            Integer n = (Integer)enumeration.nextElement();
            String string2 = (String)this.ids2Classes.get(n);
            if (string2.compareTo(string) != 0) continue;
            return n;
        }
        return -1;
    }

    @Override
    XSLJDWPPacket execute(XSLJDWPPacket xSLJDWPPacket) {
        this.cmd = xSLJDWPPacket;
        this.cmdStrm = new XSLJDWPPacketStream(this.cmd);
        XSLJDWPPacket xSLJDWPPacket2 = null;
        switch (this.getCommand()) {
            case 1: {
                xSLJDWPPacket2 = this.versionCmd();
                break;
            }
            case 3: {
                xSLJDWPPacket2 = this.allClassesCmd();
                break;
            }
            case 4: {
                xSLJDWPPacket2 = this.allThreadsCmd();
                break;
            }
            case 5: {
                xSLJDWPPacket2 = this.topLevelThreadGroupsCmd();
                break;
            }
            case 6: {
                xSLJDWPPacket2 = this.disposeCmd();
                break;
            }
            case 7: {
                xSLJDWPPacket2 = this.idSizesCmd();
                break;
            }
            case 8: {
                xSLJDWPPacket2 = this.suspendCmd();
                break;
            }
            case 9: {
                xSLJDWPPacket2 = this.resumeCmd();
                break;
            }
            case 10: {
                xSLJDWPPacket2 = this.exitCmd();
                break;
            }
            case 11: {
                xSLJDWPPacket2 = this.createStringCmd();
                break;
            }
            case 12: {
                xSLJDWPPacket2 = this.capabilitiesCmd();
                break;
            }
            case 13: {
                xSLJDWPPacket2 = this.classPathsCmd();
                break;
            }
            case 15: {
                xSLJDWPPacket2 = this.HoldEventsCmd();
                break;
            }
            case 16: {
                xSLJDWPPacket2 = this.ReleaseEventsCmd();
                break;
            }
            case 17: {
                xSLJDWPPacket2 = this.capabilitiesNewCmd();
                break;
            }
            default: {
                xSLJDWPPacket2 = this.cmd.createErrorReply((short)99);
            }
        }
        return xSLJDWPPacket2;
    }

    XSLJDWPPacket versionCmd() {
        XSLJDWPPacketStream xSLJDWPPacketStream = new XSLJDWPPacketStream(this.cmd.createReply());
        String string = XMLParser.getReleaseVersion();
        try {
            char c;
            xSLJDWPPacketStream.writeString(string);
            xSLJDWPPacketStream.writeInt(1);
            xSLJDWPPacketStream.writeInt(3);
            int n = 0;
            while ((c = string.charAt(n)) != '\u0000' && !Character.isDigit(c)) {
                ++n;
            }
            int n2 = string.indexOf(" ", n);
            xSLJDWPPacketStream.writeString(string.substring(n, n2));
            xSLJDWPPacketStream.writeString(string.substring(0, n));
        }
        catch (XSLJDWPException xSLJDWPException) {
            return this.cmd.createErrorReply(xSLJDWPException.errorCode());
        }
        xSLJDWPPacketStream.close();
        return xSLJDWPPacketStream.packet();
    }

    XSLJDWPPacket allClassesCmd() {
        XSLJDWPPacketStream xSLJDWPPacketStream = new XSLJDWPPacketStream(this.cmd.createReply());
        Hashtable hashtable = this.getAllClassesByID();
        int n = hashtable.size();
        xSLJDWPPacketStream.writeInt(n);
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Integer n2 = (Integer)enumeration.nextElement();
            int n3 = n2;
            if (n3 == this.getRefType("XMLNode[]") || n3 == this.getRefType("char[]")) {
                xSLJDWPPacketStream.writeByte((byte)3);
            } else {
                xSLJDWPPacketStream.writeByte((byte)1);
            }
            xSLJDWPPacketStream.writeReferenceTypeID(n3);
            String string = (String)hashtable.get(n2);
            try {
                URL uRL = null;
                try {
                    uRL = new URL(string);
                    xSLJDWPPacketStream.writeString(XSLJDWPUtil.getClassSignature(uRL));
                }
                catch (MalformedURLException malformedURLException) {
                    xSLJDWPPacketStream.writeString(XSLJDWPUtil.getClassSignature(string));
                }
            }
            catch (XSLJDWPException xSLJDWPException) {
                return this.cmd.createErrorReply(xSLJDWPException.errorCode());
            }
            xSLJDWPPacketStream.writeInt(this.jdwpvm.xsl.getClassStatus());
        }
        xSLJDWPPacketStream.close();
        return xSLJDWPPacketStream.packet();
    }

    XSLJDWPPacket allThreadsCmd() {
        XSLJDWPPacketStream xSLJDWPPacketStream = new XSLJDWPPacketStream(this.cmd.createReply());
        xSLJDWPPacketStream.writeInt(1);
        xSLJDWPPacketStream.writeThreadID(1);
        xSLJDWPPacketStream.close();
        return xSLJDWPPacketStream.packet();
    }

    XSLJDWPPacket topLevelThreadGroupsCmd() {
        XSLJDWPPacketStream xSLJDWPPacketStream = new XSLJDWPPacketStream(this.cmd.createReply());
        xSLJDWPPacketStream.writeInt(1);
        xSLJDWPPacketStream.writeThreadGroupID(11);
        xSLJDWPPacketStream.close();
        return xSLJDWPPacketStream.packet();
    }

    XSLJDWPPacket disposeCmd() {
        XSLJDWPPacketStream xSLJDWPPacketStream = new XSLJDWPPacketStream(this.cmd.createReply());
        this.jdwpvm.setDispose(true);
        Thread thread = this.jdwpvm.getXSLThread();
        this.jdwpvm.disconnectReader();
        this.jdwpvm.disconnectWriter();
        try {
            this.jdwpvm.joinThread(thread);
            this.jdwpvm.closeConnection();
        }
        catch (XSLJDWPException xSLJDWPException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return xSLJDWPPacketStream.packet();
    }

    XSLJDWPPacket idSizesCmd() {
        XSLJDWPPacketStream xSLJDWPPacketStream = new XSLJDWPPacketStream(this.cmd.createReply());
        xSLJDWPPacketStream.writeInt(4);
        xSLJDWPPacketStream.writeInt(4);
        xSLJDWPPacketStream.writeInt(4);
        xSLJDWPPacketStream.writeInt(4);
        xSLJDWPPacketStream.writeInt(4);
        xSLJDWPPacketStream.close();
        return xSLJDWPPacketStream.packet();
    }

    XSLJDWPPacket suspendCmd() {
        this.jdwpvm.xsl.suspendDebugger(true);
        XSLJDWPPacketStream xSLJDWPPacketStream = new XSLJDWPPacketStream(this.cmd.createReply());
        xSLJDWPPacketStream.close();
        return xSLJDWPPacketStream.packet();
    }

    XSLJDWPPacket resumeCmd() {
        this.jdwpvm.xsl.suspendDebugger(false);
        XSLJDWPUtil.printTrace(this.jdwpvm.xsl.getXSLDebugProp(), "Resume command, status set to RUNNING");
        XSLJDWPPacketStream xSLJDWPPacketStream = new XSLJDWPPacketStream(this.cmd.createReply());
        xSLJDWPPacketStream.close();
        return xSLJDWPPacketStream.packet();
    }

    XSLJDWPPacket HoldEventsCmd() {
        XSLJDWPUtil.printTrace(this.jdwpvm.xsl.getXSLDebugProp(), "HoldEvents command");
        XSLJDWPPacketStream xSLJDWPPacketStream = new XSLJDWPPacketStream(this.cmd.createReply());
        xSLJDWPPacketStream.close();
        return xSLJDWPPacketStream.packet();
    }

    XSLJDWPPacket ReleaseEventsCmd() {
        XSLJDWPUtil.printTrace(this.jdwpvm.xsl.getXSLDebugProp(), "ReleaseEvents command");
        XSLJDWPPacketStream xSLJDWPPacketStream = new XSLJDWPPacketStream(this.cmd.createReply());
        xSLJDWPPacketStream.close();
        return xSLJDWPPacketStream.packet();
    }

    XSLJDWPPacket exitCmd() {
        int n = this.cmdStrm.readInt();
        XSLJDWPPacketStream xSLJDWPPacketStream = new XSLJDWPPacketStream(this.cmd.createReply());
        this.jdwpvm.disconnectReader();
        this.jdwpvm.disconnectWriter();
        Thread thread = this.jdwpvm.getXSLThread();
        try {
            this.jdwpvm.joinThread(thread);
            this.jdwpvm.closeConnection();
        }
        catch (XSLJDWPException xSLJDWPException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return xSLJDWPPacketStream.packet();
    }

    XSLJDWPPacket capabilitiesCmd() {
        XSLJDWPPacketStream xSLJDWPPacketStream = new XSLJDWPPacketStream(this.cmd.createReply());
        xSLJDWPPacketStream.writeBoolean(false);
        xSLJDWPPacketStream.writeBoolean(false);
        xSLJDWPPacketStream.writeBoolean(false);
        xSLJDWPPacketStream.writeBoolean(false);
        xSLJDWPPacketStream.writeBoolean(false);
        xSLJDWPPacketStream.writeBoolean(false);
        xSLJDWPPacketStream.writeBoolean(false);
        xSLJDWPPacketStream.close();
        return xSLJDWPPacketStream.packet();
    }

    XSLJDWPPacket capabilitiesNewCmd() {
        XSLJDWPPacketStream xSLJDWPPacketStream = new XSLJDWPPacketStream(this.cmd.createReply());
        xSLJDWPPacketStream.writeBoolean(false);
        xSLJDWPPacketStream.writeBoolean(false);
        xSLJDWPPacketStream.writeBoolean(false);
        xSLJDWPPacketStream.writeBoolean(false);
        xSLJDWPPacketStream.writeBoolean(false);
        xSLJDWPPacketStream.writeBoolean(false);
        xSLJDWPPacketStream.writeBoolean(false);
        xSLJDWPPacketStream.writeBoolean(false);
        xSLJDWPPacketStream.writeBoolean(false);
        xSLJDWPPacketStream.writeBoolean(false);
        xSLJDWPPacketStream.writeBoolean(false);
        xSLJDWPPacketStream.writeBoolean(false);
        xSLJDWPPacketStream.writeBoolean(false);
        xSLJDWPPacketStream.writeBoolean(false);
        xSLJDWPPacketStream.writeBoolean(false);
        xSLJDWPPacketStream.writeBoolean(false);
        xSLJDWPPacketStream.writeBoolean(false);
        xSLJDWPPacketStream.writeBoolean(false);
        xSLJDWPPacketStream.writeBoolean(false);
        xSLJDWPPacketStream.writeBoolean(false);
        xSLJDWPPacketStream.writeBoolean(false);
        xSLJDWPPacketStream.writeBoolean(false);
        xSLJDWPPacketStream.writeBoolean(false);
        xSLJDWPPacketStream.writeBoolean(false);
        xSLJDWPPacketStream.writeBoolean(false);
        xSLJDWPPacketStream.writeBoolean(false);
        xSLJDWPPacketStream.writeBoolean(false);
        xSLJDWPPacketStream.writeBoolean(false);
        xSLJDWPPacketStream.writeBoolean(false);
        xSLJDWPPacketStream.writeBoolean(false);
        xSLJDWPPacketStream.writeBoolean(false);
        xSLJDWPPacketStream.writeBoolean(false);
        xSLJDWPPacketStream.close();
        return xSLJDWPPacketStream.packet();
    }

    XSLJDWPPacket classPathsCmd() {
        XSLJDWPPacketStream xSLJDWPPacketStream = new XSLJDWPPacketStream(this.cmd.createReply());
        try {
            xSLJDWPPacketStream.writeString("");
            xSLJDWPPacketStream.writeInt(0);
            xSLJDWPPacketStream.writeInt(0);
        }
        catch (XSLJDWPException xSLJDWPException) {
            return this.cmd.createErrorReply(xSLJDWPException.errorCode());
        }
        xSLJDWPPacketStream.close();
        return xSLJDWPPacketStream.packet();
    }

    XSLJDWPPacket createStringCmd() {
        String string;
        try {
            string = this.cmdStrm.readString();
        }
        catch (XSLJDWPException xSLJDWPException) {
            return this.cmd.createErrorReply(xSLJDWPException.errorCode());
        }
        XSLJDWPPacketStream xSLJDWPPacketStream = new XSLJDWPPacketStream(this.cmd.createReply());
        int n = this.or.getHashCodes().size();
        Integer n2 = new Integer(n += 0x2000000);
        XPathSequence xPathSequence = new XPathSequence(this.or.context);
        XPathSequence.setStringValue(xPathSequence, string);
        this.or.getIds2Objs().put(n2, xPathSequence);
        this.or.getObjs2Ids().put(xPathSequence, n2);
        xSLJDWPPacketStream.writeStringID(n);
        xSLJDWPPacketStream.close();
        return xSLJDWPPacketStream.packet();
    }
}

