/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xpath;

import oracle.xml.parser.v2.XMLNode;
import oracle.xml.util.FastVector;
import oracle.xml.xpath.IntersectExceptExpr;
import oracle.xml.xpath.XPathException;
import oracle.xml.xpath.XPathRuntimeContext;
import oracle.xml.xpath.XPathSequence;
import oracle.xml.xpath.XSLExprBase;
import oracle.xml.xpath.XSLParseString;
import oracle.xml.xqxp.XQException;
import oracle.xml.xslt.XSLException;
import oracle.xml.xslt.XSLTContext;

class XSLNodeSetExpr
extends XSLExprBase {
    private FastVector exprVector = new FastVector();

    XSLNodeSetExpr() throws XSLException {
        super.setExprType(0x2200000);
    }

    static XSLExprBase parse(XSLParseString xSLParseString) throws XSLException, XQException {
        XSLExprBase xSLExprBase = IntersectExceptExpr.parse(xSLParseString);
        if (xSLParseString.peekToken() == 102) {
            XSLNodeSetExpr xSLNodeSetExpr = new XSLNodeSetExpr();
            xSLNodeSetExpr.setCompatibilityFlags(xSLParseString.getXSLTVersion(), xSLParseString.isBackwardCompatibilityMode(), xSLParseString.isForwardCompatibilityMode());
            xSLNodeSetExpr.exprVector.addElement(xSLExprBase);
            if (!xSLExprBase.mayBeExprType(0x200000)) {
                throw new XPathException(1038);
            }
            while (xSLParseString.peekToken(102)) {
                xSLExprBase = IntersectExceptExpr.parse(xSLParseString);
                if (!xSLExprBase.mayBeExprType(0x200000)) {
                    throw new XPathException(1038);
                }
                xSLNodeSetExpr.exprVector.addElement(xSLExprBase);
                if (!(xSLNodeSetExpr.priority < xSLExprBase.priority)) continue;
                xSLNodeSetExpr.priority = xSLExprBase.priority;
            }
            xSLExprBase = xSLNodeSetExpr;
            if (xSLParseString.isCachingExpr() && !xSLNodeSetExpr.canCacheExpr()) {
                xSLNodeSetExpr.cacheSubExpr();
            }
        }
        return xSLExprBase;
    }

    void cacheSubExpr() throws XQException {
        int n = this.exprVector.size();
        for (int i = 0; i < n; ++i) {
            XSLExprBase xSLExprBase = (XSLExprBase)this.exprVector.elementAt(i);
            if (!xSLExprBase.canCacheExpr()) continue;
            this.exprVector.setElementAt(xSLExprBase.createCachedExpr(), i);
        }
    }

    boolean canCacheExpr() {
        int n = this.exprVector.size();
        for (int i = 0; i < n; ++i) {
            XSLExprBase xSLExprBase = (XSLExprBase)this.exprVector.elementAt(i);
            if (xSLExprBase.canCacheExpr()) continue;
            return false;
        }
        return true;
    }

    String getNormalizedExpr() throws XQException {
        XSLExprBase xSLExprBase = (XSLExprBase)this.exprVector.elementAt(0);
        StringBuffer stringBuffer = new StringBuffer(xSLExprBase.getNormalizedExpr());
        int n = this.exprVector.size();
        for (int i = 1; i < n; ++i) {
            xSLExprBase = (XSLExprBase)this.exprVector.elementAt(i);
            stringBuffer.append(102);
            stringBuffer.append(xSLExprBase.getNormalizedExpr());
        }
        return stringBuffer.toString();
    }

    boolean checkPosLastFN() {
        int n = this.exprVector.size();
        for (int i = 0; i < n; ++i) {
            XSLExprBase xSLExprBase = (XSLExprBase)this.exprVector.elementAt(i);
            if (!xSLExprBase.checkPosLastFN()) continue;
            return true;
        }
        return false;
    }

    public void evaluate(XPathRuntimeContext xPathRuntimeContext) throws XSLException, XQException {
        xPathRuntimeContext.setCompatibilityFlags(this.getXSLTVersion(), this.isBackwardCompatibilityMode(), this.isForwardCompatibilityMode());
        int n = this.exprVector.size();
        XSLExprBase xSLExprBase = (XSLExprBase)this.exprVector.elementAt(0);
        xSLExprBase.evaluate(xPathRuntimeContext);
        XPathSequence xPathSequence = (XPathSequence)xPathRuntimeContext.peekExprValue();
        if (!xSLExprBase.isExprType(0x200000) && !xPathSequence.isNodeSequence()) {
            throw new XPathException(1038);
        }
        for (int i = 1; i < n; ++i) {
            xSLExprBase = (XSLExprBase)this.exprVector.elementAt(i);
            xSLExprBase.evaluate(xPathRuntimeContext);
            XPathSequence xPathSequence2 = (XPathSequence)xPathRuntimeContext.popExprValue();
            if (!xSLExprBase.isExprType(0x200000) && !xPathSequence2.isNodeSequence()) {
                throw new XPathException(1038);
            }
            XPathSequence.mergeSequence(xPathSequence, xPathSequence2);
        }
    }

    public XSLExprBase matchPattern(XMLNode xMLNode, float f, XSLTContext xSLTContext) throws XSLException, XQException {
        XSLExprBase xSLExprBase = null;
        int n = this.exprVector.size();
        for (int i = 0; i < n; ++i) {
            XSLExprBase xSLExprBase2 = (XSLExprBase)this.exprVector.elementAt(i);
            if (!(xSLExprBase2.getPriority() > f) || xSLExprBase2.matchPattern(xMLNode, f, xSLTContext) == null) continue;
            xSLExprBase = xSLExprBase2;
            f = xSLExprBase2.getPriority();
        }
        return xSLExprBase;
    }

    public void setPriority(float f) throws XSLException {
        int n = this.exprVector.size();
        for (int i = 0; i < n; ++i) {
            XSLExprBase xSLExprBase = (XSLExprBase)this.exprVector.elementAt(i);
            xSLExprBase.setPriority(f);
        }
        this.priority = f;
    }
}

