/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xpath;

import javax.xml.namespace.QName;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.util.QxName;
import oracle.xml.xpath.XPathException;
import oracle.xml.xpath.XSLExprConstants;
import oracle.xml.xpath.XSLParseString;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xslt.XSLException;
import oracle.xml.xslt.XSLStylesheet;

class XPathSeqType
implements XSLExprConstants {
    XPathSeqType() {
    }

    static OXMLSequenceType parse(XSLParseString xSLParseString) throws XSLException {
        OXMLSequenceType oXMLSequenceType = null;
        int n = xSLParseString.nextToken();
        if (n == 116) {
            oXMLSequenceType = OXMLSequenceType.EMPTY_SEQUENCE;
        } else if (n == 114 && xSLParseString.getItemType() == 710) {
            if (xSLParseString.peekToken(115)) {
                switch (XPathSeqType.mapOccurIndicator(xSLParseString.getOccurIndicator())) {
                    case 1: {
                        oXMLSequenceType = OXMLSequenceType.ITEM_ONE;
                        break;
                    }
                    case 4: {
                        oXMLSequenceType = OXMLSequenceType.ITEM_ZERO_OR_MORE;
                        break;
                    }
                    case 2: {
                        oXMLSequenceType = OXMLSequenceType.ITEM_ZERO_OR_ONE;
                        break;
                    }
                    case 3: {
                        oXMLSequenceType = OXMLSequenceType.ITEM_ONE_OR_MORE;
                    }
                }
            } else {
                oXMLSequenceType = OXMLSequenceType.ITEM_ONE;
            }
        } else if (n == 114 && xSLParseString.getItemType() == 711) {
            QxName qxName = new QxName(xSLParseString.getNamespace(), xSLParseString.getLocalName());
            oXMLSequenceType = xSLParseString.peekToken(115) ? OXMLSequenceType.createValueType(qxName, XPathSeqType.mapOccurIndicator(xSLParseString.getOccurIndicator()), xSLParseString.getStylesheet().getSchema()) : OXMLSequenceType.createValueType(qxName, 1, xSLParseString.getStylesheet().getSchema());
        } else if (n == 117) {
            switch (xSLParseString.getKindTest()) {
                case 404: {
                    oXMLSequenceType = XPathSeqType.parseDocTest(xSLParseString, oXMLSequenceType);
                    break;
                }
                case 405: {
                    oXMLSequenceType = XPathSeqType.parseElementTest(xSLParseString, 1);
                    break;
                }
                case 406: {
                    oXMLSequenceType = XPathSeqType.parseAttrTest(xSLParseString);
                    break;
                }
                case 407: {
                    throw new XPathException(23003);
                }
                case 408: {
                    throw new XPathException(23003);
                }
                case 400: {
                    oXMLSequenceType = XPathSeqType.parsePITest(xSLParseString);
                    break;
                }
                case 401: {
                    oXMLSequenceType = XPathSeqType.parseCommentTest(xSLParseString);
                    break;
                }
                case 402: {
                    oXMLSequenceType = XPathSeqType.parseTextTest(xSLParseString);
                    break;
                }
                case 403: {
                    oXMLSequenceType = XPathSeqType.parseAnyKindTest(xSLParseString);
                }
            }
        }
        return oXMLSequenceType;
    }

    private static OXMLSequenceType parseDocTest(XSLParseString xSLParseString, OXMLSequenceType oXMLSequenceType) throws XPathException {
        int n;
        if (xSLParseString.peekToken(117)) {
            n = xSLParseString.getKindTest();
            if (n == 405) {
                oXMLSequenceType = XPathSeqType.parseElementTest(xSLParseString, 9);
            } else {
                if (n == 407) {
                    throw new XPathException(23003);
                }
                throw new XPathException(1013, "document-node");
            }
        }
        if (xSLParseString.nextToken() != 26) {
            throw new XPathException(1013, "document-node");
        }
        n = XPathSeqType.nextOccurIndicator(xSLParseString);
        if (oXMLSequenceType == null) {
            oXMLSequenceType = OXMLSequenceType.createNodeType(9, n);
        } else {
            oXMLSequenceType.setOccurence(n);
        }
        return oXMLSequenceType;
    }

    private static OXMLSequenceType parseElementTest(XSLParseString xSLParseString, int n) throws XPathException {
        QxName qxName = null;
        QxName qxName2 = null;
        int n2 = 0;
        int n3 = xSLParseString.peekToken();
        if (n3 == 120 || n3 == 119) {
            xSLParseString.nextToken();
            if (n3 == 120) {
                qxName = new QxName(xSLParseString.getNamespace(), xSLParseString.getLocalName());
            }
            if (xSLParseString.peekToken(1)) {
                if (xSLParseString.nextToken() != 120) {
                    throw new XPathException(1013, "element");
                }
                qxName2 = new QxName(xSLParseString.getNamespace(), xSLParseString.getLocalName());
                if (xSLParseString.peekToken(115)) {
                    if (xSLParseString.getOccurIndicator() == 722) {
                        n2 = -1;
                    } else {
                        throw new XPathException(1013, "element");
                    }
                }
            }
        }
        if (xSLParseString.nextToken() != 26) {
            throw new XPathException(1013, "element");
        }
        int n4 = 1;
        if (n == 1) {
            n4 = XPathSeqType.nextOccurIndicator(xSLParseString);
        }
        XMLSchema xMLSchema = null;
        XSLStylesheet xSLStylesheet = xSLParseString.getStylesheet();
        if (xSLStylesheet != null) {
            xMLSchema = xSLStylesheet.getSchema();
        }
        return OXMLSequenceType.createNodeType((QName)qxName, (QName)qxName2, n, n2 != 0, n4, xMLSchema);
    }

    private static OXMLSequenceType parseAttrTest(XSLParseString xSLParseString) throws XPathException {
        QxName qxName = null;
        QxName qxName2 = null;
        int n = xSLParseString.peekToken();
        if (n == 120 || n == 119) {
            xSLParseString.nextToken();
            if (n == 120) {
                qxName = new QxName(xSLParseString.getNamespace(), xSLParseString.getLocalName());
            }
            if (xSLParseString.peekToken(1)) {
                if (xSLParseString.nextToken() == 120) {
                    qxName2 = new QxName(xSLParseString.getNamespace(), xSLParseString.getLocalName());
                } else {
                    throw new XPathException(1013, "attribute");
                }
            }
        }
        if (xSLParseString.nextToken() != 26) {
            throw new XPathException(1013, "attribute");
        }
        int n2 = XPathSeqType.nextOccurIndicator(xSLParseString);
        return OXMLSequenceType.createNodeType((QName)qxName, qxName2, 2, false, n2, xSLParseString.getStylesheet().getSchema());
    }

    private static OXMLSequenceType parseSchemaElementTest(XSLParseString xSLParseString, int n) throws XPathException {
        QxName qxName = null;
        if (xSLParseString.nextToken() != 120) {
            throw new XPathException(1013, "schema-element");
        }
        qxName = new QxName(xSLParseString.getNamespace(), xSLParseString.getLocalName());
        if (xSLParseString.nextToken() != 26) {
            throw new XPathException(1013, "schema-element");
        }
        int n2 = 1;
        if (n == 1) {
            n2 = XPathSeqType.nextOccurIndicator(xSLParseString);
        }
        return null;
    }

    private static OXMLSequenceType parseSchemaAttrTest(XSLParseString xSLParseString) throws XPathException {
        QxName qxName = null;
        if (xSLParseString.nextToken() != 120) {
            throw new XPathException(1013, "schema-attribute");
        }
        qxName = new QxName(xSLParseString.getNamespace(), xSLParseString.getLocalName());
        if (xSLParseString.nextToken() != 26) {
            throw new XPathException(1013, "schema-attribute");
        }
        int n = XPathSeqType.nextOccurIndicator(xSLParseString);
        return null;
    }

    private static OXMLSequenceType parsePITest(XSLParseString xSLParseString) throws XPathException {
        String string = null;
        if (xSLParseString.peekToken(118)) {
            string = xSLParseString.getNCName();
        } else if (xSLParseString.peekToken(109)) {
            if (xSLParseString.getLiteralType() != 303) {
                throw new XPathException(1013, "processing-instruction");
            }
            string = xSLParseString.getLiteralValue();
        }
        if (xSLParseString.nextToken() != 26) {
            throw new XPathException(1013, "processing-instruction");
        }
        int n = XPathSeqType.nextOccurIndicator(xSLParseString);
        if (string == null) {
            return OXMLSequenceType.createNodeType(7, n);
        }
        return OXMLSequenceType.createNodeType(new QxName("", string), null, 7, false, n);
    }

    private static OXMLSequenceType parseCommentTest(XSLParseString xSLParseString) throws XPathException {
        if (xSLParseString.nextToken() != 26) {
            throw new XPathException(1013, "comment");
        }
        int n = XPathSeqType.nextOccurIndicator(xSLParseString);
        return OXMLSequenceType.createNodeType(8, n);
    }

    private static OXMLSequenceType parseTextTest(XSLParseString xSLParseString) throws XPathException {
        if (xSLParseString.nextToken() != 26) {
            throw new XPathException(1013, "text");
        }
        int n = XPathSeqType.nextOccurIndicator(xSLParseString);
        return OXMLSequenceType.createNodeType(3, n);
    }

    private static OXMLSequenceType parseAnyKindTest(XSLParseString xSLParseString) throws XPathException {
        if (xSLParseString.nextToken() != 26) {
            throw new XPathException(1013, "node");
        }
        int n = XPathSeqType.nextOccurIndicator(xSLParseString);
        return OXMLSequenceType.createNodeType(n);
    }

    private static int nextOccurIndicator(XSLParseString xSLParseString) throws XPathException {
        if (xSLParseString.peekToken(115)) {
            return XPathSeqType.mapOccurIndicator(xSLParseString.getOccurIndicator());
        }
        return 1;
    }

    private static int mapOccurIndicator(int n) {
        switch (n) {
            case 722: {
                return 2;
            }
            case 720: {
                return 4;
            }
            case 721: {
                return 3;
            }
        }
        return -1;
    }

    static String getNormalizedExpr(OXMLSequenceType oXMLSequenceType) throws XQException {
        return "";
    }
}

