/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import oracle.xml.parser.v2.XMLByteReader;
import oracle.xml.parser.v2.XMLConstants;

class XMLCharReader
extends XMLByteReader {
    Reader reader;
    boolean fixedCoords;
    XMLByteReader prevReader;
    boolean lastCharNewLine;
    static final int[] CP037ToUTF8 = new int[]{-1, -1, -1, -1, -1, 9, -1, -1, -1, -1, -1, -1, -1, 13, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 32, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 46, 60, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 45, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 95, 62, 63, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 58, -1, -1, 34, 61, 34, -1, 97, 98, 99, 100, 101, 102, 103, 104, 105, -1, -1, -1, -1, -1, -1, -1, 106, 107, 108, 109, 110, 111, 112, 113, 114, -1, -1, -1, -1, -1, -1, -1, -1, 115, 116, 117, 118, 119, 120, 121, 122, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 65, 66, 67, 68, 69, 70, 71, 72, 73, -1, -1, -1, -1, -1, -1, -1, 74, 75, 76, 77, 78, 79, 80, 81, 82, -1, -1, -1, -1, -1, -1, -1, -1, 83, 84, 85, 86, 87, 88, 89, 90, -1, -1, -1, -1, -1, -1, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, -1, -1, -1, -1, -1, -1};

    XMLCharReader(Reader reader, String string, String string2) {
        this.reader = reader;
        this.sysId = string;
        this.pubId = string2;
    }

    XMLCharReader(String string, String string2, String string3) {
        super(string.length());
        this.sysId = string2;
        this.pubId = string3;
        this.charPos = 0;
        this.eofPos = this.endPos = string.length();
        string.getChars(0, this.endPos, this.charBuffer, 0);
        this.fixedCoords = true;
    }

    void reset() {
        if (this.fixedCoords) {
            this.charPos = 0;
            this.eofPos = this.endPos;
        } else {
            super.reset();
        }
        this.lastCharNewLine = false;
    }

    void reset(String string) {
        this.reset();
        this.charPos = 0;
        this.eofPos = this.endPos = string.length();
        string.getChars(0, this.endPos, this.charBuffer, 0);
    }

    void setPrevReader(XMLByteReader xMLByteReader) {
        this.prevReader = xMLByteReader;
    }

    int getLineNumber() {
        if (this.fixedCoords) {
            return this.prevReader.getLineNumber();
        }
        return super.getLineNumber();
    }

    int getColumnNumber() {
        if (this.fixedCoords) {
            return this.prevReader.getColumnNumber();
        }
        return super.getColumnNumber();
    }

    void close() throws IOException {
        if (this.reader != null && this.closeInput) {
            this.reader.close();
        }
        super.close();
    }

    void fillByteBuffer() throws IOException {
    }

    void fillBuffer() throws IOException {
        if (this.fixedCoords) {
            return;
        }
        int n = 0;
        int n2 = this.BUFSIZE - this.endPos;
        int n3 = 0;
        while (n2 > 0 && n != -1) {
            char c;
            n = this.reader.read(this.charBuffer, this.endPos, n2);
            if (n == -1) continue;
            int n4 = this.endPos + n - 1;
            n3 = 0;
            int n5 = this.endPos;
            if (this.lastCharNewLine) {
                if (this.charBuffer[this.endPos] == '\n') {
                    ++n3;
                    ++n5;
                }
                this.lastCharNewLine = false;
            }
            if (n3 == 0) {
                while (n5 < n4) {
                    c = this.charBuffer[n5];
                    if (c == '\n' || c == '\r') {
                        this.setLineNumber(n5);
                        if (c == '\r' && this.charBuffer[n5 + 1] == '\n') {
                            this.charBuffer[n5] = 10;
                            ++n3;
                            n5 += 2;
                            break;
                        }
                        this.charBuffer[n5] = 10;
                    }
                    ++n5;
                }
            }
            while (n5 < n4) {
                c = this.charBuffer[n5];
                if (c == '\n' || c == '\r') {
                    this.setLineNumber(n5 - n3);
                    if (c == '\r' && this.charBuffer[n5 + 1] == '\n') {
                        this.charBuffer[n5 - n3] = 10;
                        ++n3;
                        ++n5;
                    } else {
                        this.charBuffer[n5 - n3] = 10;
                    }
                } else {
                    this.charBuffer[n5 - n3] = this.charBuffer[n5];
                }
                ++n5;
            }
            if (n5 == n4) {
                if (this.charBuffer[n5] == '\r') {
                    this.lastCharNewLine = true;
                    this.charBuffer[n5 - n3] = 10;
                } else {
                    this.charBuffer[n5 - n3] = this.charBuffer[n5];
                }
            }
            this.endPos += (n -= n3);
            n2 -= n;
        }
        if (n == -1) {
            this.setEOF(this.endPos);
        }
    }

    int fillXMLDecl(InputStream inputStream) throws IOException {
        this.in = inputStream;
        char[] cArray = XMLConstants.cPIEND;
        int n = 2;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n2 < n && (n3 = inputStream.read()) != -1) {
            n3 = CP037ToUTF8[n3];
            this.charBuffer[n4++] = (char)n3;
            if (n3 == cArray[n2]) {
                ++n2;
                continue;
            }
            n2 = 0;
        }
        if (n2 != n) {
            return -1;
        }
        System.arraycopy(this.charBuffer, 0, this.charBuffer, this.BUFSIZE - n4, n4);
        this.charPos = this.BUFSIZE - n4;
        this.endPos = this.BUFSIZE;
        return this.charPos;
    }

    void setEncoding(String string) throws IOException {
        this.reader = new InputStreamReader(this.in, string);
    }
}

