/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.schema;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDAny;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.schema.XSDException;
import oracle.xml.parser.schema.XSDNode;
import oracle.xml.parser.schema.XSDParticleNode;
import oracle.xml.util.FastVector;
import oracle.xml.util.QxName;
import oracle.xml.util.QxNameHash;

public class XSDGroup
extends XSDNode
implements XSDParticleNode {
    String refNamespace;
    String refLocalname;
    int refState;
    int order = 0;
    int minOccurs = 1;
    int maxOccurs = 1;
    ArrayList nodeVector;
    int[] offsets;
    int vectorSize = 0;
    int width;
    HashMap pathTable;
    FastVector elemList;
    byte[] viLevel;
    boolean optional = false;
    boolean topGroup = false;
    boolean allElement;

    XSDGroup() {
        this(5);
    }

    XSDGroup(int n, int n2, short s) {
        this(5);
        this.minOccurs = n;
        this.maxOccurs = n2;
        this.order = s;
    }

    XSDGroup(int n) {
        this.nodeType = n;
        if (this.nodeType == 6) {
            this.order = 2;
        }
        this.nodeVector = new ArrayList(10);
        this.refState = 0;
    }

    void setParticleNode(XSDParticleNode xSDParticleNode, int n) {
        this.nodeVector.set(n, xSDParticleNode);
    }

    void addParticleNode(XSDParticleNode xSDParticleNode) {
        this.nodeVector.add(xSDParticleNode);
        this.vectorSize = this.nodeVector.size();
        if (((XSDNode)((Object)xSDParticleNode)).parent == null) {
            ((XSDNode)((Object)xSDParticleNode)).parent = this;
        }
    }

    void setRef(String string, String string2) {
        this.refLocalname = string2;
        this.refNamespace = string;
        this.refState = 1;
    }

    public String getRefLocalname() {
        return this.refLocalname;
    }

    int minOccurs(int n) {
        if (n >= 0 && n < this.vectorSize) {
            return ((XSDParticleNode)this.nodeVector.get(n)).getMinOccurs();
        }
        return -1;
    }

    int maxOccurs(int n) {
        if (n >= 0 && n < this.vectorSize) {
            return ((XSDParticleNode)this.nodeVector.get(n)).getMaxOccurs();
        }
        return -1;
    }

    boolean isOptional(int n) {
        XSDParticleNode xSDParticleNode = (XSDParticleNode)this.nodeVector.get(n);
        if (xSDParticleNode instanceof XSDGroup) {
            return ((XSDGroup)xSDParticleNode).optional;
        }
        return xSDParticleNode.getMinOccurs() == 0;
    }

    public Vector getNodeVector() {
        return new Vector(this.nodeVector);
    }

    public int getMinOccurs() {
        return this.minOccurs;
    }

    public int getMaxOccurs() {
        return this.maxOccurs;
    }

    public void setMinOccurs(int n) {
        this.minOccurs = n;
    }

    public void setMaxOccurs(int n) {
        this.maxOccurs = n;
    }

    public int getOrder() {
        return this.order;
    }

    public boolean isTopGroup() {
        return this.topGroup;
    }

    public boolean isEmptiable() {
        if (this.minOccurs == 0) {
            return true;
        }
        if (this.order == 2 || this.order == 0) {
            for (int i = 0; i < this.vectorSize; ++i) {
                if (((XSDParticleNode)this.nodeVector.get(i)).isEmptiable()) continue;
                return false;
            }
            return true;
        }
        for (int i = 0; i < this.vectorSize; ++i) {
            if (!((XSDParticleNode)this.nodeVector.get(i)).isEmptiable()) continue;
            return true;
        }
        return false;
    }

    XSDElement[] getVisible() {
        if (!this.topGroup) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        XSDGroup xSDGroup = (XSDGroup)this.nodeVector.get(0);
        xSDGroup.getVisible(false, arrayList, -1);
        if (arrayList.size() > 0) {
            int n = arrayList.size();
            XSDElement[] xSDElementArray = new XSDElement[n];
            for (int i = 0; i < n; ++i) {
                xSDElementArray[i] = (XSDElement)arrayList.get(i);
            }
            return xSDElementArray;
        }
        return null;
    }

    XSDElement[] getVisible(boolean bl, String string, String string2) {
        if (!this.topGroup || this.pathTable == null) {
            return null;
        }
        QxName qxName = QxNameHash.create(string, string2, "", string2);
        int[] nArray = (int[])this.pathTable.get(qxName);
        if (nArray == null) {
            return null;
        }
        int n = nArray[0];
        ArrayList arrayList = new ArrayList();
        XSDGroup xSDGroup = (XSDGroup)this.nodeVector.get(0);
        xSDGroup.getVisible(bl, arrayList, n);
        if (arrayList.size() > 0) {
            int n2 = arrayList.size();
            XSDElement[] xSDElementArray = new XSDElement[n2];
            for (int i = 0; i < n2; ++i) {
                xSDElementArray[i] = (XSDElement)arrayList.get(i);
            }
            return xSDElementArray;
        }
        return null;
    }

    void addElement(ArrayList arrayList, XSDNode xSDNode) {
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!xSDNode.equals((XSDNode)arrayList.get(i))) continue;
            return;
        }
        arrayList.add(xSDNode);
    }

    boolean getVisible(boolean bl, ArrayList arrayList, int n) {
        int n2;
        int n3;
        XSDNode xSDNode;
        int n4 = this.getBranch(n);
        if (this.order == 2) {
            for (int i = 0; i < this.vectorSize; ++i) {
                XSDNode xSDNode2 = (XSDNode)this.nodeVector.get(i);
                if (!(xSDNode2 instanceof XSDElement)) continue;
                this.addElement(arrayList, xSDNode2);
            }
            return false;
        }
        if (this.order == 1) {
            boolean bl2 = false;
            if (n4 >= 0) {
                int n5;
                XSDNode xSDNode3 = (XSDNode)this.nodeVector.get(n4);
                return !(xSDNode3 instanceof XSDGroup) || (bl2 = ((XSDGroup)xSDNode3).getVisible(bl, arrayList, n - (n5 = this.getOffset(n4))));
            }
            for (int i = 0; i < this.vectorSize; ++i) {
                int n6 = this.getOffset(i);
                XSDNode xSDNode4 = (XSDNode)this.nodeVector.get(i);
                if (((XSDParticleNode)((Object)xSDNode4)).getMinOccurs() == 0) {
                    bl2 = true;
                }
                if (xSDNode4 instanceof XSDElement) {
                    this.addElement(arrayList, xSDNode4);
                    continue;
                }
                if (!(xSDNode4 instanceof XSDGroup) || !((XSDGroup)xSDNode4).getVisible(bl, arrayList, n - n6)) continue;
                bl2 = true;
            }
            return bl2;
        }
        boolean bl3 = true;
        if (n4 >= 0) {
            xSDNode = (XSDNode)this.nodeVector.get(n4);
            n3 = this.getOffset(n4);
            if (xSDNode instanceof XSDGroup && !(bl3 = ((XSDGroup)xSDNode).getVisible(bl, arrayList, n - n3))) {
                return false;
            }
        }
        if (bl) {
            int n7;
            int n8 = n7 = n4 >= 0 ? n4 - 1 : this.vectorSize - 1;
            while (n7 >= 0) {
                xSDNode = (XSDNode)this.nodeVector.get(n7);
                n3 = this.getOffset(n7);
                if (xSDNode instanceof XSDElement) {
                    bl3 = false;
                    this.addElement(arrayList, xSDNode);
                } else if (xSDNode instanceof XSDGroup) {
                    bl3 = ((XSDGroup)xSDNode).getVisible(bl, arrayList, n - n3);
                }
                if (((XSDParticleNode)((Object)xSDNode)).getMinOccurs() > 0 && !bl3) {
                    return false;
                }
                --n7;
            }
            return true;
        }
        int n9 = n2 = n4 >= 0 ? n4 + 1 : 0;
        while (n2 < this.vectorSize) {
            xSDNode = (XSDNode)this.nodeVector.get(n2);
            n3 = this.getOffset(n2);
            if (xSDNode instanceof XSDElement) {
                bl3 = false;
                this.addElement(arrayList, xSDNode);
            } else if (xSDNode instanceof XSDGroup) {
                bl3 = ((XSDGroup)xSDNode).getVisible(bl, arrayList, n - n3);
            }
            if (((XSDParticleNode)((Object)xSDNode)).getMinOccurs() > 0 && !bl3) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    void resolveReference(XMLSchema xMLSchema) throws XSDException {
        XSDGroup xSDGroup = (XSDGroup)xMLSchema.getComponent(this.refNamespace, this.refLocalname, this.nodeType);
        if (xSDGroup != null) {
            this.refState = 0;
            xSDGroup = (XSDGroup)xSDGroup.item(0);
            this.nodeVector = xSDGroup.nodeVector;
            this.vectorSize = xSDGroup.vectorSize;
            this.order = xSDGroup.order;
            this.annotation = xSDGroup.annotation;
        }
    }

    XSDParticleNode item(int n) {
        if (n >= 0 && n < this.vectorSize) {
            return (XSDParticleNode)this.nodeVector.get(n);
        }
        return null;
    }

    boolean buildPathTable(FastVector fastVector, byte[] byArray, int n) throws Exception {
        int n2;
        if (this.topGroup) {
            if (this.isClean || this.width == 0) {
                return false;
            }
            if (this.elemList == null) {
                this.elemList = new FastVector(this.width);
            } else {
                this.elemList.setSize(0);
            }
            this.viLevel = new byte[this.width];
            fastVector = this.elemList;
            byArray = this.viLevel;
            n = 0;
        } else {
            ++n;
        }
        if (this.maxOccurs == 0) {
            this.optional = true;
            return false;
        }
        int n3 = fastVector.size();
        this.isClean = true;
        int n4 = this.length();
        this.allElement = true;
        boolean bl = true;
        boolean bl2 = false;
        int n5 = -1;
        for (n2 = 0; n2 < n4; ++n2) {
            XSDNode xSDNode = (XSDNode)this.nodeVector.get(n2);
            if (!xSDNode.buildPathTable(fastVector, byArray, n)) {
                this.allElement = false;
            }
            if (this.isOptional(n2)) {
                bl2 = true;
            } else {
                bl = false;
            }
            if (this.order != 0 || this.isOptional(n2) || n5 >= 0) continue;
            n5 = fastVector.size();
        }
        if (n5 < 0) {
            n5 = fastVector.size();
        }
        for (n2 = n3; n2 < n5; ++n2) {
            if (byArray[n2] != n + 1) continue;
            byArray[n2] = (byte)n;
        }
        if (this.topGroup) {
            if (this.pathTable != null) {
                this.pathTable.clear();
            } else {
                this.pathTable = new HashMap((int)((double)this.width * 1.5));
            }
            n4 = fastVector.size();
            for (n2 = 0; n2 < n4; ++n2) {
                ((XSDNode)fastVector.elementAt(n2)).buildPaths(this.pathTable, n2);
            }
        }
        if (!this.allElement) {
            if (this.offsets == null || this.offsets.length <= n4) {
                this.offsets = new int[n4];
            }
            n2 = 0;
            n4 = this.length();
            for (int i = 0; i < n4; ++i) {
                this.offsets[i] = n2 += ((XSDNode)this.nodeVector.get(i)).getWidth();
            }
        }
        this.optional = false;
        this.optional = this.minOccurs == 0 || n4 == 0 ? true : (this.order == 1 ? bl2 : bl);
        return false;
    }

    int postProcess(FastVector fastVector, Hashtable hashtable, XMLSchema xMLSchema) throws Exception {
        if (this.topGroup) {
            if (!this.isClean) {
                return this.width;
            }
            hashtable.clear();
        } else if (hashtable.get(this) != null) {
            throw new XSDException(2210, this.getContainerName(), this.domNode);
        }
        hashtable.put(this, this);
        this.isClean = false;
        int n = this.length();
        this.width = 0;
        for (int i = 0; i < n; ++i) {
            int n2 = ((XSDNode)this.nodeVector.get(i)).postProcess(fastVector, hashtable, xMLSchema);
            this.width += n2;
        }
        hashtable.remove(this);
        if (this.maxOccurs == 0) {
            this.width = 0;
        }
        if (this.width == 0) {
            this.minOccurs = 0;
            this.maxOccurs = 0;
        }
        return this.width;
    }

    int getWidth() {
        return this.width;
    }

    int getBranch(int n) {
        if (n < 0 || n >= this.width) {
            return -1;
        }
        if (this.allElement) {
            return n;
        }
        for (int i = 0; i < this.vectorSize; ++i) {
            if (n >= this.offsets[i]) continue;
            return i;
        }
        return -1;
    }

    int getOffset(int n) {
        if (n == 0) {
            return 0;
        }
        if (this.allElement) {
            return n - 1;
        }
        return this.offsets[n - 1];
    }

    int length() {
        return this.nodeVector.size();
    }

    void print(int n) {
        boolean bl = false;
        if (this.refLocalname != null) {
            bl = true;
        }
        if (!bl && this.vectorSize == 0) {
            return;
        }
        this.printSTag(n);
        if (this.refLocalname != null) {
            System.out.print(XSDGroup.indent(n) + "ref = " + this.refNamespace);
            System.out.println(":" + this.refLocalname);
        }
        switch (this.order) {
            case 2: {
                System.out.println(XSDGroup.indent(n) + "order = " + "all");
                break;
            }
            case 0: {
                System.out.println(XSDGroup.indent(n) + "order = " + "sequence");
                break;
            }
            case 1: {
                System.out.println(XSDGroup.indent(n) + "order = " + "choice");
                break;
            }
        }
        System.out.println(XSDGroup.indent(n) + "minOccurs = " + this.minOccurs);
        System.out.println(XSDGroup.indent(n) + "maxOccurs = " + this.maxOccurs);
        this.printSTagEnd(n);
        if (!bl) {
            for (int i = 0; i < this.vectorSize; ++i) {
                ((XSDNode)this.nodeVector.get(i)).print(n + 3);
            }
        }
        this.printETag(n);
    }

    public boolean isSequential() {
        if (this.maxOccurs > 1 || this.order == 2) {
            return false;
        }
        for (int i = 0; i < this.vectorSize; ++i) {
            XSDParticleNode xSDParticleNode = (XSDParticleNode)this.nodeVector.get(i);
            if (!(xSDParticleNode instanceof XSDGroup ? !((XSDGroup)xSDParticleNode).isSequential() : xSDParticleNode instanceof XSDAny)) continue;
            return false;
        }
        return true;
    }
}

