/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.jdwp;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import oracle.xml.jdwp.Field;
import oracle.xml.jdwp.VariableTable;
import oracle.xml.jdwp.XSLJDWPCommandSet;
import oracle.xml.jdwp.XSLJDWPConstants;
import oracle.xml.jdwp.XSLJDWPException;
import oracle.xml.jdwp.XSLJDWPNode;
import oracle.xml.jdwp.XSLJDWPObjectReference;
import oracle.xml.jdwp.XSLJDWPPacket;
import oracle.xml.jdwp.XSLJDWPPacketStream;
import oracle.xml.jdwp.XSLJDWPPacketValue;
import oracle.xml.jdwp.XSLJDWPString;
import oracle.xml.jdwp.XSLJDWPUtil;
import oracle.xml.parser.v2.NSName;
import oracle.xml.util.FastVector;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xslt.XSLTContext;
import oracle.xml.xslt.XSLVariable;

public class XSLJDWPReferenceType
extends XSLJDWPCommandSet
implements XSLJDWPConstants {
    private Hashtable id2Name;
    XSLTContext context;

    XSLJDWPPacket execute(XSLJDWPPacket xSLJDWPPacket) {
        this.cmd = xSLJDWPPacket;
        this.cmdStrm = new XSLJDWPPacketStream(this.cmd);
        XSLJDWPPacket xSLJDWPPacket2 = null;
        switch (this.cmd.cmd) {
            case 1: {
                xSLJDWPPacket2 = this.signatureCmd();
                break;
            }
            case 2: {
                xSLJDWPPacket2 = this.classLoaderCmd();
                break;
            }
            case 4: {
                xSLJDWPPacket2 = this.fieldsCmd();
                break;
            }
            case 5: {
                xSLJDWPPacket2 = this.methodsCmd();
                break;
            }
            case 6: {
                xSLJDWPPacket2 = this.getValuesCmd();
                break;
            }
            case 7: {
                xSLJDWPPacket2 = this.sourceFileCmd();
                break;
            }
            case 9: {
                xSLJDWPPacket2 = this.statusCmd();
                break;
            }
            case 10: {
                xSLJDWPPacket2 = this.interfacesCmd();
                break;
            }
            default: {
                xSLJDWPPacket2 = this.cmd.createErrorReply((short)99);
            }
        }
        return xSLJDWPPacket2;
    }

    public void setXSLTContext(XSLTContext xSLTContext) {
        this.context = xSLTContext;
    }

    XSLJDWPPacket signatureCmd() {
        int n = this.cmdStrm.readReferenceType();
        XSLJDWPPacketStream xSLJDWPPacketStream = new XSLJDWPPacketStream(this.cmd.createReply());
        try {
            String string = this.signatureCmdData(n);
            xSLJDWPPacketStream.writeString(string);
        }
        catch (XSLJDWPException xSLJDWPException) {
            return this.cmd.createErrorReply(xSLJDWPException.errorCode());
        }
        xSLJDWPPacketStream.close();
        return xSLJDWPPacketStream.packet();
    }

    XSLJDWPPacket classLoaderCmd() {
        XSLJDWPPacketStream xSLJDWPPacketStream = new XSLJDWPPacketStream(this.cmd.createReply());
        xSLJDWPPacketStream.writeClassLoaderID(0);
        xSLJDWPPacketStream.close();
        return xSLJDWPPacketStream.packet();
    }

    XSLJDWPPacket fieldsCmd() {
        XSLJDWPPacketStream xSLJDWPPacketStream = new XSLJDWPPacketStream(this.cmd.createReply());
        try {
            int n = this.cmdStrm.readReferenceType();
            Field[] fieldArray = this.getFieldsCmdData(n);
            if (fieldArray == null) {
                xSLJDWPPacketStream.writeInt(0);
                xSLJDWPPacketStream.close();
                return xSLJDWPPacketStream.packet();
            }
            xSLJDWPPacketStream.writeInt(fieldArray.length);
            for (int i = 0; i < fieldArray.length; ++i) {
                xSLJDWPPacketStream.writeFieldID(fieldArray[i].getFieldID());
                xSLJDWPPacketStream.writeString(fieldArray[i].getName());
                xSLJDWPPacketStream.writeString(fieldArray[i].getSignature());
                xSLJDWPPacketStream.writeInt(fieldArray[i].getModBits());
            }
        }
        catch (XSLJDWPException xSLJDWPException) {
            return this.cmd.createErrorReply(xSLJDWPException.errorCode());
        }
        xSLJDWPPacketStream.close();
        return xSLJDWPPacketStream.packet();
    }

    Hashtable getFieldID2Name(int n) throws XSLJDWPException {
        this.getFieldsCmdData(n);
        return this.id2Name;
    }

    Field[] getFieldsCmdData(int n) throws XSLJDWPException {
        if (this.jdwpvm.xsl.getJDWPVirtualMachine().getRefType("XMLNode[]") == n || this.jdwpvm.xsl.getJDWPVirtualMachine().getRefType("char[]") == n) {
            return null;
        }
        if (this.jdwpvm.xsl.getJDWPVirtualMachine().getRefType("XMLNode") == n) {
            return XSLJDWPNode.getFields();
        }
        if (this.jdwpvm.xsl.getJDWPVirtualMachine().getRefType("XMLString") == n) {
            return XSLJDWPString.getFields();
        }
        FastVector fastVector = this.jdwpvm.xsl.getFields();
        int n2 = fastVector.size();
        Field[] fieldArray = new Field[n2];
        this.id2Name = new Hashtable(n2);
        for (int i = 0; i < n2; ++i) {
            block13: {
                fieldArray[i] = new Field();
                fieldArray[i].setFieldID(i + 1);
                XSLVariable xSLVariable = (XSLVariable)fastVector.elementAt(i);
                NSName nSName = xSLVariable.getName();
                String string = nSName.getExpandedName();
                fieldArray[i].setName(string);
                this.id2Name.put(new Integer(i + 1), string);
                if (this.context != null) {
                    try {
                        String string2 = XSLJDWPUtil.getTypeString(this.context.getVariable(nSName, -2));
                        if (string2.compareTo("string") == 0) {
                            fieldArray[i].setSignature("L$oracle/xml/xslt/XMLString;");
                            break block13;
                        }
                        if (string2.compareTo("boolean") == 0) {
                            fieldArray[i].setSignature("Z");
                            break block13;
                        }
                        if (string2.compareTo("number") == 0) {
                            fieldArray[i].setSignature("D");
                            break block13;
                        }
                        if (string2.compareTo("node-set") == 0) {
                            fieldArray[i].setSignature("[L$oracle/xml/xslt/XMLNode;");
                            break block13;
                        }
                        fieldArray[i].setSignature("L$oracle/xml/xslt/XMLNode;");
                    }
                    catch (NullPointerException nullPointerException) {
                        fieldArray[i].setSignature("L$oracle/xml/xslt/XMLString;");
                    }
                    catch (XQException xQException) {
                        fieldArray[i].setSignature("L$oracle/xml/xslt/XMLString;");
                    }
                } else {
                    fieldArray[i].setSignature("L$oracle/xml/xslt/XMLString;");
                }
            }
            fieldArray[i].setModBits(9);
        }
        return fieldArray;
    }

    XSLJDWPPacket methodsCmd() {
        int n = this.cmdStrm.readReferenceType();
        XSLJDWPPacketStream xSLJDWPPacketStream = new XSLJDWPPacketStream(this.cmd.createReply());
        if (this.jdwpvm.xsl.getJDWPVirtualMachine().getRefType("XMLNode") == n || this.jdwpvm.xsl.getJDWPVirtualMachine().getRefType("XMLNode[]") == n || this.jdwpvm.xsl.getJDWPVirtualMachine().getRefType("XMLString") == n || this.jdwpvm.xsl.getJDWPVirtualMachine().getRefType("char[]") == n) {
            xSLJDWPPacketStream.writeInt(0);
            xSLJDWPPacketStream.close();
            return xSLJDWPPacketStream.packet();
        }
        Hashtable[] hashtableArray = this.jdwpvm.xsl.getClassID2methodID();
        if (n > hashtableArray.length) {
            return this.cmd.createErrorReply((short)21);
        }
        Hashtable hashtable = hashtableArray[n - 1];
        int n2 = 0;
        if (hashtable == null) {
            xSLJDWPPacketStream.writeInt(n2);
            xSLJDWPPacketStream.close();
            return xSLJDWPPacketStream.packet();
        }
        n2 = hashtable.size();
        xSLJDWPPacketStream.writeInt(n2);
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            VariableTable variableTable;
            Integer n3 = (Integer)enumeration.nextElement();
            String string = (String)hashtable.get(n3);
            string = XSLJDWPUtil.convertMethodName(string);
            int n4 = n3;
            xSLJDWPPacketStream.writeMethodID(n4);
            try {
                xSLJDWPPacketStream.writeString(string);
            }
            catch (XSLJDWPException xSLJDWPException) {
                return this.cmd.createErrorReply(xSLJDWPException.errorCode());
            }
            StringBuffer stringBuffer = new StringBuffer("(");
            Hashtable hashtable2 = this.jdwpvm.xsl.getClassMethodParams();
            long l = ((long)n << 32) + (long)n4;
            Long l2 = new Long(l);
            Integer n5 = (Integer)hashtable2.get(l2);
            int n6 = 4;
            if (n5 != null) {
                n6 += n5.intValue();
            }
            if ((variableTable = this.jdwpvm.xsl.getJDWPMethod().getVariableTable(n, n4)) != null) {
                String[] stringArray = variableTable.getSignature();
                for (int i = 0; i < n6; ++i) {
                    stringBuffer.append(stringArray[i]);
                }
            }
            stringBuffer.append(")V");
            try {
                xSLJDWPPacketStream.writeString(stringBuffer.toString());
            }
            catch (XSLJDWPException xSLJDWPException) {
                return this.cmd.createErrorReply(xSLJDWPException.errorCode());
            }
            xSLJDWPPacketStream.writeInt(10);
        }
        xSLJDWPPacketStream.close();
        return xSLJDWPPacketStream.packet();
    }

    XSLJDWPPacket getValuesCmd() {
        int n = this.cmdStrm.readReferenceType();
        int n2 = this.cmdStrm.readInt();
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = this.cmdStrm.readFieldID();
        }
        XSLJDWPPacketValue[] xSLJDWPPacketValueArray = null;
        XSLJDWPPacketStream xSLJDWPPacketStream = new XSLJDWPPacketStream(this.cmd.createReply());
        try {
            xSLJDWPPacketValueArray = this.generateValuesData(n, n2, nArray);
            int n3 = xSLJDWPPacketValueArray.length;
            xSLJDWPPacketStream.writeInt(n3);
            if (n3 == 0) {
                xSLJDWPPacketStream.close();
                return xSLJDWPPacketStream.packet();
            }
            XSLJDWPObjectReference xSLJDWPObjectReference = this.jdwpvm.xsl.getJDWPObjectReference();
            xSLJDWPObjectReference.generateIDs(xSLJDWPPacketValueArray);
            for (int i = 0; i < n3; ++i) {
                xSLJDWPPacketStream.writeValue(xSLJDWPPacketValueArray[i]);
            }
        }
        catch (XSLJDWPException xSLJDWPException) {
            return this.cmd.createErrorReply(xSLJDWPException.errorCode());
        }
        xSLJDWPPacketStream.close();
        return xSLJDWPPacketStream.packet();
    }

    XSLJDWPPacketValue[] generateValuesData(int n, int n2, int[] nArray) throws XSLJDWPException {
        if (this.context == null) {
            XSLJDWPPacketValue[] xSLJDWPPacketValueArray = new XSLJDWPPacketValue[n2];
            for (int i = 0; i < n2; ++i) {
                xSLJDWPPacketValueArray[i] = new XSLJDWPPacketValue(76, new Integer(0));
            }
            return xSLJDWPPacketValueArray;
        }
        int n3 = n2;
        XSLJDWPPacketValue[] xSLJDWPPacketValueArray = new XSLJDWPPacketValue[n3];
        Hashtable hashtable = this.context.getGlobalVariables();
        Hashtable hashtable2 = this.getFieldID2Name(n);
        for (int i = 0; i < n3; ++i) {
            XSLJDWPPacketValue xSLJDWPPacketValue;
            int n4 = nArray[i];
            String string = (String)hashtable2.get(new Integer(n4));
            OXMLSequence oXMLSequence = (OXMLSequence)hashtable.get(string);
            xSLJDWPPacketValueArray[i] = xSLJDWPPacketValue = XSLJDWPUtil.convertXPathSequence2PacketValue(oXMLSequence);
        }
        return xSLJDWPPacketValueArray;
    }

    XSLJDWPPacket sourceFileCmd() {
        int n = this.cmdStrm.readReferenceType();
        XSLJDWPPacketStream xSLJDWPPacketStream = new XSLJDWPPacketStream(this.cmd.createReply());
        try {
            String string = this.getSourceFileCmdData(n);
            if (string == null) {
                throw new XSLJDWPException(101);
            }
            xSLJDWPPacketStream.writeString(string);
        }
        catch (XSLJDWPException xSLJDWPException) {
            return this.cmd.createErrorReply(xSLJDWPException.errorCode());
        }
        xSLJDWPPacketStream.close();
        return xSLJDWPPacketStream.packet();
    }

    XSLJDWPPacket statusCmd() {
        XSLJDWPPacketStream xSLJDWPPacketStream = new XSLJDWPPacketStream(this.cmd.createReply());
        xSLJDWPPacketStream.writeInt(this.jdwpvm.xsl.getClassStatus());
        xSLJDWPPacketStream.close();
        return xSLJDWPPacketStream.packet();
    }

    private String signatureCmdData(int n) {
        if (n >> 24 == 0) {
            int n2 = this.jdwpvm.xsl.getJDWPVirtualMachine().getRefType("XMLNode");
            if (n == n2) {
                return "L$oracle/xml/xslt/XMLNode;";
            }
            n2 = this.jdwpvm.xsl.getJDWPVirtualMachine().getRefType("XMLNode[]");
            if (n == n2) {
                return "[L$oracle/xml/xslt/XMLNode;";
            }
            n2 = this.jdwpvm.xsl.getJDWPVirtualMachine().getRefType("XMLString");
            if (n == n2) {
                return "L$oracle/xml/xslt/XMLString;";
            }
            this.jdwpvm.xsl.getJDWPVirtualMachine().getRefType("char[]");
            if (n == n2) {
                return "[C";
            }
            return "L$oracle/xml/xslt/Object;";
        }
        if (n >> 24 == 3) {
            return "[L$oracle/xml/xslt/XMLNode;";
        }
        if (n >> 24 == 2) {
            return "L$oracle/xml/xslt/XMLString;";
        }
        return "L$oracle/xml/xslt/Object;";
    }

    private int getStatusCmdData(int n) {
        return this.jdwpvm.xsl.getClassStatus();
    }

    private String getSourceFileCmdData(int n) {
        int n2 = this.jdwpvm.xsl.getJDWPVirtualMachine().getRefType("XMLNode");
        int n3 = this.jdwpvm.xsl.getJDWPVirtualMachine().getRefType("XMLNode[]");
        int n4 = this.jdwpvm.xsl.getJDWPVirtualMachine().getRefType("XMLString");
        int n5 = this.jdwpvm.xsl.getJDWPVirtualMachine().getRefType("char[]");
        if (n2 == n || n4 == n || n3 == n || n5 == n) {
            return null;
        }
        Hashtable hashtable = this.jdwpvm.xsl.getJDWPVirtualMachine().getAllClassesByID();
        String string = (String)hashtable.get(new Integer(n));
        File file = new File(string);
        return file.getName();
    }

    XSLJDWPPacket interfacesCmd() {
        int n = this.cmdStrm.readReferenceType();
        XSLJDWPPacketStream xSLJDWPPacketStream = new XSLJDWPPacketStream(this.cmd.createReply());
        xSLJDWPPacketStream.writeInt(0);
        xSLJDWPPacketStream.close();
        return xSLJDWPPacketStream.packet();
    }
}

