/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.Representation;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.sql.DATE;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPTZ;
import oracle.sql.TIMEZONETAB;
import oracle.sql.ZONEIDMAP;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
abstract class DateTimeCommonAccessor
extends Accessor {
    static final int GREGORIAN_CUTOVER_YEAR = 1582;
    static final long GREGORIAN_CUTOVER = -12219292800000L;
    static final int JAN_1_1_JULIAN_DAY = 1721426;
    static final int EPOCH_JULIAN_DAY = 2440588;
    static final int ONE_SECOND = 1000;
    static final int ONE_MINUTE = 60000;
    static final int ONE_HOUR = 3600000;
    static final long ONE_DAY = 86400000L;
    static final int[] NUM_DAYS;
    static final int[] LEAP_NUM_DAYS;
    static final int ORACLE_CENTURY = 0;
    static final int ORACLE_YEAR = 1;
    static final int ORACLE_MONTH = 2;
    static final int ORACLE_DAY = 3;
    static final int ORACLE_HOUR = 4;
    static final int ORACLE_MIN = 5;
    static final int ORACLE_SEC = 6;
    static final int ORACLE_NANO1 = 7;
    static final int ORACLE_NANO2 = 8;
    static final int ORACLE_NANO3 = 9;
    static final int ORACLE_NANO4 = 10;
    static final int ORACLE_TZ1 = 11;
    static final int ORACLE_TZ2 = 12;
    static final int SIZE_DATE = 7;
    static int OFFSET_HOUR;
    static int OFFSET_MINUTE;
    static byte REGIONIDBIT;
    static final int MAX_TIMESTAMP_LENGTH = 11;
    protected final byte[] tmpBytes;
    static TimeZone epochTimeZone;
    static long epochTimeZoneOffset;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;

    static int setHighOrderbits(int n2) {
        return (n2 & 0x1FC0) >> 6;
    }

    static int setLowOrderbits(int n2) {
        return (n2 & 0x3F) << 2;
    }

    static int getHighOrderbits(int n2) {
        return (n2 & 0x7F) << 6;
    }

    static int getLowOrderbits(int n2) {
        return (n2 & 0xFC) >> 2;
    }

    DateTimeCommonAccessor(Representation representation, OracleStatement oracleStatement, int n2, boolean bl) {
        super(representation, oracleStatement, n2, bl);
        this.tmpBytes = new byte[this.representationMaxLength];
    }

    @Override
    Date getDate(int n2) throws SQLException {
        return this.getDate(n2, null);
    }

    @Override
    Date getDate(int n2, Calendar calendar) throws SQLException {
        if (this.isNull(n2)) {
            return null;
        }
        Calendar calendar2 = calendar == null ? this.statement.getDefaultCalendar() : (Calendar)calendar.clone();
        this.getBytesInternal(n2, this.tmpBytes);
        int n3 = this.oracleYear(this.tmpBytes);
        calendar2.clear();
        calendar2.set(1, n3);
        calendar2.set(2, this.oracleMonth(this.tmpBytes));
        calendar2.set(5, this.oracleDay(this.tmpBytes));
        if (OracleDriver.getSystemPropertyDateZeroTime()) {
            calendar2.set(11, 0);
            calendar2.set(12, 0);
            calendar2.set(13, 0);
        } else {
            calendar2.set(11, this.oracleHour(this.tmpBytes));
            calendar2.set(12, this.oracleMin(this.tmpBytes));
            calendar2.set(13, this.oracleSec(this.tmpBytes));
        }
        calendar2.set(14, 0);
        if (n3 > 0 && calendar2.isSet(0)) {
            calendar2.set(0, 1);
        }
        Date date = new Date(calendar2.getTimeInMillis());
        return date;
    }

    @Override
    LocalDate getLocalDate(int n2) throws SQLException {
        if (this.isNull(n2)) {
            return null;
        }
        for (int i2 = 0; i2 < this.tmpBytes.length; ++i2) {
            this.tmpBytes[i2] = 0;
        }
        this.getBytesInternal(n2, this.tmpBytes);
        return LocalDate.of(this.oracleYear(this.tmpBytes), this.oracleMonth(this.tmpBytes) + 1, this.oracleDay(this.tmpBytes));
    }

    @Override
    LocalDateTime getLocalDateTime(int n2) throws SQLException {
        if (this.isNull(n2)) {
            return null;
        }
        for (int i2 = 0; i2 < this.tmpBytes.length; ++i2) {
            this.tmpBytes[i2] = 0;
        }
        this.getBytesInternal(n2, this.tmpBytes);
        return LocalDateTime.of(this.oracleYear(this.tmpBytes), this.oracleMonth(this.tmpBytes) + 1, this.oracleDay(this.tmpBytes), this.oracleHour(this.tmpBytes), this.oracleMin(this.tmpBytes), this.oracleSec(this.tmpBytes), this.tmpBytes.length > 7 ? this.oracleNanos(this.tmpBytes) : 0);
    }

    @Override
    LocalTime getLocalTime(int n2) throws SQLException {
        if (this.isNull(n2)) {
            return null;
        }
        for (int i2 = 0; i2 < this.tmpBytes.length; ++i2) {
            this.tmpBytes[i2] = 0;
        }
        this.getBytesInternal(n2, this.tmpBytes);
        return LocalTime.of(this.oracleHour(this.tmpBytes), this.oracleMin(this.tmpBytes), this.oracleSec(this.tmpBytes), this.tmpBytes.length > 7 ? this.oracleNanos(this.tmpBytes) : 0);
    }

    @Override
    OffsetDateTime getOffsetDateTime(int n2) throws SQLException {
        if (this.isNull(n2)) {
            return null;
        }
        for (int i2 = 0; i2 < this.tmpBytes.length; ++i2) {
            this.tmpBytes[i2] = 0;
        }
        this.getBytesInternal(n2, this.tmpBytes);
        LocalDateTime localDateTime = LocalDateTime.of(this.oracleYear(this.tmpBytes), this.oracleMonth(this.tmpBytes) + 1, this.oracleDay(this.tmpBytes), this.oracleHour(this.tmpBytes), this.oracleMin(this.tmpBytes), this.oracleSec(this.tmpBytes), this.tmpBytes.length > 7 ? this.oracleNanos(this.tmpBytes) : 0);
        OffsetDateTime offsetDateTime = OffsetDateTime.of(localDateTime, ZoneOffset.UTC);
        if (this.tmpBytes.length > 11) {
            ZoneOffset zoneOffset;
            if ((this.oracleTZ1(this.tmpBytes) & REGIONIDBIT) != 0) {
                int n3 = 0;
                n3 = DateTimeCommonAccessor.getHighOrderbits(this.oracleTZ1(this.tmpBytes));
                long l2 = offsetDateTime.toInstant().toEpochMilli();
                TIMEZONETAB tIMEZONETAB = this.statement.connection.getTIMEZONETAB();
                if (tIMEZONETAB.checkID(n3 += DateTimeCommonAccessor.getLowOrderbits(this.oracleTZ2(this.tmpBytes)))) {
                    tIMEZONETAB.updateTable(this.statement.connection, n3);
                }
                int n4 = tIMEZONETAB.getOffset(l2, n3);
                zoneOffset = ZoneOffset.ofTotalSeconds(n4 / 1000);
            } else {
                int n5 = this.oracleTZ1(this.tmpBytes) - OFFSET_HOUR;
                int n6 = Math.abs(this.oracleTZ2(this.tmpBytes) - OFFSET_MINUTE);
                zoneOffset = ZoneOffset.ofHoursMinutes(n5, (int)Math.signum(n5) * n6);
            }
            return offsetDateTime.withOffsetSameInstant(zoneOffset);
        }
        return offsetDateTime;
    }

    @Override
    OffsetTime getOffsetTime(int n2) throws SQLException {
        if (this.isNull(n2)) {
            return null;
        }
        for (int i2 = 0; i2 < this.tmpBytes.length; ++i2) {
            this.tmpBytes[i2] = 0;
        }
        this.getBytesInternal(n2, this.tmpBytes);
        LocalTime localTime = LocalTime.of(this.oracleHour(this.tmpBytes), this.oracleMin(this.tmpBytes), this.oracleSec(this.tmpBytes), this.tmpBytes.length > 7 ? this.oracleNanos(this.tmpBytes) : 0);
        OffsetTime offsetTime = OffsetTime.of(localTime, ZoneOffset.UTC);
        if (this.tmpBytes.length > 11) {
            ZoneOffset zoneOffset;
            if ((this.oracleTZ1(this.tmpBytes) & REGIONIDBIT) != 0) {
                int n3 = 0;
                n3 = DateTimeCommonAccessor.getHighOrderbits(this.oracleTZ1(this.tmpBytes));
                long l2 = offsetTime.atDate(LocalDate.now()).toInstant().toEpochMilli();
                TIMEZONETAB tIMEZONETAB = this.statement.connection.getTIMEZONETAB();
                if (tIMEZONETAB.checkID(n3 += DateTimeCommonAccessor.getLowOrderbits(this.oracleTZ2(this.tmpBytes)))) {
                    tIMEZONETAB.updateTable(this.statement.connection, n3);
                }
                int n4 = tIMEZONETAB.getOffset(l2, n3);
                zoneOffset = ZoneOffset.ofTotalSeconds(n4 / 1000);
            } else {
                int n5 = this.oracleTZ1(this.tmpBytes) - OFFSET_HOUR;
                int n6 = Math.abs(this.oracleTZ2(this.tmpBytes) - OFFSET_MINUTE);
                zoneOffset = ZoneOffset.ofHoursMinutes(n5, (int)Math.signum(n5) * n6);
            }
            return offsetTime.withOffsetSameInstant(zoneOffset);
        }
        return offsetTime;
    }

    @Override
    ZonedDateTime getZonedDateTime(int n2) throws SQLException {
        ZoneId zoneId;
        if (this.isNull(n2)) {
            return null;
        }
        for (int i2 = 0; i2 < this.tmpBytes.length; ++i2) {
            this.tmpBytes[i2] = 0;
        }
        this.getBytesInternal(n2, this.tmpBytes);
        LocalDateTime localDateTime = LocalDateTime.of(this.oracleYear(this.tmpBytes), this.oracleMonth(this.tmpBytes) + 1, this.oracleDay(this.tmpBytes), this.oracleHour(this.tmpBytes), this.oracleMin(this.tmpBytes), this.oracleSec(this.tmpBytes), this.tmpBytes.length > 7 ? this.oracleNanos(this.tmpBytes) : 0);
        OffsetDateTime offsetDateTime = OffsetDateTime.of(localDateTime, ZoneOffset.UTC);
        if (this.tmpBytes.length <= 11) {
            zoneId = offsetDateTime.getOffset();
        } else if ((this.oracleTZ1(this.tmpBytes) & REGIONIDBIT) != 0) {
            int n3 = DateTimeCommonAccessor.getHighOrderbits(this.oracleTZ1(this.tmpBytes)) + DateTimeCommonAccessor.getLowOrderbits(this.oracleTZ2(this.tmpBytes));
            try {
                zoneId = ZoneId.of(ZONEIDMAP.getRegion(n3));
            }
            catch (DateTimeException dateTimeException) {
                long l2 = offsetDateTime.toInstant().toEpochMilli();
                TIMEZONETAB tIMEZONETAB = this.statement.connection.getTIMEZONETAB();
                if (tIMEZONETAB.checkID(n3)) {
                    tIMEZONETAB.updateTable(this.statement.connection, n3);
                }
                int n4 = tIMEZONETAB.getOffset(l2, n3);
                zoneId = ZoneOffset.ofTotalSeconds(n4 / 1000);
            }
        } else {
            int n5 = this.oracleTZ1(this.tmpBytes) - OFFSET_HOUR;
            int n6 = Math.abs(this.oracleTZ2(this.tmpBytes) - OFFSET_MINUTE);
            zoneId = ZoneOffset.ofHoursMinutes(n5, (int)Math.signum(n5) * n6);
        }
        return offsetDateTime.atZoneSameInstant(zoneId);
    }

    @Override
    Time getTime(int n2) throws SQLException {
        Time time = null;
        if (this.isNull(n2)) {
            return null;
        }
        TimeZone timeZone = this.statement.getDefaultTimeZone();
        if (timeZone != epochTimeZone) {
            epochTimeZoneOffset = DateTimeCommonAccessor.calculateEpochOffset(timeZone);
            epochTimeZone = timeZone;
        }
        this.getBytesInternal(n2, this.tmpBytes);
        time = new Time((long)this.oracleTime(this.tmpBytes) - epochTimeZoneOffset);
        return time;
    }

    @Override
    Time getTime(int n2, Calendar calendar) throws SQLException {
        if (this.isNull(n2)) {
            return null;
        }
        if (calendar == null) {
            return this.getTime(n2);
        }
        this.getBytesInternal(n2, this.tmpBytes);
        int n3 = this.oracleYear(this.tmpBytes);
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.clear();
        calendar2.set(1, 1970);
        calendar2.set(2, 0);
        calendar2.set(5, 1);
        calendar2.set(11, this.oracleHour(this.tmpBytes));
        calendar2.set(12, this.oracleMin(this.tmpBytes));
        calendar2.set(13, this.oracleSec(this.tmpBytes));
        calendar2.set(14, 0);
        if (n3 > 0 && calendar2.isSet(0)) {
            calendar2.set(0, 1);
        }
        return new Time(calendar2.getTimeInMillis());
    }

    @Override
    Timestamp getTimestamp(int n2) throws SQLException {
        return this.getTimestamp(n2, null);
    }

    @Override
    Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        if (this.isNull(n2)) {
            return null;
        }
        Calendar calendar2 = calendar == null ? this.statement.getDefaultCalendar() : (Calendar)calendar.clone();
        this.getBytesInternal(n2, this.tmpBytes);
        int n3 = this.oracleYear(this.tmpBytes);
        calendar2.clear();
        calendar2.set(1, n3);
        calendar2.set(2, this.oracleMonth(this.tmpBytes));
        calendar2.set(5, this.oracleDay(this.tmpBytes));
        calendar2.set(11, this.oracleHour(this.tmpBytes));
        calendar2.set(12, this.oracleMin(this.tmpBytes));
        calendar2.set(13, this.oracleSec(this.tmpBytes));
        calendar2.set(14, 0);
        if (n3 > 0 && calendar2.isSet(0)) {
            calendar2.set(0, 1);
        }
        Timestamp timestamp = new Timestamp(calendar2.getTimeInMillis());
        if (this.getLength(n2) >= 11) {
            timestamp.setNanos(this.oracleNanos(this.tmpBytes));
        }
        return timestamp;
    }

    @Override
    DATE getDATE(int n2) throws SQLException {
        if (this.isNull(n2)) {
            return null;
        }
        byte[] byArray = new byte[7];
        this.rowData.get(this.getOffset(n2), byArray, 0, 7);
        return new DATE(byArray);
    }

    @Override
    TIMESTAMP getTIMESTAMP(int n2) throws SQLException {
        if (this.isNull(n2)) {
            return null;
        }
        return new TIMESTAMP(this.getBytesInternal(n2));
    }

    @Override
    java.util.Date getJavaUtilDate(int n2) throws SQLException {
        if (this.isNull(n2)) {
            return null;
        }
        this.getBytesInternal(n2, this.tmpBytes);
        int n3 = this.oracleYear(this.tmpBytes);
        Calendar calendar = this.statement.getDefaultCalendar();
        calendar.set(1, n3);
        calendar.set(2, this.oracleMonth(this.tmpBytes));
        calendar.set(5, this.oracleDay(this.tmpBytes));
        calendar.set(11, this.oracleHour(this.tmpBytes));
        calendar.set(12, this.oracleMin(this.tmpBytes));
        calendar.set(13, this.oracleSec(this.tmpBytes));
        calendar.set(14, 0);
        if (n3 > 0 && calendar.isSet(0)) {
            calendar.set(0, 1);
        }
        java.util.Date date = calendar.getTime();
        return date;
    }

    @Override
    Calendar getCalendar(int n2) throws SQLException {
        if (this.isNull(n2)) {
            return null;
        }
        this.getBytesInternal(n2, this.tmpBytes);
        int n3 = this.oracleYear(this.tmpBytes);
        Calendar calendar = (Calendar)this.statement.getDefaultCalendar().clone();
        calendar.clear();
        calendar.set(1, n3);
        calendar.set(2, this.oracleMonth(this.tmpBytes));
        calendar.set(5, this.oracleDay(this.tmpBytes));
        calendar.set(11, this.oracleHour(this.tmpBytes));
        calendar.set(12, this.oracleMin(this.tmpBytes));
        calendar.set(13, this.oracleSec(this.tmpBytes));
        if (this.getLength(n2) >= 11) {
            calendar.set(14, this.oracleNanos(this.tmpBytes) / 1000000);
        } else {
            calendar.set(14, 0);
        }
        if (n3 > 0 && calendar.isSet(0)) {
            calendar.set(0, 1);
        }
        return calendar;
    }

    final int oracleYear(byte[] byArray) {
        int n2 = ((byArray[0] & 0xFF) - 100) * 100 + (byArray[1] & 0xFF) - 100;
        return n2 < 0 ? n2 + 1 : n2;
    }

    final int oracleMonth(byte[] byArray) {
        return byArray[2] - 1;
    }

    final int oracleDay(byte[] byArray) {
        return byArray[3];
    }

    final int oracleHour(byte[] byArray) {
        return byArray[4] - 1;
    }

    final int oracleMin(byte[] byArray) {
        return byArray[5] - 1;
    }

    final int oracleSec(byte[] byArray) {
        return byArray[6] - 1;
    }

    final int oracleTZ1(byte[] byArray) {
        return byArray[11];
    }

    final int oracleTZ2(byte[] byArray) {
        return byArray[12];
    }

    final int oracleTime(byte[] byArray) {
        int n2 = this.oracleHour(byArray);
        n2 *= 60;
        n2 += this.oracleMin(byArray);
        n2 *= 60;
        n2 += this.oracleSec(byArray);
        return n2 *= 1000;
    }

    final int oracleNanos(byte[] byArray) {
        int n2 = (byArray[7] & 0xFF) << 24;
        n2 |= (byArray[8] & 0xFF) << 16;
        n2 |= (byArray[9] & 0xFF) << 8;
        return n2 |= byArray[10] & 0xFF & 0xFF;
    }

    static final long computeJulianDay(boolean bl, int n2, int n3, int n4) {
        boolean bl2 = n2 % 4 == 0;
        int n5 = n2 - 1;
        long l2 = 365L * (long)n5 + DateTimeCommonAccessor.floorDivide(n5, 4L) + 1721423L;
        if (bl) {
            bl2 = bl2 && (n2 % 100 != 0 || n2 % 400 == 0);
            l2 += DateTimeCommonAccessor.floorDivide(n5, 400L) - DateTimeCommonAccessor.floorDivide(n5, 100L) + 2L;
        }
        return l2 + (long)n4 + (long)(bl2 ? LEAP_NUM_DAYS[n3] : NUM_DAYS[n3]);
    }

    static final long floorDivide(long l2, long l3) {
        return l2 >= 0L ? l2 / l3 : (l2 + 1L) / l3 - 1L;
    }

    static final long julianDayToMillis(long l2) {
        return (l2 - 2440588L) * 86400000L;
    }

    static final long zoneOffset(TimeZone timeZone, int n2, int n3, int n4, int n5, int n6) {
        return timeZone.getOffset(n2 < 0 ? 0 : 1, n2, n3, n4, n5, n6);
    }

    static long getMillis(int n2, int n3, int n4, int n5, TimeZone timeZone) {
        long l2;
        long l3;
        boolean bl = n2 >= 1582;
        if (bl != (l3 = ((l2 = DateTimeCommonAccessor.computeJulianDay(bl, n2, n3, n4)) - 2440588L) * 86400000L) >= -12219292800000L) {
            l2 = DateTimeCommonAccessor.computeJulianDay(!bl, n2, n3, n4);
            l3 = (l2 - 2440588L) * 86400000L;
        }
        return (l3 += (long)n5) - DateTimeCommonAccessor.zoneOffset(timeZone, n2, n3, n4, DateTimeCommonAccessor.julianDayToDayOfWeek(l2), n5);
    }

    static final int julianDayToDayOfWeek(long l2) {
        int n2;
        return n2 + ((n2 = (int)((l2 + 1L) % 7L)) < 0 ? 8 : 1);
    }

    static long calculateEpochOffset(TimeZone timeZone) {
        return DateTimeCommonAccessor.zoneOffset(timeZone, 1970, 0, 1, 5, 0);
    }

    String toText(int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl, String string) throws SQLException {
        return oracle.sql.TIMESTAMPTZ.toString(n2, n3, n4, n5, n6, n7, n8, string);
    }

    static {
        try {
            $$$methodRef$$$38 = DateTimeCommonAccessor.class.getDeclaredConstructor(Representation.class, OracleStatement.class, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$37 = DateTimeCommonAccessor.class.getDeclaredMethod("toText", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$36 = DateTimeCommonAccessor.class.getDeclaredMethod("calculateEpochOffset", TimeZone.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$35 = DateTimeCommonAccessor.class.getDeclaredMethod("julianDayToDayOfWeek", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$34 = DateTimeCommonAccessor.class.getDeclaredMethod("getMillis", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, TimeZone.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$33 = DateTimeCommonAccessor.class.getDeclaredMethod("zoneOffset", TimeZone.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$32 = DateTimeCommonAccessor.class.getDeclaredMethod("julianDayToMillis", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$31 = DateTimeCommonAccessor.class.getDeclaredMethod("floorDivide", Long.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = DateTimeCommonAccessor.class.getDeclaredMethod("computeJulianDay", Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = DateTimeCommonAccessor.class.getDeclaredMethod("oracleNanos", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = DateTimeCommonAccessor.class.getDeclaredMethod("oracleTime", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = DateTimeCommonAccessor.class.getDeclaredMethod("oracleTZ2", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = DateTimeCommonAccessor.class.getDeclaredMethod("oracleTZ1", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = DateTimeCommonAccessor.class.getDeclaredMethod("oracleSec", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = DateTimeCommonAccessor.class.getDeclaredMethod("oracleMin", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = DateTimeCommonAccessor.class.getDeclaredMethod("oracleHour", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = DateTimeCommonAccessor.class.getDeclaredMethod("oracleDay", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = DateTimeCommonAccessor.class.getDeclaredMethod("oracleMonth", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = DateTimeCommonAccessor.class.getDeclaredMethod("oracleYear", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = DateTimeCommonAccessor.class.getDeclaredMethod("getCalendar", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = DateTimeCommonAccessor.class.getDeclaredMethod("getJavaUtilDate", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = DateTimeCommonAccessor.class.getDeclaredMethod("getTIMESTAMP", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = DateTimeCommonAccessor.class.getDeclaredMethod("getDATE", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = DateTimeCommonAccessor.class.getDeclaredMethod("getTimestamp", Integer.TYPE, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = DateTimeCommonAccessor.class.getDeclaredMethod("getTimestamp", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = DateTimeCommonAccessor.class.getDeclaredMethod("getTime", Integer.TYPE, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = DateTimeCommonAccessor.class.getDeclaredMethod("getTime", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = DateTimeCommonAccessor.class.getDeclaredMethod("getZonedDateTime", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = DateTimeCommonAccessor.class.getDeclaredMethod("getOffsetTime", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = DateTimeCommonAccessor.class.getDeclaredMethod("getOffsetDateTime", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = DateTimeCommonAccessor.class.getDeclaredMethod("getLocalTime", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = DateTimeCommonAccessor.class.getDeclaredMethod("getLocalDateTime", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = DateTimeCommonAccessor.class.getDeclaredMethod("getLocalDate", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = DateTimeCommonAccessor.class.getDeclaredMethod("getDate", Integer.TYPE, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = DateTimeCommonAccessor.class.getDeclaredMethod("getDate", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = DateTimeCommonAccessor.class.getDeclaredMethod("getLowOrderbits", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = DateTimeCommonAccessor.class.getDeclaredMethod("getHighOrderbits", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = DateTimeCommonAccessor.class.getDeclaredMethod("setLowOrderbits", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = DateTimeCommonAccessor.class.getDeclaredMethod("setHighOrderbits", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        NUM_DAYS = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};
        LEAP_NUM_DAYS = new int[]{0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335};
        OFFSET_HOUR = 20;
        OFFSET_MINUTE = 60;
        REGIONIDBIT = (byte)-128;
    }
}

