/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLevel;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Logging;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.OBJECT_TYPES})
@DefaultLevel(value=Logging.FINEST)
public class Util {
    private static int[] ldsRoundTable;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;

    static void checkNextByte(InputStream inputStream, byte by) throws SQLException {
        try {
            if (inputStream.read() != by) {
                throw (SQLException)DatabaseError.createSqlException(47, "parseTDS").fillInStackTrace();
            }
        }
        catch (IOException iOException) {
            throw (SQLException)DatabaseError.createSqlException(iOException).fillInStackTrace();
        }
    }

    public static int[] toJavaUnsignedBytes(byte[] byArray) {
        int[] nArray = new int[byArray.length];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            nArray[i2] = byArray[i2] & 0xFF;
        }
        return nArray;
    }

    static byte[] readBytes(InputStream inputStream, int n2) throws SQLException {
        byte[] byArray = new byte[n2];
        try {
            int n3 = inputStream.read(byArray);
            if (n3 != n2) {
                byte[] byArray2 = new byte[n3];
                System.arraycopy(byArray, 0, byArray2, 0, n3);
                return byArray2;
            }
        }
        catch (IOException iOException) {
            throw (SQLException)DatabaseError.createSqlException(iOException).fillInStackTrace();
        }
        return byArray;
    }

    static void writeBytes(OutputStream outputStream, byte[] byArray) throws SQLException {
        try {
            outputStream.write(byArray);
        }
        catch (IOException iOException) {
            throw (SQLException)DatabaseError.createSqlException(iOException).fillInStackTrace();
        }
    }

    static void skipBytes(InputStream inputStream, int n2) throws SQLException {
        try {
            inputStream.skip(n2);
        }
        catch (IOException iOException) {
            throw (SQLException)DatabaseError.createSqlException(iOException).fillInStackTrace();
        }
    }

    static long readLong(InputStream inputStream) throws SQLException {
        byte[] byArray = new byte[4];
        try {
            inputStream.read(byArray);
            return (((byArray[0] & 0xFF) * 256 + (byArray[1] & 0xFF)) * 256 + (byArray[2] & 0xFF)) * 256 + (byArray[3] & 0xFF);
        }
        catch (IOException iOException) {
            throw (SQLException)DatabaseError.createSqlException(iOException).fillInStackTrace();
        }
    }

    static short readShort(InputStream inputStream) throws SQLException {
        byte[] byArray = new byte[2];
        try {
            inputStream.read(byArray);
            return (short)((byArray[0] & 0xFF) * 256 + (byArray[1] & 0xFF));
        }
        catch (IOException iOException) {
            throw (SQLException)DatabaseError.createSqlException(iOException).fillInStackTrace();
        }
    }

    static byte readByte(InputStream inputStream) throws SQLException {
        try {
            return (byte)inputStream.read();
        }
        catch (IOException iOException) {
            throw (SQLException)DatabaseError.createSqlException(iOException).fillInStackTrace();
        }
    }

    static byte fdoGetSize(byte[] byArray, int n2) {
        byte by = Util.fdoGetEntry(byArray, n2);
        return (byte)(by >> 3 & 0x1F);
    }

    static byte fdoGetAlign(byte[] byArray, int n2) {
        byte by = Util.fdoGetEntry(byArray, n2);
        return (byte)(by & 7);
    }

    static int ldsRound(int n2, int n3) {
        int n4 = ldsRoundTable[n3];
        return (n2 >> n4) + 1 << n4;
    }

    private static byte fdoGetEntry(byte[] byArray, int n2) {
        short s2 = Util.getUnsignedByte(byArray[5]);
        byte by = byArray[6 + s2 + n2];
        return by;
    }

    public static short getUnsignedByte(byte by) {
        return (short)(by & 0xFF);
    }

    public static byte[] serializeObject(Object object) throws IOException {
        if (object == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(object);
        objectOutputStream.flush();
        return byteArrayOutputStream.toByteArray();
    }

    public static Object deserializeObject(byte[] byArray) throws IOException, ClassNotFoundException {
        if (byArray == null) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        return new ObjectInputStream(byteArrayInputStream).readObject();
    }

    public static void printByteArray(byte[] byArray) {
        System.out.println("DONT CALL THIS -- oracle.jdbc.oracore.Util.printByteArray");
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    static {
        try {
            $$$methodRef$$$17 = Util.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = Util.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = Util.class.getDeclaredMethod("printByteArray", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = Util.class.getDeclaredMethod("deserializeObject", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = Util.class.getDeclaredMethod("serializeObject", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = Util.class.getDeclaredMethod("getUnsignedByte", Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = Util.class.getDeclaredMethod("fdoGetEntry", byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = Util.class.getDeclaredMethod("ldsRound", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = Util.class.getDeclaredMethod("fdoGetAlign", byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = Util.class.getDeclaredMethod("fdoGetSize", byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = Util.class.getDeclaredMethod("readByte", InputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = Util.class.getDeclaredMethod("readShort", InputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = Util.class.getDeclaredMethod("readLong", InputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = Util.class.getDeclaredMethod("skipBytes", InputStream.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = Util.class.getDeclaredMethod("writeBytes", OutputStream.class, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = Util.class.getDeclaredMethod("readBytes", InputStream.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = Util.class.getDeclaredMethod("toJavaUnsignedBytes", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = Util.class.getDeclaredMethod("checkNextByte", InputStream.class, Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        ldsRoundTable = new int[]{0, 1, 0, 2, 0, 0, 0, 3, 0};
    }
}

