/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.util.Map;
import java.util.logging.Logger;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.ACProxyable;
import oracle.jdbc.internal.OracleConcreteProxy;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.proxy.ProxyFactory;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.Methods;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyAccess;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.ProxyResult;
import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.proxy.annotation.Signature;
import oracle.jdbc.replay.driver.JDBCReplayable;
import oracle.jdbc.replay.driver.TxnFailoverManagerImpl;
import oracle.jdbc.replay.driver.TxnReplayableBase;
import oracle.sql.BFILE;

@ProxyFor(value={oracle.jdbc.internal.OracleResultSet.class})
@ProxyAccess(value=ACProxyable.class)
@DefaultLogger(value="oracle.jdbc.internal.replay")
@Supports(value={Feature.APPLICATION_CONTINUITY})
public abstract class TxnReplayableResultSet
extends TxnReplayableBase
implements JDBCReplayable {
    private static final Method GETCLOB_METHOD;
    private static final Method GETCLOB_WITH_NAME_METHOD;
    private static final Method GETNCLOB_METHOD;
    private static final Method GETNCLOB_WITH_NAME_METHOD;
    private static final Method GETBLOB_METHOD;
    private static final Method GETBLOB_WITH_NAME_METHOD;
    private static final Method GETBFILE_METHOD;
    private static final Method GETBFILE_WITH_NAME_METHOD;
    private static final Method GETOBJECT_METHOD;
    private static final Method GETOBJECT_WITH_TYPE_METHOD;
    private static final Method GETOBJECT_WITH_MAP_METHOD;
    private static final Method GETOBJECT_WITH_NAME_METHOD;
    private static final Method GETOBJECT_WITH_NAME_AND_TYPE_METHOD;
    private static final Method GETOBJECT_WITH_NAME_AND_MAP_METHOD;
    private static final Method GETREF_METHOD;
    private static final Method GETREF_WITH_NAME_METHOD;
    private static final Method GETARRAY_METHOD;
    private static final Method GETARRAY_WITH_NAME_METHOD;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;

    protected TxnReplayableResultSet() {
        this.thisProxyNameInLog = "RSET" + this.thisProxyNameInLog;
    }

    @Override
    @Pre
    protected void preForAll(Method method, Object object, Object ... objectArray) {
        super.preForAll(method, object, objectArray);
    }

    @Pre
    @Methods(signatures={@Signature(name="getAsciiStream", args={int.class}), @Signature(name="getBinaryStream", args={int.class}), @Signature(name="getCharacterStream", args={int.class}), @Signature(name="getNCharacterStream", args={int.class})})
    protected void preForGetStreams(Method method, Object object, Object ... objectArray) {
        try {
            int n2;
            ResultSetMetaData resultSetMetaData = ((ResultSet)this.getDelegate()).getMetaData();
            if (resultSetMetaData != null && ((n2 = resultSetMetaData.getColumnType((Integer)objectArray[0])) == 2004 || n2 == 2005 || n2 == -13 || n2 == 2016)) {
                this.failoverMngr.setLobStreamInRequest(true);
                this.failoverMngr.disableReplayInternal(method, 372, "Replay disabled because of nonreplayable call", null);
            }
        }
        catch (Throwable throwable) {
        }
        this.preForAll(method, object, objectArray);
    }

    @Pre
    @Methods(signatures={@Signature(name="getAsciiStream", args={String.class}), @Signature(name="getBinaryStream", args={String.class}), @Signature(name="getCharacterStream", args={String.class}), @Signature(name="getNCharacterStream", args={String.class})})
    protected void preForGetStreamsByColumnName(Method method, Object object, Object ... objectArray) {
        try {
            int n2;
            ResultSet resultSet = (ResultSet)this.getDelegate();
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            if (resultSetMetaData != null && ((n2 = resultSetMetaData.getColumnType(resultSet.findColumn((String)objectArray[0]))) == 2004 || n2 == 2005 || n2 == -13 || n2 == 2016)) {
                this.failoverMngr.setLobStreamInRequest(true);
                this.failoverMngr.disableReplayInternal(method, 372, "Replay disabled because of nonreplayable call", null);
            }
        }
        catch (Throwable throwable) {
        }
        this.preForAll(method, object, objectArray);
    }

    @Pre
    @Methods(signatures={@Signature(name="getOPAQUE", args={int.class}), @Signature(name="getOPAQUE", args={String.class})})
    protected void preForMethodWithConcreteClass(Method method, Object object, Object ... objectArray) {
        block1: {
            TxnFailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
            if (replayLifecycle != TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
                return;
            }
            if (this.failoverMngr == null) break block1;
            this.failoverMngr.disableReplayInternal(method, 397, "Replay disabled because of concrete class usage", null);
        }
    }

    @Pre
    @Methods(signatures={@Signature(name="updateAsciiStream", args={String.class, InputStream.class}), @Signature(name="updateAsciiStream", args={String.class, InputStream.class, int.class}), @Signature(name="updateAsciiStream", args={String.class, InputStream.class, long.class}), @Signature(name="updateBinaryStream", args={String.class, InputStream.class}), @Signature(name="updateBinaryStream", args={String.class, InputStream.class, int.class}), @Signature(name="updateBinaryStream", args={String.class, InputStream.class, long.class}), @Signature(name="updateCharacterStream", args={String.class, Reader.class}), @Signature(name="updateCharacterStream", args={String.class, Reader.class, int.class}), @Signature(name="updateCharacterStream", args={String.class, Reader.class, long.class}), @Signature(name="updateNCharacterStream", args={String.class, Reader.class}), @Signature(name="updateNCharacterStream", args={String.class, Reader.class, long.class}), @Signature(name="updateAsciiStream", args={int.class, InputStream.class}), @Signature(name="updateAsciiStream", args={int.class, InputStream.class, int.class}), @Signature(name="updateAsciiStream", args={int.class, InputStream.class, long.class}), @Signature(name="updateBinaryStream", args={int.class, InputStream.class}), @Signature(name="updateBinaryStream", args={int.class, InputStream.class, int.class}), @Signature(name="updateBinaryStream", args={int.class, InputStream.class, long.class}), @Signature(name="updateCharacterStream", args={int.class, Reader.class}), @Signature(name="updateCharacterStream", args={int.class, Reader.class, int.class}), @Signature(name="updateCharacterStream", args={int.class, Reader.class, long.class}), @Signature(name="updateNCharacterStream", args={int.class, Reader.class}), @Signature(name="updateNCharacterStream", args={int.class, Reader.class, long.class})})
    protected void preForUpdateStreams(Method method, Object object, Object ... objectArray) {
        block1: {
            TxnFailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
            if (replayLifecycle != TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
                return;
            }
            if (this.failoverMngr == null) break block1;
            this.failoverMngr.disableReplayInternal(method, 371, "Replay disabled because of active transaction", null);
        }
    }

    @Override
    @Post
    protected void postForAll(Method method) {
        this.postForAll(method, null);
    }

    @Override
    @Post
    protected Object postForAll(Method method, Object object) {
        return super.postForAll(method, object);
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Clob getClob(int n2) throws SQLException {
        if (GETCLOB_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getClob(int)");
        }
        Method method = GETCLOB_METHOD;
        this.preForAll(method, this, n2);
        try {
            ResultSet resultSet = (ResultSet)this.getDelegate();
            Clob clob = resultSet.getClob(n2);
            return (Clob)this.postForAll(method, clob);
        }
        catch (SQLException sQLException) {
            return (Clob)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Clob getClob(String string) throws SQLException {
        if (GETCLOB_WITH_NAME_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getClob(String)");
        }
        Method method = GETCLOB_WITH_NAME_METHOD;
        this.preForAll(method, this, string);
        try {
            ResultSet resultSet = (ResultSet)this.getDelegate();
            Clob clob = resultSet.getClob(string);
            return (Clob)this.postForAll(method, clob);
        }
        catch (SQLException sQLException) {
            return (Clob)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public NClob getNClob(int n2) throws SQLException {
        if (GETNCLOB_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getNClob(int)");
        }
        Method method = GETNCLOB_METHOD;
        this.preForAll(method, this, n2);
        try {
            ResultSet resultSet = (ResultSet)this.getDelegate();
            NClob nClob = resultSet.getNClob(n2);
            return (NClob)this.postForAll(method, nClob);
        }
        catch (SQLException sQLException) {
            return (NClob)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public NClob getNClob(String string) throws SQLException {
        if (GETNCLOB_WITH_NAME_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getNClob(String)");
        }
        Method method = GETNCLOB_WITH_NAME_METHOD;
        this.preForAll(method, this, string);
        try {
            ResultSet resultSet = (ResultSet)this.getDelegate();
            NClob nClob = resultSet.getNClob(string);
            return (NClob)this.postForAll(method, nClob);
        }
        catch (SQLException sQLException) {
            return (NClob)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Blob getBlob(int n2) throws SQLException {
        if (GETBLOB_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getBlob(int)");
        }
        Method method = GETBLOB_METHOD;
        this.preForAll(method, this, n2);
        try {
            ResultSet resultSet = (ResultSet)this.getDelegate();
            Blob blob = resultSet.getBlob(n2);
            return (Blob)this.postForAll(method, blob);
        }
        catch (SQLException sQLException) {
            return (Blob)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Blob getBlob(String string) throws SQLException {
        if (GETBLOB_WITH_NAME_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getBlob(String)");
        }
        Method method = GETBLOB_WITH_NAME_METHOD;
        this.preForAll(method, this, string);
        try {
            ResultSet resultSet = (ResultSet)this.getDelegate();
            Blob blob = resultSet.getBlob(string);
            return (Blob)this.postForAll(method, blob);
        }
        catch (SQLException sQLException) {
            return (Blob)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public BFILE getBfile(int n2) throws SQLException {
        if (GETBFILE_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getBfile(int)");
        }
        Method method = GETBFILE_METHOD;
        this.preForAll(method, this, n2);
        try {
            OracleResultSet oracleResultSet = (OracleResultSet)this.getDelegate();
            BFILE bFILE = oracleResultSet.getBfile(n2);
            return (BFILE)this.postForAll(method, bFILE);
        }
        catch (SQLException sQLException) {
            return (BFILE)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public BFILE getBfile(String string) throws SQLException {
        if (GETBFILE_WITH_NAME_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getBfile(String)");
        }
        Method method = GETBFILE_WITH_NAME_METHOD;
        this.preForAll(method, this, string);
        try {
            OracleResultSet oracleResultSet = (OracleResultSet)this.getDelegate();
            BFILE bFILE = oracleResultSet.getBfile(string);
            return (BFILE)this.postForAll(method, bFILE);
        }
        catch (SQLException sQLException) {
            return (BFILE)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Object getObject(int n2) throws SQLException {
        if (GETOBJECT_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getObject(int)");
        }
        Method method = GETOBJECT_METHOD;
        this.preForAll(method, this, n2);
        try {
            ProxyFactory proxyFactory;
            ResultSet resultSet = (ResultSet)this.getDelegate();
            Object object = resultSet.getObject(n2);
            if (!(object instanceof OracleConcreteProxy) && (proxyFactory = this.failoverMngr.getProxyFactory()) != null) {
                return this.postForAll(method, proxyFactory.proxyFor(object));
            }
            return this.postForAll(method, object);
        }
        catch (SQLException sQLException) {
            return this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public <T> T getObject(int n2, Class<T> clazz) throws SQLException {
        if (GETOBJECT_WITH_TYPE_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getObject(int,Class<T>)");
        }
        Method method = GETOBJECT_WITH_TYPE_METHOD;
        this.preForAll(method, this, n2, clazz);
        try {
            ProxyFactory proxyFactory;
            ResultSet resultSet = (ResultSet)this.getDelegate();
            T t2 = resultSet.getObject(n2, clazz);
            if (!(t2 instanceof OracleConcreteProxy) && (proxyFactory = this.failoverMngr.getProxyFactory()) != null) {
                return (T)this.postForAll(method, proxyFactory.proxyFor(t2));
            }
            return (T)this.postForAll(method, t2);
        }
        catch (SQLException sQLException) {
            return (T)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Object getObject(int n2, Map<String, Class<?>> map) throws SQLException {
        if (GETOBJECT_WITH_MAP_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getObject(int, Map)");
        }
        Method method = GETOBJECT_WITH_MAP_METHOD;
        this.preForAll(method, this, n2, map);
        try {
            ProxyFactory proxyFactory;
            ResultSet resultSet = (ResultSet)this.getDelegate();
            Object object = resultSet.getObject(n2, map);
            if (!(object instanceof OracleConcreteProxy) && (proxyFactory = this.failoverMngr.getProxyFactory()) != null) {
                return this.postForAll(method, proxyFactory.proxyFor(object));
            }
            return this.postForAll(method, object);
        }
        catch (SQLException sQLException) {
            return this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Object getObject(String string) throws SQLException {
        if (GETOBJECT_WITH_NAME_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getObject(String)");
        }
        Method method = GETOBJECT_WITH_NAME_METHOD;
        this.preForAll(method, this, string);
        try {
            ProxyFactory proxyFactory;
            ResultSet resultSet = (ResultSet)this.getDelegate();
            Object object = resultSet.getObject(string);
            if (!(object instanceof OracleConcreteProxy) && (proxyFactory = this.failoverMngr.getProxyFactory()) != null) {
                return this.postForAll(method, proxyFactory.proxyFor(object));
            }
            return this.postForAll(method, object);
        }
        catch (SQLException sQLException) {
            return this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public <T> T getObject(String string, Class<T> clazz) throws SQLException {
        if (GETOBJECT_WITH_NAME_AND_TYPE_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getObject(String,Class<T>)");
        }
        Method method = GETOBJECT_WITH_NAME_AND_TYPE_METHOD;
        this.preForAll(method, this, string, clazz);
        try {
            ProxyFactory proxyFactory;
            ResultSet resultSet = (ResultSet)this.getDelegate();
            T t2 = resultSet.getObject(string, clazz);
            if (!(t2 instanceof OracleConcreteProxy) && (proxyFactory = this.failoverMngr.getProxyFactory()) != null) {
                return (T)this.postForAll(method, proxyFactory.proxyFor(t2));
            }
            return (T)this.postForAll(method, t2);
        }
        catch (SQLException sQLException) {
            return (T)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Object getObject(String string, Map<String, Class<?>> map) throws SQLException {
        if (GETOBJECT_WITH_NAME_AND_MAP_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getObject(String, Map)");
        }
        Method method = GETOBJECT_WITH_NAME_AND_MAP_METHOD;
        this.preForAll(method, this, string, map);
        try {
            ProxyFactory proxyFactory;
            ResultSet resultSet = (ResultSet)this.getDelegate();
            Object object = resultSet.getObject(string, map);
            if (!(object instanceof OracleConcreteProxy) && (proxyFactory = this.failoverMngr.getProxyFactory()) != null) {
                return this.postForAll(method, proxyFactory.proxyFor(object));
            }
            return this.postForAll(method, object);
        }
        catch (SQLException sQLException) {
            return this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Ref getRef(int n2) throws SQLException {
        if (GETREF_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getRef(int)");
        }
        Method method = GETREF_METHOD;
        this.preForAll(method, this, n2);
        try {
            ResultSet resultSet = (ResultSet)this.getDelegate();
            Ref ref = resultSet.getRef(n2);
            return (Ref)this.postForAll(method, ref);
        }
        catch (SQLException sQLException) {
            return (Ref)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Ref getRef(String string) throws SQLException {
        if (GETREF_WITH_NAME_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getRef(String)");
        }
        Method method = GETREF_WITH_NAME_METHOD;
        this.preForAll(method, this, string);
        try {
            ResultSet resultSet = (ResultSet)this.getDelegate();
            Ref ref = resultSet.getRef(string);
            return (Ref)this.postForAll(method, ref);
        }
        catch (SQLException sQLException) {
            return (Ref)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Array getArray(int n2) throws SQLException {
        if (GETARRAY_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getArray(int)");
        }
        Method method = GETARRAY_METHOD;
        this.preForAll(method, this, n2);
        try {
            ResultSet resultSet = (ResultSet)this.getDelegate();
            Array array = resultSet.getArray(n2);
            return (Array)this.postForAll(method, array);
        }
        catch (SQLException sQLException) {
            return (Array)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Array getArray(String string) throws SQLException {
        if (GETARRAY_WITH_NAME_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getArray(String)");
        }
        Method method = GETARRAY_WITH_NAME_METHOD;
        this.preForAll(method, this, string);
        try {
            ResultSet resultSet = (ResultSet)this.getDelegate();
            Array array = resultSet.getArray(string);
            return (Array)this.postForAll(method, array);
        }
        catch (SQLException sQLException) {
            return (Array)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    private static final Method getGetLobMethod(String string, Class<?> clazz) {
        try {
            return oracle.jdbc.internal.OracleResultSet.class.getMethod(string, clazz);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final Method getMethod(String string, Class<?> ... classArray) {
        try {
            return oracle.jdbc.internal.OracleResultSet.class.getMethod(string, classArray);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Post
    @Methods(signatures={@Signature(name="close", args={})})
    protected void postForClose(Method method) {
        this.postForAll(method);
        TxnFailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
        if (replayLifecycle == TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            this.isLogicallyClosed = true;
        }
    }

    @Override
    @OnError(value=SQLException.class)
    protected void onErrorVoidForAll(Method method, SQLException sQLException) throws SQLException {
        this.onErrorForAll(method, sQLException);
    }

    @Override
    @OnError(value=SQLException.class)
    protected Object onErrorForAll(Method method, SQLException sQLException) throws SQLException {
        return super.onErrorForAll(method, sQLException);
    }

    @OnError(value=SQLException.class)
    @Methods(signatures={@Signature(name="last", args={})})
    protected boolean onErrorForLast(Method method, SQLException sQLException) throws SQLException {
        if (this.isClosedAndNoReplay) {
            throw sQLException;
        }
        TxnFailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
        if (sQLException instanceof SQLRecoverableException && replayLifecycle == TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            this.failoverMngr.disableReplayInternal(method, 372, "Replay disabled because of nonreplayable call", null);
        }
        return (Boolean)super.onErrorForAll(method, sQLException);
    }

    @Override
    @GetDelegate
    protected abstract Object getDelegate();

    @Override
    @SetDelegate
    protected abstract void setDelegate(Object var1);

    @Override
    @GetCreator
    protected abstract Object getCreator();

    @Override
    public Object replayOneCall(TxnFailoverManagerImpl.CallHistoryEntry callHistoryEntry, SQLRecoverableException sQLRecoverableException) throws SQLException {
        Object object = super.replayOneCall(callHistoryEntry, sQLRecoverableException);
        return object;
    }

    static {
        try {
            $$$methodRef$$$32 = TxnReplayableResultSet.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$31 = TxnReplayableResultSet.class.getDeclaredMethod("replayOneCall", TxnFailoverManagerImpl.CallHistoryEntry.class, SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$30 = TxnReplayableResultSet.class.getDeclaredMethod("onErrorForLast", Method.class, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$29 = TxnReplayableResultSet.class.getDeclaredMethod("onErrorForAll", Method.class, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$28 = TxnReplayableResultSet.class.getDeclaredMethod("onErrorVoidForAll", Method.class, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$27 = TxnReplayableResultSet.class.getDeclaredMethod("postForClose", Method.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$26 = TxnReplayableResultSet.class.getDeclaredMethod("getMethod", String.class, Class[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$25 = TxnReplayableResultSet.class.getDeclaredMethod("getGetLobMethod", String.class, Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$24 = TxnReplayableResultSet.class.getDeclaredMethod("getArray", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$23 = TxnReplayableResultSet.class.getDeclaredMethod("getArray", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$22 = TxnReplayableResultSet.class.getDeclaredMethod("getRef", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$21 = TxnReplayableResultSet.class.getDeclaredMethod("getRef", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$20 = TxnReplayableResultSet.class.getDeclaredMethod("getObject", String.class, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$19 = TxnReplayableResultSet.class.getDeclaredMethod("getObject", String.class, Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$18 = TxnReplayableResultSet.class.getDeclaredMethod("getObject", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$17 = TxnReplayableResultSet.class.getDeclaredMethod("getObject", Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$16 = TxnReplayableResultSet.class.getDeclaredMethod("getObject", Integer.TYPE, Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$15 = TxnReplayableResultSet.class.getDeclaredMethod("getObject", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$14 = TxnReplayableResultSet.class.getDeclaredMethod("getBfile", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$13 = TxnReplayableResultSet.class.getDeclaredMethod("getBfile", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$12 = TxnReplayableResultSet.class.getDeclaredMethod("getBlob", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$11 = TxnReplayableResultSet.class.getDeclaredMethod("getBlob", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$10 = TxnReplayableResultSet.class.getDeclaredMethod("getNClob", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$9 = TxnReplayableResultSet.class.getDeclaredMethod("getNClob", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$8 = TxnReplayableResultSet.class.getDeclaredMethod("getClob", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$7 = TxnReplayableResultSet.class.getDeclaredMethod("getClob", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$6 = TxnReplayableResultSet.class.getDeclaredMethod("postForAll", Method.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$5 = TxnReplayableResultSet.class.getDeclaredMethod("postForAll", Method.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$4 = TxnReplayableResultSet.class.getDeclaredMethod("preForUpdateStreams", Method.class, Object.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$3 = TxnReplayableResultSet.class.getDeclaredMethod("preForMethodWithConcreteClass", Method.class, Object.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$2 = TxnReplayableResultSet.class.getDeclaredMethod("preForGetStreamsByColumnName", Method.class, Object.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$1 = TxnReplayableResultSet.class.getDeclaredMethod("preForGetStreams", Method.class, Object.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$0 = TxnReplayableResultSet.class.getDeclaredMethod("preForAll", Method.class, Object.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        GETCLOB_METHOD = TxnReplayableResultSet.getGetLobMethod("getClob", Integer.TYPE);
        GETCLOB_WITH_NAME_METHOD = TxnReplayableResultSet.getGetLobMethod("getClob", String.class);
        GETNCLOB_METHOD = TxnReplayableResultSet.getGetLobMethod("getNClob", Integer.TYPE);
        GETNCLOB_WITH_NAME_METHOD = TxnReplayableResultSet.getGetLobMethod("getNClob", String.class);
        GETBLOB_METHOD = TxnReplayableResultSet.getGetLobMethod("getBlob", Integer.TYPE);
        GETBLOB_WITH_NAME_METHOD = TxnReplayableResultSet.getGetLobMethod("getBlob", String.class);
        GETBFILE_METHOD = TxnReplayableResultSet.getGetLobMethod("getBfile", Integer.TYPE);
        GETBFILE_WITH_NAME_METHOD = TxnReplayableResultSet.getGetLobMethod("getBfile", String.class);
        GETOBJECT_METHOD = TxnReplayableResultSet.getMethod("getObject", Integer.TYPE);
        GETOBJECT_WITH_TYPE_METHOD = TxnReplayableResultSet.getMethod("getObject", Integer.TYPE, Class.class);
        GETOBJECT_WITH_MAP_METHOD = TxnReplayableResultSet.getMethod("getObject", Integer.TYPE, Map.class);
        GETOBJECT_WITH_NAME_METHOD = TxnReplayableResultSet.getMethod("getObject", String.class);
        GETOBJECT_WITH_NAME_AND_TYPE_METHOD = TxnReplayableResultSet.getMethod("getObject", String.class, Class.class);
        GETOBJECT_WITH_NAME_AND_MAP_METHOD = TxnReplayableResultSet.getMethod("getObject", String.class, Map.class);
        GETREF_METHOD = TxnReplayableResultSet.getMethod("getRef", Integer.TYPE);
        GETREF_WITH_NAME_METHOD = TxnReplayableResultSet.getMethod("getRef", String.class);
        GETARRAY_METHOD = TxnReplayableResultSet.getMethod("getArray", Integer.TYPE);
        GETARRAY_WITH_NAME_METHOD = TxnReplayableResultSet.getMethod("getArray", String.class);
    }
}

