/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import oracle.dms.instrument.NounIntf;
import oracle.net.ns.NetException;
import oracle.net.nt.ConnOption;
import oracle.net.nt.ConnectDescription;
import oracle.net.nt.DownHostsCache;
import oracle.net.nt.TimeoutInterruptHandler;
import oracle.net.resolver.EnvVariableResolver;
import oracle.net.resolver.TimeUnitSuffixUtility;

public class ConnStrategy {
    static final boolean DEBUG = false;
    private boolean optFound = false;
    public boolean reuseOpt = false;
    private ConnOption copt;
    public int sdu;
    public int tdu;
    public int nextOptToTry = 0;
    public Properties socketOptions = new Properties();
    private String osuser;
    private String programName;
    public int retryCount = 0;
    private int lastRetryCounter = 0;
    private int lastRetryConnectDescription = 0;
    private final Properties userProp;
    private ConnectDescription currentDescription;
    private ArrayList<ConnectDescription> descriptionList = new ArrayList(4);
    private final SSLContext sslContext;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;

    public ConnStrategy(Properties properties) {
        this(properties, null);
    }

    public ConnStrategy(Properties properties, SSLContext sSLContext) {
        this.osuser = properties.getProperty("oracle.jdbc.v$session.osuser");
        this.programName = properties.getProperty("oracle.jdbc.v$session.program");
        DownHostsCache.DOWN_HOSTS_TIMEOUT = Integer.parseInt(properties.getProperty("oracle.net.DOWN_HOSTS_TIMEOUT"));
        this.userProp = properties;
        this.createSocketOptions(properties);
        this.sslContext = sSLContext;
    }

    public String getOSUsername() {
        return this.osuser;
    }

    public String getProgramName() {
        return this.programName;
    }

    public void createSocketOptions(Properties properties) {
        String string = null;
        String string2 = null;
        boolean bl = false;
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (string.equalsIgnoreCase("TCP.NODELAY")) {
                bl = true;
                string2 = properties.getProperty("TCP.NODELAY").toUpperCase();
                if (string2.equals("NO")) {
                    this.socketOptions.put((Object)0, "NO");
                    continue;
                }
                this.socketOptions.put((Object)0, "YES");
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.READ_TIMEOUT")) {
                string2 = properties.getProperty("oracle.net.READ_TIMEOUT");
                this.socketOptions.put((Object)3, string2);
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.CONNECT_TIMEOUT")) {
                string2 = properties.getProperty("oracle.net.CONNECT_TIMEOUT");
                this.socketOptions.put((Object)2, String.valueOf(TimeUnitSuffixUtility.getTimeInMilliseconds(string2, false, 0)));
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.ssl_server_dn_match")) {
                string2 = properties.getProperty("oracle.net.ssl_server_dn_match");
                this.socketOptions.put((Object)4, string2);
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.ssl_allow_weak_dn_match")) {
                string2 = properties.getProperty(string);
                this.socketOptions.put((Object)43, string2);
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.ssl_server_cert_dn")) {
                string2 = properties.getProperty("oracle.net.ssl_server_cert_dn");
                this.socketOptions.put((Object)28, string2);
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.wallet_location")) {
                string2 = properties.getProperty("oracle.net.wallet_location");
                this.socketOptions.put((Object)5, EnvVariableResolver.resolveEnvPlaceHolders(string2, properties));
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.wallet_password")) {
                string2 = properties.getProperty("oracle.net.wallet_password");
                this.socketOptions.put((Object)16, string2);
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.ssl_version")) {
                string2 = properties.getProperty("oracle.net.ssl_version");
                this.socketOptions.put((Object)6, string2);
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.ssl_cipher_suites")) {
                string2 = properties.getProperty("oracle.net.ssl_cipher_suites");
                this.socketOptions.put((Object)7, string2);
                continue;
            }
            if (string.equalsIgnoreCase("javax.net.ssl.keyStore")) {
                string2 = properties.getProperty("javax.net.ssl.keyStore");
                this.socketOptions.put((Object)8, string2);
                continue;
            }
            if (string.equalsIgnoreCase("javax.net.ssl.keyStoreType")) {
                string2 = properties.getProperty("javax.net.ssl.keyStoreType");
                this.socketOptions.put((Object)9, string2);
                continue;
            }
            if (string.equalsIgnoreCase("javax.net.ssl.keyStorePassword")) {
                string2 = properties.getProperty("javax.net.ssl.keyStorePassword");
                this.socketOptions.put((Object)10, string2);
                continue;
            }
            if (string.equalsIgnoreCase("javax.net.ssl.trustStore")) {
                string2 = properties.getProperty("javax.net.ssl.trustStore");
                this.socketOptions.put((Object)11, string2);
                continue;
            }
            if (string.equalsIgnoreCase("javax.net.ssl.trustStoreType")) {
                string2 = properties.getProperty("javax.net.ssl.trustStoreType");
                this.socketOptions.put((Object)12, string2);
                continue;
            }
            if (string.equalsIgnoreCase("javax.net.ssl.trustStorePassword")) {
                string2 = properties.getProperty("javax.net.ssl.trustStorePassword");
                this.socketOptions.put((Object)13, string2);
                continue;
            }
            if (string.equalsIgnoreCase("ssl.keyManagerFactory.algorithm")) {
                string2 = properties.getProperty("ssl.keyManagerFactory.algorithm");
                this.socketOptions.put((Object)14, string2);
                continue;
            }
            if (string.equalsIgnoreCase("FORCE_DNS_LOAD_BALANCING")) {
                string2 = properties.getProperty("FORCE_DNS_LOAD_BALANCING");
                this.socketOptions.put((Object)18, string2);
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.keepAlive")) {
                string2 = properties.getProperty("oracle.net.keepAlive");
                if (Boolean.parseBoolean(string2)) {
                    this.socketOptions.put((Object)1, "YES");
                    continue;
                }
                this.socketOptions.put((Object)1, "NO");
                continue;
            }
            if (string.equalsIgnoreCase("oracle.jdbc.useNio")) {
                string2 = properties.getProperty("oracle.jdbc.useNio");
                this.socketOptions.put((Object)20, string2);
                continue;
            }
            if (string.equalsIgnoreCase("oracle.jdbc.javaNetLocalIPForMsgq")) {
                string2 = properties.getProperty("oracle.jdbc.javaNetLocalIPForMsgq");
                this.socketOptions.put((Object)21, string2);
                continue;
            }
            if (string.equalsIgnoreCase("oracle.jdbc.javaNetMsgqTransport")) {
                string2 = properties.getProperty("oracle.jdbc.javaNetMsgqTransport");
                this.socketOptions.put((Object)22, string2);
                continue;
            }
            if (string.equalsIgnoreCase("oracle.jdbc.javaNetMsgqBusyWait")) {
                string2 = properties.getProperty("oracle.jdbc.javaNetMsgqBusyWait");
                this.socketOptions.put((Object)23, string2);
                continue;
            }
            if (string.equalsIgnoreCase("oracle.jdbc.javaNetMsgqKernelWait")) {
                string2 = properties.getProperty("oracle.jdbc.javaNetMsgqKernelWait");
                this.socketOptions.put((Object)24, string2);
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.OUTBOUND_CONNECT_TIMEOUT")) {
                string2 = properties.getProperty("oracle.net.OUTBOUND_CONNECT_TIMEOUT");
                this.socketOptions.put((Object)25, String.valueOf(TimeUnitSuffixUtility.getTimeInMilliseconds(string2, true, 0)));
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.websocketUser")) {
                string2 = properties.getProperty("oracle.net.websocketUser");
                this.socketOptions.put((Object)26, string2);
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.websocketPassword")) {
                string2 = properties.getProperty("oracle.net.websocketPassword");
                this.socketOptions.put((Object)27, string2);
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.ssl_certificate_alias")) {
                string2 = properties.getProperty("oracle.net.ssl_certificate_alias");
                this.socketOptions.put((Object)29, string2);
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.ssl_server_dn_match_default")) {
                this.socketOptions.put((Object)40, properties.getProperty("oracle.net.ssl_server_dn_match_default"));
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.useTcpFastOpen")) {
                string2 = properties.getProperty(string);
                this.socketOptions.put((Object)109, string2);
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.ssl_context_protocol")) {
                this.socketOptions.put((Object)38, properties.getProperty("oracle.net.ssl_context_protocol"));
                continue;
            }
            if (!string.equalsIgnoreCase("oracle.net.useTcpFastOpen")) continue;
            if (properties.getProperty(string).equalsIgnoreCase("true")) {
                this.socketOptions.put((Object)109, "true");
                continue;
            }
            this.socketOptions.put((Object)109, "false");
        }
        if (!bl && !this.reuseOpt) {
            this.socketOptions.put((Object)0, "YES");
        }
    }

    public void addSocketOptions(boolean bl) {
        if (bl) {
            this.socketOptions.put((Object)1, "YES");
        } else if (!this.reuseOpt && !this.socketOptions.containsKey(1)) {
            this.socketOptions.put((Object)1, "NO");
        }
    }

    public void addSocketOptions_FORCE_DNS_LOAD_BALANCING_OFF() {
        this.socketOptions.put((Object)18, "true");
    }

    public boolean hasMoreOptions() {
        int n2 = 0;
        for (ConnectDescription connectDescription : this.descriptionList) {
            n2 += connectDescription.getConnectOptions().size();
        }
        return this.nextOptToTry < n2;
    }

    public ConnOption execute(boolean bl, NounIntf nounIntf) throws NetException {
        IOException iOException = null;
        for (int i2 = this.lastRetryConnectDescription; i2 < this.descriptionList.size(); ++i2) {
            ConnectDescription connectDescription = this.descriptionList.get(i2);
            ArrayList<ConnOption> arrayList = connectDescription.getConnectOptions();
            DownHostsCache.getInstance().reorderAddresses(arrayList);
            if (connectDescription.getTokenAuthentication() != null) {
                this.userProp.setProperty("oracle.jdbc.tokenAuthentication", connectDescription.getTokenAuthentication());
            }
            if (connectDescription.getTokenLocation() != null) {
                this.userProp.setProperty("oracle.jdbc.tokenLocation", connectDescription.getTokenLocation());
            }
            if (connectDescription.getPasswordAuthentication() != null) {
                this.userProp.setProperty("oracle.jdbc.passwordAuthentication", connectDescription.getPasswordAuthentication());
            }
            if (connectDescription.getOciIamUrl() != null) {
                this.userProp.setProperty("oracle.jdbc.ociIamUrl", connectDescription.getOciIamUrl());
            }
            if (connectDescription.getOciTenancy() != null) {
                this.userProp.setProperty("oracle.jdbc.ociTenancy", connectDescription.getOciTenancy());
            }
            if (connectDescription.getOciCompartment() != null) {
                this.userProp.setProperty("oracle.jdbc.ociCompartment", connectDescription.getOciCompartment());
            }
            if (connectDescription.getOciDatabase() != null) {
                this.userProp.setProperty("oracle.jdbc.ociDatabase", connectDescription.getOciDatabase());
            }
            if (connectDescription.getTransportConnectTimeout() >= 0) {
                this.socketOptions.put((Object)2, Integer.toString(connectDescription.getTransportConnectTimeout()));
            }
            if (connectDescription.getAllowWeakCrypto() != null) {
                this.userProp.setProperty("oracle.net.allow_weak_crypto", connectDescription.getAllowWeakCrypto());
            }
            int n2 = 0;
            if (connectDescription.getConnectTimeout() >= 0) {
                n2 = connectDescription.getConnectTimeout();
            } else if (this.socketOptions.get(25) != null) {
                try {
                    n2 = Integer.parseInt((String)this.socketOptions.get(25));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.sdu = connectDescription.getSdu();
            this.tdu = connectDescription.getTdu();
            this.retryCount = connectDescription.getRetryCount();
            if (this.retryCount < 0) {
                this.retryCount = 0;
            }
            this.socketOptions.put((Object)17, Integer.toString(this.retryCount));
            if ("OCI_TOKEN".equals(connectDescription.getTokenAuthentication()) || "OCI_TOKEN".equals(connectDescription.getPasswordAuthentication())) {
                this.socketOptions.put((Object)40, "true");
            }
            int n3 = connectDescription.getDelayInMillis();
            for (int i3 = this.lastRetryCounter; i3 <= this.retryCount; ++i3) {
                while (this.nextOptToTry < arrayList.size()) {
                    try {
                        this.copt = arrayList.get(this.nextOptToTry);
                        if (n2 > 0 && bl) {
                            TimeoutInterruptHandler.scheduleInterrupt(TimeoutInterruptHandler.InterruptTaskType.OUTBOUND_TIMEOUT, n2, Thread.currentThread());
                        }
                        if (this.copt.walletDirectory != null) {
                            this.socketOptions.put((Object)5, EnvVariableResolver.resolveFilePath(this.copt.walletDirectory, this.userProp));
                        }
                        if (this.copt.sslServerCertDN == null) {
                            this.copt.sslServerCertDN = (String)this.socketOptions.get(28);
                        }
                        if (this.copt.sslServerDNMatch != null) {
                            this.socketOptions.put((Object)4, this.copt.sslServerDNMatch);
                        }
                        if (this.copt.sslAllowWeakDNMatch == null) {
                            this.copt.sslAllowWeakDNMatch = (String)this.socketOptions.get(43);
                        }
                        if (this.copt.useTcpFastOpen != null) {
                            this.socketOptions.put((Object)109, this.copt.useTcpFastOpen);
                        }
                        if (this.copt.sslServerCertDN != null && this.socketOptions.get(4) == null) {
                            this.socketOptions.put((Object)4, "TRUE");
                        }
                        this.copt.connect(this.socketOptions, this.sslContext, nounIntf);
                        this.copt.sdu = this.sdu;
                        this.copt.tdu = this.tdu;
                        this.optFound = true;
                        if (!this.copt.nt.hasMoreInetAddresses()) {
                            ++this.nextOptToTry;
                        }
                        this.lastRetryCounter = i3;
                        this.lastRetryConnectDescription = i2;
                        return this.copt;
                    }
                    catch (IOException iOException2) {
                        DownHostsCache.getInstance().markDownHost(this.copt);
                        ++this.nextOptToTry;
                        if (n2 > 0) {
                            TimeoutInterruptHandler.cancelInterrupt(TimeoutInterruptHandler.InterruptTaskType.OUTBOUND_TIMEOUT, Thread.currentThread());
                        }
                        iOException = iOException2;
                    }
                }
                this.nextOptToTry = 0;
                if (n3 <= 0 || i3 >= this.retryCount) continue;
                try {
                    Thread.sleep(n3);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.lastRetryCounter = 0;
        }
        if (iOException == null) {
            throw new NetException(20);
        }
        throw (NetException)new NetException(20).initCause(iOException);
    }

    public boolean optAvailable() {
        return this.optFound;
    }

    public void clearElements() {
        this.descriptionList = null;
    }

    public ConnOption getOption() {
        return this.copt;
    }

    public boolean isConnectionSocketKeepAlive() throws SocketException {
        return this.copt.isConnectionSocketKeepAlive();
    }

    public ConnectDescription newConnectDescription() {
        this.currentDescription = new ConnectDescription();
        return this.currentDescription;
    }

    public ConnectDescription currentDescription() {
        return this.currentDescription;
    }

    public void closeDescription() {
        this.descriptionList.add(this.currentDescription);
        this.currentDescription = null;
    }

    public List<ConnectDescription> getAllDescriptions() {
        return this.descriptionList;
    }

    static {
        try {
            $$$methodRef$$$16 = ConnStrategy.class.getDeclaredConstructor(Properties.class, SSLContext.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = ConnStrategy.class.getDeclaredConstructor(Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = ConnStrategy.class.getDeclaredMethod("getAllDescriptions", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = ConnStrategy.class.getDeclaredMethod("closeDescription", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = ConnStrategy.class.getDeclaredMethod("currentDescription", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = ConnStrategy.class.getDeclaredMethod("newConnectDescription", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = ConnStrategy.class.getDeclaredMethod("isConnectionSocketKeepAlive", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = ConnStrategy.class.getDeclaredMethod("getOption", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = ConnStrategy.class.getDeclaredMethod("clearElements", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = ConnStrategy.class.getDeclaredMethod("optAvailable", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = ConnStrategy.class.getDeclaredMethod("execute", Boolean.TYPE, NounIntf.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = ConnStrategy.class.getDeclaredMethod("hasMoreOptions", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = ConnStrategy.class.getDeclaredMethod("addSocketOptions_FORCE_DNS_LOAD_BALANCING_OFF", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = ConnStrategy.class.getDeclaredMethod("addSocketOptions", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = ConnStrategy.class.getDeclaredMethod("createSocketOptions", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = ConnStrategy.class.getDeclaredMethod("getProgramName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = ConnStrategy.class.getDeclaredMethod("getOSUsername", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

