/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.binary;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Executable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.Period;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import oracle.jdbc.driver.json.JsonpParserWrapper;
import oracle.jdbc.driver.json.OracleJsonExceptions;
import oracle.jdbc.driver.json.binary.OracleOsonValueFactory;
import oracle.jdbc.driver.json.binary.OsonAbstractArray;
import oracle.jdbc.driver.json.binary.OsonAbstractObject;
import oracle.jdbc.driver.json.binary.OsonContext;
import oracle.jdbc.driver.json.binary.OsonObjectImpl;
import oracle.jdbc.driver.json.binary.OsonStructureImpl;
import oracle.jdbc.driver.json.tree.OracleJsonBinaryImpl;
import oracle.jdbc.driver.json.tree.OracleJsonDateImpl;
import oracle.jdbc.driver.json.tree.OracleJsonDecimalImpl;
import oracle.jdbc.driver.json.tree.OracleJsonDoubleImpl;
import oracle.jdbc.driver.json.tree.OracleJsonFloatImpl;
import oracle.jdbc.driver.json.tree.OracleJsonIntervalDSImpl;
import oracle.jdbc.driver.json.tree.OracleJsonIntervalYMImpl;
import oracle.jdbc.driver.json.tree.OracleJsonNumberImpl;
import oracle.jdbc.driver.json.tree.OracleJsonStringImpl;
import oracle.jdbc.driver.json.tree.OracleJsonStringNumberImpl;
import oracle.jdbc.driver.json.tree.OracleJsonTimestampImpl;
import oracle.jdbc.driver.json.tree.OracleJsonTimestampTZImpl;
import oracle.sql.CHAR;
import oracle.sql.json.OracleJsonArray;
import oracle.sql.json.OracleJsonBinary;
import oracle.sql.json.OracleJsonDate;
import oracle.sql.json.OracleJsonDecimal;
import oracle.sql.json.OracleJsonIntervalDS;
import oracle.sql.json.OracleJsonIntervalYM;
import oracle.sql.json.OracleJsonNumber;
import oracle.sql.json.OracleJsonObject;
import oracle.sql.json.OracleJsonParser;
import oracle.sql.json.OracleJsonString;
import oracle.sql.json.OracleJsonStructure;
import oracle.sql.json.OracleJsonTimestamp;
import oracle.sql.json.OracleJsonTimestampTZ;
import oracle.sql.json.OracleJsonValue;

public class OsonParserImpl
extends OracleOsonValueFactory
implements OracleJsonParser {
    private static int INITIAL_DEPTH_CAPACITY;
    private final OsonContext ctx;
    private State state;
    private int depth;
    private OracleJsonStructure[] depthStack;
    private int[] currentChild;
    private OsonAbstractObject[] objectCache;
    private OsonAbstractArray[] arrayCache;
    private OracleJsonDecimalImpl numberCache;
    private StringPointer stringPointer = new StringPointer();
    private OracleJsonValue currentPrimitive;
    private Closeable closeable;
    OracleJsonParser.Event event;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;

    public OsonParserImpl(OsonContext osonContext) {
        this.ctx = osonContext;
        this.depthStack = new OracleJsonStructure[INITIAL_DEPTH_CAPACITY];
        this.currentChild = new int[INITIAL_DEPTH_CAPACITY];
        this.objectCache = new OsonAbstractObject[INITIAL_DEPTH_CAPACITY];
        this.arrayCache = new OsonAbstractArray[INITIAL_DEPTH_CAPACITY];
        this.init();
    }

    private void init() {
        this.state = State.START;
        this.depth = -1;
        this.event = null;
    }

    @Override
    public boolean hasNext() {
        return this.state != State.FINISHED;
    }

    @Override
    public OracleJsonParser.Event next() {
        switch (this.state) {
            case START: {
                int n2 = this.ctx.getHeader().getTreeSegmentOffset();
                this.pushDepth();
                OracleJsonValue oracleJsonValue = (OracleJsonValue)OsonStructureImpl.getValueInternal(n2, this, this.ctx);
                if (oracleJsonValue.getOracleJsonType() != OracleJsonValue.OracleJsonType.ARRAY && oracleJsonValue.getOracleJsonType() != OracleJsonValue.OracleJsonType.OBJECT) {
                    this.state = State.FINISHED;
                    this.currentPrimitive = oracleJsonValue;
                    this.event = this.OracleJsonTypeToEvent(oracleJsonValue);
                    return this.event;
                }
                this.setCurrent((OracleJsonStructure)oracleJsonValue);
                this.state = State.NEXT_VALUE;
                if (oracleJsonValue.getOracleJsonType() == OracleJsonValue.OracleJsonType.ARRAY) {
                    this.event = OracleJsonParser.Event.START_ARRAY;
                    return this.event;
                }
                this.event = OracleJsonParser.Event.START_OBJECT;
                return this.event;
            }
            case NEXT_VALUE: {
                this.event = this.nextValue();
                return this.event;
            }
            case AFTER_KEY: {
                this.state = State.NEXT_VALUE;
                this.event = this.nextChild();
                return this.event;
            }
        }
        throw new NoSuchElementException();
    }

    @Override
    public String getString() {
        if (this.state == State.AFTER_KEY) {
            return ((OsonAbstractObject)((Object)this.depthStack[this.depth])).getFieldName(this.currentChild[this.depth]);
        }
        if (this.currentPrimitive != null) {
            switch (this.currentPrimitive.getOracleJsonType()) {
                case BINARY: {
                    return ((OracleJsonBinary)this.currentPrimitive).getString();
                }
                case DATE: {
                    return ((OracleJsonDate)this.currentPrimitive).getString();
                }
                case DECIMAL: 
                case FLOAT: 
                case DOUBLE: {
                    return ((OracleJsonNumberImpl)((Object)this.currentPrimitive)).getString();
                }
                case INTERVALDS: {
                    return ((OracleJsonIntervalDS)this.currentPrimitive).getString();
                }
                case INTERVALYM: {
                    return ((OracleJsonIntervalYM)this.currentPrimitive).getString();
                }
                case STRING: {
                    return ((OracleJsonString)this.currentPrimitive).getString();
                }
                case TIMESTAMP: {
                    return ((OracleJsonTimestamp)this.currentPrimitive).getString();
                }
                case TIMESTAMPTZ: {
                    return ((OracleJsonTimestampTZ)this.currentPrimitive).getString();
                }
            }
            throw OracleJsonExceptions.BAD_PARSER_STATE3.create(this.ctx.getExceptionFactory(), new Object[]{this.event});
        }
        throw OracleJsonExceptions.BAD_PARSER_STATE3.create(this.ctx.getExceptionFactory(), new Object[]{this.event});
    }

    @Override
    public boolean isIntegralNumber() {
        this.assertNumeric();
        return ((OracleJsonNumber)this.currentPrimitive).isIntegral();
    }

    @Override
    public int getInt() {
        this.assertNumeric();
        return ((OracleJsonNumber)this.currentPrimitive).intValue();
    }

    @Override
    public long getLong() {
        this.assertNumeric();
        return ((OracleJsonNumber)this.currentPrimitive).longValue();
    }

    @Override
    public BigDecimal getBigDecimal() {
        this.assertNumeric();
        return ((OracleJsonNumber)this.currentPrimitive).bigDecimalValue();
    }

    @Override
    public BigInteger getBigInteger() {
        this.assertNumeric();
        return ((OracleJsonNumber)this.currentPrimitive).bigIntegerValue();
    }

    @Override
    public double getDouble() {
        this.assertNumeric();
        return ((OracleJsonNumber)this.currentPrimitive).doubleValue();
    }

    @Override
    public float getFloat() {
        this.assertNumeric();
        return ((OracleJsonNumber)this.currentPrimitive).floatValue();
    }

    @Override
    public OffsetDateTime getOffsetDateTime() {
        if (this.currentPrimitive == null) {
            throw OracleJsonExceptions.BAD_PARSER_STATE.create(this.ctx.getExceptionFactory(), OracleJsonValue.OracleJsonType.TIMESTAMPTZ.toString());
        }
        if (this.currentPrimitive.getOracleJsonType() == OracleJsonValue.OracleJsonType.TIMESTAMPTZ) {
            return ((OracleJsonTimestampTZ)this.currentPrimitive).getOffsetDateTime();
        }
        throw OracleJsonExceptions.BAD_PARSER_STATE.create(this.ctx.getExceptionFactory(), OracleJsonValue.OracleJsonType.TIMESTAMPTZ.toString());
    }

    @Override
    public LocalDateTime getLocalDateTime() {
        if (this.currentPrimitive == null) {
            throw OracleJsonExceptions.BAD_PARSER_STATE.create(this.ctx.getExceptionFactory(), OracleJsonValue.OracleJsonType.TIMESTAMP.toString());
        }
        if (this.currentPrimitive.getOracleJsonType() == OracleJsonValue.OracleJsonType.DATE) {
            return ((OracleJsonDate)this.currentPrimitive).getLocalDateTime();
        }
        if (this.currentPrimitive.getOracleJsonType() == OracleJsonValue.OracleJsonType.TIMESTAMP) {
            return ((OracleJsonTimestamp)this.currentPrimitive).getLocalDateTime();
        }
        throw OracleJsonExceptions.BAD_PARSER_STATE.create(this.ctx.getExceptionFactory(), OracleJsonValue.OracleJsonType.TIMESTAMP.toString());
    }

    @Override
    public byte[] getBytes() {
        this.assertJsonType(OracleJsonValue.OracleJsonType.BINARY);
        return ((OracleJsonBinaryImpl)this.currentPrimitive).getBytes();
    }

    @Override
    public Period getPeriod() {
        this.assertJsonType(OracleJsonValue.OracleJsonType.INTERVALYM);
        return ((OracleJsonIntervalYMImpl)this.currentPrimitive).getPeriod();
    }

    @Override
    public Duration getDuration() {
        this.assertJsonType(OracleJsonValue.OracleJsonType.INTERVALDS);
        return ((OracleJsonIntervalDSImpl)this.currentPrimitive).getDuration();
    }

    @Override
    public OracleJsonObject getObject() {
        this.assertJsonType(OracleJsonValue.OracleJsonType.OBJECT);
        OsonAbstractObject osonAbstractObject = (OsonAbstractObject)((Object)this.getCurrent());
        this.objectCache[this.depth] = null;
        this.pop();
        return (OracleJsonObject)((Object)osonAbstractObject);
    }

    @Override
    public OracleJsonValue getValue() {
        OracleOsonValueFactory oracleOsonValueFactory = OracleOsonValueFactory.INSTANCE;
        if (this.event == null || this.event == OracleJsonParser.Event.END_ARRAY || this.event == OracleJsonParser.Event.END_OBJECT) {
            throw OracleJsonExceptions.BAD_PARSER_STATE_VALUE.create(this.ctx.getExceptionFactory(), new Object[0]);
        }
        if (this.event == OracleJsonParser.Event.KEY_NAME) {
            return new OracleJsonStringImpl(this.getString());
        }
        if (this.event == OracleJsonParser.Event.VALUE_NULL) {
            return OracleJsonValue.NULL;
        }
        if (this.event == OracleJsonParser.Event.VALUE_FALSE) {
            return OracleJsonValue.FALSE;
        }
        if (this.event == OracleJsonParser.Event.VALUE_TRUE) {
            return OracleJsonValue.TRUE;
        }
        OracleJsonValue oracleJsonValue = this.currentPrimitive == null ? this.getCurrent() : this.currentPrimitive;
        switch (oracleJsonValue.getOracleJsonType()) {
            case BINARY: {
                OracleJsonBinaryImpl oracleJsonBinaryImpl = (OracleJsonBinaryImpl)oracleJsonValue;
                return new OracleJsonBinaryImpl(oracleJsonBinaryImpl.getBytes(), oracleJsonBinaryImpl.isId());
            }
            case DOUBLE: {
                OracleJsonDoubleImpl oracleJsonDoubleImpl = (OracleJsonDoubleImpl)oracleJsonValue;
                return new OracleJsonDoubleImpl(oracleJsonDoubleImpl.doubleValue());
            }
            case FLOAT: {
                OracleJsonFloatImpl oracleJsonFloatImpl = (OracleJsonFloatImpl)oracleJsonValue;
                return new OracleJsonFloatImpl(oracleJsonFloatImpl.floatValue());
            }
            case DECIMAL: {
                if (oracleJsonValue instanceof OracleJsonStringNumberImpl) {
                    OracleJsonStringNumberImpl oracleJsonStringNumberImpl = (OracleJsonStringNumberImpl)oracleJsonValue;
                    return new OracleJsonStringNumberImpl(oracleJsonStringNumberImpl.getString());
                }
                OracleJsonDecimalImpl oracleJsonDecimalImpl = (OracleJsonDecimalImpl)oracleJsonValue;
                return new OracleJsonDecimalImpl(oracleJsonDecimalImpl.raw(), oracleJsonDecimalImpl.getTargetType());
            }
            case STRING: {
                return new OracleJsonStringImpl(((OracleJsonString)oracleJsonValue).getString());
            }
            case TIMESTAMP: {
                OracleJsonTimestampImpl oracleJsonTimestampImpl = (OracleJsonTimestampImpl)oracleJsonValue;
                return oracleOsonValueFactory.createTimestamp(oracleJsonTimestampImpl.raw());
            }
            case TIMESTAMPTZ: {
                OracleJsonTimestampTZImpl oracleJsonTimestampTZImpl = (OracleJsonTimestampTZImpl)oracleJsonValue;
                return oracleOsonValueFactory.createTimestampTZ(oracleJsonTimestampTZImpl.raw());
            }
            case DATE: {
                OracleJsonDateImpl oracleJsonDateImpl = (OracleJsonDateImpl)oracleJsonValue;
                return oracleOsonValueFactory.createDate(oracleJsonDateImpl.raw());
            }
            case INTERVALDS: {
                OracleJsonIntervalDSImpl oracleJsonIntervalDSImpl = (OracleJsonIntervalDSImpl)oracleJsonValue;
                return oracleOsonValueFactory.createIntervalDS(oracleJsonIntervalDSImpl.raw());
            }
            case INTERVALYM: {
                OracleJsonIntervalYMImpl oracleJsonIntervalYMImpl = (OracleJsonIntervalYMImpl)oracleJsonValue;
                return oracleOsonValueFactory.createIntervalYM(oracleJsonIntervalYMImpl.raw());
            }
            case ARRAY: {
                return this.getArray();
            }
        }
        return this.getObject();
    }

    @Override
    public OracleJsonArray getArray() {
        this.assertJsonType(OracleJsonValue.OracleJsonType.ARRAY);
        OsonAbstractArray osonAbstractArray = (OsonAbstractArray)((Object)this.getCurrent());
        this.arrayCache[this.depth] = null;
        this.pop();
        return (OracleJsonArray)((Object)osonAbstractArray);
    }

    @Override
    public void skipArray() {
        if (this.depth < 0) {
            return;
        }
        if (this.getCurrent().getOracleJsonType() == OracleJsonValue.OracleJsonType.ARRAY) {
            this.pop();
            this.currentPrimitive = null;
        }
    }

    @Override
    public void skipObject() {
        if (this.depth < 0) {
            return;
        }
        if (this.getCurrent().getOracleJsonType() == OracleJsonValue.OracleJsonType.OBJECT) {
            this.pop();
            this.currentPrimitive = null;
        }
    }

    @Override
    public void close() {
        if (this.closeable != null) {
            try {
                this.closeable.close();
            }
            catch (IOException iOException) {
                throw OracleJsonExceptions.IO.create(this.ctx.getExceptionFactory(), iOException, new Object[0]);
            }
            this.closeable = null;
        }
        this.depth = -1;
        this.state = State.FINISHED;
        this.event = null;
    }

    public void setCloseable(Closeable closeable) {
        this.closeable = closeable;
    }

    @Override
    public OsonAbstractArray createArray(OsonContext osonContext, int n2) {
        if (this.arrayCache[this.depth] == null) {
            this.arrayCache[this.depth] = osonContext.getFactory().createArray(osonContext, n2);
        } else {
            this.arrayCache[this.depth].init(n2);
        }
        return this.arrayCache[this.depth];
    }

    @Override
    public OsonAbstractObject createObject(OsonContext osonContext, int n2) {
        if (this.objectCache[this.depth] == null) {
            this.objectCache[this.depth] = osonContext.getFactory().createObject(osonContext, n2);
        } else {
            this.objectCache[this.depth].init(n2);
        }
        return this.objectCache[this.depth];
    }

    @Override
    public Object createString(OsonContext osonContext, int n2, int n3) {
        this.stringPointer.reset(n2, n3);
        return this.stringPointer;
    }

    @Override
    public OracleJsonDecimalImpl createNumber(byte[] byArray, OracleJsonDecimal.TargetType targetType) {
        if (this.numberCache == null) {
            this.numberCache = super.createNumber(byArray, targetType);
        } else {
            this.numberCache.reset(byArray, targetType);
        }
        return this.numberCache;
    }

    public boolean toEntry(String string) {
        if (this.event != OracleJsonParser.Event.START_OBJECT) {
            throw new IllegalStateException();
        }
        OsonObjectImpl osonObjectImpl = (OsonObjectImpl)this.getCurrent();
        int n2 = osonObjectImpl.getChildPosition(string);
        if (n2 == -1) {
            return false;
        }
        this.currentChild[this.depth] = n2;
        this.event = OracleJsonParser.Event.KEY_NAME;
        this.state = State.AFTER_KEY;
        return true;
    }

    public void reset() {
        this.init();
    }

    private void setCurrent(OracleJsonStructure oracleJsonStructure) {
        this.currentChild[this.depth] = 0;
        this.depthStack[this.depth] = oracleJsonStructure;
        this.currentPrimitive = null;
    }

    private OracleJsonStructure getCurrent() {
        return this.depthStack[this.depth];
    }

    private void pop() {
        --this.depth;
        if (this.depth < 0) {
            this.state = State.FINISHED;
        }
    }

    private OracleJsonParser.Event nextChild() {
        int n2 = this.currentChild[this.depth];
        int n3 = this.depth;
        this.currentChild[n3] = this.currentChild[n3] + 1;
        int n4 = ((OsonStructureImpl)((Object)this.depthStack[this.depth])).getChildOffset(n2);
        this.pushDepth();
        OracleJsonValue oracleJsonValue = (OracleJsonValue)OsonStructureImpl.getValueInternal(n4, this, this.ctx);
        if (oracleJsonValue.getOracleJsonType() == OracleJsonValue.OracleJsonType.OBJECT) {
            this.setCurrent((OracleJsonStructure)oracleJsonValue);
            return OracleJsonParser.Event.START_OBJECT;
        }
        if (oracleJsonValue.getOracleJsonType() == OracleJsonValue.OracleJsonType.ARRAY) {
            this.setCurrent((OracleJsonStructure)oracleJsonValue);
            return OracleJsonParser.Event.START_ARRAY;
        }
        this.currentPrimitive = oracleJsonValue;
        --this.depth;
        return this.OracleJsonTypeToEvent(oracleJsonValue);
    }

    private OracleJsonParser.Event OracleJsonTypeToEvent(OracleJsonValue oracleJsonValue) {
        switch (oracleJsonValue.getOracleJsonType()) {
            case FALSE: {
                return OracleJsonParser.Event.VALUE_FALSE;
            }
            case NULL: {
                return OracleJsonParser.Event.VALUE_NULL;
            }
            case DECIMAL: {
                return OracleJsonParser.Event.VALUE_DECIMAL;
            }
            case STRING: {
                return OracleJsonParser.Event.VALUE_STRING;
            }
            case TRUE: {
                return OracleJsonParser.Event.VALUE_TRUE;
            }
            case BINARY: {
                return OracleJsonParser.Event.VALUE_BINARY;
            }
            case DOUBLE: {
                return OracleJsonParser.Event.VALUE_DOUBLE;
            }
            case FLOAT: {
                return OracleJsonParser.Event.VALUE_FLOAT;
            }
            case INTERVALDS: {
                return OracleJsonParser.Event.VALUE_INTERVALDS;
            }
            case INTERVALYM: {
                return OracleJsonParser.Event.VALUE_INTERVALYM;
            }
            case DATE: {
                return OracleJsonParser.Event.VALUE_DATE;
            }
            case TIMESTAMP: {
                return OracleJsonParser.Event.VALUE_TIMESTAMP;
            }
            case TIMESTAMPTZ: {
                return OracleJsonParser.Event.VALUE_TIMESTAMPTZ;
            }
        }
        throw new IllegalStateException(oracleJsonValue.toString());
    }

    private void pushDepth() {
        ++this.depth;
        if (this.depth >= this.depthStack.length) {
            this.expand();
        }
    }

    private void expand() {
        this.depthStack = Arrays.copyOf(this.depthStack, this.depthStack.length * 2);
        this.currentChild = Arrays.copyOf(this.currentChild, this.depthStack.length);
        this.objectCache = Arrays.copyOf(this.objectCache, this.depthStack.length);
        this.arrayCache = Arrays.copyOf(this.arrayCache, this.depthStack.length);
    }

    private OracleJsonParser.Event nextValue() {
        if (this.currentChild[this.depth] >= ((OsonStructureImpl)((Object)this.depthStack[this.depth])).size()) {
            if (this.depthStack[this.depth].getOracleJsonType() == OracleJsonValue.OracleJsonType.OBJECT) {
                this.pop();
                return OracleJsonParser.Event.END_OBJECT;
            }
            this.pop();
            return OracleJsonParser.Event.END_ARRAY;
        }
        if (this.depthStack[this.depth].getOracleJsonType() == OracleJsonValue.OracleJsonType.OBJECT) {
            this.state = State.AFTER_KEY;
            return OracleJsonParser.Event.KEY_NAME;
        }
        return this.nextChild();
    }

    private void assertNumeric() {
        OracleJsonValue oracleJsonValue = this.currentPrimitive == null ? this.getCurrent() : this.currentPrimitive;
        OracleJsonValue.OracleJsonType oracleJsonType = oracleJsonValue.getOracleJsonType();
        if (oracleJsonType != OracleJsonValue.OracleJsonType.DECIMAL && oracleJsonType != OracleJsonValue.OracleJsonType.DOUBLE && oracleJsonType != OracleJsonValue.OracleJsonType.FLOAT) {
            throw OracleJsonExceptions.BAD_PARSER_STATE3.create(this.ctx.getExceptionFactory(), new Object[]{this.event});
        }
    }

    private void assertJsonType(OracleJsonValue.OracleJsonType oracleJsonType) {
        if (this.depth < 0) {
            throw OracleJsonExceptions.BAD_PARSER_STATE.create(this.ctx.getExceptionFactory(), oracleJsonType.toString());
        }
        switch (oracleJsonType) {
            case ARRAY: {
                if (this.currentPrimitive == null && this.getCurrent().getOracleJsonType() == OracleJsonValue.OracleJsonType.ARRAY) break;
                throw OracleJsonExceptions.BAD_PARSER_STATE.create(this.ctx.getExceptionFactory(), oracleJsonType.toString());
            }
            case OBJECT: {
                if (this.currentPrimitive == null && this.getCurrent().getOracleJsonType() == OracleJsonValue.OracleJsonType.OBJECT) break;
                throw OracleJsonExceptions.BAD_PARSER_STATE.create(this.ctx.getExceptionFactory(), oracleJsonType.toString());
            }
            default: {
                if (this.currentPrimitive != null && this.currentPrimitive.getOracleJsonType() == oracleJsonType) break;
                throw OracleJsonExceptions.BAD_PARSER_STATE.create(this.ctx.getExceptionFactory(), oracleJsonType.toString());
            }
        }
    }

    @Override
    public <T> T wrap(Class<T> clazz) {
        try {
            return clazz.cast(new JsonpParserWrapper(this));
        }
        catch (ClassCastException classCastException) {
            throw OracleJsonExceptions.BAD_WRAP.create(OracleJsonExceptions.ORACLE_FACTORY, classCastException, clazz.getName());
        }
    }

    public long getStreamOffset() {
        if (this.state == State.START) {
            return 0L;
        }
        return -1L;
    }

    public OsonContext getContext() {
        return this.ctx;
    }

    public int getCurrentStringPos() {
        return this.stringPointer.getPos();
    }

    public int getCurrentStringLen() {
        return this.stringPointer.getLen();
    }

    static {
        try {
            $$$methodRef$$$46 = OsonParserImpl.class.getDeclaredConstructor(OsonContext.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$45 = OsonParserImpl.class.getDeclaredMethod("access$000", OsonParserImpl.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$44 = OsonParserImpl.class.getDeclaredMethod("createNumber", byte[].class, OracleJsonDecimal.TargetType.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$43 = OsonParserImpl.class.getDeclaredMethod("getCurrentStringLen", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$42 = OsonParserImpl.class.getDeclaredMethod("getCurrentStringPos", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$41 = OsonParserImpl.class.getDeclaredMethod("getContext", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$40 = OsonParserImpl.class.getDeclaredMethod("getStreamOffset", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$39 = OsonParserImpl.class.getDeclaredMethod("wrap", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$38 = OsonParserImpl.class.getDeclaredMethod("assertJsonType", OracleJsonValue.OracleJsonType.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$37 = OsonParserImpl.class.getDeclaredMethod("assertNumeric", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$36 = OsonParserImpl.class.getDeclaredMethod("nextValue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$35 = OsonParserImpl.class.getDeclaredMethod("expand", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$34 = OsonParserImpl.class.getDeclaredMethod("pushDepth", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$33 = OsonParserImpl.class.getDeclaredMethod("OracleJsonTypeToEvent", OracleJsonValue.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$32 = OsonParserImpl.class.getDeclaredMethod("nextChild", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$31 = OsonParserImpl.class.getDeclaredMethod("pop", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = OsonParserImpl.class.getDeclaredMethod("getCurrent", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = OsonParserImpl.class.getDeclaredMethod("setCurrent", OracleJsonStructure.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = OsonParserImpl.class.getDeclaredMethod("reset", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = OsonParserImpl.class.getDeclaredMethod("toEntry", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = OsonParserImpl.class.getDeclaredMethod("createNumber", byte[].class, OracleJsonDecimal.TargetType.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = OsonParserImpl.class.getDeclaredMethod("createString", OsonContext.class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = OsonParserImpl.class.getDeclaredMethod("createObject", OsonContext.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = OsonParserImpl.class.getDeclaredMethod("createArray", OsonContext.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = OsonParserImpl.class.getDeclaredMethod("setCloseable", Closeable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = OsonParserImpl.class.getDeclaredMethod("close", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = OsonParserImpl.class.getDeclaredMethod("skipObject", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = OsonParserImpl.class.getDeclaredMethod("skipArray", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = OsonParserImpl.class.getDeclaredMethod("getArray", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = OsonParserImpl.class.getDeclaredMethod("getValue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = OsonParserImpl.class.getDeclaredMethod("getObject", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = OsonParserImpl.class.getDeclaredMethod("getDuration", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = OsonParserImpl.class.getDeclaredMethod("getPeriod", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = OsonParserImpl.class.getDeclaredMethod("getBytes", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = OsonParserImpl.class.getDeclaredMethod("getLocalDateTime", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OsonParserImpl.class.getDeclaredMethod("getOffsetDateTime", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OsonParserImpl.class.getDeclaredMethod("getFloat", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OsonParserImpl.class.getDeclaredMethod("getDouble", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OsonParserImpl.class.getDeclaredMethod("getBigInteger", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OsonParserImpl.class.getDeclaredMethod("getBigDecimal", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OsonParserImpl.class.getDeclaredMethod("getLong", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OsonParserImpl.class.getDeclaredMethod("getInt", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OsonParserImpl.class.getDeclaredMethod("isIntegralNumber", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OsonParserImpl.class.getDeclaredMethod("getString", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OsonParserImpl.class.getDeclaredMethod("next", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OsonParserImpl.class.getDeclaredMethod("hasNext", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OsonParserImpl.class.getDeclaredMethod("init", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        INITIAL_DEPTH_CAPACITY = 4;
    }

    private static final class State
    extends Enum<State> {
        public static final /* enum */ State START;
        public static final /* enum */ State NEXT_VALUE;
        public static final /* enum */ State AFTER_KEY;
        public static final /* enum */ State FINISHED;
        private static final /* synthetic */ State[] $VALUES;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String string) {
            return Enum.valueOf(State.class, string);
        }

        static {
            try {
                $$$methodRef$$$2 = State.class.getDeclaredConstructor(String.class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = State.class.getDeclaredMethod("valueOf", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = State.class.getDeclaredMethod("values", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            START = new State();
            NEXT_VALUE = new State();
            AFTER_KEY = new State();
            FINISHED = new State();
            $VALUES = new State[]{START, NEXT_VALUE, AFTER_KEY, FINISHED};
        }
    }

    private class StringPointer
    implements OracleJsonString {
        int pos;
        int len;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;
        private static Executable $$$methodRef$$$8;
        private static Logger $$$loggerRef$$$8;
        private static Executable $$$methodRef$$$9;
        private static Logger $$$loggerRef$$$9;

        private StringPointer() {
        }

        @Override
        public OracleJsonValue.OracleJsonType getOracleJsonType() {
            return OracleJsonValue.OracleJsonType.STRING;
        }

        @Override
        public <T> T wrap(Class<T> clazz) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getString() {
            ((OsonParserImpl)OsonParserImpl.this).ctx.b.position(this.pos);
            return ((OsonParserImpl)OsonParserImpl.this).ctx.b.readString(this.len);
        }

        @Override
        public CharSequence getChars() {
            return this.getString();
        }

        @Override
        public CHAR getCHAR() {
            throw new UnsupportedOperationException();
        }

        public void reset(int n2, int n3) {
            this.pos = n2;
            this.len = n3;
        }

        public int getLen() {
            return this.len;
        }

        public int getPos() {
            return this.pos;
        }

        static {
            try {
                $$$methodRef$$$9 = StringPointer.class.getDeclaredConstructor(OsonParserImpl.class, 1.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$8 = StringPointer.class.getDeclaredConstructor(OsonParserImpl.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$7 = StringPointer.class.getDeclaredMethod("getPos", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$6 = StringPointer.class.getDeclaredMethod("getLen", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$5 = StringPointer.class.getDeclaredMethod("reset", Integer.TYPE, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = StringPointer.class.getDeclaredMethod("getCHAR", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = StringPointer.class.getDeclaredMethod("getChars", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = StringPointer.class.getDeclaredMethod("getString", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = StringPointer.class.getDeclaredMethod("wrap", Class.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = StringPointer.class.getDeclaredMethod("getOracleJsonType", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }
}

