/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.util.Arrays;
import java.util.logging.Logger;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class ReplayContext
implements oracle.jdbc.internal.ReplayContext {
    long flags_kpdxcAppContCtl;
    short queue_kpdxcAppContCtl;
    byte[] replayctx_kpdxcAppContCtl;
    long errcode_kpdxcAppContCtl;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;

    ReplayContext(long l2, short s2, byte[] byArray, long l3) {
        this.flags_kpdxcAppContCtl = l2;
        this.queue_kpdxcAppContCtl = s2;
        this.errcode_kpdxcAppContCtl = l3;
        this.replayctx_kpdxcAppContCtl = byArray;
    }

    @Override
    public byte[] getContext() {
        return this.replayctx_kpdxcAppContCtl;
    }

    @Override
    public short getQueue() {
        return this.queue_kpdxcAppContCtl;
    }

    @Override
    public long getDirectives() {
        return this.flags_kpdxcAppContCtl;
    }

    @Override
    public long getErrorCode() {
        return this.errcode_kpdxcAppContCtl;
    }

    private String getDirectivesAsString() {
        String string = "[0";
        if ((this.flags_kpdxcAppContCtl & 1L) == 1L) {
            string = string + "|DIRECTIVE_ENQUEUE_CALL";
        }
        if ((this.flags_kpdxcAppContCtl & 2L) == 2L) {
            string = string + "|DIRECTIVE_REQ_SCOPE_CRSR";
        }
        if ((this.flags_kpdxcAppContCtl & 4L) == 4L) {
            string = string + "|DIRECTIVE_REPLAY_ENABLED";
        }
        if ((this.flags_kpdxcAppContCtl & 8L) == 8L) {
            string = string + "|DIRECTIVE_EMPTY_QUEUE";
        }
        return string + "]";
    }

    @DisableTrace
    boolean isDuplicate(ReplayContext replayContext) {
        if (replayContext == null) {
            return false;
        }
        return this.flags_kpdxcAppContCtl == replayContext.flags_kpdxcAppContCtl && this.queue_kpdxcAppContCtl == replayContext.queue_kpdxcAppContCtl && this.errcode_kpdxcAppContCtl == replayContext.errcode_kpdxcAppContCtl && Arrays.equals(this.replayctx_kpdxcAppContCtl, replayContext.replayctx_kpdxcAppContCtl);
    }

    @DisableTrace
    public String toString() {
        return "ReplayContext[Directives=" + this.getDirectivesAsString() + ",Queue=" + this.queue_kpdxcAppContCtl + ",ErrorCode=" + this.errcode_kpdxcAppContCtl + ",Context=" + this.replayctx_kpdxcAppContCtl + "]";
    }

    static {
        try {
            $$$methodRef$$$5 = ReplayContext.class.getDeclaredConstructor(Long.TYPE, Short.TYPE, byte[].class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = ReplayContext.class.getDeclaredMethod("getDirectivesAsString", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = ReplayContext.class.getDeclaredMethod("getErrorCode", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = ReplayContext.class.getDeclaredMethod("getDirectives", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = ReplayContext.class.getDeclaredMethod("getQueue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = ReplayContext.class.getDeclaredMethod("getContext", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

