/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Executable;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import oracle.jdbc.AccessToken;
import oracle.jdbc.driver.AccessTokenCache;
import oracle.jdbc.driver.OpaqueAccessToken;
import oracle.jdbc.driver.OpaquePrivateKey;
import oracle.jdbc.internal.OpaqueString;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.net.nt.CustomSSLSocketFactory;
import oracle.sql.json.OracleJsonException;
import oracle.sql.json.OracleJsonFactory;
import oracle.sql.json.OracleJsonNumber;
import oracle.sql.json.OracleJsonValue;

public final class JsonWebToken
extends OpaqueAccessToken {
    private static final OracleJsonFactory JSON_FACTORY;
    private static final DateTimeFormatter DATE_FORMATTER;
    private static final int CACHES_SIZE = 128;
    private static final Map<Builder, AccessTokenCache<JsonWebToken>> CACHES;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;

    private JsonWebToken(@Blind OpaqueString opaqueString, OffsetDateTime offsetDateTime, @Blind OpaquePrivateKey opaquePrivateKey) {
        super(opaqueString, offsetDateTime, opaquePrivateKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Blind
    static JsonWebToken fromOciFile(Path path) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        char[] cArray = JsonWebToken.readTokenFile(path.resolve("token"));
        try {
            OffsetDateTime offsetDateTime = JsonWebToken.parseExp(cArray);
            JsonWebToken jsonWebToken = new JsonWebToken(OpaqueString.newOpaqueString(new String(cArray)), offsetDateTime, OpaquePrivateKey.fromPemFile(path.resolve("oci_db_key.pem")));
            return jsonWebToken;
        }
        finally {
            Arrays.fill(cArray, '\u0000');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Blind
    static JsonWebToken fromFile(Path path) throws IOException {
        char[] cArray = Files.isDirectory(path, new LinkOption[0]) ? JsonWebToken.readTokenFile(path.resolve("token")) : JsonWebToken.readTokenFile(path);
        try {
            OffsetDateTime offsetDateTime = JsonWebToken.parseExp(cArray);
            JsonWebToken jsonWebToken = new JsonWebToken(OpaqueString.newOpaqueString(new String(cArray)), offsetDateTime, null);
            return jsonWebToken;
        }
        finally {
            Arrays.fill(cArray, '\u0000');
        }
    }

    static Builder requestBuilder() {
        return new Builder();
    }

    @Blind
    public static JsonWebToken createProofOfPossessionToken(@Blind char[] cArray, @Blind PrivateKey privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        return new JsonWebToken(OpaqueString.newOpaqueString(new String(cArray)), JsonWebToken.parseExp(cArray), OpaquePrivateKey.fromPrivateKey(privateKey));
    }

    @Blind
    public static JsonWebToken createBearerToken(@Blind char[] cArray) {
        return new JsonWebToken(OpaqueString.newOpaqueString(new String(cArray)), JsonWebToken.parseExp(cArray), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Blind
    private static char[] readTokenFile(Path path) throws IOException {
        byte[] byArray = Files.readAllBytes(path);
        try {
            char[] cArray;
            CharBuffer charBuffer = StandardCharsets.UTF_8.decode(ByteBuffer.wrap(byArray));
            try {
                char[] cArray2 = new char[charBuffer.remaining()];
                charBuffer.get(cArray2);
                cArray = cArray2;
                charBuffer.clear();
            }
            catch (Throwable throwable) {
                charBuffer.clear();
                charBuffer.put(new char[charBuffer.remaining()]);
                throw throwable;
            }
            charBuffer.put(new char[charBuffer.remaining()]);
            return cArray;
        }
        finally {
            Arrays.fill(byArray, (byte)0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static OffsetDateTime parseExp(@Blind char[] cArray) {
        OracleJsonValue oracleJsonValue;
        int n2;
        int n3;
        if (cArray.length > 16000) {
            throw new IllegalArgumentException("JWT of length " + cArray.length + " exceeds the maximum accepted length of 16,000 characters");
        }
        for (n3 = 0; n3 < cArray.length && cArray[n3] != '.'; ++n3) {
        }
        if (++n3 > cArray.length) {
            throw new IllegalArgumentException("Failed to identify payload of JWT");
        }
        for (n2 = n3; n2 < cArray.length && cArray[n2] != '.'; ++n2) {
        }
        if (n2 == cArray.length) {
            throw new IllegalArgumentException("Failed to identify payload of JWT");
        }
        byte[] byArray = new byte[n2 - n3];
        try {
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                byArray[i2] = (byte)cArray[i2 + n3];
            }
            new TraceControllerImpl().suspend();
            try {
                byte[] byArray2 = Base64.getMimeDecoder().decode(byArray);
                try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);){
                    oracleJsonValue = (OracleJsonValue)JSON_FACTORY.createJsonTextValue(byteArrayInputStream).asJsonObject().get("exp");
                }
                catch (ClassCastException | OracleJsonException runtimeException) {
                    throw new IllegalArgumentException("JWT payload is not JSON", runtimeException);
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException("Failed to read JWT payload", iOException);
                }
                finally {
                    Arrays.fill(byArray2, (byte)0);
                }
            }
            finally {
                new TraceControllerImpl().resume();
            }
        }
        finally {
            Arrays.fill(byArray, (byte)0);
        }
        if (oracleJsonValue == null) {
            throw new IllegalArgumentException("JWT is missing an exp claim");
        }
        if (!(oracleJsonValue instanceof OracleJsonNumber)) {
            throw new IllegalArgumentException("JWT has an exp claim with a non-numeric value of type: " + (Object)((Object)oracleJsonValue.getOracleJsonType()));
        }
        return Instant.ofEpochSecond(oracleJsonValue.asJsonNumber().longValue()).atOffset(ZoneOffset.UTC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Blind
    private static JsonWebToken requestBearerToken(Builder builder) throws IOException {
        URL uRL = new URL(builder.endPoint);
        if (!"https".equalsIgnoreCase(uRL.getProtocol())) {
            throw new IllegalArgumentException("Protocol of endpoint is not https: " + uRL.getProtocol());
        }
        HttpsURLConnection httpsURLConnection = (HttpsURLConnection)uRL.openConnection();
        httpsURLConnection.setRequestMethod("POST");
        httpsURLConnection.setRequestProperty("Content-Type", "application/json");
        httpsURLConnection.setRequestProperty("Accept", "application/json");
        httpsURLConnection.setSSLSocketFactory(CustomSSLSocketFactory.getSSLSocketFactory(builder.sqlNetOptions, null));
        httpsURLConnection.setRequestProperty("Date", ZonedDateTime.now(ZoneId.of("Z")).format(DATE_FORMATTER));
        httpsURLConnection.setRequestProperty("Authorization", JsonWebToken.createAuthorization(builder.user, builder.password));
        httpsURLConnection.setDoOutput(true);
        try (Closeable closeable = httpsURLConnection.getOutputStream();){
            ((OutputStream)closeable).write(String.format("{\"scope\": \"urn:oracle:db::id::%s\", \"tenantId\": \"%s\"}", builder.compartment == null ? "*" : (builder.database == null ? builder.compartment : builder.compartment + "::" + builder.database), builder.tenancy).getBytes(StandardCharsets.UTF_8));
            ((OutputStream)closeable).flush();
        }
        closeable = httpsURLConnection.getInputStream();
        var4_4 = null;
        try {
            JsonWebToken jsonWebToken;
            String string = JSON_FACTORY.createJsonTextValue((InputStream)closeable).asJsonObject().getString("token");
            if (string == null) {
                throw new IOException("JSON response does not contain a token");
            }
            char[] cArray = string.toCharArray();
            try {
                jsonWebToken = JsonWebToken.createBearerToken(cArray);
            }
            catch (Throwable throwable) {
                try {
                    Arrays.fill(cArray, '\u0000');
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    var4_4 = throwable2;
                    throw throwable2;
                }
            }
            Arrays.fill(cArray, '\u0000');
            return jsonWebToken;
        }
        finally {
            if (closeable != null) {
                if (var4_4 != null) {
                    try {
                        ((InputStream)closeable).close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    ((InputStream)closeable).close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Blind
    private static String createAuthorization(String string, @Blind OpaqueString opaqueString) {
        ByteBuffer byteBuffer;
        byte[] byArray = (string + ":").getBytes(StandardCharsets.UTF_8);
        char[] cArray = opaqueString.get().toCharArray();
        try {
            byteBuffer = StandardCharsets.UTF_8.encode(CharBuffer.wrap(cArray));
        }
        finally {
            Arrays.fill(cArray, '\u0000');
        }
        try {
            String string2;
            byte[] byArray2 = new byte[byArray.length + byteBuffer.remaining()];
            try {
                System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                byteBuffer.get(byArray2, byArray.length, byteBuffer.remaining());
                string2 = "Basic " + Base64.getEncoder().encodeToString(byArray2);
            }
            catch (Throwable throwable) {
                Arrays.fill(byArray2, (byte)0);
                throw throwable;
            }
            Arrays.fill(byArray2, (byte)0);
            return string2;
        }
        finally {
            byteBuffer.clear();
            byteBuffer.put(new byte[byteBuffer.remaining()]);
        }
    }

    public static AccessTokenCache<JsonWebToken> createCache(Supplier<? extends AccessToken> supplier) {
        return AccessTokenCache.create(() -> {
            AccessToken accessToken = (AccessToken)supplier.get();
            if (!(accessToken instanceof JsonWebToken)) {
                throw new IllegalArgumentException("token supplier has output an unrecognized object type: " + accessToken.getClass());
            }
            return (JsonWebToken)accessToken;
        });
    }

    static {
        try {
            $$$methodRef$$$13 = JsonWebToken.class.getDeclaredConstructor(OpaqueString.class, OffsetDateTime.class, OpaquePrivateKey.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = JsonWebToken.class.getDeclaredMethod("access$900", Builder.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = JsonWebToken.class.getDeclaredMethod("access$800", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = JsonWebToken.class.getDeclaredMethod("lambda$createCache$0", Supplier.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = JsonWebToken.class.getDeclaredMethod("createCache", Supplier.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = JsonWebToken.class.getDeclaredMethod("createAuthorization", String.class, OpaqueString.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = JsonWebToken.class.getDeclaredMethod("requestBearerToken", Builder.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = JsonWebToken.class.getDeclaredMethod("parseExp", char[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = JsonWebToken.class.getDeclaredMethod("readTokenFile", Path.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = JsonWebToken.class.getDeclaredMethod("createBearerToken", char[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = JsonWebToken.class.getDeclaredMethod("createProofOfPossessionToken", char[].class, PrivateKey.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = JsonWebToken.class.getDeclaredMethod("requestBuilder", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = JsonWebToken.class.getDeclaredMethod("fromFile", Path.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = JsonWebToken.class.getDeclaredMethod("fromOciFile", Path.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        JSON_FACTORY = new OracleJsonFactory();
        DATE_FORMATTER = DateTimeFormatter.ofPattern("E, dd MMM uuuu HH:mm:ss z", Locale.US);
        CACHES = Collections.synchronizedMap(new LinkedHashMap<Builder, AccessTokenCache<JsonWebToken>>(16, 0.75f, true){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            protected boolean removeEldestEntry(Map.Entry<Builder, AccessTokenCache<JsonWebToken>> entry) {
                return this.size() > 128;
            }

            static {
                try {
                    $$$methodRef$$$1 = 1.class.getDeclaredConstructor(Integer.TYPE, Float.TYPE, Boolean.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 1.class.getDeclaredMethod("removeEldestEntry", Map.Entry.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
    }

    static final class Builder {
        private String endPoint;
        private String tenancy;
        private String compartment;
        private String database;
        private String user;
        private OpaqueString password;
        private Properties sqlNetOptions;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;
        private static Executable $$$methodRef$$$8;
        private static Logger $$$loggerRef$$$8;
        private static Executable $$$methodRef$$$9;
        private static Logger $$$loggerRef$$$9;
        private static Executable $$$methodRef$$$10;
        private static Logger $$$loggerRef$$$10;
        private static Executable $$$methodRef$$$11;
        private static Logger $$$loggerRef$$$11;
        private static Executable $$$methodRef$$$12;
        private static Logger $$$loggerRef$$$12;
        private static Executable $$$methodRef$$$13;
        private static Logger $$$loggerRef$$$13;
        private static Executable $$$methodRef$$$14;
        private static Logger $$$loggerRef$$$14;
        private static Executable $$$methodRef$$$15;
        private static Logger $$$loggerRef$$$15;
        private static Executable $$$methodRef$$$16;
        private static Logger $$$loggerRef$$$16;
        private static Executable $$$methodRef$$$17;
        private static Logger $$$loggerRef$$$17;
        private static Executable $$$methodRef$$$18;
        private static Logger $$$loggerRef$$$18;
        private static Executable $$$methodRef$$$19;
        private static Logger $$$loggerRef$$$19;
        private static Executable $$$methodRef$$$20;
        private static Logger $$$loggerRef$$$20;

        private Builder() {
        }

        Builder endPoint(String string) {
            this.endPoint = string;
            return this;
        }

        Builder tenancy(String string) {
            this.tenancy = string;
            return this;
        }

        Builder compartment(String string) {
            this.compartment = string;
            return this;
        }

        Builder database(String string) {
            this.database = string;
            return this;
        }

        Builder user(String string) {
            this.user = string;
            return this;
        }

        Builder password(@Blind OpaqueString opaqueString) {
            this.password = opaqueString;
            return this;
        }

        Builder sqlNetOptions(Properties properties) {
            this.sqlNetOptions = (Properties)properties.clone();
            return this;
        }

        @Blind
        JsonWebToken build() throws IOException {
            try {
                return (JsonWebToken)CACHES.computeIfAbsent(this, builder -> JsonWebToken.createCache(() -> {
                    try {
                        return JsonWebToken.requestBearerToken(this);
                    }
                    catch (IOException iOException) {
                        throw new UncheckedIOException(iOException);
                    }
                })).get();
            }
            catch (UncheckedIOException uncheckedIOException) {
                throw uncheckedIOException.getCause();
            }
        }

        public boolean equals(Object object) {
            return this == object || object instanceof Builder && Objects.equals(this.endPoint, ((Builder)object).endPoint) && Objects.equals(this.tenancy, ((Builder)object).tenancy) && Objects.equals(this.compartment, ((Builder)object).compartment) && Objects.equals(this.database, ((Builder)object).database) && Objects.equals(this.user, ((Builder)object).user) && Objects.equals(this.password, ((Builder)object).password) && Objects.equals(this.sqlNetOptions, ((Builder)object).sqlNetOptions);
        }

        public int hashCode() {
            return Objects.hash(this.endPoint, this.tenancy, this.compartment, this.database, this.user, this.password, this.sqlNetOptions);
        }

        static {
            try {
                $$$methodRef$$$20 = Builder.class.getDeclaredConstructor(1.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$19 = Builder.class.getDeclaredConstructor(new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$18 = Builder.class.getDeclaredMethod("access$700", Builder.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$17 = Builder.class.getDeclaredMethod("access$600", Builder.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$16 = Builder.class.getDeclaredMethod("access$500", Builder.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$15 = Builder.class.getDeclaredMethod("access$400", Builder.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$14 = Builder.class.getDeclaredMethod("access$300", Builder.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$13 = Builder.class.getDeclaredMethod("access$200", Builder.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$12 = Builder.class.getDeclaredMethod("access$100", Builder.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$11 = Builder.class.getDeclaredMethod("lambda$null$0", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$10 = Builder.class.getDeclaredMethod("lambda$build$1", Builder.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$9 = Builder.class.getDeclaredMethod("hashCode", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$8 = Builder.class.getDeclaredMethod("equals", Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$7 = Builder.class.getDeclaredMethod("build", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$6 = Builder.class.getDeclaredMethod("sqlNetOptions", Properties.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$5 = Builder.class.getDeclaredMethod("password", OpaqueString.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = Builder.class.getDeclaredMethod("user", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = Builder.class.getDeclaredMethod("database", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = Builder.class.getDeclaredMethod("compartment", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = Builder.class.getDeclaredMethod("tenancy", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = Builder.class.getDeclaredMethod("endPoint", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }
}

