/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.driver.AssociativeArrayEntry;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleArray;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLevel;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Logging;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeFLOAT;
import oracle.jdbc.oracore.OracleTypeNUMBER;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.TDSReader;
import oracle.jdbc.oracore.TypeTreeElement;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.Datum;
import oracle.sql.SQLName;
import oracle.sql.StructDescriptor;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.OBJECT_TYPES})
@DefaultLevel(value=Logging.FINEST)
public class OracleTypeCOLLECTION
extends OracleTypeADT
implements Serializable {
    static final long serialVersionUID = -7279638692691669378L;
    int userCode = 0;
    long maxSize = 0L;
    OracleType elementType = null;
    private int collectionFlag = 0;
    static final int CURRENT_USER_OBJECT = 0;
    static final int CURRENT_USER_SYNONYM = 1;
    static final int CURRENT_USER_SYNONYM_10g = 2;
    static final int CURRENT_USER_PUBLIC_SYNONYM = 3;
    static final int CURRENT_USER_PUBLIC_SYNONYM_10g = 4;
    static final int POSSIBLY_OTHER_USER_OBJECT = 5;
    static final int POSSIBLY_OTHER_USER_OBJECT_10g = 6;
    static final int OTHER_USER_OBJECT = 7;
    static final int OTHER_USER_SYNONYM = 8;
    static final int PUBLIC_SYNONYM = 9;
    static final int PUBLIC_SYNONYM_10g = 10;
    static final int BREAK = 11;
    static final String[] sqlString;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;

    public OracleTypeCOLLECTION(String string, OracleConnection oracleConnection) throws SQLException {
        super(string, (Connection)oracleConnection);
    }

    public OracleTypeCOLLECTION(OracleTypeADT oracleTypeADT, int n2, OracleConnection oracleConnection) throws SQLException {
        super(oracleTypeADT, n2, (Connection)oracleConnection);
    }

    public OracleTypeCOLLECTION(SQLName sQLName, byte[] byArray, int n2, byte[] byArray2, OracleConnection oracleConnection) throws SQLException {
        super(sQLName, byArray, n2, byArray2, oracleConnection);
    }

    @Override
    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        if (object != null) {
            if (object instanceof ARRAY) {
                return (Datum)object;
            }
            ArrayDescriptor arrayDescriptor = this.createArrayDescriptor();
            return new ARRAY(arrayDescriptor, this.connection, object);
        }
        return null;
    }

    @Override
    public int getTypeCode() {
        return 2003;
    }

    @Override
    public boolean isInHierarchyOf(OracleType oracleType) throws SQLException {
        if (oracleType == null) {
            return false;
        }
        if (oracleType == this) {
            return true;
        }
        if (oracleType.getClass() != this.getClass()) {
            return false;
        }
        return oracleType.getTypeDescriptor().getName().equals(this.descriptor.getName());
    }

    @Override
    public boolean isInHierarchyOf(StructDescriptor structDescriptor) throws SQLException {
        return false;
    }

    @Override
    public boolean isObjectType() {
        return false;
    }

    @Override
    public void parseTDSrec(TDSReader tDSReader) throws SQLException {
        long l2 = tDSReader.readLong();
        this.maxSize = tDSReader.readLong();
        this.userCode = tDSReader.readByte();
        tDSReader.addSimplePatch(l2, this);
    }

    @Override
    public Datum unlinearize(byte[] byArray, long l2, Datum datum, int n2, Map map) throws SQLException {
        return this.unlinearize(byArray, l2, datum, 1L, -1, n2, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Datum unlinearize(byte[] byArray, long l2, Datum datum, long l3, int n2, int n3, Map map) throws SQLException {
        OracleConnection oracleConnection = this.getConnection();
        Datum datum2 = null;
        if (oracleConnection == null) {
            datum2 = this.unlinearizeInternal(byArray, l2, datum, l3, n2, n3, map);
        } else {
            OracleConnection oracleConnection2 = oracleConnection;
            synchronized (oracleConnection2) {
                datum2 = this.unlinearizeInternal(byArray, l2, datum, l3, n2, n3, map);
            }
        }
        return datum2;
    }

    public synchronized Datum unlinearizeInternal(byte[] byArray, long l2, Datum datum, long l3, int n2, int n3, Map map) throws SQLException {
        if (byArray == null) {
            return null;
        }
        PickleContext pickleContext = new PickleContext(byArray, l2);
        return (Datum)((Object)this.unpickle81(pickleContext, (OracleArray)((Object)datum), l3, n2, 1, n3, map));
    }

    public synchronized boolean isInlineImage(byte[] byArray, int n2) throws SQLException {
        if (byArray == null) {
            return false;
        }
        if (PickleContext.isCollectionImage_pctx(byArray[n2])) {
            return true;
        }
        if (PickleContext.isDegenerateImage_pctx(byArray[n2])) {
            return false;
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Image is not a collection image").fillInStackTrace();
    }

    @Override
    protected int pickle81(PickleContext pickleContext, Datum datum) throws SQLException {
        OracleArray oracleArray = (OracleArray)((Object)datum);
        boolean bl = oracleArray.hasDataSeg();
        int n2 = 0;
        int n3 = pickleContext.offset() + 2;
        if (bl) {
            if (!this.metaDataInitialized) {
                this.copy_properties((OracleTypeCOLLECTION)oracleArray.getDescriptor().getPickler());
            }
            Datum[] datumArray = oracleArray.getOracleArray();
            if (this.userCode == 3 && (long)datumArray.length > this.maxSize) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 71, null).fillInStackTrace();
            }
            pickleContext.setCollectionUserCode(this.userCode);
            n2 += pickleContext.writeCollImageHeader(datumArray.length, this.typeVersion);
            for (int i2 = 0; i2 < datumArray.length; ++i2) {
                if (this.userCode == 1) {
                    AssociativeArrayEntry associativeArrayEntry = (AssociativeArrayEntry)datumArray[i2];
                    Integer n4 = (Integer)associativeArrayEntry.getKey();
                    n2 += pickleContext.writeUB4(n4);
                    Datum datum2 = (Datum)((AssociativeArrayEntry)datumArray[i2]).getValue();
                    if (datum2 == null) {
                        n2 += pickleContext.writeElementNull();
                        continue;
                    }
                    n2 += this.elementType.pickle81(pickleContext, datum2);
                    continue;
                }
                if (datumArray[i2] == null) {
                    n2 += pickleContext.writeElementNull();
                    continue;
                }
                n2 += this.elementType.pickle81(pickleContext, datumArray[i2]);
            }
        } else {
            n2 += pickleContext.writeCollImageHeader(oracleArray.getLocator());
        }
        pickleContext.patchImageLen(n3, n2);
        return n2;
    }

    OracleArray unpickle81(PickleContext pickleContext, OracleArray oracleArray, int n2, int n3, Map map) throws SQLException {
        return this.unpickle81(pickleContext, oracleArray, 1L, -1, n2, n3, map);
    }

    OracleArray unpickle81(PickleContext pickleContext, OracleArray oracleArray, long l2, int n2, int n3, int n4, Map map) throws SQLException {
        OracleArray oracleArray2 = oracleArray;
        if (oracleArray2 == null) {
            ArrayDescriptor arrayDescriptor = this.createArrayDescriptor();
            oracleArray2 = new ARRAY(arrayDescriptor, (byte[])null, this.connection);
        }
        if (this.unpickle81ImgHeader(pickleContext, oracleArray2, n3, n4)) {
            this.collectionFlag = pickleContext.readByte();
            pickleContext.setCollectionUserCode(this.collectionFlag);
            if (l2 == 1L && n2 == -1) {
                this.unpickle81ImgBody(pickleContext, oracleArray2, n4, map);
            } else {
                this.unpickle81ImgBody(pickleContext, oracleArray2, l2, n2, n4, map);
            }
        }
        return oracleArray2;
    }

    boolean unpickle81ImgHeader(PickleContext pickleContext, OracleArray oracleArray, int n2, int n3) throws SQLException {
        boolean bl = true;
        if (n2 == 3) {
            oracleArray.setImage(pickleContext.image(), pickleContext.absoluteOffset(), 0L);
        }
        byte by = pickleContext.readByte();
        if (!PickleContext.is81format(by)) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Image is not in 8.1 format").fillInStackTrace();
        }
        if (!PickleContext.hasPrefix(by)) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Image has no prefix segment").fillInStackTrace();
        }
        if (PickleContext.isCollectionImage_pctx(by)) {
            bl = true;
        } else if (PickleContext.isDegenerateImage_pctx(by)) {
            bl = false;
        } else {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Image is not a collection image").fillInStackTrace();
        }
        pickleContext.readByte();
        if (n2 == 9) {
            pickleContext.skipBytes(pickleContext.readLength(true) - 2);
            return false;
        }
        if (n2 == 3) {
            long l2 = pickleContext.readLength();
            oracleArray.setImageLength(l2);
            pickleContext.skipTo(oracleArray.getImageOffset() + l2);
            return false;
        }
        pickleContext.skipLength();
        int n4 = pickleContext.readLength();
        oracleArray.setPrefixFlag(pickleContext.readByte());
        if (oracleArray.isInline()) {
            pickleContext.readDataValue(n4 - 1);
        } else {
            oracleArray.setLocator(pickleContext.readDataValue(n4 - 1));
        }
        return oracleArray.isInline();
    }

    void unpickle81ImgBody(PickleContext pickleContext, OracleArray oracleArray, long l2, int n2, int n3, Map map) throws SQLException {
        boolean bl;
        int n4 = pickleContext.readLength();
        oracleArray.setLength(n4);
        if (n3 == 0) {
            return;
        }
        int n5 = (int)this.getAccessLength(n4, l2, n2);
        boolean bl2 = bl = ArrayDescriptor.getCacheStyle(oracleArray) == 1;
        if (l2 > 1L && n5 > 0) {
            long l3 = oracleArray.getLastIndex();
            if (l3 < l2) {
                if (l3 > 0L) {
                    pickleContext.skipTo(oracleArray.getLastOffset());
                } else {
                    l3 = 1L;
                }
                if (bl) {
                    for (long i2 = l3; i2 < l2; ++i2) {
                        oracleArray.setIndexOffset(i2, pickleContext.offset());
                        this.elementType.unpickle81rec(pickleContext, 9, null);
                    }
                } else {
                    for (long i3 = l3; i3 < l2; ++i3) {
                        this.elementType.unpickle81rec(pickleContext, 9, null);
                    }
                }
            } else if (l3 > l2) {
                long l4 = oracleArray.getOffset(l2);
                if (l4 != -1L) {
                    pickleContext.skipTo(l4);
                } else if (bl) {
                    int n6 = 1;
                    while ((long)n6 < l2) {
                        oracleArray.setIndexOffset(n6, pickleContext.offset());
                        this.elementType.unpickle81rec(pickleContext, 9, null);
                        ++n6;
                    }
                } else {
                    int n7 = 1;
                    while ((long)n7 < l2) {
                        this.elementType.unpickle81rec(pickleContext, 9, null);
                        ++n7;
                    }
                }
            } else {
                pickleContext.skipTo(oracleArray.getLastOffset());
            }
            oracleArray.setLastIndexOffset(l2, pickleContext.offset());
        }
        this.unpickle81ImgBodyElements(pickleContext, oracleArray, (int)l2, n5, n3, map);
    }

    void unpickle81ImgBody(PickleContext pickleContext, OracleArray oracleArray, int n2, Map map) throws SQLException {
        int n3 = pickleContext.readLength();
        oracleArray.setLength(n3);
        if (n2 == 0) {
            return;
        }
        this.unpickle81ImgBodyElements(pickleContext, oracleArray, 1, n3, n2, map);
    }

    private void unpickle81ImgBodyElements(PickleContext pickleContext, OracleArray oracleArray, int n2, int n3, int n4, Map map) throws SQLException {
        boolean bl = ArrayDescriptor.getCacheStyle(oracleArray) == 1;
        switch (n4) {
            case 1: {
                Datum[] datumArray = new Datum[n3];
                if (bl) {
                    for (int i2 = 0; i2 < n3; ++i2) {
                        oracleArray.setIndexOffset(n2 + i2, pickleContext.offset());
                        datumArray[i2] = (Datum)this.elementType.unpickle81rec(pickleContext, n4, map);
                    }
                } else {
                    for (int i3 = 0; i3 < n3; ++i3) {
                        datumArray[i3] = (Datum)this.elementType.unpickle81rec(pickleContext, n4, map);
                    }
                }
                oracleArray.setDatumArray(datumArray);
                break;
            }
            case 2: {
                Object[] objectArray = ArrayDescriptor.makeJavaArray(n3, this.elementType.getTypeCode());
                HashMap<Integer, Object> hashMap = null;
                if (this.userCode == 1) {
                    hashMap = new HashMap<Integer, Object>();
                }
                if (bl) {
                    for (int i4 = 0; i4 < n3; ++i4) {
                        if (this.collectionFlag == PickleContext.KOPI20_CF_INDX) {
                            Integer n5 = new Integer((int)pickleContext.readUB4());
                            oracleArray.setIndexOffset(n2 + i4, pickleContext.offset());
                            objectArray[i4] = this.elementType.unpickle81rec(pickleContext, n4, map);
                            if (hashMap == null) continue;
                            hashMap.put(n5, objectArray[i4]);
                            continue;
                        }
                        oracleArray.setIndexOffset(n2 + i4, pickleContext.offset());
                        objectArray[i4] = this.elementType.unpickle81rec(pickleContext, n4, map);
                    }
                } else {
                    for (int i5 = 0; i5 < n3; ++i5) {
                        if (this.collectionFlag == PickleContext.KOPI20_CF_INDX) {
                            Integer n6 = new Integer((int)pickleContext.readUB4());
                            objectArray[i5] = this.elementType.unpickle81rec(pickleContext, n4, map);
                            if (hashMap == null) continue;
                            hashMap.put(n6, objectArray[i5]);
                            continue;
                        }
                        objectArray[i5] = this.elementType.unpickle81rec(pickleContext, n4, map);
                    }
                }
                oracleArray.setObjArray(objectArray);
                oracleArray.setJavaMap(hashMap);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                if (this.elementType instanceof OracleTypeNUMBER || this.elementType instanceof OracleTypeFLOAT) {
                    oracleArray.setObjArray(OracleTypeNUMBER.unpickle81NativeArray(pickleContext, 1L, n3, n4));
                    break;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23, "This feature is limited to numeric collection").fillInStackTrace();
            }
            default: {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "Invalid conversion type " + this.elementType).fillInStackTrace();
            }
        }
        oracleArray.setLastIndexOffset(n2 + n3, pickleContext.offset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCollElemTypeName() throws SQLException {
        if (this.connection == null) {
            return;
        }
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            if (this.sqlName == null) {
                this.getFullName();
            }
            Statement statement = null;
            Statement statement2 = null;
            ResultSet resultSet = null;
            this.connection.beginNonRequestCalls();
            try {
                int n2;
                int n3 = n2 = this.sqlName.getSchema().equalsIgnoreCase(this.connection.getDefaultSchemaNameForNamedTypes()) ? 0 : 7;
                while (n2 != 11) {
                    switch (n2) {
                        case 0: {
                            statement2 = this.connection.prepareStatement(this.getSqlHint() + sqlString[n2]);
                            statement2.setString(1, this.sqlName.getSimpleName());
                            statement2.setFetchSize(1);
                            resultSet = statement2.executeQuery();
                            n2 = 5;
                            break;
                        }
                        case 1: {
                            if (this.connection.getVersionNumber() >= 10000) {
                                n2 = 2;
                            }
                        }
                        case 2: {
                            statement = (OracleCallableStatement)this.connection.prepareCall(this.getSqlHint() + sqlString[n2]);
                            statement.setString(1, this.sqlName.getSimpleName());
                            statement.setString(3, this.sqlName.getSimpleName());
                            statement.registerOutParameter(2, -10);
                            statement.execute();
                            resultSet = ((OracleCallableStatement)statement).getCursor(2);
                            resultSet.setFetchSize(1);
                            n2 = 3;
                            break;
                        }
                        case 3: {
                            if (this.connection.getVersionNumber() >= 10000) {
                                n2 = 4;
                            }
                        }
                        case 4: {
                            statement2 = this.connection.prepareStatement(this.getSqlHint() + sqlString[n2]);
                            statement2.setString(1, this.sqlName.getSimpleName());
                            statement2.setString(2, this.sqlName.getSimpleName());
                            statement2.setFetchSize(1);
                            resultSet = statement2.executeQuery();
                            n2 = 8;
                            break;
                        }
                        case 5: {
                            if (this.connection.getVersionNumber() >= 10000) {
                                n2 = 6;
                            }
                        }
                        case 6: {
                            statement = (OracleCallableStatement)this.connection.prepareCall(this.getSqlHint() + sqlString[n2]);
                            statement.setString(1, this.sqlName.getSimpleName());
                            statement.setString(3, this.sqlName.getSimpleName());
                            statement.registerOutParameter(2, -10);
                            statement.execute();
                            resultSet = ((OracleCallableStatement)statement).getCursor(2);
                            resultSet.setFetchSize(1);
                            n2 = 1;
                            break;
                        }
                        case 7: {
                            statement2 = this.connection.prepareStatement(this.getSqlHint() + sqlString[n2]);
                            statement2.setString(1, this.sqlName.getSchema());
                            statement2.setString(2, this.sqlName.getSimpleName());
                            statement2.setFetchSize(1);
                            resultSet = statement2.executeQuery();
                            n2 = 8;
                            break;
                        }
                        case 8: {
                            statement2 = this.connection.prepareStatement(this.getSqlHint() + sqlString[n2]);
                            statement2.setString(1, this.sqlName.getSimpleName());
                            statement2.setString(2, this.sqlName.getSimpleName());
                            statement2.setFetchSize(1);
                            resultSet = statement2.executeQuery();
                            n2 = 9;
                            break;
                        }
                        case 9: {
                            if (this.connection.getVersionNumber() >= 10000) {
                                n2 = 10;
                            }
                        }
                        case 10: {
                            statement = this.connection.prepareCall(this.getSqlHint() + sqlString[n2]);
                            statement.setString(1, this.sqlName.getSimpleName());
                            statement.registerOutParameter(2, -10);
                            statement.execute();
                            resultSet = ((OracleCallableStatement)statement).getCursor(2);
                            n2 = 11;
                        }
                    }
                    if (resultSet != null && resultSet.next()) {
                        if (this.attrTypeNames == null) {
                            this.attrTypeNames = new String[1];
                        }
                        this.attrTypeNames[0] = resultSet.getString(2) + "." + resultSet.getString(1);
                        n2 = 11;
                    } else if (n2 == 11) {
                        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1).fillInStackTrace();
                    }
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (statement2 != null) {
                        statement2.close();
                    }
                    if (statement == null) continue;
                    statement.close();
                }
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement2 != null) {
                    statement2.close();
                }
                if (statement != null) {
                    statement.close();
                }
                this.connection.endNonRequestCalls();
            }
        }
    }

    @Override
    public String getAttributeName(int n2) throws SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1).fillInStackTrace();
    }

    @Override
    public String getAttributeName(int n2, boolean bl) throws SQLException {
        return this.getAttributeName(n2);
    }

    @Override
    public String getAttributeType(int n2) throws SQLException {
        if (n2 != 1) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
        }
        if (this.sqlName == null) {
            this.getFullName();
        }
        if (this.attrTypeNames == null) {
            this.initCollElemTypeName();
        }
        return this.attrTypeNames[0];
    }

    @Override
    public String getAttributeType(int n2, boolean bl) throws SQLException {
        if (bl) {
            return this.getAttributeType(n2);
        }
        if (n2 != 1) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
        }
        if (this.sqlName != null && this.attrTypeNames != null) {
            return this.attrTypeNames[0];
        }
        return null;
    }

    @Override
    public int getNumAttrs() throws SQLException {
        return 0;
    }

    @Override
    public OracleType getAttrTypeAt(int n2) throws SQLException {
        return null;
    }

    ArrayDescriptor createArrayDescriptor() throws SQLException {
        return new ArrayDescriptor(this, (Connection)this.connection);
    }

    ArrayDescriptor createArrayDescriptorWithItsOwnTree() throws SQLException {
        if (this.descriptor == null) {
            this.descriptor = this.sqlName == null && this.getFullName(false) == null ? new ArrayDescriptor(this, (Connection)this.connection) : ArrayDescriptor.createDescriptor(this.sqlName, (Connection)this.connection);
        }
        return (ArrayDescriptor)this.descriptor;
    }

    public OracleType getElementType() throws SQLException {
        return this.elementType;
    }

    public int getUserCode() throws SQLException {
        return this.userCode;
    }

    public long getMaxLength() throws SQLException {
        return this.maxSize;
    }

    private long getAccessLength(long l2, long l3, int n2) throws SQLException {
        if (l3 > l2) {
            return 0L;
        }
        if (n2 < 0) {
            return l2 - l3 + 1L;
        }
        return Math.min(l2 - l3 + 1L, (long)n2);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.userCode);
        objectOutputStream.writeLong(this.maxSize);
        objectOutputStream.writeObject(this.elementType);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.userCode = objectInputStream.readInt();
        this.maxSize = objectInputStream.readLong();
        this.elementType = (OracleType)objectInputStream.readObject();
    }

    @Override
    public void setConnection(OracleConnection oracleConnection) throws SQLException {
        this.connection = oracleConnection;
        this.elementType.setConnection(oracleConnection);
    }

    @Override
    public void initMetadataRecursively() throws SQLException {
        this.initMetadata(this.connection);
        if (this.elementType != null) {
            this.elementType.initMetadataRecursively();
        }
    }

    @Override
    public void initChildNamesRecursively(Map map) throws SQLException {
        TypeTreeElement typeTreeElement = (TypeTreeElement)map.get(this.sqlName);
        if (this.elementType != null) {
            this.elementType.setNames(typeTreeElement.getChildSchemaName(0), typeTreeElement.getChildTypeName(0));
            this.elementType.initChildNamesRecursively(map);
            this.elementType.cacheDescriptor();
        }
    }

    @Override
    public void cacheDescriptor() throws SQLException {
        this.descriptor = ArrayDescriptor.createDescriptor(this);
    }

    @Override
    public void printXML(PrintWriter printWriter, int n2) throws SQLException {
        this.printXML(printWriter, n2, false);
    }

    @Override
    public void printXML(PrintWriter printWriter, int n2, boolean bl) throws SQLException {
        int n3;
        for (n3 = 0; n3 < n2; ++n3) {
            printWriter.print("  ");
        }
        printWriter.println("<OracleTypeCOLLECTION sqlName=\"" + this.sqlName + "\" >");
        if (this.elementType != null) {
            this.elementType.printXML(printWriter, n2 + 1, bl);
        }
        for (n3 = 0; n3 < n2; ++n3) {
            printWriter.print("  ");
        }
        printWriter.println("</OracleTypeCOLLECTION>");
    }

    @Override
    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }

    static {
        try {
            $$$methodRef$$$40 = OracleTypeCOLLECTION.class.getDeclaredConstructor(SQLName.class, byte[].class, Integer.TYPE, byte[].class, OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$39 = OracleTypeCOLLECTION.class.getDeclaredConstructor(OracleTypeADT.class, Integer.TYPE, OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$38 = OracleTypeCOLLECTION.class.getDeclaredConstructor(String.class, OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$37 = OracleTypeCOLLECTION.class.getDeclaredMethod("printXML", PrintWriter.class, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$36 = OracleTypeCOLLECTION.class.getDeclaredMethod("printXML", PrintWriter.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$35 = OracleTypeCOLLECTION.class.getDeclaredMethod("cacheDescriptor", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$34 = OracleTypeCOLLECTION.class.getDeclaredMethod("initChildNamesRecursively", Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$33 = OracleTypeCOLLECTION.class.getDeclaredMethod("initMetadataRecursively", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$32 = OracleTypeCOLLECTION.class.getDeclaredMethod("setConnection", OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$31 = OracleTypeCOLLECTION.class.getDeclaredMethod("readObject", ObjectInputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = OracleTypeCOLLECTION.class.getDeclaredMethod("writeObject", ObjectOutputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = OracleTypeCOLLECTION.class.getDeclaredMethod("getAccessLength", Long.TYPE, Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = OracleTypeCOLLECTION.class.getDeclaredMethod("getMaxLength", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = OracleTypeCOLLECTION.class.getDeclaredMethod("getUserCode", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = OracleTypeCOLLECTION.class.getDeclaredMethod("getElementType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = OracleTypeCOLLECTION.class.getDeclaredMethod("createArrayDescriptorWithItsOwnTree", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = OracleTypeCOLLECTION.class.getDeclaredMethod("createArrayDescriptor", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = OracleTypeCOLLECTION.class.getDeclaredMethod("getAttrTypeAt", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = OracleTypeCOLLECTION.class.getDeclaredMethod("getNumAttrs", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = OracleTypeCOLLECTION.class.getDeclaredMethod("getAttributeType", Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = OracleTypeCOLLECTION.class.getDeclaredMethod("getAttributeType", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = OracleTypeCOLLECTION.class.getDeclaredMethod("getAttributeName", Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = OracleTypeCOLLECTION.class.getDeclaredMethod("getAttributeName", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = OracleTypeCOLLECTION.class.getDeclaredMethod("initCollElemTypeName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = OracleTypeCOLLECTION.class.getDeclaredMethod("unpickle81ImgBodyElements", PickleContext.class, OracleArray.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = OracleTypeCOLLECTION.class.getDeclaredMethod("unpickle81ImgBody", PickleContext.class, OracleArray.class, Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = OracleTypeCOLLECTION.class.getDeclaredMethod("unpickle81ImgBody", PickleContext.class, OracleArray.class, Long.TYPE, Integer.TYPE, Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = OracleTypeCOLLECTION.class.getDeclaredMethod("unpickle81ImgHeader", PickleContext.class, OracleArray.class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = OracleTypeCOLLECTION.class.getDeclaredMethod("unpickle81", PickleContext.class, OracleArray.class, Long.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OracleTypeCOLLECTION.class.getDeclaredMethod("unpickle81", PickleContext.class, OracleArray.class, Integer.TYPE, Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OracleTypeCOLLECTION.class.getDeclaredMethod("pickle81", PickleContext.class, Datum.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleTypeCOLLECTION.class.getDeclaredMethod("isInlineImage", byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleTypeCOLLECTION.class.getDeclaredMethod("unlinearizeInternal", byte[].class, Long.TYPE, Datum.class, Long.TYPE, Integer.TYPE, Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleTypeCOLLECTION.class.getDeclaredMethod("unlinearize", byte[].class, Long.TYPE, Datum.class, Long.TYPE, Integer.TYPE, Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleTypeCOLLECTION.class.getDeclaredMethod("unlinearize", byte[].class, Long.TYPE, Datum.class, Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleTypeCOLLECTION.class.getDeclaredMethod("parseTDSrec", TDSReader.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleTypeCOLLECTION.class.getDeclaredMethod("isObjectType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleTypeCOLLECTION.class.getDeclaredMethod("isInHierarchyOf", StructDescriptor.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleTypeCOLLECTION.class.getDeclaredMethod("isInHierarchyOf", OracleType.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleTypeCOLLECTION.class.getDeclaredMethod("getTypeCode", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleTypeCOLLECTION.class.getDeclaredMethod("toDatum", Object.class, OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        sqlString = new String[]{"SELECT ELEM_TYPE_NAME, ELEM_TYPE_OWNER FROM USER_COLL_TYPES WHERE TYPE_NAME = :1", "DECLARE CURSOR usyn_cur IS SELECT table_name from user_synonyms; TYPE table_name_type IS TABLE OF usyn_cur%ROWTYPE; table_names table_name_type; lastrow BINARY_INTEGER := null; l_syntname user_synonyms.table_name%TYPE; BEGIN SELECT TABLE_NAME BULK COLLECT INTO table_names FROM USER_SYNONYMS START WITH SYNONYM_NAME = ? CONNECT BY PRIOR TABLE_NAME = SYNONYM_NAME; IF table_names.LAST IS NOT NULL THEN   lastrow := table_names.LAST;   l_syntname := table_names(lastrow).table_name; END IF; OPEN ? FOR SELECT  ELEM_TYPE_NAME, ELEM_TYPE_OWNER   FROM USER_COLL_TYPES   WHERE (TYPE_NAME = l_syntname OR TYPE_NAME = ?); END;", "DECLARE CURSOR usyn_cur IS SELECT table_name from user_synonyms; TYPE table_name_type IS TABLE OF usyn_cur%ROWTYPE; table_names table_name_type; lastrow BINARY_INTEGER := null; l_syntname user_synonyms.table_name%TYPE; BEGIN SELECT TABLE_NAME BULK COLLECT INTO table_names FROM USER_SYNONYMS START WITH SYNONYM_NAME = ? CONNECT BY NOCYCLE PRIOR TABLE_NAME = SYNONYM_NAME; IF table_names.LAST IS NOT NULL THEN   lastrow := table_names.LAST;   l_syntname := table_names(lastrow).table_name; END IF; OPEN ? FOR SELECT  ELEM_TYPE_NAME, ELEM_TYPE_OWNER   FROM USER_COLL_TYPES   WHERE (TYPE_NAME = l_syntname OR TYPE_NAME = ?); END;", "SELECT ELEM_TYPE_NAME, ELEM_TYPE_OWNER FROM USER_COLL_TYPES WHERE TYPE_NAME IN (SELECT TABLE_NAME FROM ALL_SYNONYMS START WITH SYNONYM_NAME = :1 AND  OWNER = 'PUBLIC' CONNECT BY PRIOR TABLE_NAME = SYNONYM_NAME AND TABLE_OWNER = OWNER UNION SELECT :2  FROM DUAL) ", "SELECT ELEM_TYPE_NAME, ELEM_TYPE_OWNER FROM USER_COLL_TYPES WHERE TYPE_NAME IN (SELECT TABLE_NAME FROM ALL_SYNONYMS START WITH SYNONYM_NAME = :1 AND  OWNER = 'PUBLIC' CONNECT BY NOCYCLE PRIOR TABLE_NAME = SYNONYM_NAME AND TABLE_OWNER = OWNER UNION SELECT :2  FROM DUAL) ", "DECLARE CURSOR usyn_cur IS SELECT table_name from user_synonyms; TYPE table_name_type IS TABLE OF usyn_cur%ROWTYPE; table_names table_name_type; lastrow BINARY_INTEGER := null; l_syntname user_synonyms.table_name%TYPE; BEGIN SELECT TABLE_NAME BULK COLLECT INTO table_names FROM USER_SYNONYMS START WITH SYNONYM_NAME = ? CONNECT BY PRIOR TABLE_NAME = SYNONYM_NAME; IF table_names.LAST IS NOT NULL THEN   lastrow := table_names.LAST;   l_syntname := table_names(lastrow).table_name; END IF; OPEN ? FOR SELECT  ELEM_TYPE_NAME, ELEM_TYPE_OWNER   FROM ALL_COLL_TYPES   WHERE (TYPE_NAME = l_syntname OR TYPE_NAME = ?); END;", "DECLARE CURSOR usyn_cur IS SELECT table_name from user_synonyms; TYPE table_name_type IS TABLE OF usyn_cur%ROWTYPE; table_names table_name_type; lastrow BINARY_INTEGER := null; l_syntname user_synonyms.table_name%TYPE; BEGIN SELECT TABLE_NAME BULK COLLECT INTO table_names FROM USER_SYNONYMS START WITH SYNONYM_NAME = ? CONNECT BY NOCYCLE PRIOR TABLE_NAME = SYNONYM_NAME; IF table_names.LAST IS NOT NULL THEN   lastrow := table_names.LAST;   l_syntname := table_names(lastrow).table_name; END IF; OPEN ? FOR SELECT  ELEM_TYPE_NAME, ELEM_TYPE_OWNER   FROM ALL_COLL_TYPES   WHERE (TYPE_NAME = l_syntname OR TYPE_NAME = ?); END;", "SELECT ELEM_TYPE_NAME, ELEM_TYPE_OWNER FROM ALL_COLL_TYPES WHERE OWNER = :1 AND TYPE_NAME = :2", "SELECT ELEM_TYPE_NAME, ELEM_TYPE_OWNER FROM ALL_COLL_TYPES WHERE OWNER = (SELECT DISTINCT TABLE_OWNER FROM ALL_SYNONYMS WHERE SYNONYM_NAME=:1) AND TYPE_NAME = (SELECT DISTINCT TABLE_NAME FROM ALL_SYNONYMS WHERE SYNONYM_NAME=:2) ", "DECLARE   the_owner VARCHAR2(100);   the_type  VARCHAR2(100); BEGIN  SELECT TABLE_NAME, TABLE_OWNER INTO THE_TYPE, THE_OWNER  FROM ALL_SYNONYMS  WHERE TABLE_NAME IN (SELECT TYPE_NAME FROM ALL_TYPES)  START WITH SYNONYM_NAME = :1 AND OWNER = 'PUBLIC'  CONNECT BY PRIOR TABLE_NAME = SYNONYM_NAME AND TABLE_OWNER = OWNER; OPEN :2 FOR SELECT ELEM_TYPE_NAME, ELEM_TYPE_OWNER FROM ALL_COLL_TYPES  WHERE TYPE_NAME = THE_TYPE and OWNER = THE_OWNER; END;", "DECLARE   the_owner VARCHAR2(100);   the_type  VARCHAR2(100); BEGIN  SELECT TABLE_NAME, TABLE_OWNER INTO THE_TYPE, THE_OWNER  FROM ALL_SYNONYMS  WHERE TABLE_NAME IN (SELECT TYPE_NAME FROM ALL_TYPES)  START WITH SYNONYM_NAME = :1 AND OWNER = 'PUBLIC'  CONNECT BY NOCYCLE PRIOR TABLE_NAME = SYNONYM_NAME AND TABLE_OWNER = OWNER; OPEN :2 FOR SELECT ELEM_TYPE_NAME, ELEM_TYPE_OWNER FROM ALL_COLL_TYPES  WHERE TYPE_NAME = THE_TYPE and OWNER = THE_OWNER; END;"};
    }
}

