/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.security.MessageDigest;
import java.sql.SQLException;
import java.util.logging.Logger;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.sql.CharacterSet;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class SimpleByteArray
extends ByteArray {
    protected byte[] bytes;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;

    protected SimpleByteArray(byte[] byArray) {
        this.setBytes(byArray);
    }

    void setBytes(byte[] byArray) {
        this.bytes = byArray;
    }

    @Override
    long length() {
        return this.bytes.length;
    }

    @Override
    void put(long l2, byte by) {
        assert (l2 >= 0L && l2 < (long)this.bytes.length) : "index = " + l2 + " length = " + this.bytes.length;
        this.bytes[(int)l2] = by;
    }

    @Override
    byte get(long l2) {
        assert (l2 >= 0L && l2 < (long)this.bytes.length) : "index = " + l2 + " length = " + this.bytes.length;
        return this.bytes[(int)l2];
    }

    @Override
    void put(long l2, byte[] byArray, int n2, int n3) {
        assert (l2 >= 0L && l2 + (long)n3 < (long)this.bytes.length) : "offset = " + l2 + " length = " + n3 + " bytes.length = " + this.bytes.length;
        assert (n2 >= 0 && n2 + n3 < byArray.length) : "srcOffset = " + n2 + " length = " + n3 + " src.length = " + byArray.length;
        System.arraycopy(byArray, n2, this.bytes, (int)l2, n3);
    }

    @Override
    void get(long l2, byte[] byArray, int n2, int n3) {
        assert (l2 >= 0L && l2 + (long)n3 <= (long)this.bytes.length && n2 >= 0 && n2 + n3 <= byArray.length) : " offset: " + l2 + " bytes.length: " + this.bytes.length + " destOffset: " + n2 + " length: " + n3;
        System.arraycopy(this.bytes, (int)l2, byArray, n2, n3);
    }

    char[] getChars(long l2, int n2, DBConversion dBConversion, int n3, int[] nArray) throws SQLException {
        int n4;
        assert (l2 >= 0L && n2 >= 0 && (long)this.bytes.length >= l2 + (long)n2) : "bytes.length: " + this.bytes.length + " offset: " + l2 + " lengthInBytes: " + n2;
        assert (dBConversion != null) : "conversion is null";
        assert (nArray != null && nArray.length >= 1) : "out_lengthInChars: " + nArray;
        boolean bl = n3 == 2;
        char[] cArray = new char[n2 * dBConversion.cMaxCharSize];
        int[] nArray2 = new int[]{n2};
        nArray[0] = n4 = dBConversion.CHARBytesToJavaChars(this.bytes, (int)l2, cArray, 0, nArray2, cArray.length, bl);
        return cArray;
    }

    @Override
    char[] getChars(long l2, int n2, CharacterSet characterSet, int[] nArray) throws SQLException {
        assert (l2 >= 0L && n2 >= 0) : "offset: " + l2 + " lengthInBytes: " + n2;
        assert ((long)this.bytes.length >= l2 + (long)n2) : "bytes.length: " + this.bytes.length + " offset: " + l2 + " lengthInBytes: " + n2;
        assert (nArray != null && nArray.length > 0) : "out_lengthInChars: " + nArray;
        String string = characterSet.toString(this.bytes, (int)l2, n2);
        char[] cArray = string.toCharArray();
        nArray[0] = cArray.length;
        return cArray;
    }

    @Override
    long updateChecksum(long l2, int n2, CRC64 cRC64, long l3) {
        return CRC64.updateChecksum(l3, this.bytes, (int)l2, n2);
    }

    @Override
    void updateDigest(MessageDigest messageDigest, long l2, int n2) {
        assert (l2 >= 0L && l2 + (long)n2 <= (long)this.bytes.length) : " valOffset: " + l2 + " bytes.length: " + this.bytes.length + " valLen: " + n2;
        messageDigest.update(this.bytes, (int)l2, n2);
    }

    @Override
    byte[] getBlockBasic(long l2, int[] nArray) {
        nArray[0] = (int)l2;
        return l2 < (long)this.bytes.length ? this.bytes : null;
    }

    @Override
    void free() {
    }

    @Override
    long getCapacity() {
        return this.bytes.length;
    }

    static {
        try {
            $$$methodRef$$$13 = SimpleByteArray.class.getDeclaredConstructor(byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = SimpleByteArray.class.getDeclaredMethod("getCapacity", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = SimpleByteArray.class.getDeclaredMethod("free", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = SimpleByteArray.class.getDeclaredMethod("getBlockBasic", Long.TYPE, int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = SimpleByteArray.class.getDeclaredMethod("updateDigest", MessageDigest.class, Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = SimpleByteArray.class.getDeclaredMethod("updateChecksum", Long.TYPE, Integer.TYPE, CRC64.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = SimpleByteArray.class.getDeclaredMethod("getChars", Long.TYPE, Integer.TYPE, CharacterSet.class, int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = SimpleByteArray.class.getDeclaredMethod("getChars", Long.TYPE, Integer.TYPE, DBConversion.class, Integer.TYPE, int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = SimpleByteArray.class.getDeclaredMethod("get", Long.TYPE, byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = SimpleByteArray.class.getDeclaredMethod("put", Long.TYPE, byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = SimpleByteArray.class.getDeclaredMethod("get", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = SimpleByteArray.class.getDeclaredMethod("put", Long.TYPE, Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = SimpleByteArray.class.getDeclaredMethod("length", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = SimpleByteArray.class.getDeclaredMethod("setBytes", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

