/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.StringWriter;
import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Logger;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleDataFactory;
import oracle.jdbc.OracleTypeMetaData;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.sql.CustomDatumFactory;
import oracle.sql.Datum;
import oracle.sql.DatumWithConnection;
import oracle.sql.ORADataFactory;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.OBJECT_DATUM})
public class OracleStruct
extends DatumWithConnection
implements oracle.jdbc.internal.OracleStruct {
    StructDescriptor descriptor;
    Datum[] datumArray;
    Object[] objectArray;
    boolean enableLocalCache = false;
    long imageOffset;
    long imageLength;
    Object acProxy;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;

    public OracleStruct(StructDescriptor structDescriptor, Connection connection, Object[] objectArray) throws SQLException {
        OracleStruct.assertNotNull(structDescriptor);
        this.descriptor = structDescriptor;
        OracleStruct.assertNotNull(connection);
        if (!structDescriptor.getInternalConnection().isDescriptorSharable(((OracleConnection)connection).physicalConnectionWithin())) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Cannot construct STRUCT instance, invalid connection").fillInStackTrace();
        }
        structDescriptor.setConnection(connection);
        if (!this.descriptor.isInstantiable()) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Cannot construct STRUCT instance for a non-instantiable object type").fillInStackTrace();
        }
        this.setPhysicalConnectionOf(connection);
        this.datumArray = objectArray != null ? this.descriptor.toArray(objectArray) : new Datum[this.descriptor.getLength()];
    }

    public OracleStruct(StructDescriptor structDescriptor, Connection connection, Map map) throws SQLException {
        OracleStruct.assertNotNull(structDescriptor);
        this.descriptor = structDescriptor;
        OracleStruct.assertNotNull(connection);
        if (!structDescriptor.getInternalConnection().isDescriptorSharable(((OracleConnection)connection).physicalConnectionWithin())) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Cannot construct STRUCT instance, invalid connection").fillInStackTrace();
        }
        structDescriptor.setConnection(connection);
        if (!this.descriptor.isInstantiable()) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Cannot construct STRUCT instance for a non-instantiable object type").fillInStackTrace();
        }
        this.setPhysicalConnectionOf(connection);
        this.datumArray = this.descriptor.toOracleArray(map);
    }

    public OracleStruct(StructDescriptor structDescriptor, byte[] byArray, Connection connection) throws SQLException {
        super(byArray);
        OracleStruct.assertNotNull(structDescriptor);
        this.descriptor = structDescriptor;
        OracleStruct.assertNotNull(connection);
        if (!structDescriptor.getInternalConnection().isDescriptorSharable(((OracleConnection)connection).physicalConnectionWithin())) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Cannot construct STRUCT instance, invalid connection").fillInStackTrace();
        }
        structDescriptor.setConnection(connection);
        this.setPhysicalConnectionOf(connection);
        this.datumArray = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSQLTypeName() throws SQLException {
        oracle.jdbc.internal.OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            return this.descriptor.getName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] getAttributes() throws SQLException {
        oracle.jdbc.internal.OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            Object[] objectArray = this.getAttributes(this.getMap());
            return objectArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getAttributes(Map map) throws SQLException {
        oracle.jdbc.internal.OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            return this.descriptor.toArray(this, this, map, this.enableLocalCache);
        }
    }

    @Override
    public OracleTypeMetaData getOracleMetaData() throws SQLException {
        return this.getDescriptor();
    }

    @Override
    public StructDescriptor getDescriptor() throws SQLException {
        return this.descriptor;
    }

    @Override
    public void setDescriptor(StructDescriptor structDescriptor) {
        this.descriptor = structDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Datum[] getOracleAttributes() throws SQLException {
        oracle.jdbc.internal.OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            return this.descriptor.toOracleArray(this, this, this.enableLocalCache);
        }
    }

    @Override
    public Map getMap() {
        Map map = null;
        try {
            map = this.getInternalConnection().getTypeMap();
        }
        catch (SQLException sQLException) {
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] toBytes() throws SQLException {
        oracle.jdbc.internal.OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            return this.descriptor.toBytes(this, this, this.enableLocalCache);
        }
    }

    @Override
    public void setDatumArray(Datum[] datumArray) {
        try {
            this.datumArray = datumArray == null ? new Datum[this.descriptor.getLength()] : datumArray;
        }
        catch (SQLException sQLException) {
        }
    }

    @Override
    public Datum[] getDatumArray() {
        return this.datumArray;
    }

    @Override
    public void setNullDatumArray() {
        this.datumArray = null;
    }

    @Override
    public Object[] getObjectArray() {
        return this.objectArray;
    }

    @Override
    public void setNullObjectArray() {
        this.objectArray = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setObjArray(Object[] objectArray) throws SQLException {
        oracle.jdbc.internal.OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            this.objectArray = objectArray == null ? new Object[]{} : objectArray;
        }
    }

    @Override
    public Object toJdbc() throws SQLException {
        Map map = this.getMap();
        return this.toJdbc(map);
    }

    @Override
    public Object toJdbc(Map map) throws SQLException {
        Class clazz;
        Object object = this;
        if (map != null && (clazz = this.descriptor.getClass(map)) != null) {
            object = this.toClass(clazz, map);
        }
        return object;
    }

    @Override
    public Object toClass(Class clazz) throws SQLException {
        return this.toClass(clazz, this.getMap());
    }

    @Override
    public Object toClass(Class clazz, Map map) throws SQLException {
        Object object;
        block8: {
            object = null;
            try {
                if (clazz == null || clazz == STRUCT.class || clazz == Struct.class || clazz == oracle.jdbc.OracleStruct.class || clazz == oracle.jdbc.internal.OracleStruct.class) {
                    object = this;
                    break block8;
                }
                Object t2 = clazz.newInstance();
                if (t2 instanceof SQLData) {
                    ((SQLData)t2).readSQL(this.descriptor.toJdbc2SQLInput(this, this, map), this.descriptor.getName());
                    object = t2;
                    break block8;
                }
                if (t2 instanceof ORADataFactory) {
                    ORADataFactory oRADataFactory = (ORADataFactory)t2;
                    object = oRADataFactory.create(this, 2002);
                    break block8;
                }
                if (t2 instanceof OracleDataFactory) {
                    OracleDataFactory oracleDataFactory = (OracleDataFactory)t2;
                    object = oracleDataFactory.create(this, 2002);
                    break block8;
                }
                if (t2 instanceof CustomDatumFactory) {
                    CustomDatumFactory customDatumFactory = (CustomDatumFactory)t2;
                    object = customDatumFactory.create(this, 2002);
                    break block8;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 49, this.descriptor.getName()).fillInStackTrace();
            }
            catch (InstantiationException instantiationException) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 49, "InstantiationException: " + instantiationException.getMessage()).fillInStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 49, "IllegalAccessException: " + illegalAccessException.getMessage()).fillInStackTrace();
            }
        }
        return object;
    }

    @Override
    public boolean isConvertibleTo(Class clazz) {
        return false;
    }

    @Override
    public Object makeJdbcArray(int n2) {
        return new Object[n2];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAutoBuffering(boolean bl) throws SQLException {
        oracle.jdbc.internal.OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            this.enableLocalCache = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getAutoBuffering() throws SQLException {
        oracle.jdbc.internal.OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            return this.enableLocalCache;
        }
    }

    @Override
    public void setImage(byte[] byArray, long l2, long l3) throws SQLException {
        this.setShareBytes(byArray);
        this.imageOffset = l2;
        this.imageLength = l3;
    }

    @Override
    public void setImageLength(long l2) throws SQLException {
        this.imageLength = l2;
    }

    @Override
    public long getImageOffset() {
        return this.imageOffset;
    }

    @Override
    public long getImageLength() {
        return this.imageLength;
    }

    public CustomDatumFactory getFactory(Hashtable hashtable, String string) throws SQLException {
        String string2 = this.getSQLTypeName();
        Object v2 = hashtable.get(string2);
        if (v2 == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Unable to convert a \"" + string2 + "\" to a \"" + string + "\" or a subclass of \"" + string + "\"").fillInStackTrace();
        }
        return (CustomDatumFactory)v2;
    }

    @Override
    public ORADataFactory getORADataFactory(Hashtable hashtable, String string) throws SQLException {
        String string2 = this.getSQLTypeName();
        Object v2 = hashtable.get(string2);
        if (v2 == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Unable to convert a \"" + string2 + "\" to a \"" + string + "\" or a subclass of \"" + string + "\"").fillInStackTrace();
        }
        return (ORADataFactory)v2;
    }

    public OracleDataFactory getOracleDataFactory(Hashtable hashtable, String string) throws SQLException {
        String string2 = this.getSQLTypeName();
        Object v2 = hashtable.get(string2);
        if (v2 == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Unable to convert a \"" + string2 + "\" to a \"" + string + "\" or a subclass of \"" + string + "\"").fillInStackTrace();
        }
        return (OracleDataFactory)v2;
    }

    public String debugString() {
        StringWriter stringWriter = new StringWriter();
        String string = null;
        try {
            StructDescriptor structDescriptor = this.getDescriptor();
            stringWriter.write("name = " + structDescriptor.getName());
            int n2 = structDescriptor.getLength();
            stringWriter.write(" length = " + n2);
            Object[] objectArray = this.getAttributes();
            for (int i2 = 0; i2 < n2; ++i2) {
                stringWriter.write(" attribute[" + i2 + "] = " + objectArray[i2]);
            }
            string = stringWriter.toString();
        }
        catch (SQLException sQLException) {
            string = "StructDescriptor missing or bad";
        }
        return string;
    }

    @Override
    public boolean isInHierarchyOf(String string) throws SQLException {
        return this.descriptor.isInHierarchyOf(string);
    }

    @Override
    public Connection getJavaSqlConnection() throws SQLException {
        return super.getJavaSqlConnection();
    }

    @Override
    public void setACProxy(Object object) {
        this.acProxy = object;
    }

    @Override
    public Object getACProxy() {
        return this.acProxy;
    }

    static {
        try {
            $$$methodRef$$$37 = OracleStruct.class.getDeclaredConstructor(StructDescriptor.class, byte[].class, Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$36 = OracleStruct.class.getDeclaredConstructor(StructDescriptor.class, Connection.class, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$35 = OracleStruct.class.getDeclaredConstructor(StructDescriptor.class, Connection.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$34 = OracleStruct.class.getDeclaredMethod("getACProxy", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$33 = OracleStruct.class.getDeclaredMethod("setACProxy", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$32 = OracleStruct.class.getDeclaredMethod("getJavaSqlConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$31 = OracleStruct.class.getDeclaredMethod("isInHierarchyOf", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = OracleStruct.class.getDeclaredMethod("debugString", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = OracleStruct.class.getDeclaredMethod("getOracleDataFactory", Hashtable.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = OracleStruct.class.getDeclaredMethod("getORADataFactory", Hashtable.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = OracleStruct.class.getDeclaredMethod("getFactory", Hashtable.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = OracleStruct.class.getDeclaredMethod("getImageLength", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = OracleStruct.class.getDeclaredMethod("getImageOffset", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = OracleStruct.class.getDeclaredMethod("setImageLength", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = OracleStruct.class.getDeclaredMethod("setImage", byte[].class, Long.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = OracleStruct.class.getDeclaredMethod("getAutoBuffering", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = OracleStruct.class.getDeclaredMethod("setAutoBuffering", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = OracleStruct.class.getDeclaredMethod("makeJdbcArray", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = OracleStruct.class.getDeclaredMethod("isConvertibleTo", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = OracleStruct.class.getDeclaredMethod("toClass", Class.class, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = OracleStruct.class.getDeclaredMethod("toClass", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = OracleStruct.class.getDeclaredMethod("toJdbc", Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = OracleStruct.class.getDeclaredMethod("toJdbc", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = OracleStruct.class.getDeclaredMethod("setObjArray", Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = OracleStruct.class.getDeclaredMethod("setNullObjectArray", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = OracleStruct.class.getDeclaredMethod("getObjectArray", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OracleStruct.class.getDeclaredMethod("setNullDatumArray", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OracleStruct.class.getDeclaredMethod("getDatumArray", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleStruct.class.getDeclaredMethod("setDatumArray", Datum[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleStruct.class.getDeclaredMethod("toBytes", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleStruct.class.getDeclaredMethod("getMap", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleStruct.class.getDeclaredMethod("getOracleAttributes", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleStruct.class.getDeclaredMethod("setDescriptor", StructDescriptor.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleStruct.class.getDeclaredMethod("getDescriptor", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleStruct.class.getDeclaredMethod("getOracleMetaData", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleStruct.class.getDeclaredMethod("getAttributes", Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleStruct.class.getDeclaredMethod("getAttributes", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleStruct.class.getDeclaredMethod("getSQLTypeName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

