/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa.client;

import java.io.Serializable;
import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.T2CConnection;
import oracle.jdbc.driver.T4CXAConnection;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.pool.OraclePooledConnection;
import oracle.jdbc.xa.OracleXAConnectionBuilderImpl;
import oracle.jdbc.xa.client.OracleXAConnection;
import oracle.jdbc.xa.client.OracleXAHeteroCloseCallback;
import oracle.jdbc.xa.client.OracleXAHeteroConnection;
import org.ietf.jgss.GSSCredential;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.XA})
public class OracleXADataSource
extends oracle.jdbc.xa.OracleXADataSource {
    private static final boolean DEBUG = false;
    private int rmid = -1;
    private String xaOpenString = null;
    private static boolean libraryLoaded;
    private static final String dbSuffix = "HeteroXA";
    private static final String dllName = "heteroxa19";
    private static final char atSignChar = '@';
    private static int rmidSeed;
    private static final int MAX_RMID_SEED = 65536;
    private String driverCharSetIdString = null;
    private String oldTnsEntry = null;
    private static final String _Copyright_2014_Oracle_All_Rights_Reserved_;
    public static final String BUILD_DATE = "Sun_Mar_07_03:03:46_PST_2021";
    public static boolean TRACE;
    private static Logger LOGGER;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;

    public OracleXADataSource() throws SQLException {
        this.isOracleDataSource = true;
    }

    @Override
    public XAConnection getXAConnection() throws SQLException {
        Properties properties = new Properties(this.connectionProperties);
        if (this.user != null && this.password != null) {
            properties.setProperty("user", this.user);
            properties.setProperty("password", this.password.get());
        }
        return this.getXAConnection(properties);
    }

    @Override
    public XAConnection getXAConnection(String string, @Blind String string2) throws SQLException {
        Properties properties = new Properties(this.connectionProperties);
        if (string == null || string2 == null) {
            throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
        }
        properties.setProperty("user", string);
        properties.setProperty("password", string2);
        return this.getXAConnection(properties);
    }

    @Override
    public XAConnection getXAConnection(Properties properties) throws SQLException {
        if (this.connCachingEnabled) {
            throw (SQLException)DatabaseError.createSqlException(163).fillInStackTrace();
        }
        return (XAConnection)this.getPooledConnection(properties);
    }

    public XAConnection getXAConnection(OracleXAConnectionBuilderImpl oracleXAConnectionBuilderImpl) throws SQLException {
        String string;
        Properties properties = new Properties(this.connectionProperties);
        if (oracleXAConnectionBuilderImpl.getUser() != null && oracleXAConnectionBuilderImpl.getPassword() != null) {
            properties.setProperty("user", oracleXAConnectionBuilderImpl.getUser());
            properties.setProperty("password", oracleXAConnectionBuilderImpl.getPassword());
        }
        if (oracleXAConnectionBuilderImpl.getServiceName() != null) {
            properties.setProperty("oracle.jdbc.targetServiceName", oracleXAConnectionBuilderImpl.getServiceName());
        }
        if (oracleXAConnectionBuilderImpl.getShardingKey() != null) {
            string = oracleXAConnectionBuilderImpl.getShardingKey().encodeKeyinB64Format();
            properties.setProperty("oracle.jdbc.targetShardingKey", string);
        }
        if (oracleXAConnectionBuilderImpl.getSuperShardingKey() != null) {
            string = oracleXAConnectionBuilderImpl.getSuperShardingKey().encodeKeyinB64Format();
            properties.setProperty("oracle.jdbc.targetSuperShardingKey", string);
        }
        return (XAConnection)this.getPooledConnection(properties, oracleXAConnectionBuilderImpl.getGSSCredential(), oracleXAConnectionBuilderImpl.getSSLContext());
    }

    @Override
    public OracleXAConnectionBuilderImpl createXAConnectionBuilder() {
        return new OracleXAConnectionBuilderImpl(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            public oracle.jdbc.datasource.OracleXAConnection build() throws SQLException {
                if (this.gssCredential != null && (this.user != null || this.password != null)) {
                    throw (SQLException)DatabaseError.createSqlException(1702).fillInStackTrace();
                }
                return (OracleXAConnection)OracleXADataSource.this.getXAConnection(this);
            }

            static {
                try {
                    $$$methodRef$$$1 = 1.class.getDeclaredConstructor(OracleXADataSource.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 1.class.getDeclaredMethod("build", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        };
    }

    @Override
    public PooledConnection getPooledConnection(String string, @Blind String string2) throws SQLException {
        Properties properties = new Properties();
        properties.setProperty("user", string);
        properties.setProperty("password", string2);
        return this.getPooledConnection(properties);
    }

    public PooledConnection getPooledConnection(Properties properties) throws SQLException {
        return this.getPooledConnection(properties, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    PooledConnection getPooledConnection(Properties properties, GSSCredential gSSCredential, SSLContext sSLContext) throws SQLException {
        try {
            String string = this.getURL();
            String string2 = properties.getProperty("user");
            String string3 = properties.getProperty("password");
            String string4 = properties.getProperty("oracle.jdbc.targetInstanceName");
            String string5 = properties.getProperty("oracle.jdbc.targetServiceName");
            String string6 = properties.getProperty("oracle.jdbc.targetShardingKey");
            String string7 = properties.getProperty("oracle.jdbc.targetSuperShardingKey");
            String string8 = null;
            String string9 = null;
            String string10 = null;
            int n2 = 0;
            if (this.useNativeXA && (string.startsWith("jdbc:oracle:oci8") || string.startsWith("jdbc:oracle:oci"))) {
                Class<OracleXADataSource> clazz;
                long[] lArray = new long[]{0L, 0L};
                String string11 = null;
                String string12 = null;
                OracleXADataSource oracleXADataSource = this;
                // MONITORENTER : oracleXADataSource
                string11 = this.tnsEntry != null ? this.tnsEntry : this.getTNSEntryFromUrl(string);
                if (string11 != null) {
                    if (string11.length() == 0) throw (SQLException)DatabaseError.createSqlException(207).fillInStackTrace();
                }
                if (string11.startsWith("(DESCRIPTION")) {
                    throw (SQLException)DatabaseError.createSqlException(207).fillInStackTrace();
                }
                if (!libraryLoaded) {
                    clazz = OracleXADataSource.class;
                    // MONITORENTER : oracle.jdbc.xa.client.OracleXADataSource.class
                    if (!libraryLoaded) {
                        try {
                            System.loadLibrary(dllName);
                            libraryLoaded = true;
                        }
                        catch (Error error) {
                            libraryLoaded = false;
                            throw error;
                        }
                    }
                    // MONITOREXIT : clazz
                }
                if (this.connectionProperties != null) {
                    string12 = this.connectionProperties.getProperty("oracle.jdbc.ociNlsLangBackwardCompatible");
                }
                // MONITOREXIT : oracleXADataSource
                if (string12 != null && string12.equalsIgnoreCase("true")) {
                    short s2 = T2CConnection.getDriverCharSetIdFromNLS_LANG();
                    this.driverCharSetIdString = Integer.toString(s2);
                } else if (!string11.equals(this.oldTnsEntry)) {
                    short s3 = T2CConnection.getClientCharSetId();
                    this.driverCharSetIdString = Integer.toString(s3);
                    this.oldTnsEntry = string11;
                }
                OracleXADataSource oracleXADataSource2 = this;
                // MONITORENTER : oracleXADataSource2
                string8 = this.databaseName + dbSuffix + rmidSeed;
                this.rmid = n2 = rmidSeed;
                clazz = OracleXADataSource.class;
                // MONITORENTER : oracle.jdbc.xa.client.OracleXADataSource.class
                rmidSeed = (rmidSeed + 1) % 65536;
                // MONITOREXIT : clazz
                int n3 = 0;
                Object object = this.connectionProperties != null ? this.connectionProperties.getProperty("oracle.jdbc.XATransLoose") : null;
                this.xaOpenString = string10 = this.generateXAOpenString(string8, string11, string2, string3, 60, 2000, true, true, ".", n3, false, object != null && ((String)object).equalsIgnoreCase("true"), this.driverCharSetIdString, this.driverCharSetIdString);
                string9 = this.generateXACloseString(string8, false);
                // MONITOREXIT : oracleXADataSource2
                int n4 = this.t2cDoXaOpen(string10, n2, 0, 0);
                if (n4 != 0) {
                    throw (SQLException)DatabaseError.createSqlException(null, -1 * n4).fillInStackTrace();
                }
                n4 = this.t2cConvertOciHandles(string8, lArray);
                if (n4 != 0) {
                    throw (SQLException)DatabaseError.createSqlException(null, -1 * n4).fillInStackTrace();
                }
                properties.put("OCISvcCtxHandle", String.valueOf(lArray[0]));
                properties.put("OCIEnvHandle", String.valueOf(lArray[1]));
                properties.put("JDBCDriverCharSetId", this.driverCharSetIdString);
                if (this.loginTimeout != 0) {
                    properties.put("oracle.net.CONNECT_TIMEOUT", "" + this.loginTimeout * 1000);
                }
                Connection connection = this.driver.connect(this.getURL(), properties);
                if (this.maxStatementsSet) {
                    ((OracleConnection)connection).setStatementCacheSize(this.maxStatements);
                }
                if (this.explicitCachingEnabledSet) {
                    ((OracleConnection)connection).setExplicitCachingEnabled(this.explicitCachingEnabled);
                }
                if (this.implicitCachingEnabledSet) {
                    ((OracleConnection)connection).setImplicitCachingEnabled(this.implicitCachingEnabled);
                }
                if (this.maxStatements > 0 && !this.explicitCachingEnabled && !this.implicitCachingEnabled) {
                    ((OracleConnection)connection).setImplicitCachingEnabled(true);
                    ((OracleConnection)connection).setExplicitCachingEnabled(true);
                }
                object = new OracleXAHeteroConnection(connection);
                if (string2 != null && string3 != null) {
                    ((OraclePooledConnection)object).setUserName(string2, string3);
                }
                ((OracleXAHeteroConnection)object).setRmid(n2);
                ((OracleXAHeteroConnection)object).setXaCloseString(string9);
                ((OraclePooledConnection)object).registerCloseCallback(new OracleXAHeteroCloseCallback(), object);
                return object;
            }
            if (this.useNativeXA && string.startsWith("jdbc:oracle:thin")) {
                Properties properties2 = new Properties();
                Serializable serializable = this;
                // MONITORENTER : serializable
                Class<OracleXADataSource> clazz = OracleXADataSource.class;
                // MONITORENTER : oracle.jdbc.xa.client.OracleXADataSource.class
                this.rmid = rmidSeed = (rmidSeed + 1) % 65536;
                // MONITOREXIT : clazz
                if (this.connectionProperties == null) {
                    this.connectionProperties = new Properties();
                }
                this.connectionProperties.put("RessourceManagerId", Integer.toString(this.rmid));
                if (string2 != null) {
                    properties2.setProperty("user", string2);
                }
                if (string3 != null) {
                    properties2.setProperty("password", string3);
                }
                if (this.maxStatementsSet) {
                    properties2.setProperty("stmt_cache_size", "" + this.maxStatements);
                }
                if (this.implicitCachingEnabledSet) {
                    properties2.setProperty("ImplicitStatementCachingEnabled", "" + this.implicitCachingEnabled);
                }
                if (this.explicitCachingEnabledSet) {
                    properties2.setProperty("ExplicitStatementCachingEnabled", "" + this.explicitCachingEnabled);
                }
                if (this.loginTimeout != 0) {
                    properties2.setProperty("LoginTimeout", "" + this.loginTimeout);
                }
                if (string4 != null) {
                    properties2.setProperty("oracle.jdbc.targetInstanceName", string4);
                }
                if (string5 != null) {
                    properties2.setProperty("oracle.jdbc.targetServiceName", string5);
                }
                if (string6 != null) {
                    properties2.setProperty("oracle.jdbc.targetShardingKey", string6);
                }
                if (string7 != null) {
                    properties2.setProperty("oracle.jdbc.targetSuperShardingKey", string7);
                }
                // MONITOREXIT : serializable
                serializable = new T4CXAConnection(super.getPhysicalConnection(properties2, gSSCredential, sSLContext));
                if (string2 != null && string3 != null) {
                    ((OraclePooledConnection)serializable).setUserName(string2, string3);
                }
                clazz = this.connectionProperties != null ? this.connectionProperties.getProperty("oracle.jdbc.XATransLoose") : null;
                ((OracleXAConnection)serializable).isXAResourceTransLoose = clazz != null && (((String)((Object)clazz)).equals("true") || ((String)((Object)clazz)).equalsIgnoreCase("true"));
                return serializable;
            }
            Properties properties3 = new Properties();
            Serializable serializable = this;
            // MONITORENTER : serializable
            if (string2 != null) {
                properties3.setProperty("user", string2);
            }
            if (string3 != null) {
                properties3.setProperty("password", string3);
            }
            if (this.maxStatementsSet) {
                properties3.setProperty("stmt_cache_size", "" + this.maxStatements);
            }
            if (this.implicitCachingEnabledSet) {
                properties3.setProperty("ImplicitStatementCachingEnabled", "" + this.implicitCachingEnabled);
            }
            if (this.explicitCachingEnabledSet) {
                properties3.setProperty("ExplicitStatementCachingEnabled", "" + this.explicitCachingEnabled);
            }
            if (this.loginTimeout != 0) {
                properties3.setProperty("LoginTimeout", "" + this.loginTimeout);
            }
            if (string4 != null) {
                properties3.setProperty("oracle.jdbc.targetInstanceName", string4);
            }
            if (string5 != null) {
                properties3.setProperty("oracle.jdbc.targetServiceName", string5);
            }
            if (string6 != null) {
                properties3.setProperty("oracle.jdbc.targetShardingKey", string6);
            }
            if (string7 != null) {
                properties3.setProperty("oracle.jdbc.targetSuperShardingKey", string7);
            }
            // MONITOREXIT : serializable
            serializable = new OracleXAConnection(super.getPhysicalConnection(properties3, null, null));
            if (string2 != null && string3 != null) {
                ((OraclePooledConnection)serializable).setUserName(string2, string3);
            }
            String string13 = this.connectionProperties != null ? this.connectionProperties.getProperty("oracle.jdbc.XATransLoose") : null;
            ((OracleXAConnection)serializable).isXAResourceTransLoose = string13 != null && (string13.equals("true") || string13.equalsIgnoreCase("true"));
            return serializable;
        }
        catch (XAException xAException) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), xAException);
        }
    }

    private native int t2cDoXaOpen(String var1, int var2, int var3, int var4);

    private native int t2cConvertOciHandles(String var1, long[] var2);

    synchronized void setRmid(int n2) {
        this.rmid = n2;
    }

    synchronized int getRmid() {
        return this.rmid;
    }

    synchronized void setXaOpenString(String string) {
        this.xaOpenString = string;
    }

    synchronized String getXaOpenString() {
        return this.xaOpenString;
    }

    @Blind
    private String generateXAOpenString(String string, String string2, String string3, @Blind String string4, int n2, int n3, boolean bl, boolean bl2, String string5, int n4, boolean bl3, boolean bl4, String string6, String string7) {
        return "ORACLE_XA+DB=" + string + "+ACC=P/" + string3 + "/" + string4 + "+SESTM=" + n3 + "+SESWT=" + n2 + "+LOGDIR=" + string5 + "+SQLNET=" + string2 + (bl ? "+THREADS=true" : "") + (bl2 ? "+OBJECTS=true" : "") + "+DBGFL=0x" + n4 + (bl3 ? "+CONNCACHE=t" : "+CONNCACHE=f") + (bl4 ? "+Loose_Coupling=t" : "") + "+CharSet=" + string6 + "+NCharSet=" + string7;
    }

    private String generateXACloseString(String string, boolean bl) {
        return "ORACLE_XA+DB=" + string + (bl ? "+CONNCACHE=t" : "+CONNCACHE=f");
    }

    private String getTNSEntryFromUrl(String string) {
        int n2 = string.indexOf(64);
        return string.substring(n2 + 1);
    }

    @Override
    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.xa.client");
        }
        return LOGGER;
    }

    static {
        try {
            $$$methodRef$$$17 = OracleXADataSource.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = OracleXADataSource.class.getDeclaredMethod("createXAConnectionBuilder", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = OracleXADataSource.class.getDeclaredMethod("logger", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = OracleXADataSource.class.getDeclaredMethod("getTNSEntryFromUrl", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = OracleXADataSource.class.getDeclaredMethod("generateXACloseString", String.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = OracleXADataSource.class.getDeclaredMethod("generateXAOpenString", String.class, String.class, String.class, String.class, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Boolean.TYPE, String.class, Integer.TYPE, Boolean.TYPE, Boolean.TYPE, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OracleXADataSource.class.getDeclaredMethod("getXaOpenString", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OracleXADataSource.class.getDeclaredMethod("setXaOpenString", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleXADataSource.class.getDeclaredMethod("getRmid", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleXADataSource.class.getDeclaredMethod("setRmid", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleXADataSource.class.getDeclaredMethod("getPooledConnection", Properties.class, GSSCredential.class, SSLContext.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleXADataSource.class.getDeclaredMethod("getPooledConnection", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleXADataSource.class.getDeclaredMethod("getPooledConnection", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleXADataSource.class.getDeclaredMethod("createXAConnectionBuilder", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleXADataSource.class.getDeclaredMethod("getXAConnection", OracleXAConnectionBuilderImpl.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleXADataSource.class.getDeclaredMethod("getXAConnection", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleXADataSource.class.getDeclaredMethod("getXAConnection", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleXADataSource.class.getDeclaredMethod("getXAConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        libraryLoaded = false;
        rmidSeed = 0;
        _Copyright_2014_Oracle_All_Rights_Reserved_ = null;
        TRACE = false;
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.xa.client.OracleXADataSource"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

