/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.lang.reflect.Executable;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;

@DefaultLogger(value="oracle.sql")
@Supports(value={Feature.CHARACTER_PROCESSING})
public class ConverterArchive {
    private String m_izipName;
    private FileOutputStream m_ifStream;
    private ZipOutputStream m_izStream;
    private InputStream m_riStream;
    private ZipFile m_rzipFile;
    private static final String TEMPFILE = "gsstemp.zip";
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;

    public ConverterArchive() {
        boolean bl = ClioSupport.publicEnter() && (0x8000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, ConverterArchive.class, $$$methodRef$$$9, null, new Object[0]);
            }
            this.m_ifStream = null;
            this.m_izStream = null;
            this.m_riStream = null;
            this.m_rzipFile = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, ConverterArchive.class, $$$methodRef$$$9, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, ConverterArchive.class, $$$methodRef$$$9, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, ConverterArchive.class, $$$methodRef$$$9, null, throwable2);
            }
            throw throwable;
        }
    }

    public void openArchiveforInsert(String string) {
        boolean bl = ClioSupport.publicEnter() && (0x8000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, ConverterArchive.class, $$$methodRef$$$0, this, string);
            }
            this.m_izipName = string;
            try {
                this.m_ifStream = new FileOutputStream(this.m_izipName);
                this.m_izStream = new ZipOutputStream(this.m_ifStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, ConverterArchive.class, $$$methodRef$$$0, this);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, ConverterArchive.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, ConverterArchive.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    public void closeArchiveforInsert() {
        boolean bl = ClioSupport.publicEnter() && (0x8000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, ConverterArchive.class, $$$methodRef$$$1, this, new Object[0]);
            }
            try {
                this.m_izStream.close();
                this.m_ifStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, ConverterArchive.class, $$$methodRef$$$1, this);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, ConverterArchive.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, ConverterArchive.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    public void insertObj(Object object, String string) {
        boolean bl = ClioSupport.publicEnter() && (0x8000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, ConverterArchive.class, $$$methodRef$$$2, this, object, string);
            }
            ZipEntry zipEntry = null;
            ObjectOutputStream objectOutputStream = null;
            zipEntry = new ZipEntry(string);
            try {
                this.m_izStream.putNextEntry(zipEntry);
                objectOutputStream = new ObjectOutputStream(this.m_izStream);
                objectOutputStream.writeObject(object);
                objectOutputStream.close();
                this.m_izStream.closeEntry();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, ConverterArchive.class, $$$methodRef$$$2, this);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, ConverterArchive.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, ConverterArchive.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    public void insertSingleObj(String string, Object object, String string2) throws IOException {
        boolean bl = ClioSupport.publicEnter() && (0x8000000000L & TraceControllerImpl.feature) != 0L;
        try {
            block30: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, ConverterArchive.class, $$$methodRef$$$3, this, string, object, string2);
                }
                FileInputStream fileInputStream = null;
                ZipInputStream zipInputStream = null;
                FileOutputStream fileOutputStream = null;
                ZipOutputStream zipOutputStream = null;
                ZipEntry zipEntry = null;
                ObjectInputStream objectInputStream = null;
                ObjectOutputStream objectOutputStream = null;
                File file = new File(string);
                if (file.isFile()) {
                    try {
                        fileInputStream = new FileInputStream(string);
                        zipInputStream = new ZipInputStream(fileInputStream);
                        fileOutputStream = new FileOutputStream(TEMPFILE);
                        zipOutputStream = new ZipOutputStream(fileOutputStream);
                        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                            if (zipEntry.getName().equals(string2)) continue;
                            zipOutputStream.putNextEntry(zipEntry);
                            objectInputStream = new ObjectInputStream(zipInputStream);
                            objectOutputStream = new ObjectOutputStream(zipOutputStream);
                            Object object2 = objectInputStream.readObject();
                            objectOutputStream.writeObject(object2);
                        }
                        zipEntry = new ZipEntry(string2);
                        zipOutputStream.putNextEntry(zipEntry);
                        objectOutputStream = new ObjectOutputStream(zipOutputStream);
                        objectOutputStream.writeObject(object);
                        objectOutputStream.close();
                        zipInputStream.close();
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        IOException iOException = new IOException(fileNotFoundException.getMessage());
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, ConverterArchive.class, $$$methodRef$$$3, this, iOException);
                        }
                        throw iOException;
                    }
                    catch (StreamCorruptedException streamCorruptedException) {
                        IOException iOException = new IOException(streamCorruptedException.getMessage());
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, ConverterArchive.class, $$$methodRef$$$3, this, iOException);
                        }
                        throw iOException;
                    }
                    catch (IOException iOException) {
                        IOException iOException2 = iOException;
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, ConverterArchive.class, $$$methodRef$$$3, this, iOException2);
                        }
                        throw iOException2;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        IOException iOException = new IOException(classNotFoundException.getMessage());
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, ConverterArchive.class, $$$methodRef$$$3, this, iOException);
                        }
                        throw iOException;
                    }
                    File file2 = new File(TEMPFILE);
                    file.delete();
                    try {
                        if (!file2.renameTo(file)) {
                            IOException iOException = new IOException("can't write to target file " + string);
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, ConverterArchive.class, $$$methodRef$$$3, this, iOException);
                            }
                            throw iOException;
                        }
                        break block30;
                    }
                    catch (SecurityException securityException) {
                        IOException iOException = new IOException(securityException.getMessage());
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, ConverterArchive.class, $$$methodRef$$$3, this, iOException);
                        }
                        throw iOException;
                    }
                    catch (NullPointerException nullPointerException) {
                        IOException iOException = new IOException(nullPointerException.getMessage());
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, ConverterArchive.class, $$$methodRef$$$3, this, iOException);
                        }
                        throw iOException;
                    }
                }
                try {
                    fileOutputStream = new FileOutputStream(string);
                    zipOutputStream = new ZipOutputStream(fileOutputStream);
                    zipEntry = new ZipEntry(string2);
                    zipOutputStream.putNextEntry(zipEntry);
                    objectOutputStream = new ObjectOutputStream(zipOutputStream);
                    objectOutputStream.writeObject(object);
                    objectOutputStream.close();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    IOException iOException = new IOException(fileNotFoundException.getMessage());
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, ConverterArchive.class, $$$methodRef$$$3, this, iOException);
                    }
                    throw iOException;
                }
                catch (StreamCorruptedException streamCorruptedException) {
                    IOException iOException = new IOException(streamCorruptedException.getMessage());
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, ConverterArchive.class, $$$methodRef$$$3, this, iOException);
                    }
                    throw iOException;
                }
                catch (IOException iOException) {
                    IOException iOException3 = iOException;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, ConverterArchive.class, $$$methodRef$$$3, this, iOException3);
                    }
                    throw iOException3;
                }
            }
            System.out.print(string2 + " has been successfully stored in ");
            System.out.println(string);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, ConverterArchive.class, $$$methodRef$$$3, this);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, ConverterArchive.class, $$$methodRef$$$3, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, ConverterArchive.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    public void insertObjtoFile(String string, String string2, Object object) throws IOException {
        boolean bl = ClioSupport.publicEnter() && (0x8000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, ConverterArchive.class, $$$methodRef$$$4, this, string, string2, object);
            }
            File file = new File(string);
            File file2 = new File(string + string2);
            if (!file.isDirectory()) {
                IOException iOException = new IOException("directory " + string + " doesn't exist");
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$4, Level.FINEST, ConverterArchive.class, $$$methodRef$$$4, this, iOException);
                }
                throw iOException;
            }
            if (file2.exists()) {
                try {
                    file2.delete();
                }
                catch (SecurityException securityException) {
                    IOException iOException = new IOException("file exist, can't overwrite file.");
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$4, Level.FINEST, ConverterArchive.class, $$$methodRef$$$4, this, iOException);
                    }
                    throw iOException;
                }
            }
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
                objectOutputStream.writeObject(object);
                objectOutputStream.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                IOException iOException = new IOException("file can't be created.");
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$4, Level.FINEST, ConverterArchive.class, $$$methodRef$$$4, this, iOException);
                }
                throw iOException;
            }
            System.out.print(string2 + " has been successfully stored in ");
            System.out.println(string);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, ConverterArchive.class, $$$methodRef$$$4, this);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, ConverterArchive.class, $$$methodRef$$$4, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, ConverterArchive.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    public void openArchiveforRead() {
        boolean bl = ClioSupport.publicEnter() && (0x8000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, ConverterArchive.class, $$$methodRef$$$5, this, new Object[0]);
            }
            try {
                this.m_rzipFile = new ZipFile(this.m_izipName);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                System.exit(0);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, ConverterArchive.class, $$$methodRef$$$5, this);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, ConverterArchive.class, $$$methodRef$$$5, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, ConverterArchive.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    public void closeArchiveforRead() {
        boolean bl = ClioSupport.publicEnter() && (0x8000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, ConverterArchive.class, $$$methodRef$$$6, this, new Object[0]);
            }
            try {
                this.m_rzipFile.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                System.exit(0);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, ConverterArchive.class, $$$methodRef$$$6, this);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, ConverterArchive.class, $$$methodRef$$$6, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, ConverterArchive.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Object readObj(String string) {
        boolean bl = ClioSupport.publicEnter() && (0x8000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, ConverterArchive.class, $$$methodRef$$$7, this, string);
            }
            URL uRL = this.getClass().getResource(string);
            Object object = null;
            ObjectInputStream objectInputStream = null;
            InputStream inputStream = null;
            if (uRL == null) {
                return null;
            }
            inputStream = uRL.openStream();
            objectInputStream = new ObjectInputStream(inputStream);
            Object object2 = object = objectInputStream.readObject();
            try {
                if (objectInputStream != null) {
                    objectInputStream.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
            }
            return object2;
            catch (IOException iOException) {
                try {
                    if (objectInputStream != null) {
                        objectInputStream.close();
                    }
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException2) {
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                {
                    catch (Throwable throwable) {
                        try {
                            if (objectInputStream != null) {
                                objectInputStream.close();
                            }
                            if (inputStream != null) {
                                inputStream.close();
                            }
                        }
                        catch (IOException iOException2) {
                        }
                        Throwable throwable2 = throwable;
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, ConverterArchive.class, $$$methodRef$$$7, this, throwable2);
                        }
                        throw throwable2;
                    }
                }
                try {
                    if (objectInputStream != null) {
                        objectInputStream.close();
                    }
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException3) {
                }
            }
            return null;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, ConverterArchive.class, $$$methodRef$$$7, this, throwable3);
            }
            throw throwable;
        }
    }

    public Object readObj(String string, String string2) {
        boolean bl = ClioSupport.publicEnter() && (0x8000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, ConverterArchive.class, $$$methodRef$$$8, this, string, string2);
            }
            try {
                FileInputStream fileInputStream = new FileInputStream(string);
                ZipInputStream zipInputStream = new ZipInputStream(fileInputStream);
                ZipEntry zipEntry = null;
                ObjectInputStream objectInputStream = null;
                Object object = null;
                while (zipInputStream.available() != 0) {
                    zipEntry = zipInputStream.getNextEntry();
                    if (zipEntry == null || !zipEntry.getName().equals(string2)) continue;
                    objectInputStream = new ObjectInputStream(zipInputStream);
                    object = objectInputStream.readObject();
                    break;
                }
                zipInputStream.close();
                return object;
            }
            catch (IOException iOException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return null;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, ConverterArchive.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$9 = ConverterArchive.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$8 = ConverterArchive.class.getDeclaredMethod("readObj", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$7 = ConverterArchive.class.getDeclaredMethod("readObj", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$6 = ConverterArchive.class.getDeclaredMethod("closeArchiveforRead", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$5 = ConverterArchive.class.getDeclaredMethod("openArchiveforRead", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$4 = ConverterArchive.class.getDeclaredMethod("insertObjtoFile", String.class, String.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$3 = ConverterArchive.class.getDeclaredMethod("insertSingleObj", String.class, Object.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$2 = ConverterArchive.class.getDeclaredMethod("insertObj", Object.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$1 = ConverterArchive.class.getDeclaredMethod("closeArchiveforInsert", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$0 = ConverterArchive.class.getDeclaredMethod("openArchiveforInsert", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
    }
}

