/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterRepConstants;
import oracle.sql.CharacterSet;
import oracle.sql.CharacterWalker;

@DefaultLogger(value="oracle.sql")
@Supports(value={Feature.CHARACTER_PROCESSING})
class CharacterSetAL16UTF16
extends CharacterSet
implements CharacterRepConstants {
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;

    CharacterSetAL16UTF16(int n2) {
        super(n2);
        this.rep = 4;
    }

    @Override
    public boolean isLossyFrom(CharacterSet characterSet) {
        boolean bl = ClioSupport.publicEnter() && (0x8000000000L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, CharacterSetAL16UTF16.class, $$$methodRef$$$0, this, characterSet);
            }
            boolean bl3 = bl2 = !characterSet.isUnicode();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, CharacterSetAL16UTF16.class, $$$methodRef$$$0, this, bl2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, CharacterSetAL16UTF16.class, $$$methodRef$$$0, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, CharacterSetAL16UTF16.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean isConvertibleFrom(CharacterSet characterSet) {
        boolean bl = ClioSupport.publicEnter() && (0x8000000000L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, CharacterSetAL16UTF16.class, $$$methodRef$$$1, this, characterSet);
            }
            boolean bl3 = bl2 = characterSet.rep <= 1024;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, CharacterSetAL16UTF16.class, $$$methodRef$$$1, this, bl3);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, CharacterSetAL16UTF16.class, $$$methodRef$$$1, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, CharacterSetAL16UTF16.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean isUnicode() {
        boolean bl = ClioSupport.publicEnter() && (0x8000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, CharacterSetAL16UTF16.class, $$$methodRef$$$2, this, new Object[0]);
            }
            boolean bl2 = true;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, CharacterSetAL16UTF16.class, $$$methodRef$$$2, this, bl2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, CharacterSetAL16UTF16.class, $$$methodRef$$$2, this, null);
            }
            return true;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, CharacterSetAL16UTF16.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @DisableTrace
    public String toStringWithReplacement(byte[] byArray, int n2, int n3) {
        try {
            char[] cArray = new char[n3 >>> 1];
            int n4 = CharacterSet.convertAL16UTF16BytesToJavaChars(byArray, n2, cArray, 0, n3, true);
            return new String(cArray, 0, n4);
        }
        catch (SQLException sQLException) {
            return "";
        }
    }

    @Override
    @DisableTrace
    public String toString(byte[] byArray, int n2, int n3) throws SQLException {
        try {
            char[] cArray = new char[n3 >>> 1];
            int n4 = CharacterSet.convertAL16UTF16BytesToJavaChars(byArray, n2, cArray, 0, n3, false);
            return new String(cArray, 0, n4);
        }
        catch (SQLException sQLException) {
            CharacterSetAL16UTF16.failUTFConversion();
            return "";
        }
    }

    @Override
    public byte[] convert(String string) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x8000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, CharacterSetAL16UTF16.class, $$$methodRef$$$3, this, string);
            }
            return CharacterSetAL16UTF16.stringToAL16UTF16Bytes(string);
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, CharacterSetAL16UTF16.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public byte[] convertWithReplacement(String string) {
        boolean bl = ClioSupport.publicEnter() && (0x8000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, CharacterSetAL16UTF16.class, $$$methodRef$$$4, this, string);
            }
            return CharacterSetAL16UTF16.stringToAL16UTF16Bytes(string);
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, CharacterSetAL16UTF16.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public byte[] convert(CharacterSet characterSet, byte[] byArray, int n2, int n3) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x8000000000L & TraceControllerImpl.feature) != 0L;
        try {
            byte[] byArray2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, CharacterSetAL16UTF16.class, $$$methodRef$$$5, this, characterSet, byArray, n2, n3);
            }
            if (characterSet.rep == 4) {
                byArray2 = CharacterSetAL16UTF16.useOrCopy(byArray, n2, n3);
            } else {
                String string = characterSet.toString(byArray, n2, n3);
                byArray2 = CharacterSetAL16UTF16.stringToAL16UTF16Bytes(string);
            }
            return byArray2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, CharacterSetAL16UTF16.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    int decode(CharacterWalker characterWalker) throws SQLException {
        int n2;
        byte[] byArray = characterWalker.bytes;
        int n3 = characterWalker.next;
        int n4 = characterWalker.end;
        if (n3 + 1 >= n4) {
            CharacterSetAL16UTF16.failUTFConversion();
        }
        byte by = byArray[n3++];
        byte by2 = byArray[n3++];
        int n5 = n2 = (int)(by << 8 | by2 & 0xFF);
        if (Character.isHighSurrogate((char)n2)) {
            if (n3 + 1 >= n4) {
                CharacterSetAL16UTF16.failUTFConversion();
            }
            by = byArray[n3++];
            by2 = byArray[n3++];
            char c2 = (char)(by << 8 & 0xFF00 | by2 & 0xFF);
            n5 = Character.toCodePoint((char)n2, c2);
        }
        characterWalker.next = n3;
        return n5;
    }

    @Override
    void encode(CharacterBuffer characterBuffer, int n2) throws SQLException {
        boolean bl = Character.isSupplementaryCodePoint(n2);
        if (n2 > 65535 && !bl) {
            CharacterSetAL16UTF16.failUTFConversion();
        } else if (!bl) {
            CharacterSetAL16UTF16.need(characterBuffer, 2);
            characterBuffer.bytes[characterBuffer.next++] = (byte)(n2 >> 8 & 0xFF);
            characterBuffer.bytes[characterBuffer.next++] = (byte)(n2 & 0xFF);
        } else {
            CharacterSetAL16UTF16.need(characterBuffer, 4);
            char[] cArray = Character.toChars(n2);
            characterBuffer.bytes[characterBuffer.next++] = (byte)(cArray[0] >> 8 & 0xFF);
            characterBuffer.bytes[characterBuffer.next++] = (byte)(cArray[0] & 0xFF);
            characterBuffer.bytes[characterBuffer.next++] = (byte)(cArray[1] >> 8 & 0xFF);
            characterBuffer.bytes[characterBuffer.next++] = (byte)(cArray[1] & 0xFF);
        }
    }

    static {
        try {
            $$$methodRef$$$8 = CharacterSetAL16UTF16.class.getDeclaredConstructor(Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$7 = CharacterSetAL16UTF16.class.getDeclaredMethod("encode", CharacterBuffer.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$6 = CharacterSetAL16UTF16.class.getDeclaredMethod("decode", CharacterWalker.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$5 = CharacterSetAL16UTF16.class.getDeclaredMethod("convert", CharacterSet.class, byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$4 = CharacterSetAL16UTF16.class.getDeclaredMethod("convertWithReplacement", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$3 = CharacterSetAL16UTF16.class.getDeclaredMethod("convert", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$2 = CharacterSetAL16UTF16.class.getDeclaredMethod("isUnicode", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$1 = CharacterSetAL16UTF16.class.getDeclaredMethod("isConvertibleFrom", CharacterSet.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$0 = CharacterSetAL16UTF16.class.getDeclaredMethod("isLossyFrom", CharacterSet.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
    }
}

