/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.sql.CharacterSet;

@DefaultLogger(value="oracle.sql")
@Supports(value={Feature.CHARACTER_PROCESSING})
public final class CharacterBuffer {
    CharacterSet charSet;
    byte[] bytes;
    int next;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;

    public CharacterBuffer(CharacterSet characterSet) {
        boolean bl = ClioSupport.publicEnter() && (0x8000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, CharacterBuffer.class, $$$methodRef$$$2, null, characterSet);
            }
            this.charSet = characterSet;
            this.next = 0;
            this.bytes = new byte[32];
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, CharacterBuffer.class, $$$methodRef$$$2, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, CharacterBuffer.class, $$$methodRef$$$2, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, CharacterBuffer.class, $$$methodRef$$$2, null, throwable2);
            }
            throw throwable;
        }
    }

    public void append(int n2) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x8000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, CharacterBuffer.class, $$$methodRef$$$0, this, n2);
            }
            this.charSet.encode(this, n2);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, CharacterBuffer.class, $$$methodRef$$$0, this);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, CharacterBuffer.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, CharacterBuffer.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    public byte[] getBytes() {
        boolean bl = ClioSupport.publicEnter() && (0x8000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, CharacterBuffer.class, $$$methodRef$$$1, this, new Object[0]);
            }
            return CharacterSet.useOrCopy(this.bytes, 0, this.next);
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, CharacterBuffer.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$2 = CharacterBuffer.class.getDeclaredConstructor(CharacterSet.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$1 = CharacterBuffer.class.getDeclaredMethod("getBytes", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$0 = CharacterBuffer.class.getDeclaredMethod("append", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
    }
}

