/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleConnectionWrapper;
import oracle.jdbc.OracleData;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.InternalFactory;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.oracore.PickleContext;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.BFILE;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CharacterSet;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.DatumWithConnection;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NCLOB;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;
import oracle.sql.TypeDescriptor;
import oracle.xdb.XMLType;

@DefaultLogger(value="oracle.sql")
@Supports(value={Feature.OBJECT_DATUM})
public class ANYDATA
implements ORAData,
OracleData {
    static final byte KAD_VSN = 1;
    static final byte KAD_VSN2 = 2;
    boolean isNull;
    byte[] data;
    TypeDescriptor type;
    boolean isREF;
    short serverCharsetId;
    short serverNCharsetId;
    OracleConnection connection;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;

    ANYDATA(TypeDescriptor typeDescriptor, boolean bl, byte[] byArray, boolean bl2) {
        this.isREF = false;
        this.serverCharsetId = 0;
        this.serverNCharsetId = 0;
        this.type = typeDescriptor;
        this.isNull = bl;
        this.data = byArray;
        this.isREF = bl2;
    }

    public ANYDATA(OPAQUE oPAQUE) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x20000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, ANYDATA.class, $$$methodRef$$$15, null, oPAQUE);
            }
            this.isREF = false;
            this.serverCharsetId = 0;
            this.serverNCharsetId = 0;
            byte[] byArray = oPAQUE.getBytesValue();
            this.connection = oPAQUE.getPhysicalConnection();
            if (this.connection != null) {
                this.serverCharsetId = this.connection.getDbCsId();
                this.serverNCharsetId = this.connection.getNCharSet();
            }
            this.unpickle(byArray, 0);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, ANYDATA.class, $$$methodRef$$$15, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, ANYDATA.class, $$$methodRef$$$15, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, ANYDATA.class, $$$methodRef$$$15, null, throwable2);
            }
            throw throwable;
        }
    }

    int unpickle(byte[] byArray, int n2) throws SQLException {
        int n3;
        PickleContext pickleContext = new PickleContext(byArray, n2);
        byte by = pickleContext.readByte();
        if (by == 2) {
            pickleContext.skipBytes(4);
        }
        short[] sArray = new short[1];
        this.type = TypeDescriptor.unpickleOpaqueTypeImage(pickleContext, this.connection, sArray);
        this.isNull = pickleContext.readByte() != 0;
        if (!this.isNull) {
            n3 = (int)pickleContext.readUB4();
            this.data = pickleContext.readDataValue(n3);
        }
        this.isREF = sArray[0] == 110;
        n3 = pickleContext.offset();
        return n3;
    }

    int pickle(byte[] byArray, int n2) {
        byArray[n2++] = 1;
        n2 = this.type.pickleOpaqueTypeImage(byArray, n2, this.isREF);
        byArray[n2++] = this.isNull ? (byte)1 : 0;
        if (!this.isNull) {
            int n3 = this.data.length;
            byArray[n2++] = (byte)((n3 & 0xFF000000) >> 24 & 0xFF);
            byArray[n2++] = (byte)((n3 & 0xFF0000) >> 16 & 0xFF);
            byArray[n2++] = (byte)((n3 & 0xFF00) >> 8 & 0xFF);
            byArray[n2++] = (byte)(n3 & 0xFF);
            System.arraycopy(this.data, 0, byArray, n2, n3);
            n2 += n3;
        }
        return n2;
    }

    int getImageSize() {
        int n2 = this.type.getOpaqueImageTypeSize() + 1 + 1;
        if (!this.isNull) {
            n2 += 4 + this.data.length;
        }
        return n2;
    }

    @Override
    public Datum toDatum(Connection connection) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x20000000000L & TraceControllerImpl.feature) != 0L;
        try {
            Object object;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, ANYDATA.class, $$$methodRef$$$3, this, connection);
            }
            if (connection instanceof OracleConnectionWrapper) {
                object = ((OracleConnectionWrapper)connection).unwrap();
                this.connection = (OracleConnection)object;
            } else {
                this.connection = (OracleConnection)connection;
            }
            object = OpaqueDescriptor.createDescriptor("SYS.ANYDATA", connection);
            byte[] byArray = new byte[this.getImageSize()];
            this.pickle(byArray, 0);
            OPAQUE oPAQUE = new OPAQUE((OpaqueDescriptor)object, this.connection, byArray);
            oPAQUE.setShareBytes(oPAQUE.toBytes());
            return oPAQUE;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, ANYDATA.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Object toJDBCObject(Connection connection) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x20000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, ANYDATA.class, $$$methodRef$$$4, this, connection);
            }
            return this.toDatum(connection);
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, ANYDATA.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    public static ANYDATA convertDatum(Datum datum) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x20000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, ANYDATA.class, $$$methodRef$$$5, null, datum);
            }
            ANYDATA aNYDATA = null;
            if (datum != null) {
                if (datum instanceof STRUCT) {
                    aNYDATA = new ANYDATA(((STRUCT)datum).getDescriptor(), false, ((STRUCT)datum).toBytes(), false);
                } else if (datum instanceof ARRAY) {
                    aNYDATA = new ANYDATA(((ARRAY)datum).getDescriptor(), false, ((ARRAY)datum).toBytes(), false);
                } else if (datum instanceof REF) {
                    aNYDATA = new ANYDATA(((REF)datum).getDescriptor(), false, ((REF)datum).getBytes(), true);
                } else if (datum instanceof OPAQUE) {
                    aNYDATA = new ANYDATA(((OPAQUE)datum).getDescriptor(), false, ((OPAQUE)datum).toBytes(), false);
                } else {
                    TypeDescriptor typeDescriptor = null;
                    if (datum instanceof NUMBER) {
                        typeDescriptor = new TypeDescriptor(2);
                    } else if (datum instanceof DATE) {
                        typeDescriptor = new TypeDescriptor(12);
                    } else if (datum instanceof INTERVALDS) {
                        typeDescriptor = new TypeDescriptor(190);
                    } else if (datum instanceof INTERVALYM) {
                        typeDescriptor = new TypeDescriptor(189);
                    } else if (datum instanceof TIMESTAMPTZ) {
                        typeDescriptor = new TypeDescriptor(188);
                    } else if (datum instanceof TIMESTAMPLTZ) {
                        typeDescriptor = new TypeDescriptor(232);
                    } else if (datum instanceof TIMESTAMP) {
                        typeDescriptor = new TypeDescriptor(187);
                    } else if (datum instanceof NCLOB) {
                        typeDescriptor = new TypeDescriptor(288);
                    } else if (datum instanceof CLOB) {
                        typeDescriptor = new TypeDescriptor(112);
                    } else if (datum instanceof BLOB) {
                        typeDescriptor = new TypeDescriptor(113);
                    } else if (datum instanceof BFILE) {
                        typeDescriptor = new TypeDescriptor(114);
                    } else if (datum instanceof RAW) {
                        typeDescriptor = new TypeDescriptor(95);
                    } else if (datum instanceof BINARY_DOUBLE) {
                        typeDescriptor = new TypeDescriptor(101);
                    } else if (datum instanceof BINARY_FLOAT) {
                        typeDescriptor = new TypeDescriptor(100);
                    } else if (datum instanceof ROWID) {
                        typeDescriptor = new TypeDescriptor(104);
                    } else if (datum instanceof CHAR) {
                        typeDescriptor = ((CHAR)datum).isVariableLength() ? new TypeDescriptor(9) : new TypeDescriptor(96);
                    }
                    if (datum instanceof ROWID) {
                        byte[] byArray = datum.shareBytes();
                        long[] lArray = InternalFactory.rowid2urowid(byArray, 0, byArray.length);
                        byte[] byArray2 = new byte[]{1, (byte)((lArray[0] & 0xFFFFFFFFFF000000L) >> 24), (byte)((lArray[0] & 0xFF0000L) >> 16), (byte)((lArray[0] & 0xFF00L) >> 8), (byte)(lArray[0] & 0xFFL), (byte)((lArray[1] & 0xFF00L) >> 8), (byte)(lArray[1] & 0xFFL), (byte)((lArray[2] & 0xFFFFFFFFFF000000L) >> 24), (byte)((lArray[2] & 0xFF0000L) >> 16), (byte)((lArray[2] & 0xFF00L) >> 8), (byte)(lArray[2] & 0xFFL), (byte)((lArray[3] & 0xFF00L) >> 8), (byte)(lArray[3] & 0xFFL)};
                        aNYDATA = new ANYDATA(typeDescriptor, false, byArray2, false);
                    } else {
                        aNYDATA = new ANYDATA(typeDescriptor, false, datum.shareBytes(), false);
                    }
                }
                if (datum instanceof DatumWithConnection) {
                    aNYDATA.connection = ((DatumWithConnection)datum).getInternalConnection();
                }
            }
            return aNYDATA;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, ANYDATA.class, $$$methodRef$$$5, null, throwable2);
            }
            throw throwable;
        }
    }

    public TypeDescriptor getTypeDescriptor() {
        boolean bl = ClioSupport.publicEnter() && (0x20000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, ANYDATA.class, $$$methodRef$$$6, this, new Object[0]);
            }
            return this.type;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, ANYDATA.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    public boolean isNull() {
        boolean bl = ClioSupport.publicEnter() && (0x20000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, ANYDATA.class, $$$methodRef$$$7, this, new Object[0]);
            }
            boolean bl2 = this.isNull;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, ANYDATA.class, $$$methodRef$$$7, this, bl2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, ANYDATA.class, $$$methodRef$$$7, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, ANYDATA.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    public byte[] getData() {
        boolean bl = ClioSupport.publicEnter() && (0x20000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, ANYDATA.class, $$$methodRef$$$8, this, new Object[0]);
            }
            return this.data;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, ANYDATA.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    public boolean isREF() {
        boolean bl = ClioSupport.publicEnter() && (0x20000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, ANYDATA.class, $$$methodRef$$$9, this, new Object[0]);
            }
            boolean bl2 = this.isREF;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, ANYDATA.class, $$$methodRef$$$9, this, bl2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, ANYDATA.class, $$$methodRef$$$9, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, ANYDATA.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    public String stringValue() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x20000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, ANYDATA.class, $$$methodRef$$$10, this, new Object[0]);
            }
            return this.stringValue(this.connection);
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, ANYDATA.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String stringValue(Connection connection) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x20000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, ANYDATA.class, $$$methodRef$$$11, this, connection);
            }
            String string = null;
            string = "ANYDATA TypeCode: \"" + this.getTypeDescriptor().getTypeCodeName();
            if (this.isREF) {
                string = string + "(REF)";
            }
            string = string + "\" - ANYDATA Value: \"";
            Datum datum = this.accessDatum();
            boolean bl2 = false;
            try {
                string = string + datum.stringValue();
                bl2 = true;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (!bl2) {
                if (!(this.type.getInternalTypeCode() != 108 && this.type.getInternalTypeCode() != 110 || this.type.isTransient())) {
                    string = string + ((StructDescriptor)this.type).getName() + "(...)";
                } else if (this.type.getInternalTypeCode() == 122 && !this.type.isTransient()) {
                    string = string + ((ArrayDescriptor)this.type).getName() + "(...)";
                } else {
                    switch (this.type.getInternalTypeCode()) {
                        case 113: {
                            int n2;
                            InputStream inputStream = ((BLOB)datum).getBinaryStream();
                            String string2 = "";
                            while ((n2 = inputStream.read()) != -1) {
                                string2 = string2 + Integer.toHexString(n2);
                            }
                            string = string + string2;
                            try {
                                inputStream.close();
                            }
                            catch (IOException iOException) {}
                            break;
                            catch (IOException iOException) {
                                try {
                                    inputStream.close();
                                }
                                catch (IOException iOException2) {}
                                break;
                                catch (Throwable throwable) {
                                    try {
                                        inputStream.close();
                                    }
                                    catch (IOException iOException3) {
                                        // empty catch block
                                    }
                                    Throwable throwable2 = throwable;
                                    if (bl) {
                                        ClioSupport.throwing($$$loggerRef$$$11, Level.FINEST, ANYDATA.class, $$$methodRef$$$11, this, throwable2);
                                    }
                                    throw throwable2;
                                }
                            }
                        }
                        case 188: {
                            if (connection == null) {
                                string = string + "?";
                                break;
                            }
                            string = string + ((TIMESTAMPTZ)datum).stringValue(connection);
                            break;
                        }
                        case 232: {
                            if (connection == null) {
                                string = string + "?";
                                break;
                            }
                            string = string + ((TIMESTAMPLTZ)datum).stringValue(connection);
                            break;
                        }
                        case 114: {
                            string = string + "bfile_dir=" + ((BFILE)datum).getDirAlias() + " bfile_name=" + ((BFILE)datum).getName();
                            break;
                        }
                        case 58: {
                            OPAQUE oPAQUE = (OPAQUE)datum;
                            String string3 = oPAQUE.getSQLTypeName();
                            string = string + "OPAQUE(" + string3 + ")";
                            if (string3.compareTo("SYS.XMLTYPE") != 0) break;
                            string = string + ":";
                            XMLType xMLType = XMLType.createXML((OPAQUE)oPAQUE);
                            string = string + xMLType.getStringVal();
                        }
                    }
                }
            }
            string = string + "\"";
            return string;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, ANYDATA.class, $$$methodRef$$$11, this, throwable3);
            }
            throw throwable;
        }
    }

    public Datum accessDatum() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x20000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, ANYDATA.class, $$$methodRef$$$12, this, new Object[0]);
            }
            Datum datum = null;
            if (!this.isNull) {
                short s2 = this.type.getInternalTypeCode();
                switch (s2) {
                    case 58: {
                        datum = new OPAQUE((OpaqueDescriptor)this.type, this.data, this.connection);
                        break;
                    }
                    case 108: {
                        if (this.type instanceof OpaqueDescriptor) {
                            datum = new OPAQUE((OpaqueDescriptor)this.type, this.data, this.connection);
                            break;
                        }
                        if (!this.isREF) {
                            datum = new STRUCT((StructDescriptor)this.type, this.data, this.connection);
                            break;
                        }
                        datum = new REF((StructDescriptor)this.type, (Connection)this.connection, this.data);
                        break;
                    }
                    case 122: {
                        datum = new ARRAY((ArrayDescriptor)this.type, this.data, this.connection);
                        break;
                    }
                    case 110: {
                        datum = new REF((StructDescriptor)this.type, (Connection)this.connection, this.data);
                        break;
                    }
                    case 2: {
                        datum = new NUMBER(this.data);
                        break;
                    }
                    case 12: {
                        datum = new DATE(this.data);
                        break;
                    }
                    case 190: {
                        datum = new INTERVALDS(this.data);
                        break;
                    }
                    case 189: {
                        datum = new INTERVALYM(this.data);
                        break;
                    }
                    case 188: {
                        datum = new TIMESTAMPTZ(this.data);
                        break;
                    }
                    case 232: {
                        datum = new TIMESTAMPLTZ(this.data);
                        break;
                    }
                    case 187: {
                        datum = new TIMESTAMP(this.data);
                        break;
                    }
                    case 112: {
                        datum = new CLOB(this.connection, this.data);
                        break;
                    }
                    case 288: {
                        datum = new NCLOB(this.connection, this.data);
                        break;
                    }
                    case 113: {
                        datum = new BLOB(this.connection, this.data);
                        break;
                    }
                    case 114: {
                        datum = new BFILE(this.connection, this.data);
                        break;
                    }
                    case 95: {
                        datum = new RAW(this.data);
                        break;
                    }
                    case 101: {
                        datum = new BINARY_DOUBLE(this.data);
                        break;
                    }
                    case 100: {
                        datum = new BINARY_FLOAT(this.data);
                        break;
                    }
                    case 104: {
                        long l2 = ((long)this.data[1] & 0xFFL) << 24 | ((long)this.data[2] & 0xFFL) << 16 | ((long)this.data[3] & 0xFFL) << 8 | (long)this.data[4] & 0xFFL;
                        long l3 = ((long)this.data[5] & 0xFFL) << 8 | (long)this.data[6] & 0xFFL;
                        long l4 = ((long)this.data[7] & 0xFFL) << 24 | ((long)this.data[8] & 0xFFL) << 16 | ((long)this.data[9] & 0xFFL) << 8 | (long)this.data[10] & 0xFFL;
                        long l5 = ((long)this.data[11] & 0xFFL) << 8 | (long)this.data[12] & 0xFFL;
                        long[] lArray = new long[]{l2, l3, l4, l5};
                        byte[] byArray = InternalFactory.urowid2rowid(lArray);
                        datum = new ROWID(byArray);
                        break;
                    }
                    case 1: 
                    case 9: 
                    case 96: {
                        datum = this.serverCharsetId != 0 ? new CHAR(this.data, CharacterSet.make(this.serverCharsetId)) : new CHAR(this.data, null);
                        if (s2 != 1 && s2 != 9) break;
                        ((CHAR)datum).setVariableLength(true);
                        break;
                    }
                    case 286: 
                    case 287: {
                        datum = this.serverNCharsetId != 0 ? new CHAR(this.data, CharacterSet.make(this.serverNCharsetId)) : new CHAR(this.data, null);
                        if (s2 != 287) break;
                        ((CHAR)datum).setVariableLength(true);
                        break;
                    }
                    default: {
                        String string = "internal typecode: " + s2;
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, string).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$12, Level.FINEST, ANYDATA.class, $$$methodRef$$$12, this, sQLException);
                        }
                        throw sQLException;
                    }
                }
            }
            return datum;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, ANYDATA.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return this.connection;
    }

    static {
        try {
            $$$methodRef$$$15 = ANYDATA.class.getDeclaredConstructor(OPAQUE.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$14 = ANYDATA.class.getDeclaredConstructor(TypeDescriptor.class, Boolean.TYPE, byte[].class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$13 = ANYDATA.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$12 = ANYDATA.class.getDeclaredMethod("accessDatum", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$11 = ANYDATA.class.getDeclaredMethod("stringValue", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$10 = ANYDATA.class.getDeclaredMethod("stringValue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$9 = ANYDATA.class.getDeclaredMethod("isREF", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$8 = ANYDATA.class.getDeclaredMethod("getData", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$7 = ANYDATA.class.getDeclaredMethod("isNull", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$6 = ANYDATA.class.getDeclaredMethod("getTypeDescriptor", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$5 = ANYDATA.class.getDeclaredMethod("convertDatum", Datum.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$4 = ANYDATA.class.getDeclaredMethod("toJDBCObject", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$3 = ANYDATA.class.getDeclaredMethod("toDatum", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$2 = ANYDATA.class.getDeclaredMethod("getImageSize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$1 = ANYDATA.class.getDeclaredMethod("pickle", byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$0 = ANYDATA.class.getDeclaredMethod("unpickle", byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
    }
}

