/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.LobCommonAccessor;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.Representation;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.sql.BFILE;
import oracle.sql.Datum;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class BfileAccessor
extends LobCommonAccessor {
    static final int MAXLENGTH = 530;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;

    BfileAccessor(OracleStatement oracleStatement, int n2, short s2, int n3, boolean bl) throws SQLException {
        super(Representation.BFILE, oracleStatement, 530, bl);
        this.init(oracleStatement, 114, 114, s2, bl);
        this.initForDataAccess(n3, n2, null);
    }

    BfileAccessor(OracleStatement oracleStatement, int n2, boolean bl, int n3, int n4, int n5, int n6, int n7, short s2) throws SQLException {
        super(Representation.BFILE, oracleStatement, 530, false);
        this.init(oracleStatement, 114, 114, s2, false);
        this.initForDescribe(114, n2, bl, n3, n4, n5, n6, n7, s2, null);
        this.initForDataAccess(0, n2, null);
    }

    @Override
    Object getObject(int n2) throws SQLException {
        return this.getBFILE(n2);
    }

    @Override
    Object getObject(int n2, Map map) throws SQLException {
        return this.getBFILE(n2);
    }

    @Override
    Datum getOracleObject(int n2) throws SQLException {
        return this.getBFILE(n2);
    }

    @Override
    BFILE getBFILE(int n2) throws SQLException {
        if (this.isNull(n2)) {
            return null;
        }
        BFILE bFILE = new BFILE(this.statement.connection, this.getBytesInternal(n2));
        if (this.isPrefetched()) {
            bFILE.setLength(this.getPrefetchedLength(n2));
        }
        return bFILE;
    }

    @Override
    InputStream getAsciiStream(int n2) throws SQLException {
        BFILE bFILE = this.getBFILE(n2);
        if (bFILE == null) {
            return null;
        }
        return bFILE.asciiStreamValue();
    }

    @Override
    Reader getCharacterStream(int n2) throws SQLException {
        BFILE bFILE = this.getBFILE(n2);
        if (bFILE == null) {
            return null;
        }
        return bFILE.characterStreamValue();
    }

    @Override
    InputStream getBinaryStream(int n2) throws SQLException {
        BFILE bFILE = this.getBFILE(n2);
        if (bFILE == null) {
            return null;
        }
        return bFILE.getBinaryStream();
    }

    @Override
    byte[] getBytes(int n2) throws SQLException {
        BFILE bFILE = this.getBFILE(n2);
        if (bFILE == null) {
            return null;
        }
        InputStream inputStream = bFILE.getBinaryStream();
        int n3 = 4096;
        int n4 = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n3);
        byte[] byArray = new byte[n3];
        try {
            while ((n4 = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n4);
            }
        }
        catch (IOException iOException) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 151).fillInStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    static {
        try {
            $$$methodRef$$$9 = BfileAccessor.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = BfileAccessor.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Short.TYPE, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = BfileAccessor.class.getDeclaredMethod("getBytes", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = BfileAccessor.class.getDeclaredMethod("getBinaryStream", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = BfileAccessor.class.getDeclaredMethod("getCharacterStream", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = BfileAccessor.class.getDeclaredMethod("getAsciiStream", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = BfileAccessor.class.getDeclaredMethod("getBFILE", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = BfileAccessor.class.getDeclaredMethod("getOracleObject", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = BfileAccessor.class.getDeclaredMethod("getObject", Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = BfileAccessor.class.getDeclaredMethod("getObject", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

