/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.util;

import java.io.File;
import oracle.dms.util.Platform;
import oracle.dms.util.PlatformSupport;
import oracle.dms.util.PlatformSupportFactory;
import oracle.jrf.PortabilityLayerException;
import oracle.jrf.ServerPlatformSupport;
import oracle.jrf.ServerPlatformSupportFactory;
import oracle.jrf.UnknownPlatformException;

public class PlatformSupportForJRF
implements PlatformSupport {
    private ServerPlatformSupport mServerPlatformSupport;
    private Platform mPlatform;
    private static final String DMS_CONFIG_XML_FILE = "dms_config.xml";

    public PlatformSupportForJRF() throws PortabilityLayerException, InstantiationException {
        try {
            this.mServerPlatformSupport = ServerPlatformSupportFactory.getInstance();
            if (this.mServerPlatformSupport.isWebLogic()) {
                this.mPlatform = Platform.WebLogic;
            } else if (this.mServerPlatformSupport.isWebSphereND()) {
                this.mPlatform = Platform.WebSphereND;
            } else if (this.mServerPlatformSupport.isWebSphereAS()) {
                this.mPlatform = Platform.WebSphereAS;
            }
            if (this.mPlatform == null) {
                throw new PlatformSupportFactory.PlatformSupportException("Can not determine platform from ServerPlatformSupport.");
            }
        }
        catch (UnknownPlatformException upe) {
            throw new PlatformSupportFactory.PlatformSupportException((Exception)((Object)upe));
        }
    }

    @Override
    public boolean isDeploymentManager() {
        boolean retVal = "dmgr".equals(this.getServerName());
        return retVal;
    }

    @Override
    public String getClusterName() {
        String retVal = null;
        try {
            String clusterName = this.mServerPlatformSupport.getClusterName();
            if (clusterName != null) {
                if (!clusterName.equals("cluster_unknown")) {
                    retVal = clusterName;
                }
            }
        }
        catch (PortabilityLayerException pe) {
            throw new RuntimeException(pe);
        }
        return retVal;
    }

    @Override
    public Platform getPlatform() {
        return this.mPlatform;
    }

    @Override
    public String getServerName() {
        String retVal;
        try {
            retVal = this.mServerPlatformSupport.getServerName();
        }
        catch (PortabilityLayerException e) {
            throw new RuntimeException(e);
        }
        return retVal;
    }

    @Override
    public String getDomainConfigDirectory() {
        String retVal;
        try {
            retVal = this.mServerPlatformSupport.getDomainConfigDirectory();
        }
        catch (PortabilityLayerException e) {
            throw new RuntimeException(e);
        }
        return retVal;
    }

    @Override
    public String getServerConfigDirectory(String s1, String s2) {
        String retVal;
        try {
            retVal = this.mServerPlatformSupport.getServerConfigDirectory(s1, s2);
        }
        catch (PortabilityLayerException e) {
            throw new RuntimeException(e);
        }
        return retVal;
    }

    @Override
    public String getServerConfigDirectory() {
        return this.getServerConfigDirectory(null, this.getServerName());
    }

    @Override
    public String getConfigFilename() {
        String serverConfigDir = this.getServerConfigDirectory();
        String domainConfigDir = this.getDomainConfigDirectory();
        String configFilename = null;
        if (serverConfigDir != null) {
            configFilename = serverConfigDir + File.separator + DMS_CONFIG_XML_FILE;
        }
        if (!(configFilename != null && new File(configFilename).canRead() || domainConfigDir == null)) {
            configFilename = domainConfigDir + File.separator + DMS_CONFIG_XML_FILE;
        }
        return configFilename;
    }

    @Override
    public String getServerLogPath() {
        String retVal;
        try {
            retVal = this.mServerPlatformSupport.getServerLogPath();
        }
        catch (PortabilityLayerException e) {
            throw new RuntimeException(e);
        }
        return retVal;
    }

    @Override
    public boolean isAdminServer() {
        boolean retVal;
        try {
            retVal = this.mServerPlatformSupport.isAdminServer();
        }
        catch (PortabilityLayerException e) {
            throw new RuntimeException(e);
        }
        return retVal;
    }
}

