/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.table;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import oracle.dms.reporter.TbmlReporter;
import oracle.dms.spy.ErrorObject;
import oracle.dms.table.ColumnDefinition;
import oracle.dms.table.ColumnDefinitionSupport;
import oracle.dms.table.Key;
import oracle.dms.table.NullValue;
import oracle.dms.table.Row;
import oracle.dms.table.Schema;
import oracle.dms.table.TableBaseSupport;
import oracle.dms.table.TableSupport;
import oracle.dms.table.ValueType;
import oracle.dms.util.DMSNLSupport;
import oracle.dms.util.NetUtil;

public class RowSupport
extends TableBaseSupport
implements Row {
    static final Serializable NULL = new NullValue();
    protected Key m_key = null;
    protected Map<String, Serializable> m_values = Collections.synchronizedMap(new LinkedHashMap());
    private boolean m_isCacheable = true;
    private static final long serialVersionUID = -1150676024825L;

    public RowSupport() {
    }

    public RowSupport(TableSupport table) {
        super(table);
        this.setCacheable(table.isCacheable());
    }

    @Override
    public int columnCount() {
        return this.m_values.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getNames() {
        String[] ret = null;
        Map<String, Serializable> map = this.m_values;
        synchronized (map) {
            ret = new String[this.m_values.size()];
            this.m_values.keySet().toArray(ret);
        }
        return ret;
    }

    @Override
    public boolean containsColumn(String name) {
        if (name == null || name.trim().length() == 0) {
            return false;
        }
        return this.m_values.containsKey(name);
    }

    @Override
    public Enumeration<String> enumerateNames(boolean sorted) {
        if (!sorted) {
            return Collections.enumeration(this.m_values.keySet());
        }
        Vector<String> names = new Vector<String>(this.m_values.keySet());
        Collections.sort(names);
        return names.elements();
    }

    @Override
    public Serializable getValue(String name) {
        if (name == null || name.trim().length() == 0) {
            return ErrorObject.ERROR_OBJECT;
        }
        Serializable value = this.m_values.get(name);
        if (value instanceof NullValue) {
            return null;
        }
        return value;
    }

    @Override
    public Key getKey() {
        return this.getKey(false);
    }

    @Override
    public Key getKey(boolean reset) {
        String METHOD_NAME = "getKey";
        if (!reset && this.m_key != null) {
            return this.m_key;
        }
        Hashtable<String, Serializable> map = new Hashtable<String, Serializable>();
        Enumeration<String> iter = this.m_table.enumerateKeys(false);
        while (iter.hasMoreElements()) {
            String key = iter.nextElement();
            Serializable value = this.m_values.get(key);
            if (value == null) {
                if (TableSupport.LOGGER.isLoggable(Level.FINER)) {
                    TableSupport.LOGGER.logp(Level.FINER, this.getClass().getName(), "getKey", "key=" + key + " has null value");
                }
                value = NULL;
            } else if (value instanceof NullValue) {
                if (TableSupport.LOGGER.isLoggable(Level.FINER)) {
                    TableSupport.LOGGER.logp(Level.FINER, this.getClass().getName(), "getKey", "key=" + key + " has NULL value");
                }
            } else if (value instanceof ErrorObject && TableSupport.LOGGER.isLoggable(Level.FINER)) {
                TableSupport.LOGGER.logp(Level.FINER, this.getClass().getName(), "getKey", "key=" + key + " has ERROR value");
            }
            map.put(key, value);
        }
        this.m_key = new Key(map);
        return this.m_key;
    }

    @Override
    public String getType(String name) {
        return this.getTypeID(name).toString();
    }

    @Override
    public ValueType getTypeID(String name) {
        if (name == null || name.trim().length() == 0) {
            return ValueType.UNKNOWN;
        }
        ValueType type = this.m_table.getColumnType(name);
        if (type == ValueType.UNKNOWN) {
            Serializable value = this.m_values.get(name);
            type = ColumnDefinitionSupport.getValueTypeCodeByClass(value);
        }
        return type;
    }

    private ValueType _getTypeID(String name, Serializable value) {
        ValueType type = this.m_table.getColumnType(name);
        if (type == ValueType.UNKNOWN) {
            type = ColumnDefinitionSupport.getValueTypeCodeByClass(value);
        }
        return type;
    }

    public void setCacheable(boolean isCacheable) {
        this.m_isCacheable = isCacheable;
    }

    @Override
    public boolean isCacheable() {
        return this.m_isCacheable;
    }

    public void updateValue(String name, Serializable value) {
        if (name == null || name.trim().length() == 0) {
            return;
        }
        if (value == null) {
            this.m_values.put(name, NULL);
            return;
        }
        ValueType type = this.m_table.getColumnType(name);
        value = RowSupport.castValueType(value, type);
        this.m_values.put(name, value);
    }

    public void addValuesFrom(RowSupport row) {
        if (row != null) {
            this.m_values.putAll(row.m_values);
        }
    }

    public static Serializable castValueType(Serializable value, ValueType type) {
        if (value == null || value instanceof NullValue || value instanceof ErrorObject) {
            return value;
        }
        try {
            switch (type) {
                case INTEGER: {
                    return NetUtil.cast2Integer(value);
                }
                case LONG: {
                    return NetUtil.cast2Long(value);
                }
                case DOUBLE: {
                    return NetUtil.cast2Double(value);
                }
                case STRING: {
                    return value.toString();
                }
            }
            return value;
        }
        catch (NumberFormatException e) {
            return ErrorObject.ERROR_OBJECT;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        long hash = 0L;
        Map<String, Serializable> map = this.m_values;
        synchronized (map) {
            for (Serializable value : this.m_values.values()) {
                hash += (long)value.hashCode();
            }
        }
        return (int)hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RowSupport)) {
            return false;
        }
        RowSupport row = (RowSupport)obj;
        if (this.m_values.size() != row.m_values.size()) {
            return false;
        }
        Map<String, Serializable> map = this.m_values;
        synchronized (map) {
            for (Map.Entry<String, Serializable> entry : this.m_values.entrySet()) {
                String name = entry.getKey();
                Serializable value = entry.getValue();
                if (!row.m_values.containsKey(name)) {
                    return false;
                }
                Serializable comparedValue = row.m_values.get(name);
                ValueType type = this._getTypeID(name, value);
                value = RowSupport.castValueType(value, type);
                comparedValue = RowSupport.castValueType(comparedValue, type);
                boolean match = name.equalsIgnoreCase("Host") || name.equalsIgnoreCase("Host.value") ? (value instanceof String && comparedValue instanceof String ? NetUtil.isSameHost((String)((Object)value), (String)((Object)comparedValue)) : value.equals(comparedValue)) : value.equals(comparedValue);
                if (match) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object clone() {
        RowSupport clone = null;
        try {
            clone = (RowSupport)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        Map<String, Serializable> map = this.m_values;
        synchronized (map) {
            clone.m_values = Collections.synchronizedMap(new LinkedHashMap());
            clone.copyValuesFrom(this);
        }
        return clone;
    }

    protected RowSupport clone(TableSupport table) {
        RowSupport clone = (RowSupport)this.clone();
        if (table != null) {
            clone.m_table = table;
        }
        return clone;
    }

    protected void copyValuesFrom(RowSupport from) {
        for (Map.Entry<String, Serializable> entry : from.m_values.entrySet()) {
            String name = entry.getKey();
            Serializable value = entry.getValue();
            this.m_values.put(name, value);
        }
    }

    public void close() {
        this.m_values.clear();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        this.appendRow(buf);
        return buf.toString();
    }

    public void appendRow(StringBuilder buf) {
        if (buf == null) {
            return;
        }
        Schema schema = this.m_table.getSchema();
        Enumeration<String> iter = this.enumerateNames(true);
        while (iter.hasMoreElements()) {
            ColumnDefinition cdesc;
            String name = iter.nextElement();
            Serializable value = this.getValue(name);
            String unit = null;
            if (schema != null && (cdesc = schema.getColumnDefinition(name)) != null) {
                unit = cdesc.getUnit();
            }
            RowSupport.appendColumn(name, value, unit, buf);
        }
    }

    public static void appendColumn(String name, Object value, String unit, StringBuilder buf) {
        if (buf == null || name == null || name.trim().length() == 0) {
            return;
        }
        buf.append(name);
        buf.append(":\t");
        if (value instanceof ErrorObject) {
            buf.append(DMSNLSupport.getString("NO_VALUE"));
        } else {
            buf.append(value);
            if (unit != null && unit.trim().length() > 0) {
                buf.append('\t');
                buf.append(unit);
            }
        }
        buf.append('\n');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void printTbml(long valueRefreshTime, PrintWriter out) {
        TbmlReporter.printRowHeading(this.m_isCacheable, out);
        Map<String, Serializable> map = this.m_values;
        synchronized (map) {
            for (Map.Entry<String, Serializable> entry : this.m_values.entrySet()) {
                String columnName = entry.getKey();
                Serializable value = entry.getValue();
                ValueType type = ((TableSupport)this.getTable()).getColumnType(columnName);
                TbmlReporter.printColumn(columnName, value, type, out);
            }
        }
        TbmlReporter.printRowEnding(out);
    }

    protected boolean isPrintColumn(String columnName, long valueRefreshTime) {
        return true;
    }
}

