/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.instrument;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import oracle.dms.event.Event;
import oracle.dms.event.EventActionType;
import oracle.dms.event.EventSourceType;
import oracle.dms.event.EventType;
import oracle.dms.event.EventTypeEnthusiast;
import oracle.dms.event.LoadableDestination;
import oracle.dms.event.config.DestinationDescription;
import oracle.dms.instrument.ActivationParameter;
import oracle.dms.instrument.Bucket;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.NounDescriptor;
import oracle.dms.instrument.Sensor;
import oracle.dms.util.Validatable;

@DestinationDescription(nlsDescriptionResourceBundle="oracle.dms.event.EventResourceBundle", nlsDescriptionID="DYNAMIC_BUCKET")
public class DynamicBucketingDestination
implements LoadableDestination,
EventTypeEnthusiast {
    String mName;
    String mId;
    Map<String, List<String>> mNounTypeToBucketKeysMap = new HashMap<String, List<String>>();
    private static EventType[] sEventTypes = EventType.parseList("STATE_SENSOR:UPDATE, EVENT_SENSOR:UPDATE, PHASE_SENSOR:STOP");

    @Override
    public void setName(String name) {
        this.mName = name;
    }

    @Override
    public void setId(String id) {
        this.mId = id;
    }

    @Override
    public void handleEvent(Event event) {
        EventSourceType sourceType = event.getSourceType();
        if (sourceType.isTypeOf(EventSourceType.SENSOR) && sourceType != EventSourceType.ANONYMOUS_PHASE_SENSOR) {
            List<String> bucketValues;
            List<String> bucketKeys;
            Sensor s = (Sensor)event.getSource();
            Noun n = s.getParent();
            NounDescriptor nd = n.getDescriptor();
            long eventTime = event.getTime();
            Number value = null;
            switch (sourceType) {
                case EVENT_SENSOR: {
                    if (event.getActionType() != EventActionType.UPDATE) break;
                    value = new Integer(1);
                    break;
                }
                case PHASE_SENSOR: {
                    Object[] eventValues;
                    if (event.getActionType() != EventActionType.STOP || (eventValues = event.getSubsidiaryObjects()).length < 2) break;
                    value = new Long(Long.valueOf((Long)eventValues[1]) - Long.valueOf((Long)eventValues[0]));
                    break;
                }
                case STATE_SENSOR: {
                    if (event.getActionType() != EventActionType.UPDATE || !(event.getSubsidiaryObject(0) instanceof Number)) break;
                    value = (Number)event.getSubsidiaryObject(0);
                }
            }
            if (value != null && (bucketKeys = this.getBucketKeysForNounType(nd)) != null && bucketKeys.size() > 0 && (bucketValues = this.getBucketValues(bucketKeys, s, event)) != null) {
                Bucket.drop(s, bucketKeys, bucketValues, value, eventTime);
            }
        }
    }

    public void setBucketRule(String s) {
        StringTokenizer st = new StringTokenizer(s, ";");
        while (st.hasMoreTokens()) {
            String typeAndKeyToken = st.nextToken();
            String[] splitArray = typeAndKeyToken.split(":");
            if (splitArray.length != 2 || splitArray[0].trim().isEmpty() || splitArray[1].trim().isEmpty()) continue;
            String nounTypeName = splitArray[0].trim();
            StringTokenizer keyTokenizer = new StringTokenizer(splitArray[1], ",");
            while (keyTokenizer.hasMoreTokens()) {
                String key = keyTokenizer.nextToken().trim();
                if (key.isEmpty()) continue;
                List<String> keyList = this.mNounTypeToBucketKeysMap.get(nounTypeName);
                if (keyList == null) {
                    keyList = new ArrayList<String>();
                    this.mNounTypeToBucketKeysMap.put(nounTypeName, keyList);
                }
                keyList.add(key);
            }
        }
    }

    private List<String> getBucketKeysForNounType(NounDescriptor nd) {
        List<String> retVal = this.mNounTypeToBucketKeysMap.get(nd.getName());
        return retVal;
    }

    private List<String> getBucketValues(List<String> bucketKeys, Sensor sensor, Event event) {
        ArrayList<String> retVal = null;
        ActivationParameter[] actParams = sensor.getActivationParametersFromEvent(event);
        if (actParams != null && actParams.length > 0) {
            HashMap<String, String> map = new HashMap<String, String>(bucketKeys.size());
            for (ActivationParameter ap : actParams) {
                map.put(ap.getDescriptor().getName(), ap.getValue().toString());
            }
            retVal = new ArrayList<String>(bucketKeys.size());
            for (String bucketKey : bucketKeys) {
                String bucketValue = (String)map.get(bucketKey);
                retVal.add(bucketValue);
            }
        }
        return retVal;
    }

    @Override
    public boolean needsContext() {
        return true;
    }

    @Override
    public void initDestination() {
    }

    @Override
    public void shutdownDestination() {
    }

    @Override
    public String getId() {
        return this.mId;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public EventType[] getEventTypesOfInterest() {
        return sEventTypes;
    }

    @Override
    public void validate(Set<Validatable.ValidationLevel> validationLevels) {
    }
}

